
--[[
function init_random(seed)
	math.randomseed(seed)
end

function random(a, b)
	if (a > b) then
		local c = b
		b = a
		a = c
	end
	local delta = b-a
	return (a + math.random()*delta)
end
--]]
    



local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gx_cam_lib_v2.lua")
dofile(lib_dir .. "lua/imgui.lua")
dofile(lib_dir .. "lua/gxl.lua")





is_rpi = false
if (gh_utils.get_platform() == 4) then
  is_rpi = true
end





winW, winH = gh_window.getsize(0)





keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 5
camera_lookat_z = 0

camera = gx_camera.create_perspective(camera_fov, 1, 0, 0, winW, winH, 1, 1000)
gh_camera.set_position(camera._id, 0, 0, 20)
gx_camera.init_orientation(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z, 15, 110)
gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_mode_orbit(camera)
gx_camera.set_keyboard_speed(camera, keyboard_speed)





function NewGear(inner_radius, outer_radius, tooth_depth, num_teeth, width)
  local gear = {
    _inner_radius = inner_radius,
    _outer_radius = outer_radius,
    _tooth_depth = tooth_depth,
    _num_teeth = num_teeth,
    _rot_speed = 60.0, -- degrees/second
    _rot_angle = 0.0,
    _initial_angle_offset = 0,
    _width = width,
    _mesh = 0,
    _color = {r=0.7, g=0.7, b=0.7, a=1.0}
  }

  gear._mesh = gh_mesh.create_gear(inner_radius, outer_radius, tooth_depth, num_teeth, width)
  --local num_vertices = gh_object.get_num_vertices(gear._mesh)
  --print("Gear num vertices: " .. num_vertices) -- log file

  return gear
end



gear_ratio = 2.0

-- Gear A -------------------------------------------------------
--
inner_radius = 1.0
outer_radius = 3.0
tooth_depth = 1.0
num_teeth = 10
width = 1.2

gearA = NewGear(inner_radius, outer_radius, tooth_depth, num_teeth, width)
gearA._color.r = 1.0
gearA._color.g = 0.2
gearA._color.b = 0.2


-- Gear B -------------------------------------------------------
--
outer_radius = gearA._outer_radius * gear_ratio
num_teeth = gearA._num_teeth * gear_ratio
gearB = NewGear(inner_radius, outer_radius, tooth_depth, num_teeth, width)
gearB._color.r = 0.2
gearB._color.g = 0.680
gearB._color.b = 1.0

gearB._rot_speed = gearA._rot_speed / gear_ratio
gearB._initial_angle_offset = (360 / gearB._num_teeth) / 4.0
gearB._rot_angle = gearB._initial_angle_offset









lighting_prog = gh_node.getid("lighting01_prog")


light_position = {x=12.0, y=10.0, z=20.0}



grid = gh_utils.grid_create()
gh_utils.grid_set_geometry_params(grid, 50, 50, 30, 30)
gh_utils.grid_set_lines_color(grid, 0.7, 0.7, 0.7, 1.0)
gh_utils.grid_set_main_lines_color(grid, 1.0, 1.0, 0.0, 1.0)
gh_utils.grid_set_main_x_axis_color(grid, 1.0, 0.0, 0.0, 1.0)
gh_utils.grid_set_main_z_axis_color(grid, 0.0, 0.0, 1.0, 1.0)
local display_main_lines = 1
local display_lines = 1
gh_utils.grid_set_display_lines_options(grid, display_main_lines, display_lines)


color_prog = gh_node.getid("color_prog")


gh_renderer.set_vsync(1)
gh_renderer.set_scissor_state(0)
gh_renderer.set_depth_test_state(1)

last_time = gh_utils.get_elapsed_time()


win_hovered = false
item_hovered = false



