
local demo_dir = gh_utils.get_demo_dir()
    
local lib_dir = gh_utils.get_scripting_libs_dir() 		
dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    
dofile(lib_dir .. "lua/gxl.lua")    


winW, winH = gh_window.getsize(0)


win_hovered = 0
item_hovered = 0


--[[
local aspect = winW / winH
camera = gh_camera.create_persp(60, aspect, 0.1, 1000.0)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 0.2, 0.4)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.setupvec(camera, 0, 1, 0, 0)
--]]





orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 0.1, 1000)
gh_camera.set_position(camera, 0, 0, 80)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 90)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)









wire_color = {r=1.0, g=1.0, b=1.0, a=1.0}
plane_color = {r=1.0, g=0.5, b=0.0, a=1.0}
ground_color = {r=0.7, g=0.7, b=0.7, a=1.0}



color_prog = gh_node.getid("color_prog")
gh_gpu_program.uniform4f(color_prog, "color", 1, 1, 1, 1)


particle_prog = gh_node.getid("particle_prog")
gh_gpu_program.uniform1i(particle_prog, "tex0", 0)

particle_size = 80.0
gh_gpu_program.uniform1f(particle_prog, "particle_size", particle_size)





local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 1
local compressed_texture = 0

local filename = demo_dir .. "textures/flare19.jpg"
particle_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)





mesh_plane = gh_mesh.create_plane(100, 100, 10, 10)

show_plane = 0



function gen_random_xyz(radius) 
  local x = gxl.random(0.0, 1.0) * 2.0 * radius - radius
  local y = gxl.random(0.0, 1.0) * 2.0 * radius - radius
  local z = gxl.random(0.0, 1.0) * 2.0 * radius - radius

  -- local x = gh_utils.random_uniform_real(0.0, 1.0) * 2.0 * radius - radius
  -- local y = gh_utils.random_uniform_real(0.0, 1.0) * 2.0 * radius - radius
  -- local z = gh_utils.random_uniform_real(0.0, 1.0) * 2.0 * radius - radius

  -- local x = gh_utils.random_normal(1.0, 0.2) * 2.0 * radius - radius
  -- local y = gh_utils.random_normal(1.0, 0.2) * 2.0 * radius - radius
  -- local z = gh_utils.random_normal(1.0, 0.2) * 2.0 * radius - radius

  return x, y, z
end    


-------------------------------------------------------------
-- Vertex pool creation and initialization.
--
num_particles = 10000
vp = gh_vertex_pool.create(num_particles)

-- Init particles position and color
--
local outerRadius = 40.0
local outerRadiusSquared = outerRadius*outerRadius
local innerRadius = 38.0
local innerRadiusSquared = innerRadius*innerRadius
local pb_percent = 0
local pb_step = num_particles / 100
local pb_counter = 0

for i=0, num_particles-1 do
  local x=0
  local y=0
  local z=0
  local point_ok = false
  while (point_ok == false) do
    x, y, z = gen_random_xyz(outerRadius)
    local mag = x*x + y*y + z*z
		if ((mag <= outerRadiusSquared) and (mag >= innerRadiusSquared)) then
      point_ok = true
    end
  end
  gh_vertex_pool.vertex_set_position(vp, i, x, y, z, 1)
  
  local alpha = 1.0
  x = gxl.random(0.0, 1.0)
  y = gxl.random(0.0, 1.0)
  z = gxl.random(0.0, 1.0)
  gh_vertex_pool.vertex_set_color(vp, i, x, y, z, alpha)
end













gh_renderer.set_vsync(0)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0


speed_factor = 1.0

bgcolor = {r=0.2, g=0.2, b=0.2, a=1.0}


