   
    
-- Get the size of the current 3D window    
--
winW, winH = gh_window.getsize(0)




-- Perspective camera.
--
local aspect = winW / winH
camera_params = { fov=60, znear=0.1, zfar=1000.0 }
camera = gh_camera.create_persp(camera_params.fov, aspect, camera_params.znear, camera_params.zfar)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 2, 2, 4)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.set_upvec(camera, 0, 1, 0, 0)



-- The GPU program for this demo: a simple vertex color program.
-- The GLSL source code is at the end of this XML file.
--
vertex_color_prog = gh_node.getid("vertex_color_prog")




-- Creation of the most simple mesh: a triangle made up of 3 vertices.
--
triangle = gh_mesh.create_v2()
local num_vertices = 3
local num_faces = 0 -- non-indexed rendering
local ret = gh_mesh.alloc_mesh_data(triangle, num_vertices, num_faces)
if (ret == 1) then
  gh_mesh.set_vertex_position(triangle, 0, -1, -1, 0, 1)
  gh_mesh.set_vertex_position(triangle, 1, 0, 1, 0, 1)
  gh_mesh.set_vertex_position(triangle, 2, 1, -1, 0, 1)

  gh_mesh.set_vertex_color(triangle, 0, 1, 0, 0, 1)
  gh_mesh.set_vertex_color(triangle, 1, 0, 1, 0, 1)
  gh_mesh.set_vertex_color(triangle, 2, 0, 0, 1, 1)
end  




-- Creation of a reference grid.
-- More parameters to customize the grid are available here:
-- http://www.geeks3d.com/glslhacker/blog/20141117/how-to-render-a-reference-grid/
--
grid = gh_utils.grid_create()
gh_utils.grid_set_geometry_params(grid, 10, 10, 20, 20)

