import gh_renderer
import gh_gpu_program
  
def CreateGPUProgram(name, vs_gl2, ps_gl2, vs_gles2, ps_gles2, vs_gl3, ps_gl3):
  vs = ""
  ps = ""

  if (gh_renderer.is_opengl_es() == 1):
    vs = vs_gles2
    ps = ps_gles2
  else:
    if (gh_renderer.get_api_version_major() < 3):
      vs = vs_gl2
      ps = ps_gl2
    else:
      if ((gh_renderer.get_api_version_major() == 3) and (gh_renderer.get_api_version_minor() < 2)):
        vs = "#version 130\n" + vs_gl3
        ps = "#version 130\n" + ps_gl3
      else:
        vs = "#version 150\n" + vs_gl3
        ps = "#version 150\n" + ps_gl3
  
  prog = gh_gpu_program.create_v2(name, vs, ps)
  return prog



  
#----------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------
def init_color_program():

  color_vs_gl3='''
  in vec4 gxl3d_Position;
  in vec4 gxl3d_Color;
  uniform mat4 gxl3d_ModelViewProjectionMatrix; // GeeXLab built-in uniform.
  out vec4 v_color;
  void main()
  {
    gl_Position = gxl3d_ModelViewProjectionMatrix * gxl3d_Position;
    v_color = gxl3d_Color;
  }
  '''

  color_ps_gl3='''
  in vec4 v_color;
  out vec4 FragColor;
  void main()
  {
    FragColor = v_color;
  }
  '''


  color_vs_gl2='''
  uniform mat4 gxl3d_ModelViewProjectionMatrix; // GXL3D built-in uniform.
  varying vec4 v_color;
  void main()
  {
    gl_Position = gxl3d_ModelViewProjectionMatrix * gl_Vertex;
    v_color = gl_Color;
  }
  '''

  color_ps_gl2='''
  varying vec4 v_color;
  void main()
  {
    gl_FragColor = v_color;
  }
  '''

  color_vs_gles2='''
  attribute vec4 gxl3d_Position;
  attribute vec4 gxl3d_Color;
  uniform mat4 gxl3d_ModelViewProjectionMatrix;
  varying vec4 v_color;
  void main()
  {
    gl_Position = gxl3d_ModelViewProjectionMatrix * gxl3d_Position;
    v_color = gxl3d_Color;
  }
  '''

  color_ps_gles2='''
  varying highp vec4 v_color;
  void main()
  {
    gl_FragColor = v_color;
  }
  '''

  color_prog = CreateGPUProgram("color_prog", color_vs_gl2, color_ps_gl2, color_vs_gles2, color_ps_gles2, color_vs_gl3, color_ps_gl3)  
  return color_prog


  #----------------------------------------------------------------------------------------------
  #----------------------------------------------------------------------------------------------

def init_texture_program():

  tex_vs_gl3='''
  in vec4 gxl3d_Position;
  in vec4 gxl3d_Color;
  in vec4 gxl3d_TexCoord0;
  uniform mat4 gxl3d_ModelViewProjectionMatrix; // GeeXLab built-in uniform.
  out vec4 v_color;
  out vec4 v_uv;
  void main()
  {
    gl_Position = gxl3d_ModelViewProjectionMatrix * gxl3d_Position;
    v_color = gxl3d_Color;
    v_uv = gxl3d_TexCoord0;
  }
  '''

  tex_ps_gl3='''
  in vec4 v_color;
  in vec4 v_uv;
  out vec4 FragColor;

  uniform sampler2D tex0; 
  void main()
  {
    vec2 uv = v_uv.xy;
    uv.y *= -1;
    vec4 tex_color = texture(tex0, uv);
    FragColor = tex_color * v_color;
  }
  '''


  tex_vs_gl2='''
  uniform mat4 gxl3d_ModelViewProjectionMatrix; // GXL3D built-in uniform.
  varying vec4 v_color;
  varying vec4 v_uv;
  void main()
  {
    gl_Position = gxl3d_ModelViewProjectionMatrix * gl_Vertex;
    v_color = gl_Color;
    v_uv = gl_MultiTexCoord0;
  }
  '''

  tex_ps_gl2='''
  varying vec4 v_color;
  varying vec4 v_uv;
  uniform sampler2D tex0; 
  void main()
  {
    vec2 uv = v_uv.xy;
    uv.y *= -1;
    vec4 tex_color = texture2D(tex0, uv);
    gl_FragColor = tex_color * v_color;
  }
  '''

  tex_vs_gles2='''
  attribute vec4 gxl3d_Position;
  attribute vec4 gxl3d_Color;
  attribute vec4 gxl3d_TexCoord0;
  uniform mat4 gxl3d_ModelViewProjectionMatrix;
  varying vec4 v_color;
  varying vec4 v_uv;
  void main()
  {
    gl_Position = gxl3d_ModelViewProjectionMatrix * gxl3d_Position;
    v_color = gxl3d_Color;
    v_uv = gxl3d_TexCoord0;
  }
  '''

  tex_ps_gles2='''
  varying highp vec4 v_color;
  varying highp vec4 v_uv;
  void main()
  {
    vec2 uv = v_uv.xy;
    uv.y *= -1;
    vec4 tex_color = texture2D(tex0, uv);
    gl_FragColor = tex_color * v_color;
  }
  '''

  tex_prog = CreateGPUProgram("tex_prog", tex_vs_gl2, tex_ps_gl2, tex_vs_gles2, tex_ps_gles2, tex_vs_gl3, tex_ps_gl3)  
  return tex_prog

