	
   
local elapsed_time = gh_utils.get_elapsed_time()


local cmdbuf_index = gh_vk.frame_get_active_command_buffer_index()


local ub = ubs[cmdbuf_index+1]

gh_gpu_buffer.map(ub)

-- Camera position and lookat
--
gh_camera.set_position(camera, 0, 0, 6)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
UpdateCameraTransform(ub, camera)



-- Mesh transformation.
--
--gh_object.set_euler_angles(mesh, elapsed_time * 3.0, elapsed_time * 5.0, elapsed_time * 7.0)
gh_object.set_euler_angles(mesh, 90.0 + 10.0 * math.cos(elapsed_time * 2.0), 0.0, 10.0 * math.sin(elapsed_time * 2.0))
gh_object.set_position(mesh, 0.0, 0.0, 0.0)
UpdateObjectTransform(ub, mesh)

gh_gpu_buffer.unmap(ub)






if (display_imgui) then
  -- Only rebuild command buffers (one command buffer per frame) every frame if ImGui is used.
  --
  build_command_buffer(winW, winH)

else
  if (gh_vk.swapchain_has_changed() == 1) then

    local aspect = winW / winH
    gh_camera.update_persp(camera, camera_params.fov, aspect, camera_params.znear, camera_params.zfar)
    gh_camera.set_viewport(camera, 0, 0, winW, winH)

    for i=0, swapchain_image_count-1 do
      local ub = ubs[i+1]
      gh_gpu_buffer.map(ub)
      UpdateCameraTransform(ub, camera)
      gh_gpu_buffer.unmap(ub)

      gh_vk.frame_set_active_command_buffer_index(i)
      build_command_buffer(winW, winH)
    end
  
    -- restore current command buffer index.
    gh_vk.frame_set_active_command_buffer_index(cmdbuf_index)
  end

end





