
local elapsed_time = gh_utils.get_elapsed_time()
local dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  




if (clear_force_torque == 1) then
  clear_force_torque = 0

  gh_physx5.actor_clear_forces(px_actor_box1)
  gh_physx5.actor_clear_forces(px_actor_box2)

end


if (reset_simulation == 1) then
  reset_simulation = 0

  gh_physx5.actor_set_kinematic_state(px_actor_box1, 1)
  gh_physx5.actor_set_euler_angles(px_actor_box1, -30.0, 0.0, 0.0)
  gh_physx5.actor_set_position(px_actor_box1, 0, box_size_y*0.5 + box_size_y + 2.0, 0)
  --gh_physx5.actor_clear_forces(px_actor_box1)
  --gh_physx5.actor_set_euler_angles(px_actor_box1, 0.0, 0.0, 0.0)

  --gh_physx5.actor_set_linear_velocity(px_actor_box1, 0, gxl.random(-1.0, 1.0), 0)
  --gh_physx5.actor_set_angular_velocity(px_actor_box1, 0, gxl.random(-1.0, 1.0), 0)


  --gh_physx5.actor_clear_forces(px_actor_box2)
  --gh_physx5.actor_set_linear_velocity(px_actor_box2, 0, 0, 0)
  --gh_physx5.actor_set_angular_velocity(px_actor_box2, 0, 0, 0)
end


--[[
if (update_joint_params == 1) then

  update_joint_params = 0


  local angle = gxl.to_radians(-45.0)

  local lower_limit = -angle
  local upper_limit = angle
  local limit_contact_distance = 0.01
  gh_physx5.joint_revolute_set_rotational_limits(px_joint_revolute, lower_limit, upper_limit, limit_contact_distance)

  local damnping = 150.4
  local stiffness = 25.9
  local restitution = 0.1
  local bounce_threshold = 0.15
  gh_physx5.joint_revolute_set_angular_limits(px_joint_revolute, lower_limit, upper_limit, damnping, stiffness, restitution, bounce_threshold)
end
--]]



if (physx_ok == 1) then
  -- PhysX4 physics simulation. 
  --gh_physx4.run_simulation_step(px_scene, dt)
  --gh_physx4.fetch_results(px_scene)


  local fixed_time_step  = 1.0/60.0
  gh_physx5.run_simulation(px_scene, dt, fixed_time_step)

  -- Read back PhysX4 actors and updates 3D objects transformation.
  gh_physx5.actor_apply_transform(px_actor_box1, box1)
  gh_physx5.actor_apply_transform(px_actor_box2, box2)
end  






if (imgui_hovered == 0) then
  gx_camera.update(camera, dt)
end  
gh_camera.bind(camera)



gh_renderer.set_depth_test_state(1)
gh_renderer.clear_color_depth_buffers(0.3, 0.3, 0.3, 1, 1.0)



gh_gpu_program.bind(texture_prog)


gh_gpu_program.uniform4f(texture_prog, "uvtiling", 6, 6, 0, 0)
gh_texture.bind(ground_tex, 0)
gh_object.render(ground)

gh_gpu_program.uniform4f(texture_prog, "uvtiling", 1, 1, 0, 0)
gh_texture.bind(box_tex, 0)
gh_object.render(box1)
gh_object.render(box2)





--[[
  libfont_clear()

  local y_offset = 40
  
  libfont_print(20, y_offset, 1, 0.5, 0, 1, ">> PhysX 4 (v" .. physx4_ver .. ") <<")
  y_offset = y_offset + 20
  
  y_offset = y_offset + 20
  libfont_print(20, y_offset, 1, 1, 0, 1, "FPS: " .. fps)
  y_offset = y_offset + 20
  
  y_offset = y_offset + 20
  libfont_print(20, y_offset, 1, 1, 0, 1, "GL_RENDERER")
  y_offset = y_offset + 20
  libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_renderer)
  y_offset = y_offset + 20
  
  libfont_print(20, y_offset, 1, 1, 0, 1, "GL_VERSION")
  y_offset = y_offset + 20
  libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_version)
  y_offset = y_offset + 20
  
 
  libfont_render()
  --]]
  

  
  ----------------------------------------------------------------------------
  -- ImGui start -------------------------------------------------------------
  --
  imgui_frame_begin()

  gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.6)

  local is_open = imgui_window_begin_no_collapse("Control panel", 300, winW - physx_indicator_size_y, 0, physx_indicator_size_y)
  if (is_open == 1) then

    imgui_hovered = gh_imgui.is_window_hovered()
            
   gh_imgui.text_rgba("PhysX 5 - SDK version: " .. physx5_ver, 1.0, 1.0, 0.0, 1.0)

    gh_imgui.spacing()
    gh_imgui.spacing()
  
    gh_imgui.text("Press [ESC] to quit the demo")
   
   
    gh_imgui.spacing()
    gh_imgui.spacing()
    
    if (gh_imgui.button("Reset simultation", 280, 20) == 1) then
      reset_simulation = 1
    end

    if (gh_imgui.button("Clear forces", 280, 20) == 1) then
      clear_force_torque = 1
    end


    --[[
    if (gh_imgui.button("Update joint params", 280, 20) == 1) then
      update_joint_params = 1
    end
    --]]



    local label = "Add space for PhysX Visual indicator"
    if (physx_indicator_size_y == 50) then
      label = "Remove space for PhysX Visual indicator"
    end

    if (gh_imgui.button(label, 280, 20) == 1) then
      if (physx_indicator_size_y == 50) then
        physx_indicator_size_y = 0
      else
        physx_indicator_size_y = 50
      end
    end


  end 
  imgui_window_end()


  imgui_frame_end()
  --
  -- ImGui end ---------------------------------------------------------------
  ----------------------------------------------------------------------------


