
local elapsed_time = gh_utils.get_elapsed_time()


gh_camera.bind(camera_ortho)
gh_renderer.clear_color_depth_buffers(0, 0, 0, 0, 1.0)
gh_renderer.set_depth_test_state(0)

gh_gpu_program.bind(color_prog)
gh_object.render(mesh_quad)


gh_camera.set_position(camera, 0, 10, 30)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.bind(camera)


gh_renderer.set_depth_test_state(1)

gh_gpu_program.bind(phong_exploder_prog)
gh_gpu_program.uniform4f(phong_exploder_prog, "light_position", 0.0, 50.0, 50.0, 1.0)
gh_gpu_program.uniform4f(phong_exploder_prog, "light_diffuse", 0.9, 0.7, 0.7, 1.0)
gh_gpu_program.uniform4f(phong_exploder_prog, "light_specular", 0.9, 0.9, 0.9, 1.0)
gh_gpu_program.uniform4f(phong_exploder_prog, "material_diffuse", 0.7, 0.7, 0.7, 1.0)
gh_gpu_program.uniform4f(phong_exploder_prog, "material_specular", 0.6, 0.6, 0.6, 1.0)
gh_gpu_program.uniform1f(phong_exploder_prog, "material_shininess", 60.0)
gh_gpu_program.uniform1f(phong_exploder_prog, "normal_length", 2.0)
gh_gpu_program.uniform1f(phong_exploder_prog, "time", elapsed_time)
gh_object.set_euler_angles(mesh_sphere, 0, elapsed_time*50, 0)
gh_object.render(mesh_sphere)



gh_renderer.wireframe()

gh_gpu_program.bind(color_exploder_prog)
gh_gpu_program.uniform1f(color_exploder_prog, "normal_length", 2.0)
gh_gpu_program.uniform1f(color_exploder_prog, "time", elapsed_time)
gh_object.render(mesh_sphere)

gh_renderer.solid()






---[[
libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 0.5, 0, 1, "Geometry Shaders - Mesh Exploder")
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_renderer)
y_offset = y_offset + 20

libfont_print(20, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_version)
y_offset = y_offset + 20


libfont_render()
--]]

  
  


