
local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_lib_dir() 		

dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    






winW, winH = gh_window.getsize(0)


win_hovered = 0





-- A 2D camera. In this demo, there will be only 2D rendering.
--
camera_ortho = gh_camera.create_ortho(-winW/2, winW/2, -winH/2, winH/2, 1.0, 10.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 4)






-- The mega color shader!
--
color_prog = gh_node.getid("color_prog")
gh_gpu_program.uniform4f(color_prog, "color", 1, 1, 1, 1)

-- The mega texture shader!
--
texture_prog = gh_node.getid("texture_prog")
gh_gpu_program.uniform1i(texture_prog, "tex0", 0)
gh_gpu_program.uniform4f(texture_prog, "glow_color", 0, 0, 0, 0)



local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 0
local compressed_texture = 0

local filename = demo_dir .. "textures/playerShip2_orange.png"
spaceship_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

spaceship_quad = gh_mesh.create_quad(75, 112)

spaceship_pos_x = -250 
spaceship_pos_y = 0 
spaceship_speed_y = 200.0
spaceship_can_shoot = 0




--
-- Box2D works in MKS units (Meter / Kilogram / Second). For objects size, one unit is one meter.
-- Then if you create a quad with create_quad(10, 10) you will get a 10x10 meter quad in BoX2D.
-- It's not a problem for Box2D but it's a big quad and don't expect it will move fast like a small object.
-- A big object like in reality, will move slowly (for example if it is falling from a 100 meters tower).
-- To deal with graphics rendering, we will decouple the physics size and 3D/2D rendering size and we will use
-- a rendering_scale factor. So a 2x2 meters Box2D obstacle will be rendered with a 20x20 quad if the rendering_scale=10.
--
-- All rendering details can be found in the FRAME script after the world_step_simulation() call.
-- 
rendering_scale = 10.0
world_y_offset = -200





-- circle to display contacts
--
local plane_type = 1 
circle = gh_utils.circle_create_v2(plane_type, 10, 20, 1, 1, 1, 1)



-- The ground: 100m x 2m
--
ground_size = {x=100.0, y=2.0}
ground = gh_mesh.create_quad(ground_size.x, ground_size.y)



-- A box shaped bullet: 1m x 1m (a big bullet!)
--
box_size = {x=1.0, y=1.0}
box = gh_mesh.create_quad(box_size.x, box_size.y)


-- A disc shaped bullet with a 1.4m radius (a big bullet too!)
--
disc_radius = 1.4
disc = gh_mesh.create_disc(disc_radius, disc_radius/2, 20)





static_box1_size = {x=4.0, y=40.0}
static_box1_pos = {x=30, y=static_box1_size.y/2.0}

-- A kinematic wall.
kinematic_box1 = gh_mesh.create_quad(static_box1_size.x, static_box1_size.y)

-- A static wall.
static_box2 = gh_mesh.create_quad(static_box1_size.x, static_box1_size.y)



-- Some dynamic obstacles
--
boxes = {}
num_boxes = 0

function new_box(width, height, pos_x, pos_y)
  local box = {quad_id=0, b2id=0, sizex=width, sizey=height, posx=pos_x, posy=pos_y}
  box.quad_id = gh_mesh.create_quad(width, height)
  num_boxes = num_boxes+1
  boxes[num_boxes] = box
  return box
end


new_box(2.0, 20.0,   8.0, 20.0/2.0)
new_box(2.0, 18.0,   18.0, 18.0/2.0)
new_box(12.0, 1.0,   8.0, 20.0 + 1.0/2.0)

new_box(1.0, 10.0,  6.0,  20+1  +10.0/2.0)
new_box(1.0, 10.0,  10.0, 20+1 + 10.0/2.0)

new_box(6.0, 6.0,   28.0, 40.0 + 3.0)

new_box(4.0, 10.0,   24.0, 10.0/2.0)

new_box(20.0, 1.0,   8.0, 20.0 + 1 + 10 + 1/2)









gh_renderer.set_vsync(0)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0

total_frames = 0
total_simulations = 0

run_simulation = 1
reset_simulation = 0
shoot = 0

move_kinematic_box1 = 0

selected_obstacle = -1

show_contacts = 0

wireframe = 0

bullet1_speed = {x=50, y=0}
bullet2_speed = {x=60, y=0}
bullet_counter0 = 0






------------------------------------------------------------------------------
-- Box2D Physcis 
------------------------------------------------------------------------------


function deg2rad(deg)
  return deg*3.14159265/180.0
end

function rad2deg(rad)
  return rad*180.0/3.14159265
end


box2d_version = {major=0, minor=0, revision=0}

box2d_version.major, box2d_version.minor, box2d_version.revision = gh_box2d.get_version()


-- Like other physics engines, Box2D does not like variable time step for the simulation.
-- So we will run a simulation every 1/60 second and no more. The number of simulations is not linked
-- to the framerate.
--
sim_time = 0
sim_dt = 1.0/60.0



-- Inits the Box2D engine.
gh_box2d.init()


-- Creates a scene
b2_world = gh_box2d.world_init()


-- Sets the gravity
world_gravity = {x=0, y=-10}
gh_box2d.world_set_gravity(b2_world, world_gravity.x, world_gravity.y)




local density = 0.0
local friction = 0.6
local restitution = 0.1

b2_ground = gh_box2d.world_create_actor_box(b2_world, 0, -ground_size.y/2,    ground_size.x/2, ground_size.y/2,    "static", 0, 1.0, restitution)



density = 1000.0
friction = 0.4
restitution = 0.05



-- Bullet 1 (the box)
--
box_num_contact_points = 0
box_contact_point = {x=0, y=0}

b2_box = gh_box2d.world_create_actor_box(b2_world, 0, 10,    box_size.x/2, box_size.y/2,   "dynamic", density, friction, restitution)
gh_box2d.actor_set_ccd(b2_box, 1) -- CCD: continuous collision detection
gh_box2d.actor_set_damping(b2_box, 0.0, 0.1)
gh_box2d.actor_set_transform(b2_box, -10, 10,   deg2rad(30.0))
gh_box2d.actor_set_linear_velocity(b2_box, 0.0, 0.0)
gh_box2d.actor_set_angular_velocity(b2_box, deg2rad(0.0))
-- Sleeping is not allowed here!!!!
gh_box2d.actor_set_sleeping_allowed(b2_box, 0)



-- Bullet 2 (the disc)
--
disc_num_contact_points = 0
disc_contact_point = {x=0, y=0}

b2_disc = gh_box2d.world_create_actor_circle(b2_world, 0, 20,    disc_radius,   "dynamic", density, friction, restitution)
gh_box2d.actor_set_ccd(b2_disc, 1) -- CCD: continuous collision detection
gh_box2d.actor_set_damping(b2_disc, 0.0, 0.1)
gh_box2d.actor_set_transform(b2_disc, -15, 10,   deg2rad(0.0))
gh_box2d.actor_set_linear_velocity(b2_disc, 0.0, 0.0)
gh_box2d.actor_set_angular_velocity(b2_disc, deg2rad(0.0))
-- Sleeping is not allowed here!!!!
gh_box2d.actor_set_sleeping_allowed(b2_disc, 0)





density = 0.0
friction = 0.2
restitution = 0.1


-- The kinematic wall
--
b2_kinematic_box1 = gh_box2d.world_create_actor_box(b2_world, static_box1_pos.x, static_box1_pos.y,    static_box1_size.x/2, static_box1_size.y/2,   "kinematic", density, friction, restitution)
gh_box2d.actor_set_ccd(b2_kinematic_box1, 1) -- CCD: continuous collision detection
gh_box2d.actor_set_damping(b2_kinematic_box1, 0.0, 0.1)
gh_box2d.actor_set_transform(b2_kinematic_box1, static_box1_pos.x, static_box1_pos.y,   deg2rad(0.0))


-- The static wall
--
b2_static_box2 = gh_box2d.world_create_actor_box(b2_world, -48, static_box1_pos.y,    static_box1_size.x/2, static_box1_size.y/2,   "static", density, friction, restitution)
gh_box2d.actor_set_damping(b2_static_box2, 0.0, 0.1)
gh_box2d.actor_set_transform(b2_static_box2, -48, static_box1_pos.y,   deg2rad(0.0))




-- Dynamic obstacles
--
for i=1, num_boxes do
  local box = boxes[i]  

  density = 100.0
  friction = 0.3
  restitution = 0.2
  box.b2id = gh_box2d.world_create_actor_box(b2_world, box.posx, box.posy,    box.sizex/2.0, box.sizey/2.0,   "dynamic", density, friction, restitution)
  gh_box2d.actor_set_damping(box.b2id, 0.0, 0.0)
  gh_box2d.actor_set_transform(box.b2id, box.posx, box.posy,   deg2rad(0.0))
  gh_box2d.actor_set_linear_velocity(box.b2id, 0.0, 0.0)
  gh_box2d.actor_set_angular_velocity(box.b2id, deg2rad(0.0))

  -- Sleeping is not allowed here!!!!
  gh_box2d.actor_set_sleeping_allowed(box.b2id, 0)
 
end


