#version 120

uniform sampler2D tex0;
varying vec4 v_normal;

void main (void)
{
  vec3 N = normalize(v_normal.xyz);

  // Multiply by 0.5 and adding 0.5 => to map the normal vector coords from [-1;1] to [0;1].
  vec2 muv = N.xy * 0.5 + vec2(0.5,0.5);

  vec3 t = texture2D(tex0,vec2(muv.x, 1.0-muv.y)).rgb;
  gl_FragColor = vec4(t, 1.0);
}

