

function SaveGLSLCode()

  local glsl_text = gh_imgui.color_text_editor_get_text(glsl_editor)
  local demo_dir = gh_utils.get_demo_dir()
  full_shader_filename = demo_dir .. shader_filename
  gh_utils.file_write(full_shader_filename, glsl_text)

  operations_log = ""

  local glsl_error_str = "GLSL code OK."
  if (gh_gpu_program.update_shader_from_file(glsl_prog, full_shader_filename, 1, "pixel") == 0) then
    glsl_error_str = gh_gpu_program.get_shader_info_log(glsl_prog, "pixel")
  end
  

  local time = os.time()
  local cur_time_str = os.date('%Y-%m-%d@%H:%M:%S', time)

  -- if (string.len(operations_log) > 0) then
  --   operations_log = operations_log .. "\n"
  -- end

  operations_log = operations_log .. cur_time_str .. " " .. shader_filename .. " saved."
  if (string.len(glsl_error_str) > 0) then
    operations_log = operations_log .. "\n" .. cur_time_str .. " " .. glsl_error_str
  end
end



function SaveLuaCode()

  local lua_text = gh_imgui.color_text_editor_get_text(lua_editor)
  gh_utils.file_write(full_lua_filename, lua_text)

  local lua_error_str = ""

  operations_log = ""

  if (gh_utils.script_check_file_compilation(full_lua_filename, lua_script_name) == 1) then
    -- The script will be update next frame...
    gh_utils.script_update_from_file(lua_script_name, full_lua_filename)
    need_check_script_compil_log = true -- for next frame
    lua_error_str = "Lua code OK."
  else
    lua_error_str = gh_utils.scripting_get_last_error_message()
  end
  
  local time = os.time()
  local cur_time_str = os.date('%Y-%m-%d@%H:%M:%S', time)

  --if (string.len(operations_log) > 0) then
  --  operations_log = operations_log .. "\n"
  --end

  local frames_str = string.format("|frames: %0.6d|", total_frames)

  operations_log = operations_log .. cur_time_str  .. frames_str .. " " .. lua_filename .. " saved."
  if (string.len(lua_error_str) > 0) then
    operations_log = operations_log .. "\n" .. cur_time_str  .. frames_str .. " " ..  lua_error_str
  end
end





function CopyGLSLCode()
  gh_imgui.color_text_editor_copy_paste_cut(glsl_editor, "copy") 

  local time = os.time()
  local cur_time_str = os.date('%Y-%m-%d@%H:%M:%S', time)

  if (operations_log == "") then
    operations_log = cur_time_str .. " GLSL code copied."
  else
    operations_log = operations_log .. "\n" .. cur_time_str .. " GLSL code copied."
  end
end


function PasteGLSLCode()
  gh_imgui.color_text_editor_copy_paste_cut(glsl_editor, "paste") 

  local time = os.time()
  local cur_time_str = os.date('%Y-%m-%d@%H:%M:%S', time)

  if (operations_log == "") then
    operations_log = cur_time_str .. " GLSL code pasted."
  else
    operations_log = operations_log .. "\n" .. cur_time_str .. " GLSL code pasted."
  end
end



function CopyLuaCode()
  gh_imgui.color_text_editor_copy_paste_cut(lua_editor, "copy") 

  local time = os.time()
  local cur_time_str = os.date('%Y-%m-%d@%H:%M:%S', time)


  if (operations_log == "") then
    operations_log = cur_time_str .. " Lua code copied."
  else
    operations_log = operations_log .. "\n" .. cur_time_str .. " Lua code copied."
  end
end

function PasteLuaCode()
  gh_imgui.color_text_editor_copy_paste_cut(lua_editor, "paste") 

  local time = os.time()
  local cur_time_str = os.date('%Y-%m-%d@%H:%M:%S', time)

  if (operations_log == "") then
    operations_log = cur_time_str .. " Lua code pasted."
  else
    operations_log = operations_log .. "\n" .. cur_time_str .. " Lua code pasted."
  end

end














elapsed_time = gh_utils.get_elapsed_time()
dt = gh_utils.get_time_step()


frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  

total_frames = total_frames + 1

--CheckLuaError()



local platform_windows = 1 
local platform_osx = 2 
local platform_linux = 3 
local platform_rpi = 4 
local platform_tinkerboard = 5 
if (gh_utils.get_platform() == platform_windows) then
  gh_window.keyboard_update_buffer(0)
end



mouse_x, mouse_y = gh_input.mouse_get_position()



gh_camera.bind(camera_ortho)

gh_renderer.set_depth_test_state(0)

