    
local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_lib_dir() 		

dofile(lib_dir .. "lua/imgui.lua")    
dofile(lib_dir .. "lua/gxl.lua")  
dofile(lib_dir .. "lua/libfont/libfont1.lua")   


    
winW, winH = gh_window.getsize()
   

camera_ortho = gh_camera.create_ortho(-winW/2, winW/2, -winH/2, winH/2, 1.0, 10.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 4)



vertex_color_prog = gh_node.getid("vertex_color_program")

tex_prog = gh_node.getid("texture_program")
gh_gpu_program.bind(tex_prog)
gh_gpu_program.uniform1i(tex_prog, "tex0", 0)
gh_gpu_program.bind(0)




local absolute_path = 0
local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local pixel_format = PF_U8_RGBA
no_video_tex = gh_texture.create_from_file("data/no_video_20150412.jpg", pixel_format, absolute_path)


update_video = 0
update_audio = 0

video_width = 0
video_height = 0

duration = 1

volume = 0.7

video_stream = -1
audio_stream = -1




av_media_filename = "data/water.mkv"
--av_media_filename = "data/joe-good-girls.mp4"
--av_media_filename = "data/FKJ - Die With A Smile.mp4"
local video_filename = demo_dir .. av_media_filename


local loop_mode = 1
av1 = gh_av.decoder_open(video_filename, loop_mode)

if (av1 > 0) then

  gh_av.set_volume(av1, volume)

  video_stream, audio_stream = gh_av.get_streams_index(av1)

  if (video_stream >=0) then
    duration = gh_av.get_duration(av1)
    video_width, video_height = gh_av.video_get_resolution(av1)
    update_video = 1
  end  

  if (audio_stream >=0) then
    update_audio = 1
  end  
  
else

  print("Unable to load " .. video_filename)
  print("av1: " .. av1)

end





--update_audio = 0





video_tex = 0
mesh_quad = 0

if (av1 > 0) then
  
  if (update_video == 1) then
    local PF_U8_RGB = 1
    local PF_U8_BGR = 2
    video_tex = gh_av.video_init_texture(av1, PF_U8_RGB)

    -- new function / GeeXLab 0.29.6+
    -- video_tex = gh_av.video_init_texture_rgb24(av1)

  end
  
  gh_av.start_audio_video_processing(av1, update_video, update_audio)
end  



quad_width = 512
quad_height = 512

if ((video_width > 0) and (video_height > 0)) then
  local r = video_width / video_height
  quad_width = winW * 0.8
  quad_height = quad_width/r
end

mesh_quad = gh_mesh.create_quad(quad_width, quad_height)


mesh_pb_bkg = gh_mesh.create_quad(quad_width, 20)
gh_mesh.set_vertices_color(mesh_pb_bkg, 0.7, 0.7, 0.7, 1)

mesh_pb = gh_mesh.create_quad(1, 16)
gh_mesh.set_vertex_color(mesh_pb, 0, 0.6, 0.6, 0.7, 1) -- bottom-left
gh_mesh.set_vertex_color(mesh_pb, 1, 0.4, 0.4, 0.5, 1) -- up-left
gh_mesh.set_vertex_color(mesh_pb, 2, 0.4, 0.4, 0.5, 1) -- up-right
gh_mesh.set_vertex_color(mesh_pb, 3, 0.6, 0.6, 0.7, 1) -- bottom-right



last_time = gh_utils.get_elapsed_time()
video_frame_time = 0

space_key_pressed = 0
pause_state = 0

g_seek_key_pressed = 0
g_seek_key_pressed_time = 0

gh_renderer.vsync(1)

