
local elapsed_time = gh_utils.get_elapsed_time()
local dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  




gh_audio.sound_set_volume(sound, channel, noise_volume)
gh_audio.update()




gh_camera.bind(camera_ortho)

gh_renderer.set_depth_test_state(0)
gh_renderer.clear_color_depth_buffers(0.3, 0.3, 0.3, 1, 1.0)





gh_gpu_program.bind(electrical_arc_prog)
gh_gpu_program.uniform1f(electrical_arc_prog, "line_size", line_size)
gh_gpu_program.uniform1f(electrical_arc_prog, "time", elapsed_time)
gh_gpu_program.uniform1f(electrical_arc_prog, "arc_x", arc_x)
gh_gpu_program.uniform1f(electrical_arc_prog, "noise_scale", noise_scale)

gh_gpu_program.uniform4f(electrical_arc_prog, "bkgcolor", bkgcolor.r, bkgcolor.g, bkgcolor.b, bkgcolor.a)
gh_gpu_program.uniform4f(electrical_arc_prog, "arc_color1", arc_color1.r, arc_color1.g, arc_color1.b, arc_color1.a)
gh_gpu_program.uniform4f(electrical_arc_prog, "arc_color2", arc_color2.r, arc_color2.g, arc_color2.b, arc_color2.a)

gh_texture.bind(tex_noise, 0)

gh_object.set_euler_angles(arc_plane, 90, 0, 0)
gh_object.render(quad)









--[[
libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 0.5, 0, 1, "Electrical Arc")
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "FPS: " .. fps)
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_renderer)
y_offset = y_offset + 20

libfont_print(20, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_version)
y_offset = y_offset + 20


libfont_render()
--]]











  imgui_frame_begin()

  --gh_imgui.set_color(IMGUI_TITLE_BG_COLOR, 0.4, 0.4, 0.4, 0.90)

  gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.6)


  local is_open = imgui_window_begin_no_collapse("Control panel", 250, winH, 0, 0)
  if (is_open == 1) then

    win_hovered = gh_imgui.is_window_hovered()
  
    local window_w = gh_imgui.get_content_region_available_width()

    local widget_width = window_w * 1.0
    
    gh_imgui.text_rgba("Electrical Arc", 1.0, 1.0, 0.0, 1.0)
    
    gh_imgui.text("Press [ESC] to quit the demo")
    

    imgui_vertical_space_v2(3)


    gh_imgui.push_item_width(widget_width)

    local min_value = 0.001
    local max_value = 0.1
    local power = 1.0
    gh_imgui.text("Arc width")
    line_size = gh_imgui.slider_1f("##linesize", line_size,   min_value, max_value,   power)

    imgui_vertical_space_v2(2)

    min_value = 0.0
    max_value = 0.1
    gh_imgui.text("Noise scale")
    noise_scale = gh_imgui.slider_1f("##noise_scale", noise_scale,   min_value, max_value,   power)

    
    imgui_vertical_space_v2(2)

    min_value = 0.0
    max_value = 1.0
    gh_imgui.text("Arc X position")
    arc_x = gh_imgui.slider_1f("##arc_x", arc_x,   min_value, max_value,   power)

    imgui_vertical_space_v2(2)

    min_value = 0.0
    max_value = 1.0
    gh_imgui.text("Electrical noise volume")
    noise_volume = gh_imgui.slider_1f("##noise_volume", noise_volume,   min_value, max_value,   power)

    imgui_vertical_space_v2(2)

    gh_imgui.text("Background color")
    bkgcolor.r, bkgcolor.g, bkgcolor.b, bkgcolor.a = gh_imgui.color_edit_rgba("##bkgcolor", bkgcolor.r, bkgcolor.g, bkgcolor.b, bkgcolor.a)
    
    imgui_vertical_space_v2(2)

    gh_imgui.text("Arc color top")
    arc_color2.r, arc_color2.g, arc_color2.b, arc_color2.a = gh_imgui.color_edit_rgba("##arccolor2", arc_color2.r, arc_color2.g, arc_color2.b, arc_color2.a)

    imgui_vertical_space_v2(2)

    gh_imgui.text("Arc color bottom")
    arc_color1.r, arc_color1.g, arc_color1.b, arc_color1.a = gh_imgui.color_edit_rgba("##arccolor1", arc_color1.r, arc_color1.g, arc_color1.b, arc_color1.a)
       
    imgui_vertical_space_v2(4)
    
    imgui_separator()
    gh_imgui.text("Renderer")
    gh_imgui.text("-> " .. gl_renderer)
    imgui_vertical_space_v2(2)
    gh_imgui.text("OpenGL version")
    gh_imgui.text("-> " .. gl_version)


    gh_imgui.pop_item_width()


  end 

  imgui_window_end()

  imgui_frame_end()
  --
  -- ImGui end ---------------------------------------------------------------
  ----------------------------------------------------------------------------
  --]]
