
function UpdateQuadPosition(dt)
  px = px + (move_speed_x*dt)
  py = py + (move_speed_y*dt)
  
  if (px > winW/2) then
    px = winW/2
    move_speed_x = -move_speed_x
  end
  
  if (px < -winW/2) then
    px = -winW/2
    move_speed_x = -move_speed_x
  end
  
  if (py > winH/2) then
    py = winH/2
    move_speed_y = -move_speed_y
  end
  
  if (py < -winH/2) then
    py = -winH/2
    move_speed_y = -move_speed_y
  end
end  


function DrawQuad(x, y, r, g, b, a)
  gh_gpu_program.uniform4f(color_prog, "color", r, g, b, a)
  gh_object.set_position(quad, px, py, 0.0, 1.0)
  gh_object.render(quad)
end








    
local elapsed_time = gh_utils.get_elapsed_time()
local dt = elapsed_time - last_time
last_time = elapsed_time




gh_renderer.clear_color_depth_buffers(0.2, 0.2, 0.2, 1.0, 1.0)
gh_camera.bind(camera_ortho)
gh_gpu_program.bind(color_prog)


UpdateQuadPosition(dt)
DrawQuad(px, py, 1, 1, 0, 1)











libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 1.0, 0, 1, "Bouncing box")
y_offset = y_offset + 30

local hms_str, hour, min, sec = gh_utils.time_to_hour_min_sec(elapsed_time)

libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("-> elapsed time: %s", hms_str))
y_offset = y_offset + 20


libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("-> quad position: <%.1f ; %.1f>", px, py))
y_offset = y_offset + 20

libfont_render()
