"""
import sys

ptvsdPath = "C:/Users/jegx/AppData/Local/Programs/Python/Python37/site-packages"

if not any(ptvsdPath in p for p in sys.path):
  sys.path.append(ptvsdPath)


import ptvsd
#ptvsd.enable_attach("my_secret", address = ('127.0.0.1', 3000))

# 5678 is the default attach port in the VS Code debug configurations
#ptvsd.enable_attach(address=('127.0.0.1', 3000), redirect_output=True)
ptvsd.enable_attach(address=('127.0.0.1', 3000))
gh_utils.trace("Waiting for debugger attach")
#print("Waiting for debugger attach")
#Enable the below line of code only if you want the application to wait untill the debugger has attached to it


ptvsd.wait_for_attach()
breakpoint()

#print("Hello from GeeXLab")
gh_utils.trace("Hello from GeeXLab")
#print("Hello from GeeXLab 2")
"""





#----------------------------------------------------
# All GeeXLab modules
#
'''
import gh_asus_aura
import gh_audio
import gh_av
import gh_bullet3
import gh_camera
import gh_font
import gh_gml
import gh_gpu_buffer
import gh_gpu_program
import gh_gpumon
import gh_imagemagick
import gh_imgui
import gh_input
import gh_leap
import gh_light
import gh_logiled
import gh_material
import gh_mesh
import gh_model
import gh_nvg
import gh_node
import gh_object
import gh_opencl
import gh_vr
import gh_ps
import gh_physx3
import gh_physx4
import gh_polyline
import gh_render_target
import gh_renderer  
import gh_rpi
import gh_sqlite3
import gh_texture
import gh_utils
import gh_vb
import gh_vertex_pool
import gh_window
'''
#----------------------------------------------------


import sys
import random

sys.dont_write_bytecode = True





demo_dir = gh_utils.get_demo_dir() 		
sys.path.append(demo_dir)

lib_dir = gh_utils.get_lib_dir() 		
sys.path.append(lib_dir + "/python/")
sys.path.append(lib_dir + "/python/libfont/")

from imgui import *
from gxl_utils import *
from gxcamera_v1 import *
from libfont1 import *







#-------------------------------------------------------------------
gxl = gxl_utils()



#-------------------------------------------------------------------
winW, winH = gh_window.getsize(0)



#-------------------------------------------------------------------
orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_znear = 0.1
camera_zfar = 1000.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0


gx_camera = gxcamera()

camera = gx_camera.create_perspective(camera_fov, 1, 0, 0, winW, winH, camera_znear, camera_zfar)
gh_camera.set_position(camera, 0, 0, 12)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 90)

if (orbit_mode == 1):
  gx_camera.set_mode_orbit()
else:
  gx_camera.set_mode_fly()


gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)
#-------------------------------------------------------------------


#import pdb; pdb.set_trace()



#-------------------------------------------------------------------
#


color_prog = gh_node.getid("color_prog")
gh_gpu_program.uniform4f(color_prog, "color", 1, 1, 1, 1)





particle_prog = gh_node.getid("particle_prog")
gh_gpu_program.uniform1i(particle_prog, "tex0", 0)

particle_size = 8.0
gh_gpu_program.uniform1f(particle_prog, "particle_size", particle_size)






#-------------------------------------------------------------------


PF_U8_RGB = 1
PF_U8_RGBA = 3
PF_F32_RGBA = 6
pixel_format = PF_U8_RGBA
gen_mipmaps = 1
compressed_texture = ""

filename = demo_dir + "textures/flare19.jpg"
particle_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)





#-------------------------------------------------------------------
# The reference grid.
#
grid = gh_utils.grid_create()
grid_size = 50
grid_subdivisions = 20
gh_utils.grid_set_geometry_params(grid, grid_size, grid_size, grid_subdivisions, grid_subdivisions)
gh_utils.grid_set_lines_color(grid, 0.7, 0.7, 0.7, 1.0)
gh_utils.grid_set_main_lines_color(grid, 1.0, 1.0, 0.0, 1.0)
gh_utils.grid_set_main_x_axis_color(grid, 1.0, 0.0, 0.0, 1.0)
gh_utils.grid_set_main_z_axis_color(grid, 0.0, 0.0, 1.0, 1.0)
display_main_lines = 1
display_lines = 1
gh_utils.grid_set_display_lines_options(grid, display_main_lines, display_lines)




torus = gh_mesh.create_torus(5.0, 1.0, 20)









#-------------------------------------------------------------------
# NumPy
#-------------------------------------------------------------------
import numpy as np 

list1 = [0,1,2,3,4]
arr1d = np.array(list1)
gh_utils.trace("Numpy test")
gh_utils.trace("- array type: " + str(type(arr1d)))
gh_utils.trace("- array: " + str(arr1d))




A = np.array([[1, 2],
              [3, 4]])
B = np.array([10, 20])
AB = np.matmul(A, B)


# https://numpy.org/devdocs/user/basics.types.html



verts = np.array([[1.1, 2.1, 3.1],  [10.1, 20.1, 30.1], [40.1, 50.1, 60.1], [70.1, 80.1, 90.1]], dtype=np.float32)

#verts = np.random.rand(3,2)
# array([[ 0.14022471,  0.96360618],  #random
#        [ 0.37601032,  0.25528411],  #random
#        [ 0.49313049,  0.94909878]]) #random




#-------------------------------------------------------------------
# Vertex pool creation and initialization.
#
num_particles = 200000
use_position_float64 = 1
use_fast_vertices_update = 1
#num_particles = 1000
#vp = gh_vertex_pool.create(num_particles)
separate_vertex_array = 1
position_dim = 4 # position has 4 coordinates: X, Y, Z and W - Default is 3
vp = gh_vertex_pool.create_v2(num_particles, separate_vertex_array, position_dim)


# https://docs.scipy.org/doc/numpy-1.15.0/reference/generated/numpy.random.rand.html#numpy.random.rand
# https://numpy.org/doc/stable/reference/random/legacy.html#numpy.random.RandomState

#dtype=np.float32

#particles_pos = np.random.rand(num_particles, 4) * pos_scale

particles_pos_f64 = np.random.uniform(-10.0, 10.0, size=(num_particles, 4))
particles_pos_f32 = particles_pos_f64.astype(np.float32)


# Init particles position and color
#
i = 0
for p in particles_pos_f32:
  gh_vertex_pool.vertex_set_position(vp, i, p[0], p[1], p[2], 1.0)

  alpha = 1.0
  x = random.random()
  y = random.random()
  z = random.random()
  gh_vertex_pool.vertex_set_color(vp, i, x, y, z, alpha)

  i = i + 1





"""
for i in range(num_particles):
  x=random.uniform(-6.0, 6.0)
  y=random.uniform(-6.0, 6.0)
  z=random.uniform(-6.0, 6.0)
  gh_vertex_pool.vertex_set_position(vp, i, x, y, z, 1)
  
  alpha = 1.0
  x = random.random()
  y = random.random()
  z = random.random()
  gh_vertex_pool.vertex_set_color(vp, i, x, y, z, alpha)
"""





#-------------------------------------------------------------------


# vertical synchronization
gh_renderer.vsync(0)


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()

frames = 0
fps_time = 0
fps = 0

imgui_hovered = 0

