

# Elapsed time and FPS --------------------------------
#
elapsed_time = gh_utils.get_elapsed_time()
dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0):
  fps_time = 0
  fps = frames
  frames = 0



# Current screen size  --------------------------------
#
winW, winH = gh_window.getsize(0)


# Mouse position  --------------------------------
#
mouseX, mouseY = gh_input.mouse_get_position()



# Clear the screen --------------------------------
#
gh_renderer.set_depth_test_state(1)
gh_renderer.clear_color_depth_buffers(0.0, 0.0, 0.0, 1, 1.0)




# 3D code START --------------------------------
#

# Camera 3D  ------
#
if (imgui_hovered == 0):
  gx_camera.update(camera, dt)

gh_camera.bind(camera)









# Grid rendering
gh_gpu_program.bind(color_prog)
# gh_renderer.wireframe()
# gh_object.render(torus)
# gh_renderer.solid()
gh_object.render(grid)










if (use_fast_vertices_update == 1):

  if (use_position_float64 == 1):
    # 200K parts - 650 FPS (float64)
    gh_vertex_pool.vertices_position_from_numpy_array_f64(vp, particles_pos_f64, num_particles)
  else:
    # 200K parts - 850 FPS (float32)
    gh_vertex_pool.vertices_position_from_numpy_array_f32(vp, particles_pos_f32, num_particles)

else:
  # 200K parts - 7 FPS (float32 or float64)
  i = 0
  for p in particles_pos_f32:
    gh_vertex_pool.vertex_set_position(vp, i, p[0], p[1], p[2], 1.0)
    i = i + 1


# 1400 FPS without update!










gh_renderer.set_blending_state(1)
gh_renderer.set_blending_factors(1, 1)

gh_renderer.set_depth_test_state(0)

gh_gpu_program.bind(particle_prog)

gh_texture.bind(particle_tex, 0)
#particle_size = 4.0
gh_gpu_program.uniform1f(particle_prog, "particle_size", particle_size)
speed_factor = 1.0
gh_object.set_euler_angles(vp, elapsed_time*3 * speed_factor, elapsed_time*5 * speed_factor, elapsed_time*7 * speed_factor)
gh_vertex_pool.render(vp, 0, num_particles)

gh_renderer.set_depth_test_state(1)
gh_renderer.set_blending_state(0)






#
# 3D code END --------------------------------






# Display some information --------------------------------
#
"""
libfont_clear()

y_offset = 40

libfont_print(10, y_offset, 1, 1, 0, 1, "FPS: " + str(fps))
y_offset = y_offset + 30

libfont_print(10, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20

libfont_print(10, y_offset, 1, 1, 1, 1, "> " + gl_renderer)
y_offset = y_offset + 20

libfont_print(10, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20

libfont_print(10, y_offset, 1, 1, 1, 1, "> " + gl_version)
y_offset = y_offset + 40

libfont_print(10, y_offset, 0.4, 0.4, 0.4, 1, "Resolution: %d x %d" % (winW, winH))
y_offset = y_offset + 20

libfont_print(10, y_offset, 0.4, 0.4, 0.4, 1, "Mouse: %d x %d" % (mouseX, mouseY))
y_offset = y_offset + 20


libfont_render()
"""




  
# Display some widgets / User Interface --------------------------------
#
imgui_frame_begin()
gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.8)

is_open = imgui_window_begin_pos_size_once("Control panel", 300, winH, 0, 0)
if (is_open == 1):

  gh_imgui.text("Vertex Pool - Python 3")

  gh_imgui.spacing()
  gh_imgui.spacing()


  gh_imgui.text("FPS: " + str(fps))
  gh_imgui.text("GL_RENDERER: " + gl_renderer)
  gh_imgui.text("GL_VERSION: " + gl_version)
  gh_imgui.text("Resolution: %d x %d" % (winW, winH))

  gh_imgui.spacing()
  gh_imgui.spacing()
  gh_imgui.text("Particles: %d" % (num_particles))

  particle_size = gh_imgui.slider_1f("##particle_size", particle_size, 0.0, 20.0, 1.0)


  gh_imgui.spacing()
  gh_imgui.spacing()

  use_position_float64 = gh_imgui.checkbox("Use 64-bit numpy array", use_position_float64)
  use_fast_vertices_update = gh_imgui.checkbox("Use fast vertices update", use_fast_vertices_update)


  imgui_hovered = 0
  if (gh_imgui.is_window_hovered() == 1):
    imgui_hovered = 1

  if (gh_imgui.is_any_item_hovered() == 1):
    imgui_hovered = 1



imgui_window_end()
imgui_frame_end()

