

# Elapsed time and FPS --------------------------------
#
elapsed_time = gh_utils.get_elapsed_time()
dt = gh_utils.get_time_step()

frames += 1

fps_frames += 1
fps_time = fps_time + dt
if (fps_time >= 1.0):
  fps_time = 0
  fps = fps_frames
  fps_frames = 0



# Current screen size  --------------------------------
#
winW, winH = gh_window.getsize(0)


# Mouse position  --------------------------------
#
mouseX, mouseY = gh_input.mouse_get_position()



# Clear the screen --------------------------------
#
gh_renderer.set_depth_test_state(0)
gh_renderer.clear_color_depth_buffers(0.0, 0.0, 0.0, 1, 1.0)





  
# Display some widgets / User Interface --------------------------------
#
# Display some widgets / User Interface --------------------------------
#
imgui_frame_begin()
gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 1.0, 1.0, 1.0, 1.0)

is_open = imgui_window_begin_no_collapse("Python Sandbox", winW, winH, 0, 0)
if (is_open == 1):

  color1 = (0.2, 0.6, 1.0, 1.0)

  if (gh_imgui.button('Python 3 standard library doc', 240, 30) == 1):
    gh_utils.open_url("https://docs.python.org/3/library/index.html")

  imgui_vertical_space_v2(3)

  gh_imgui.text("Render speed => %d FPS, dt => %.3f msec, frames => %d" % (fps, dt*1000, frames))


  imgui_vertical_space_v2(3)


  ts = time.time()
  gh_imgui.text_rgba("time.time()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text("%.1f sec" % ts)

  st = datetime.datetime.fromtimestamp(ts).strftime('%Y-%m-%d %H:%M:%S')
  gh_imgui.text_rgba("datetime.datetime.fromtimestamp(ts).strftime('%%Y-%%m-%%d %%H:%%M:%%S')", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(st)

  current_date = strftime("%a, %d %b %Y %H:%M:%S +0000", gmtime())
  gh_imgui.text_rgba("strftime('%%a, %%d %%b %%Y %%H:%%M:%%S +0000', gmtime())", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(current_date)

  imgui_vertical_space_v2(5)


  gh_imgui.text_rgba("sys.executable", color1[0], color1[1], color1[2], color1[3])
  if (sys.executable == ""):
    gh_imgui.text("_EMPTY_")
  else:
    gh_imgui.text(str(sys.executable))

  gh_imgui.text_rgba("sys.float_info", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text_wrapped(str(sys.float_info))

  gh_imgui.text_rgba("sys.hexversion", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(sys.hexversion))

  gh_imgui.text_rgba("sys.version", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(sys.version)

  gh_imgui.text_rgba("sys.api_version", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(sys.api_version))

  gh_imgui.text_rgba("sys.version_info", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(sys.version_info))

  gh_imgui.text_rgba("sys.platform", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(sys.platform)

  gh_imgui.text_rgba("sys.path", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(sys.path))

  if (py_major > 3) or ((py_major == 3) and (py_minor >= 9)):
    gh_imgui.text_rgba("sys.platlibdir", color1[0], color1[1], color1[2], color1[3])
    gh_imgui.text(str(sys.platlibdir))

  imgui_vertical_space_v2(5)



  gh_imgui.text_rgba("sysconfig.get_python_version()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(sysconfig.get_python_version()))

  gh_imgui.text_rgba("sysconfig.get_path_names()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(sysconfig.get_path_names()))

  gh_imgui.text_rgba("sysconfig.get_path('stdlib')", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(sysconfig.get_path('stdlib')))


  imgui_vertical_space_v2(5)



  gh_imgui.text_rgba("platform.architecture()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(platform.architecture()))

  gh_imgui.text_rgba("platform.processor()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(platform.processor()))

  gh_imgui.text_rgba("platform.system()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(platform.system()))

  gh_imgui.text_rgba("platform.uname()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text_wrapped(str(platform.uname()))



  imgui_vertical_space_v2(5)





  if (sys.platform == "win32"):
    # os.getlogin() module does not work on Linux mint 19.1...
    #Error line: 153 - Error object: <class 'OSError'> - Error data: OSError(25, 'Inappropriate ioctl for device')
    gh_imgui.text_rgba("os.getlogin()", color1[0], color1[1], color1[2], color1[3])
    gh_imgui.text(str(os.getlogin()))



  gh_imgui.text_rgba("os.getpid()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(os.getpid()))

  gh_imgui.text_rgba("os.cpu_count()", color1[0], color1[1], color1[2], color1[3])
  gh_imgui.text(str(os.cpu_count()))




imgui_window_end()
imgui_frame_end()
