

local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_lib_dir() 		

dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    






winW, winH = gh_window.getsize(0)


win_hovered = 0


--[[
local aspect = winW / winH
camera = gh_camera.create_persp(60, aspect, 0.1, 1000.0)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 0.2, 0.4)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.setupvec(camera, 0, 1, 0, 0)
--]]




orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 5
camera_lookat_z = 0

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 0.1, 500)
gh_camera.set_position(camera, 0, 0, 30)
gx_camera.init_orientation(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z, 30, 90)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)






camera_ortho = gh_camera.create_ortho(-winW/2, winW/2, -winH/2, winH/2, 1.0, 10.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 4)









texture_prog = gh_node.getid("texture_prog")
gh_gpu_program.uniform1i(texture_prog, "tex0", 0)
gh_gpu_program.uniform4f(texture_prog, "glow_color", 0, 0, 0, 0)






lighting_prog = gh_node.getid("lighting_prog")
gh_gpu_program.uniform4f(lighting_prog, "glow_color", 0, 0, 0, 0)
gh_gpu_program.uniform4f(lighting_prog, "light_position", 5, 20, 10, 1)
gh_gpu_program.uniform4f(lighting_prog, "light_color", 1, 1, 1, 1)
gh_gpu_program.uniform4f(lighting_prog, "material_color", 1, 1, 1, 1)






local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 1
local compressed_texture = 0

local filename = demo_dir .. "textures/Bullet_Physics_Library_Logo.png"
bullet_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)





quad = gh_mesh.create_quad(180, 80)







sphere_start_pos={x=1.5, y=18, z=0}

sphere_radius = 0.6
sphere = gh_mesh.create_sphere(sphere_radius, 20, 20)
gh_object.set_position(sphere, sphere_start_pos.x, sphere_start_pos.y, sphere_start_pos.z)
gh_object.set_euler_angles(sphere, 0, 0, 0)






borderz = gh_mesh.create_box(30, 2.0, 2.0, 1, 1, 1)
borderx = gh_mesh.create_box(1.0, 20.0, 20.0, 1, 1, 1)







-- Kinematic objects / obstacles ---------------------------
--

obstacles = {}
num_obstacles = 0
obstacle_size = {x=6.0, y=0.2, z=2.0}


function new_obstacle(px, py, rz)
	local o = {b3id=0, mesh=0, posx=px, posy=py, posz=0, angx=0, angy=0, angz=rz, qx=0, qy=0, qz=0, qw=0}
	o.mesh = gh_mesh.create_box(obstacle_size.x, obstacle_size.y, obstacle_size.z, 1, 1, 1)
	num_obstacles = num_obstacles + 1
	obstacles[num_obstacles] = o
	return o
end



new_obstacle(4.8, 1.0, 15)
new_obstacle(-3, 3.4, -31)
new_obstacle(3, 5.0, 32)
new_obstacle(-1.7, 7.0, -36)
new_obstacle(5, 10.0, 42)
new_obstacle(-0.37, 11.0, -37)
new_obstacle(5.5, 15.3, 40)
new_obstacle(-2.5, 16.8, -68)

obstacle_mesh = gh_mesh.create_box(obstacle_size.x, obstacle_size.y, obstacle_size.z, 1, 1, 1)










ground = gh_mesh.create_plane(30, 20, 2, 2)
gh_object.set_position(ground, 0, 0, 0)






gh_renderer.set_vsync(0)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0

start_simulation = 0

selected_obstacle = -1





------------------------------------------------------------------------------
-- Bullet Physcis 
------------------------------------------------------------------------------


random = function (a, b)
	if (a > b) then
		local c = b
		b = a
		a = c
	end
	local delta = b-a
	return (a + math.random()*delta)
end



reset_simulation = 1


bullet3_ver = gh_bullet3.get_version()

-- Inits the Bullet engine.
gh_bullet3.init()


-- Creates a scene
b3_scene = gh_bullet3.scene_create()

-- Sets the gravity
scene_gravity = {x=0, y=-10, z=0}
gh_bullet3.scene_set_gravity(b3_scene, scene_gravity.x, scene_gravity.y, scene_gravity.z)


-- Creates a material.
local restitution = 0.1
local friction = 0.5
b3_ground_mat = gh_bullet3.material_create(restitution, friction)


-- Creates the ground plane. The ground plan is a static / kinematic actor (mass = 0). 
local mass = 0.0 -- mass = 0 --> kinematic
local ground_height = 2.0
b3_ground = gh_bullet3.actor_create_static_plane(0, 1, 0,   0,  b3_ground_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_ground)


b3_border_posx = gh_bullet3.actor_create_static_plane_v2(-1, 0, 0,  10, 0, 0,  b3_ground_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_border_posx)

b3_border_negx = gh_bullet3.actor_create_static_plane_v2(1, 0, 0, -10, 0, 0,  b3_ground_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_border_negx)


-- Creates a rigid body / dynamic actor (mass > 0)
mass = 10.0 

restitution = 0.8
friction = 0.3
b3_sphere_mat = gh_bullet3.material_create(restitution, friction)

-- Creates the second rigid body / dynamic actor (mass > 0)
b3_sphere = gh_bullet3.actor_create_sphere(sphere_radius,   sphere_start_pos.x, sphere_start_pos.y, sphere_start_pos.z,   mass,  b3_sphere_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_sphere)

-- gh_bullet3.actor_set_damping(b3_sphere, 0.85, 0.5)
-- vx = random(-0.1, 0.1)
-- vy = random(-0.2, 0.2)
-- vz = random(-0.2, 0.2)
-- gh_bullet3.actor_set_angular_velocity(b3_sphere, vx, vy, vz)



-- Creates kinematic actors (mass == 0) --------------------------------
--
mass = 0.0 

local restitution = 0.8
local friction = 0.2
b3_obstacle_mat = gh_bullet3.material_create(restitution, friction)


for i=1, num_obstacles do
	local o = obstacles[i]
	o.b3id = gh_bullet3.actor_create_box(obstacle_size.x, obstacle_size.y, obstacle_size.z,   o.posx, o.posy, o.posz,   mass,  b3_obstacle_mat)
	gh_bullet3.scene_add_actor(b3_scene, o.b3id)

	o.qx, o.qy, o.qz, o.qw = gh_utils.math_quat_from_euler_angles(o.angx, o.angy, o.angz)
	gh_bullet3.actor_set_orientation(o.b3id, o.qx, o.qy, o.qz, o.qw)
	gh_bullet3.actor_set_position(o.b3id, o.posx, o.posy, o.posz)

end




-- Run a scene simulation before.
max_sub_steps = 2
fixed_time_step = 1.0/60.0
gh_bullet3.scene_step_simulation(b3_scene, dt, max_sub_steps, fixed_time_step)

-- New mass
mass = 10.0
gh_bullet3.actor_update_mass(b3_box, mass)

-- Material properties
restitution = 1.2
friction = 0.7
gh_bullet3.material_update(b3_mat, restitution, friction)
gh_bullet3.actor_set_material(b3_box, b3_mat)






