
local elapsed_time = gh_utils.get_elapsed_time()
local dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  












-- Bullet physics simulation. 
if (start_simulation == 1) then

  if (reset_simulation == 1) then
    reset_simulation = 0
    
    sphere_start_pos.x = 1.5
    sphere_start_pos.y = 19.0

    gh_bullet3.actor_set_position(b3_sphere, sphere_start_pos.x, sphere_start_pos.y, sphere_start_pos.z)
    gh_bullet3.actor_set_linear_velocity(b3_sphere, -15.0, -10.0, 0)
    --gh_bullet3.actor_apply_central_force(b3_sphere, 0, -10.0, 0)
    
    local lin_damping = 0.02
    local ang_damping = 0.05
    gh_bullet3.actor_set_damping(b3_sphere, lin_damping, ang_damping)

    -- local vx = random(-2.0, 2.0)
    -- local vy = random(-2.0, 2.0)
    -- local vz = random(-2.0, 2.0)
    -- gh_bullet3.actor_set_angular_velocity(b3_sphere, vx, vy, vz)
  end
  

  
  for i=1, num_obstacles do
    local o = obstacles[i]
    o.qx, o.qy, o.qz, o.qw = gh_utils.math_quat_from_euler_angles(o.angx, o.angy, o.angz)
    gh_bullet3.actor_set_orientation(o.b3id, o.qx, o.qy, o.qz, o.qw)
    gh_bullet3.actor_set_position(o.b3id, o.posx, o.posy, o.posz)
  end
  

  max_sub_steps = 4
  fixed_time_step = 1.0/60.0
  gh_bullet3.scene_set_solver_num_iterations(b3_scene, 8)
  gh_bullet3.scene_step_simulation(b3_scene, dt, max_sub_steps, fixed_time_step)
end







if (win_hovered == 0) then
  gx_camera.update(camera, dt)
end  
gh_camera.bind(camera)



gh_renderer.set_depth_test_state(1)


gh_renderer.clear_color_depth_buffers(0.0, 0.2, 0.4, 1, 1.0)







gh_gpu_program.bind(lighting_prog)

gh_gpu_program.uniform4f(lighting_prog, "material_color", 0.2, 0.2, 0.9, 1)
gh_object.render(ground)

gh_gpu_program.uniform4f(lighting_prog, "material_color", 1.0, 1.0, 0.2, 1)
gh_object.set_position(borderz, 0, 1, -11)
gh_object.render(borderz)

gh_object.set_position(borderz, 0, 1, 11)
gh_object.render(borderz)

gh_object.set_position(borderx, 11, 10, 0)
gh_object.render(borderx)

gh_object.set_position(borderx, -11, 10, 0)
gh_object.render(borderx)









gh_gpu_program.uniform4f(lighting_prog, "material_color", 0, 0.4, 0.8, 1)

for i=1, num_obstacles do
  local o = obstacles[i]
  gh_object.set_position(obstacle_mesh, o.posx, o.posy, o.posz)
  gh_object.set_orientation(obstacle_mesh, o.qx, o.qy, o.qz, o.qw)

  if (selected_obstacle == i) then
    gh_gpu_program.uniform4f(lighting_prog, "glow_color", 0.0, 0.8, 0.0, 0)
  else
    gh_gpu_program.uniform4f(lighting_prog, "glow_color", 0.1, 0.1, 0.2, 0)
  end

  gh_object.render(obstacle_mesh)
end





gh_gpu_program.uniform4f(lighting_prog, "material_color", 1.0, 0.2, 0.2, 1)
gh_gpu_program.uniform4f(lighting_prog, "glow_color", 0.2, 0.1, 0.1, 0)


gh_bullet3.actor_apply_transform(b3_sphere, sphere)
gh_texture.bind(sphere_tex, 0)
gh_object.render(sphere)






gh_renderer.set_depth_test_state(0)
gh_renderer.set_blending_state(1)
gh_renderer.set_blending_factors(2, 5)
gh_gpu_program.bind(texture_prog)
gh_gpu_program.uniform4f(texture_prog, "uvtiling", 1, 1, 0, 0)
gh_camera.bind(camera_ortho)
gh_texture.bind(bullet_tex, 0)
gh_object.set_position(quad, winW/2-95, -winH/2+45)
gh_object.render(quad)
gh_renderer.set_blending_state(0)














  imgui_frame_begin()

  --gh_imgui.set_color(IMGUI_TITLE_BG_COLOR, 0.4, 0.4, 0.4, 0.90)
  gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.8)

  local is_open = imgui_window_begin_pos_size_always("Control panel", 300, winH, 0, 0)
  if (is_open == 1) then
  

    win_hovered = gh_imgui.is_window_hovered()
            
    
    gh_imgui.text_rgba("Bullet3 Physics SDK version: " .. bullet3_ver, 1.0, 1.0, 0.0, 1.0)

    gh_imgui.spacing()
    gh_imgui.spacing()

    gh_imgui.text(string.format("FPS: %.0f", fps))
    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.text(string.format("GL_RENDERER: %s", gl_renderer))
    gh_imgui.text(string.format("GL_VERSION: %s", gl_version))

   
    
    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()
    
    gh_imgui.text("Simulation")

    local label = "RUN"
    if (start_simulation == 1) then
      label = "PAUSE"
    end
    if (gh_imgui.button(label, 60, 30) == 1) then
      if (start_simulation == 1) then
        start_simulation = 0
      else
        start_simulation = 1
      end
    end

    gh_imgui.same_line(0, 10)

    if (gh_imgui.button("RESET", 120, 30) == 1) then
      reset_simulation = 1
    end


    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()

    selected_obstacle = -1

    for i=1, num_obstacles do
      local index = num_obstacles - i + 1
      local o = obstacles[index]
      local v_min = 0;
      local v_max = 0;
      local power = 1.0;

      gh_imgui.text("Obstacle " .. index)

      v_min = -30;
      v_max = 30;
      o.posx, o.posy = gh_imgui.slider_2f("pos xy##pos_" .. o.b3id, o.posx, o.posy,  v_min, v_max, power)

      if (gh_imgui.is_item_hovered() == 1) then
        selected_obstacle = index
      end



      v_min = -89;
      v_max = 89;
      o.angz = gh_imgui.slider_1f("angle z##angle_" .. o.b3id, o.angz,  v_min, v_max, power)
      o.qx, o.qy, o.qz, o.qw = gh_utils.math_quat_from_euler_angles(o.angx, o.angy, o.angz)

      if (gh_imgui.is_item_hovered() == 1) then
        selected_obstacle = index
      end
    end
    

   

  end 

  imgui_window_end()
  imgui_frame_end()
  --
  -- ImGui end ---------------------------------------------------------------
  ----------------------------------------------------------------------------
  --]]
