

local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_scripting_libs_dir() 		

dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    






winW, winH = gh_window.getsize(0)


win_hovered = 0


--[[
local aspect = winW / winH
camera = gh_camera.create_persp(60, aspect, 0.1, 1000.0)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 0.2, 0.4)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.setupvec(camera, 0, 1, 0, 0)
--]]




orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 1, 1000)
gh_camera.set_position(camera, 0, 0, 8)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 90)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)






camera_ortho = gh_camera.create_ortho(-winW/2, winW/2, -winH/2, winH/2, 1.0, 10.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 4)





wire_color = {r=1.0, g=1.0, b=1.0, a=1.0}
box_color = {r=1.0, g=0.5, b=0.0, a=1.0}
ground_color = {r=0.7, g=0.7, b=0.7, a=1.0}


texture_prog = gh_node.getid("texture_prog")
gh_gpu_program.uniform1i(texture_prog, "tex0", 0)


local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 1
local compressed_texture = 0

local filename = demo_dir .. "textures/9452-diffuse.jpg"
box_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/Wood031_2K_Color.jpg"
box2_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/10912-diffuse.jpg"
sphere_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/4791-diffuse.jpg"
ground_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)


filename = demo_dir .. "textures/Bullet_Physics_Library_Logo.png"
bullet_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)




--quad = gh_mesh.create_quad(350, 150)
quad = gh_mesh.create_quad(180, 80)




box_size = 1.0
box = gh_mesh.create_box(box_size, box_size, box_size, 1, 1, 1)
gh_object.set_position(box, 1, 3, 0)
gh_object.set_euler_angles(box, 0, 0, 0)


sphere_radius = 0.5
sphere = gh_mesh.create_sphere(sphere_radius, 20, 20)
gh_object.set_position(sphere, -1, 3, 0)
gh_object.set_euler_angles(sphere, 0, 0, 0)




-- Kinematic object ---------------------------
--
kinematic_pos = {x=2, y=0.6, z=0}

box2_size = {x=5.0, y=0.2, z=3.0}
box2 = gh_mesh.create_box(box2_size.x, box2_size.y, box2_size.z, 1, 1, 1)
gh_object.set_position(box2, kinematic_pos.x, kinematic_pos.y, kinematic_pos.z)
gh_object.set_euler_angles(box2, 0, 0, 0)

box21 = gh_mesh.create_box(box2_size.x, box2_size.y, box2_size.z, 1, 1, 1)
gh_object.set_position(box21, kinematic_pos.x, kinematic_pos.y + 2.0, kinematic_pos.z)
gh_object.set_euler_angles(box21, 0, 0, 0)




ground = gh_mesh.create_plane(20, 20, 2, 2)
gh_object.set_position(ground, 0, 0, 0)






gh_renderer.set_vsync(1)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0





------------------------------------------------------------------------------
-- Bullet Physcis 
------------------------------------------------------------------------------


random = function (a, b)
	if (a > b) then
		local c = b
		b = a
		a = c
	end
	local delta = b-a
	return (a + math.random()*delta)
end



reset_simulation = 1


bullet3_ver = gh_bullet3.get_version()

-- Inits the Bullet engine.
gh_bullet3.init()


-- Creates a scene
b3_scene = gh_bullet3.scene_create()

-- Sets the gravity
scene_gravity = {x=0, y=-10, z=0}
gh_bullet3.scene_set_gravity(b3_scene, scene_gravity.x, scene_gravity.y, scene_gravity.z)


-- Creates a material.
local restitution = 0.02
local friction = 0.5
b3_mat = gh_bullet3.material_create(restitution, friction)


-- Creates the ground plane. The ground plan is a static / kinematic actor (mass = 0). 
local mass = 0.0 -- mass = 0 --> kinematic
local ground_height = 2.0
b3_ground = gh_bullet3.actor_create_static_plane(0, 1, 0,   0,  b3_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_ground)



-- Creates a rigid body / dynamic actor (mass > 0)
mass = 10.0 
b3_box = gh_bullet3.actor_create_box(box_size, box_size, box_size,   1, 4, 0,   mass,  b3_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_box)

gh_bullet3.actor_set_damping(b3_box, 0.85, 0.5)

-- Sets some angular speed.
local vx = random(-0.1, 0.1)
local vy = random(-0.2, 0.2)
local vz = random(-0.2, 0.2)
gh_bullet3.actor_set_angular_velocity(b3_box, vx, vy, vz)



-- Creates the second rigid body / dynamic actor (mass > 0)
b3_sphere = gh_bullet3.actor_create_sphere(sphere_radius,   -1, 4, 0,   mass,  b3_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_sphere)

gh_bullet3.actor_set_damping(b3_sphere, 0.85, 0.5)

vx = random(-0.1, 0.1)
vy = random(-0.2, 0.2)
vz = random(-0.2, 0.2)
gh_bullet3.actor_set_angular_velocity(b3_sphere, vx, vy, vz)





-- Creates a kinematic actor (mass == 0) --------------------------------
mass = 0.0 
--b3_box2 = gh_bullet3.actor_create_box(box2_size, box2_size, box2_size,   4, 1.2, 0,   mass,  b3_mat)
b3_box2 = gh_bullet3.actor_create_box(box2_size.x, box2_size.y, box2_size.z,   kinematic_pos.x, kinematic_pos.y, kinematic_pos.z,   mass,  b3_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_box2)

b3_box21 = gh_bullet3.actor_create_box(box2_size.x, box2_size.y, box2_size.z,   kinematic_pos.x, kinematic_pos.y + 2.0, kinematic_pos.z,   mass,  b3_mat)
gh_bullet3.scene_add_actor(b3_scene, b3_box21)




-- Let' change actor's mass and material properties.
--

-- Run a scene simulation before.
max_sub_steps = 2
fixed_time_step = 1.0/60.0
gh_bullet3.scene_step_simulation(b3_scene, dt, max_sub_steps, fixed_time_step)

-- New mass
mass = 10.0
gh_bullet3.actor_update_mass(b3_box, mass)

-- Material properties
restitution = 1.2
friction = 0.7
gh_bullet3.material_update(b3_mat, restitution, friction)
gh_bullet3.actor_set_material(b3_box, b3_mat)






