import math
import random

class Vector3:
  def __init__(self, x = 0, y = 0, z = 0):
    self.x = x
    self.y = y
    self.z = z

  def add(self, v):
    return Vector3(
            self.x + v.x,
            self.y + v.y,
            self.z + v.z)

  def sub(self, v):
    return Vector3(
            self.x - v.x,
            self.y - v.y,
            self.z - v.z)

  def mul(self, v):
    return Vector3(
            self.x * v.x,
            self.y * v.y,
            self.z * v.z)

  def muls(self, s):
    return Vector3(
            self.x * s,
            self.y * s,
            self.z * s)

  def div(self, v):
    return Vector3(
            self.x / v.x,
            self.y / v.y,
            self.z / v.z)

  def divs(self, s):
    return Vector3(
            self.x / s,
            self.y / s,
            self.z / s)

  def dot(self, v):
    return self.x * v.x + self.y * v.y + self.z * v.z
  
  def norm(self):
    return math.sqrt(self.dot(self))

  def unit(self):
    return self.divs(self.norm())  
