

local demo_dir = gh_utils.get_demo_dir() 		

local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    
dofile(lib_dir .. "lua/gxl.lua")    



winW, winH = gh_window.getsize(0)



-- for ImGui interface.
imgui_hovered = 0




-----------------------------------------------------------------------------
--
orbit_mode = 1
keyboard_speed = 1.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 0.1, 1000)
gh_camera.set_position(camera, 0, 0, 12)
gx_camera.init_orientation(camera, 0, 0, 0, 30, -90)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)







-----------------------------------------------------------------------------
--
texture_prog = gh_node.getid("texture_prog")
gh_gpu_program.uniform1i(texture_prog, "tex0", 0)





-----------------------------------------------------------------------------
--
local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 1
local compressed_texture = 0

local filename = demo_dir .. "textures/9452-diffuse.jpg"
box_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/10912-diffuse.jpg"
sphere_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/4791-diffuse.jpg"
ground_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)


--filename = demo_dir .. "textures/Bullet_Physics_Library_Logo.png"
--bullet_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)








quad = gh_mesh.create_quad(180, 80)




box_size_x = 1.0
box_size_y = 2.0
box_size_z = 1.0

box1 = gh_mesh.create_box(box_size_x, box_size_y, box_size_z, 1, 1, 1)
gh_object.set_position(box1, 1, 3, 0)

box2 = gh_mesh.create_box(box_size_x, box_size_y, box_size_z, 1, 1, 1)
gh_object.set_position(box2, -1, 3, 0)



ground = gh_mesh.create_plane(20, 20, 2, 2)





gh_renderer.set_vsync(1)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0










physx5_ver = ""

gpu_physx = 0

px_scene = 0

physx_ok = gh_physx5.start()
if (physx_ok == 1) then
  gh_utils.trace("PhysX 5 started up ok.")
  
  local vmajor, vminor, vpatch = gh_physx5.get_version()
  physx5_ver = string.format("%d.%d.%d", vmajor, vminor, vpatch)

  --gpu_physx = gh_physx4.gpu_is_supported()
  
  local bounce_threshold_velocity = 0.1
  local enable_ccd = 0;
  local enable_collision_reporting = 0
  local enable_stabilization = 0
  
  px_scene = gh_physx5.create_scene_broadphase_sap(bounce_threshold_velocity, enable_ccd, enable_collision_reporting, enable_stabilization)
  

  gh_physx5.set_scene_gravity(px_scene, 0, -10.0, 0)


  local static_friction = 0.5
  local dynamic_friction = 0.5
  local resilience = 0.05
  px_material_plane = gh_physx5.create_material(static_friction, dynamic_friction, resilience)
  px_actor_plane = gh_physx5.create_actor_plane(px_scene, 0, 1, 0, 0, px_material_plane)

  local material_density = 1.0

  static_friction = 0.1
  dynamic_friction = 0.1
  resilience = 0.01
  px_material_box = gh_physx5.create_material(static_friction, dynamic_friction, resilience)
  
  px_actor_box1 = gh_physx5.create_actor_box(px_scene, box_size_x, box_size_y, box_size_z, 0, box_size_y*0.5 + box_size_y, 0, material_density, px_material_box)
  gh_physx5.actor_set_sleep_threshold(px_actor_box1, 0.005)
  gh_physx5.actor_set_linear_damping(px_actor_box1, 0.005)
  gh_physx5.actor_set_linear_velocity(px_actor_box1, 0, 0, 0)
  gh_physx5.actor_set_angular_velocity(px_actor_box1, 0.0, 0.0, 0.0)

  gh_physx5.actor_set_kinematic_state(px_actor_box1, 1)
  
  
  px_actor_box2 = gh_physx5.create_actor_box(px_scene, box_size_x, box_size_y, box_size_z, 0, box_size_y*0.5, 0, material_density, px_material_box)
  gh_physx5.actor_set_sleep_threshold(px_actor_box2, 0.005)
  gh_physx5.actor_set_linear_damping(px_actor_box2, 0.005)
  gh_physx5.actor_set_linear_velocity(px_actor_box2, 0, 0, 0)
  gh_physx5.actor_set_angular_velocity(px_actor_box2, 0.0, 0.0, 0.0)
    
  

  gh_physx5.actor_set_position(px_actor_box1, 0, box_size_y*0.5 + box_size_y + 1.0, 0)
  gh_physx5.actor_set_euler_angles(px_actor_box1, 0.0, 0.0, 0.0)

  --gh_physx5.actor_set_euler_angles(px_actor_box2, 0.0, 0.0, 0.0)


  local PHYSX_JOINT_SPHERICAL = 0
  local PHYSX_JOINT_REVOLUTE = 1
  local PHYSX_JOINT_FIXED = 2
  local PHYSX_JOINT_DISTANCE = 3
  local PHYSX_JOINT_PRISMATIC = 4
  local joint_type = PHYSX_JOINT_REVOLUTE
  px_joint_revolute = 0


  local box1_joint_pos_x = 0
  local box1_joint_pos_y = -box_size_y / 2.0
  local box1_joint_pos_z = -box_size_z / 2.0

  local box2_joint_pos_x = 0
  local box2_joint_pos_y = box_size_y / 2.0
  local box2_joint_pos_z = -box_size_z / 2.0

  px_joint_revolute = gh_physx5.joint_create(px_scene, joint_type, px_actor_box1,    box1_joint_pos_x, box1_joint_pos_y, box1_joint_pos_z,   0, 0, 0,    px_actor_box2,      box2_joint_pos_x, box2_joint_pos_y, box2_joint_pos_z,   0, 0, 0) 


  local angle = gxl.to_radians(10.0)

  local lower_limit = -0.78
  local upper_limit = 0.78
  local damnping = 100.0
  local stiffness = 1000.0
  local restitution = 0.0
  local bounce_threshold = 0.0
  gh_physx5.joint_revolute_set_angular_limits(px_joint_revolute, lower_limit, upper_limit, damnping, stiffness, restitution, bounce_threshold)



  gh_utils.trace("PhysX 5 scene/materials/actors init ok.")

else  
  gh_utils.trace("PhysX 5 starting up failed.")

end  



update_joint_params = 0



if (px_scene > 0) then
  -- Run a simulation
  gh_physx5.run_simulation(px_scene, 0.001, 0.0)

  -- We can now update the mass of actors.
  gh_physx5.actor_update_mass(px_actor_box, 1.1)
  gh_physx5.actor_update_mass(px_actor_sphere, 1.1)

  -- and why not update the material too?
  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.9
  gh_physx5.update_material(px_material_box, static_friction, dynamic_friction, resilience)
end  



clear_force_torque = 0

physx_indicator_size_y = 0

