

local demo_dir = gh_utils.get_demo_dir() 		

local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    
dofile(lib_dir .. "lua/gxl.lua")    



winW, winH = gh_window.getsize(0)



win_hovered = 0




-----------------------------------------------------------------------------
--
orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 0.1, 1000)
gh_camera.set_position(camera, 0, 0, 8)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 90)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)







-----------------------------------------------------------------------------
--
--texture_prog = gh_node.getid("texture_prog")
--gh_gpu_program.uniform1i(texture_prog, "tex0", 0)

dofile(demo_dir .. "init_shader.lua")



-----------------------------------------------------------------------------
--
local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 1
local compressed_texture = 0

local filename = demo_dir .. "textures/9452-diffuse.jpg"
box_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/10912-diffuse.jpg"
sphere_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir .. "textures/4791-diffuse.jpg"
ground_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)


--filename = demo_dir .. "textures/Bullet_Physics_Library_Logo.png"
--bullet_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)








quad = gh_mesh.create_quad(180, 80)




box_size = 1.0
box = gh_mesh.create_box(box_size, box_size, box_size, 1, 1, 1)
gh_object.set_position(box, 1, 3, 0)


sphere_radius = 0.5
sphere = gh_mesh.create_sphere(sphere_radius, 20, 20)
gh_object.set_position(sphere, -1, 3, 0)


ground = gh_mesh.create_plane(20, 20, 2, 2)





gh_renderer.set_vsync(0)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0










physx4_ver = ""

gpu_physx = 0

px_scene = 0

physx_ok = gh_physx4.start()
if (physx_ok == 1) then
  gh_utils.trace("PhysX 4 started up ok.")
  
  local vmajor, vminor, vpatch = gh_physx4.get_version()
  physx4_ver = string.format("%d.%d.%d", vmajor, vminor, vpatch)

  --gpu_physx = gh_physx4.gpu_is_supported()
  
  local bounce_threshold_velocity = 2.0
  local enable_ccd = 0;
  local enable_collision_reporting = 0
  local enable_stabilization = 1
  

  gh_physx4.create_scene_set_solver_type(0) -- PGS (Projected Gauss-Seidel)
  --gh_physx4.create_scene_set_solver_type(1) -- TGS (Temporal Gauss-Seidel)


  px_scene = gh_physx4.create_scene_broadphase_sap(bounce_threshold_velocity, enable_ccd, enable_collision_reporting, enable_stabilization)
  

  gh_physx4.set_scene_gravity(px_scene, 0, -10.0, 0)


  local static_friction = 0.5
  local dynamic_friction = 0.5
  local resilience = 0.4
  px_material_plane = gh_physx4.create_material(static_friction, dynamic_friction, resilience)
  px_actor_plane = gh_physx4.create_actor_plane(px_scene, 0, 1, 0, 0, px_material_plane)

  local material_density = 0.5

  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.1
  px_material_box = gh_physx4.create_material(static_friction, dynamic_friction, resilience)
  px_actor_box = gh_physx4.create_actor_box(px_scene, box_size, box_size, box_size, 1.5, 3, 0, material_density, px_material_box)
  gh_physx4.actor_set_sleep_threshold(px_actor_box, 0.01)
  gh_physx4.actor_set_linear_damping(px_actor_box, 0.02)
  gh_physx4.actor_set_linear_velocity(px_actor_box, 0, -1, 0)
  gh_physx4.actor_set_angular_velocity(px_actor_box, 0.5, 0.5, -0.4)

  gh_physx4.actor_set_3d_object(px_actor_box, box)
  
  
    
  
  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.6
  px_material_sphere = gh_physx4.create_material(static_friction, dynamic_friction, resilience)
  px_actor_sphere = gh_physx4.create_actor_sphere(px_scene, sphere_radius, -1.0, 3.0, 0.0, material_density, px_material_sphere)
  gh_physx4.actor_set_sleep_threshold(px_actor_sphere, 0.01)
  gh_physx4.actor_set_linear_damping(px_actor_sphere, 0.01)
  gh_physx4.actor_set_linear_velocity(px_actor_sphere, 0, 0, 0)
  gh_physx4.actor_set_angular_velocity(px_actor_sphere, 0, 0, 0)
  
  gh_physx4.actor_set_3d_object(px_actor_sphere, sphere)


  
  gh_utils.trace("PhysX 4 scene/materials/actors init ok.")

else  
  gh_utils.trace("PhysX 4 starting up failed.")

end  





if (px_scene > 0) then
  -- Run a simulation
  gh_physx4.run_simulation(px_scene, 0.016, 0.016)

  -- We can now update the mass of actors.
  gh_physx4.actor_update_mass(px_actor_box, 1.1)
  gh_physx4.actor_update_mass(px_actor_sphere, 1.1)

  -- and why not update the material too?
  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.9
  gh_physx4.update_material(px_material_box, static_friction, dynamic_friction, resilience)
end  




