local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gx_cam_lib_v1.lua")
dofile(lib_dir .. "lua/libfont/libfont1.lua")   
dofile(lib_dir .. "lua/imgui.lua")    




winW, winH = gh_window.getsize(0)


-- A perspective camera for the 3D scene.
--
local aspect = 1.333
if (winH > 0) then
  aspect = winW / winH
end  
camera = gh_camera.create_persp(60, aspect, 0.1, 1000.0)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 0, 30)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.setupvec(camera, 0, 1, 0, 0)




-- An ortho cam for the background quad.
--
camera_ortho = gh_camera.create_ortho(-winW/2, winW/2, -winH/2, winH/2, 1.0, 10.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 2)





mesh_quad = gh_mesh.create_quad(winW, winH)
gh_mesh.set_vertex_color(mesh_quad, 0, 0.5, 0.2, 0.0, 1) --bottom-left
gh_mesh.set_vertex_color(mesh_quad, 1, 0.5, 0.5, 0.5, 1) -- top-left
gh_mesh.set_vertex_color(mesh_quad, 2, 0.5, 0.5, 0.5, 1) --top-right
gh_mesh.set_vertex_color(mesh_quad, 3, 0.5, 0.2, 0.0, 1) --bottom-right



-- GPU programs.
--
color_prog = gh_node.getid("color_prog")
--color_prog0 = gh_node.getid("color_prog0")


-- A mesh sphere.
--
mesh_sphere = gh_mesh.create_sphere(10, 100, 100)


-- Misc renderer states.
--
gh_renderer.set_vsync(0)
gh_renderer.set_scissor_state(0)
gh_renderer.set_depth_test_state(1)


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()

