
local demo_dir = gh_utils.get_demo_dir()
   
local lib_dir = gh_utils.get_scripting_libs_dir() 		
dofile(lib_dir .. "lua/gxl_stdlib.lua")    





    





winW, winH = gh_window.getsize(0)
    


imgui_hovered = 0




orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0

camera = gx_camera.create_perspective(camera_fov, 1, 0, 0, winW, winH, 1.0, 5000.0)
gh_camera.set_position(camera, 0, 0, 1800)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 25)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)



camera_ortho = gxl.create_camera_2d(winW, winH, 1.0, 10.0)



  

particle_size = 50.0

particle_prog = gh_node.getid("particle_prog")
gh_gpu_program.uniform1i(particle_prog, "tex0", 0)
gh_gpu_program.uniform1f(particle_prog, "particle_size", particle_size)
gh_gpu_program.uniform4f(particle_prog, "particle_color", 1.0, 1.0, 1.0, 1.0)



color_prog = gh_node.getid("color_prog")
gh_gpu_program.uniform4f(color_prog, "color", 1.0, 1.0, 1.0, 1.0)






    
-- Wave shader.
--
wave_prog = gh_node.getid("wave_prog")
gh_gpu_program.uniform1f(wave_prog, "wave_mesh_segs", x_parts)

    


-- interleaved vertex array. The vertex pool uses an interleaved vertex array and then 
-- the update of the vertex pool and the water mesh from the GPU buffer is identical.
--
gh_mesh.set_vertex_alloc_params_separate_vertex_arrays(0) 


mesh_subdivisions = 64
num_particles = (mesh_subdivisions+1)*(mesh_subdivisions+1)

water_mesh = gh_mesh.create_plane(2048, 2048, mesh_subdivisions, mesh_subdivisions)
water_mesh_nverts = gh_object.get_num_vertices(water_mesh)
print("water_mesh_nverts: " .. water_mesh_nverts)

--if (water_mesh_nverts == num_particles) then
--  gh_vertex_pool.set_vertex_source_v2(vp, water_mesh)
--end



-- back to default: separate vertex arrays.
--
gh_mesh.set_vertex_alloc_params_separate_vertex_arrays(1) 




fullscreen_quad = gh_mesh.create_quad(winW, winH)


local cm_vs = demo_dir .. "shaders/colormap_vs.glsl"
local cm_ps = demo_dir .. "shaders/colormap_ps.glsl"
colormap_prog = gh_gpu_program.create_from_shader_files("colormap_prog", cm_vs, cm_ps, "", "", "", "")
gh_gpu_program.uniform1i(colormap_prog, "vertical", 1)
gh_gpu_program.uniform4f(colormap_prog, "color", 1, 1, 1, 1)








--[[
local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local PF_F16_RGBA = 9
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 0
local compressed_texture = 0

local full_path_filename = demo_dir .. "textures/flare19.jpg"
particle01 = gh_texture.create_from_file_v6(full_path_filename, pixel_format, gen_mipmaps, compressed_texture)
--]]






gh_renderer.set_vsync(0)


bgcolor = {r=93/255, g=131/255, b=158/255; a=1.0}
particle_color = {r=1.0, g=1.0, b=1.0; a=1.0}
water_mesh_color = {r=0.3, g=0.7, b=0.8; a=1.0}


wave1 = {dirx=1, diry=-1, steepness=0.398, wavelength=991.0}
wave2 = {dirx=-0.035, diry=1, steepness=0.553, wavelength=813.0}
wave3 = {dirx=0.579, diry=1, steepness=0.28, wavelength=305.0}


last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0






-- stream is for big audio file (like a mp3 track). For short sounds effects, set stream to 0.
-- When stream=0, a non-streamed sound can be played more than once at a time.
-- When stream=1, a streaming sound can only be played once.
local stream = 0 
local absolute_path = 0

-- FMOD can play many audio formats (.wav, .mp3, .xm, .s3m, etc.).
--
-- groovy.mp3 is the sound track of an old demo by the demogroup Bomb released in 1998!
-- http://www.pouet.net/prod.php?which=281
-- https://www.youtube.com/watch?v=q_bqAucaJ1g
--
sound = gh_audio.sound_create_v3(demo_dir .. "audio/sea2.mp3", stream)

-- no looping
gh_audio.sound_set_loop_state(sound, 1)

-- Start playing.
channel = gh_audio.sound_play(sound)

-- set volume to 80%
gh_audio.sound_set_volume(sound, channel, 0.8)

-- sound track duration
--duration_ms = gh_audio.sound_get_duration_ms(sound)

