
local elapsed_time = gh_utils.get_elapsed_time()
local dt = gh_utils.get_time_step()


frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  





rendering_scale = 50.0
world_y_offset = -200







-- Run a simulatiuon every 1/60 second (sim_dt == 1/60).
--
local can_run_simulation = 0

sim_time = sim_time + dt
if (sim_time >= sim_dt) then
  can_run_simulation = 1
  sim_time = 0
end














if (can_run_simulation == 1) then



  -- Reset the position of all dynamic actors
  --
  if (reset_simulation == 1) then
    reset_simulation = 0

    gh_box2d.actor_set_transform(b2_box, math.random(-2, 2), 10,    deg2rad(0.0))
    gh_box2d.actor_set_linear_velocity(b2_box, 0, -5)
    gh_box2d.actor_set_angular_velocity(b2_box, deg2rad(math.random(10, 120)))
    gh_box2d.actor_set_awake(b2_box, 1)
 
  end
  
  
 
  
  


  -- Perform a step simulation
  --
  local velocity_iterations = 8
  local position_iterations = 4
  gh_box2d.world_step_simulation(b2_world, sim_dt, velocity_iterations, position_iterations)



  -- Synchronization: update the position and orientation (around Z axis only) of GeeXLab objects.
  --
  posx, posy, angle = gh_box2d.actor_get_transform(b2_ground)
  gh_object.set_position(ground, posx*rendering_scale, posy*rendering_scale+world_y_offset, 0)
  gh_object.set_euler_angles(ground, 0, 0, rad2deg(angle))

  posx, posy, angle = gh_box2d.actor_get_transform(b2_box)
  gh_object.set_position(box, posx*rendering_scale, posy*rendering_scale+world_y_offset, 0)
  gh_object.set_euler_angles(box, 0, 0, rad2deg(angle))


  num_contacts, cpx, cpy = gh_box2d.actor_read_contacts(b2_box)
  if (num_contacts > 0) then
    contact_actor_id, cpx, cpy = gh_box2d.actor_get_contact_actor(b2_box, 0)
  end


end









gh_camera.bind(camera_ortho)

gh_renderer.set_depth_test_state(0)

gh_renderer.clear_color_depth_buffers(0.2, 0.2, 0.2, 1, 1.0)




if (wireframe == 1) then
  gh_renderer.wireframe()
end




gh_gpu_program.bind(color_prog)


-- Render the ground
--
gh_gpu_program.uniform4f(color_prog, "color", 1.0, 1.0, 0.0, 1)
gh_object.set_scale(ground, rendering_scale, rendering_scale, 1.0)
gh_object.render(ground)


-- Render the box.
--
gh_gpu_program.uniform4f(color_prog, "color", 0.0, 1.0, 0.0, 1)
gh_object.set_scale(box, rendering_scale, rendering_scale, 1.0)
gh_object.render(box)




if (wireframe == 1) then
  gh_renderer.solid()
end










  imgui_frame_begin()

  gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.6)

  local is_open = imgui_window_begin_pos_size_always("Control panel", 320, winH, 0, 0)
  if (is_open == 1) then
  

    win_hovered = gh_imgui.is_window_hovered()
            
    
    gh_imgui.text_rgba(string.format("Box2D Physics version: %d.%d.%d", box2d_version.major, box2d_version.minor, box2d_version.revision), 1.0, 1.0, 0.0, 1.0)

    gh_imgui.spacing()
    gh_imgui.spacing()

    gh_imgui.text(string.format("FPS: %.0f", fps))
    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.text(string.format("GL_RENDERER: %s", gl_renderer))
    gh_imgui.text(string.format("GL_VERSION: %s", gl_version))


    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()



    if (gh_imgui.button("Reset simulation", 140, 30) == 1) then
      reset_simulation = 1
    end


    gh_imgui.spacing()
    gh_imgui.spacing()

    wireframe = gh_imgui.checkbox("wireframe", wireframe)

    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()
    gh_imgui.spacing()



    gh_imgui.text(string.format("num_contacts: %d", num_contacts))
    gh_imgui.text(string.format("contact actor_id: %d", contact_actor_id))
    gh_imgui.text(string.format("contact position: <%.3f;%.3f>", cpx, cpy))


  end 

  imgui_window_end()
  imgui_frame_end()
  --
  -- ImGui end ---------------------------------------------------------------
  ----------------------------------------------------------------------------
  --]]
