
local demo_dir = gh_utils.get_demo_dir()
    
local lib_dir = gh_utils.get_scripting_libs_dir() 		
dofile(lib_dir .. "lua/gxl_stdlib.lua")    


winW, winH = gh_window.getsize(0)


win_hovered = 0
item_hovered = 0


--[[
local aspect = winW / winH
camera = gh_camera.create_persp(60, aspect, 0.1, 1000.0)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 0.2, 0.4)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.setupvec(camera, 0, 1, 0, 0)
--]]





orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 1, 1000)
gh_camera.set_position(camera, 0, 0, 22)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 90)

if (orbit_mode == 1) then
  gx_camera.set_mode_orbit()
else
  gx_camera.set_mode_fly()
end

gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)



camera_ortho = gxl.create_camera_2d(winW, winH, 1.0, 10.0)





wire_color = {r=1.0, g=1.0, b=1.0, a=1.0}
box_color = {r=1.0, g=0.5, b=0.0, a=1.0}
ground_color = {r=0.7, g=0.7, b=0.7, a=1.0}




matcap_prog = gh_node.getid("matcap_prog")
gh_gpu_program.uniform1i(matcap_prog, "tex0", 0)

matcap2_prog = gh_node.getid("matcap2_prog")
gh_gpu_program.uniform1i(matcap2_prog, "tex0", 0)

tex_prog = gh_node.getid("tex_prog")
gh_gpu_program.uniform1i(tex_prog, "tex0", 0)
gh_gpu_program.uniform4f(tex_prog, "uvtiling", 1, -1, 0, 0)





local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local PF_F16_RGBA = 9
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 0
local compressed_texture = 0

local full_path_filename = demo_dir .. "textures/9D282A_38191D_DFC6CD_D6495A-512px.png"
matcap01 = gh_texture.create_from_file_v6(full_path_filename, pixel_format, gen_mipmaps, compressed_texture)

local filename, folder  = gh_utils.extract_filename_from_path(full_path_filename)
matcap_filename = filename
matcap_folder = folder




matcap_quad = gh_mesh.create_quad(128, 128)



mesh1 = gh_mesh.create_torus(4, 1, 40)
gh_object.set_position(mesh1, 4, 0, 0)
gh_object.set_euler_angles(mesh1, 0, 0, 0)


mesh2 = gh_mesh.create_sphere(4, 40, 40)
--mesh2 = gh_mesh.create_box(4, 4, 4, 2, 2, 2)
gh_object.set_position(mesh2, -4, 0, 0)
gh_object.set_euler_angles(mesh2, 0, 0, 0)






---------------------------------------------------------------------------
--
mesh3 = 0

model = 0
model_directory = "models/suzanne/" 
model_filename = "Suzanne.gltf"
resource_directory = model_directory
model = gh_model.create_from_file_loader_gltf(model_filename, model_directory, resource_directory)
if (model > 0) then
  mesh3 = gh_node.get_child_by_index(model, 0)
  gh_object.set_scale(mesh3, 1.0, 1.0, 1.0)
  gh_object.set_position(mesh3, 0, 2.0, 0.0)
  gh_object.set_euler_angles(mesh3, 0, 0, 0)
end  




---------------------------------------------------------------------------
--
model_brainstem = 0
model_directory = "models/brainstem/" 
model_filename = "BrainStem.gltf"
resource_directory = model_directory
model_brainstem = gh_model.create_from_file_loader_gltf(model_filename, model_directory, resource_directory)










gh_renderer.set_vsync(1)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0


vX = 1.0

bgcolor = {r=161/255, g=0.02, b=0.02, a=1.0}


