
local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gxl_stdlib.lua")
dofile(lib_dir .. "lua/keyboard_codes.lua")    



winW, winH = gh_window.getsize(0)

win_hovered = 0

camera_ortho = gxl.create_camera_2d(winW, winH, 1.0, 10.0)


glsl_prog = gh_node.getid("glsl_prog")

--quad = gh_mesh.create_quad(512, 512)
quad = gh_mesh.create_quad(winW, winH)



vsync = 1
gh_renderer.set_vsync(vsync)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0
total_frames = 0

need_check_script_compil_log = false



operations_log = ""

enable_colorizer = 1


gh_imgui.init()
gh_imgui.set_style_colors("dark")


font_RobotoRegular = gh_imgui.add_font_from_file(demo_dir .. "fonts/Roboto-Regular.ttf", 18)
gh_imgui.rebuild_all_fonts()
gh_imgui.set_default_font(font_RobotoRegular)



shader_filename = "shaders/ps04.txt"
full_shader_filename = demo_dir .. shader_filename
local pixel_shader = gh_utils.file_read("", full_shader_filename)

glsl_editor = gh_imgui.color_text_editor_create()
gh_imgui.color_text_editor_set_text(glsl_editor, pixel_shader)
gh_imgui.color_text_editor_set_language(glsl_editor, "glsl")
gh_imgui.color_text_editor_set_property_bool(glsl_editor, "colorizer", enable_colorizer)
gh_imgui.color_text_editor_set_palette(glsl_editor, "dark")
--gh_imgui.color_text_editor_set_palette(glsl_editor, "light")




lua_script_name = "frame_02"
lua_filename = lua_script_name .. ".lua"
full_lua_filename = demo_dir .. lua_filename
local lua_source = gh_utils.file_read("", full_lua_filename)

lua_editor = gh_imgui.color_text_editor_create()
gh_imgui.color_text_editor_set_text(lua_editor, lua_source)
gh_imgui.color_text_editor_set_palette(lua_editor, "dark")

gh_imgui.color_text_editor_set_language(lua_editor, "lua")
gh_imgui.color_text_editor_set_property_bool(lua_editor, "colorizer", enable_colorizer)
--gh_imgui.color_text_editor_set_property_bool(lua_editor, "handle_keyboard_inputs", 1)



bgcolor = {r=0.0, g=0.0, b=0.0, a=1.0}

editor_alpha = 0.2
background_alpha = 0.2

animation_time = 0.0
max_animation_time = 10.0

show_editor = 1

show_whitespaces = 1

selection_enabled = false
selection_start = false
selection_end = false

current_tab = "glsl"
can_ctrl_s = true
can_ctrl_c = true
can_ctrl_v = true


max_points = 360
max_plotlines = 2
plotid = gh_imgui.plot2_create(max_points, max_plotlines)
gh_imgui.plot2_set_color(plotid, 0.0, 1.0, 0.0, 1.0)
gh_imgui.plot2_set_frame_size(plotid, 200.0, 100.0)
gh_imgui.plot2_set_line_thickness(plotid, 2.0)
for i=0, max_points-1 do
	x = i
	y = 20.0 * math.sin(i*3.14159265 / 180.0)
	gh_imgui.plot2_set_value(plotid, 0, i, x, y)
	
	y = 20.0 * math.cos(i*3.14159265 / 180.0)
	gh_imgui.plot2_set_value(plotid, 1, i, x, y)
end





plotline_sin_index = gh_imgui.plotline_create("##plotline::sin", 360)
plotline_sin_index2 = gh_imgui.plotline_create("##plotline::sin2", 10)
