



if (gh_input.keyboard_is_key_down(KC_LEFT_CTRL) == 1) then
  if ((can_ctrl_s == true) and (gh_input.keyboard_is_key_down(KC_S) == 1)) then
    can_ctrl_s = false
    if (current_tab == "lua") then
      SaveLuaCode()
    elseif (current_tab == "glsl") then
      SaveGLSLCode()
    end
  end

  if ((can_ctrl_c == true) and (gh_input.keyboard_is_key_down(KC_C) == 1)) then
    can_ctrl_c = false
    if (current_tab == "lua") then
      CopyLuaCode()
    elseif (current_tab == "glsl") then
      CopyGLSLCode()
    end
  end

  if ((can_ctrl_v == true) and (gh_input.keyboard_is_key_down(KC_V) == 1)) then
    can_ctrl_v = false
    if (current_tab == "lua") then
      PasteLuaCode()
    elseif (current_tab == "glsl") then
      PasteGLSLCode()
    end
  end

end

if (gh_input.keyboard_is_key_down(KC_LEFT_CTRL) == 0) then
  if (gh_input.keyboard_is_key_down(KC_S) == 0) then
    can_ctrl_s = true
  end
  if (gh_input.keyboard_is_key_down(KC_C) == 0) then
    can_ctrl_c = true
  end
  if (gh_input.keyboard_is_key_down(KC_V) == 0) then
    can_ctrl_v = true
  end
end






if (gh_input.keyboard_is_key_down(KC_LEFT_SHIFT) == 1) then
  selection_enabled = true
else
  --gh_imgui.color_text_editor_selection(lua_editor, "clear")
  selection_enabled = false
  selection_start = false
  --selection_enabled = false
  --if (selection_start) then
  --  selection_end = true
  --end
end




--[[
libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 0.5, 0, 1, "Checkerboard")
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "FPS: " .. fps)
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_renderer)
y_offset = y_offset + 20

libfont_print(20, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_version)
y_offset = y_offset + 20


libfont_render()
--]]







right_window_w = 250
bottom_window_h = 180
shader_editor_w = winW - right_window_w
shader_editor_h = winH - bottom_window_h

button_height = 24


---[[
  imgui_frame_begin()

  local r, g, b, a = gh_imgui.get_color(IMGUI_WINDOW_BG_COLOR)
  



  --[[
  ===========================================================================================
  Text editor window
  ===========================================================================================
  --]]

  if (show_editor == 1) then

    gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, r, g, b, 0.0)

    local is_open = imgui_window_begin_no_titlebar("Shader Editor", shader_editor_w, shader_editor_h, 0, 0)
    if (is_open == 1) then


      if (gh_imgui.tab_bar_begin_v2("tabbar1", 0) == 1) then
        

        --====================================================================
        -- Panel 1: GLSL editor
        --====================================================================
        local flags = 0
        if (gh_imgui.tab_item_begin("GLSL pixel shader", 1, flags) == 1) then

          current_tab = "glsl"
    
          local br, bg, bb, ba = gh_imgui.color_text_editor_palette_get_color(glsl_editor, "Background")
          gh_imgui.color_text_editor_palette_set_color(glsl_editor, "Background", br, bg, bb, editor_alpha)


          local cursor_x, cursor_y = gh_imgui.color_text_editor_get_cursor_position(glsl_editor)
          local num_lines = gh_imgui.color_text_editor_get_total_lines(glsl_editor)

          gh_imgui.set_cur_font_display_offset(0, 4)
          --gh_imgui.text(string.format("%d/%d | %d lines | %s", cursor_x+1, cursor_y+1, num_lines, shader_filename))
          gh_imgui.text(string.format("%d/%d | %d lines", cursor_x+1, cursor_y+1, num_lines))
          gh_imgui.set_cur_font_display_offset(0, 0)

          gh_imgui.same_line(0, 10)

          gh_imgui.set_next_item_width(400)
          shader_filename = gh_imgui.input_text("##glsl_filename", 256, shader_filename, 0)

          gh_imgui.same_line(0, 10)

          if (gh_imgui.button("Load##glsl", 60, button_height) == 1) then
            local demo_dir = gh_utils.get_demo_dir()
            full_shader_filename = demo_dir .. shader_filename
            local pixel_shader = gh_utils.file_read("", full_shader_filename)
            gh_imgui.color_text_editor_set_text(glsl_editor, pixel_shader)


            local load_status = "loaded"
            local is_absolute_path = 1
            local ret = gh_gpu_program.update_shader_from_file(glsl_prog, full_shader_filename, is_absolute_path, "pixel")
            if (ret == 0) then
              load_status = "not loaded (ERROR)"
            end

            local time = os.time()
            local cur_time_str = os.date('%Y-%m-%d@%H:%M:%S', time)

            if (operations_log == "") then
              operations_log = cur_time_str .. " " .. shader_filename .. " " .. load_status
            else
              operations_log = operations_log .. "\n" .. cur_time_str .. " " .. shader_filename .. " " .. load_status
            end
          end

          if (gh_imgui.is_item_hovered() == 1) then
            gh_imgui.set_tooltip("Load shader from " ..  shader_filename)
          end


          gh_imgui.same_line(0, 10)

          if (gh_imgui.button("Save##glsl", 60, button_height) == 1) then
            SaveGLSLCode()
          end
          if (gh_imgui.is_item_hovered() == 1) then
            gh_imgui.set_tooltip("Save the shader (CTRL+S) to file " ..  shader_filename)
          end



          if (gh_imgui.button("Copy##glsl", 60, button_height) == 1) then
            CopyGLSLCode()
          end
          if (gh_imgui.is_item_hovered() == 1) then
            gh_imgui.set_tooltip("Copy to clipboatd the selected text (CTRL+C)")
          end

          gh_imgui.same_line(0, 10)

          if (gh_imgui.button("Paste##glsl", 60, button_height) == 1) then
            PasteGLSLCode()
          end
          if (gh_imgui.is_item_hovered() == 1) then
            gh_imgui.set_tooltip("Paste from clipboatd (CTRL+V)")
          end




          if (selection_enabled) then
            
            --gh_imgui.text("SELECTION ENABLED")
            
            if (selection_start == false) then
              gh_imgui.color_text_editor_selection(glsl_editor, "start")
              selection_start = true
            else
              gh_imgui.color_text_editor_selection(glsl_editor, "end")
            end

          -- else
          --   gh_imgui.text("SELECTION DISABLED")
          end

          --gh_imgui.color_text_editor_palette_set_color(glsl_editor, "XT95Line", 0.9, 0.9, 0.9, 1.0)
          gh_imgui.color_text_editor_palette_set_color(glsl_editor, "XT95Line", 0.1, 0.1, 0.1, 0.9)

          gh_imgui.color_text_editor_set_property_bool(glsl_editor, "whitespaces", show_whitespaces)
          local size_x = 0 -- 0 == max width
          local size_y = 0 -- 0 == max height
          local border = 0 -- no border
          gh_imgui.color_text_editor_render(glsl_editor, "GLSL editor", size_x, size_y, border)




          gh_imgui.tab_item_end()
        end




        --====================================================================
        -- Panel 2: Lua editor
        --====================================================================
        if (gh_imgui.tab_item_begin("Lua FRAME script", 1, flags) == 1) then

          current_tab = "lua"


          local br, bg, bb, ba = gh_imgui.color_text_editor_palette_get_color(lua_editor, "Background")
          gh_imgui.color_text_editor_palette_set_color(lua_editor, "Background", br, bg, bb, editor_alpha)
        
    
          local cursor_x, cursor_y = gh_imgui.color_text_editor_get_cursor_position(lua_editor)
          local num_lines = gh_imgui.color_text_editor_get_total_lines(lua_editor)
    
          gh_imgui.set_cur_font_display_offset(0, 4)
          --gh_imgui.text(string.format("%d/%d | %d lines | %s", cursor_x+1, cursor_y+1, num_lines, shader_filename))
          gh_imgui.text(string.format("%d/%d | %d lines", cursor_x+1, cursor_y+1, num_lines))
          gh_imgui.set_cur_font_display_offset(0, 0)
    
          gh_imgui.same_line(0, 10)
    

          if (gh_imgui.button("Save##lua", 60, button_height) == 1) then
            SaveLuaCode()
          end
          if (gh_imgui.is_item_hovered() == 1) then
            gh_imgui.set_tooltip("Save Lua file (CTRL+S) to " .. lua_filename)
          end



          if (gh_imgui.button("Copy##lua", 60, button_height) == 1) then
            CopyLuaCode()
          end
          if (gh_imgui.is_item_hovered() == 1) then
            gh_imgui.set_tooltip("Copy to clipboard (CTRL+C)")
          end

          gh_imgui.same_line(0, 10)

          if (gh_imgui.button("Paste##lua", 60, button_height) == 1) then
            PasteLuaCode()
          end
          if (gh_imgui.is_item_hovered() == 1) then
            gh_imgui.set_tooltip("Paste from clipboard (CTRL+V)")
          end



          if (selection_enabled) then
            
            --gh_imgui.text("SELECTION ENABLED")
            
            if (selection_start == false) then
              gh_imgui.color_text_editor_selection(lua_editor, "start")
              selection_start = true
            else
              gh_imgui.color_text_editor_selection(lua_editor, "end")
            end
          
          --else
          --  gh_imgui.text("SELECTION DISABLED")
          end

          -- selected_text = gh_imgui.color_text_editor_get_selected_text(lua_editor)
          -- if (selected_text ~= "") then
          --   gh_imgui.text("SELECTION: [" .. selected_text .. "]")
          -- else
          --   gh_imgui.text("SELECTION: []")
          -- end
    
    
    
    
          gh_imgui.color_text_editor_set_property_bool(lua_editor, "whitespaces", show_whitespaces)
          local size_x = 0
          --local line_height = gh_imgui.get_text_line_height()
          local size_y = 0
          local border = 0
          gh_imgui.color_text_editor_render(lua_editor, "Lua editor", size_x, size_y, border)
      
      
        
          gh_imgui.tab_item_end()
        end

        gh_imgui.tab_bar_end()
      end


    end 
    imgui_window_end()
   
  end









  --[[
  ===========================================================================================
  CONTROLS window
  ===========================================================================================
  --]]

  gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, r, g, b, background_alpha)

  local is_open = imgui_window_begin_no_titlebar("Controls", right_window_w, shader_editor_h, shader_editor_w, 0)
  if (is_open == 1) then


    -- local dummy_a = 1.0
    gh_imgui.text("Editor")
    editor_alpha = gh_imgui.slider_1f("Alpha##editor_alpha", editor_alpha, 0.0, 1.0, 1.0)
    -- wire_color.r, wire_color.g, wire_color.b, dummy_a = gh_imgui.color_edit_rgba("##colorpicker-wire", wire_color.r, wire_color.g, wire_color.b, dummy_a)

    gh_imgui.spacing()
    gh_imgui.text("Color palette")

    if (gh_imgui.button("Light", 60, button_height) == 1) then
      gh_imgui.color_text_editor_set_palette(glsl_editor, "light")
      gh_imgui.color_text_editor_set_palette(lua_editor, "light")
    end
    gh_imgui.same_line(0, 10)
    if (gh_imgui.button("Dark", 60, button_height) == 1) then
      gh_imgui.color_text_editor_set_palette(glsl_editor, "dark")
      gh_imgui.color_text_editor_set_palette(lua_editor, "dark")
    end
    gh_imgui.same_line(0, 10)
    if (gh_imgui.button("Retro Blue", 80, button_height) == 1) then
      gh_imgui.color_text_editor_set_palette(glsl_editor, "retro_blue")
      gh_imgui.color_text_editor_set_palette(lua_editor, "retro_blue")
    end

    gh_imgui.spacing()



    gh_imgui.text("Right / Bottom Bars")
    background_alpha = gh_imgui.slider_1f("alpha##background_alpha", background_alpha, 0.0, 1.0, 1.0)




    gh_imgui.spacing()
    gh_imgui.spacing()

    local cur_vsync = gh_imgui.checkbox("VSYNC", vsync)
    if (cur_vsync ~= vsync) then
      vsync = cur_vsync
      gh_renderer.set_vsync(vsync)
    end

    gh_imgui.spacing()
    gh_imgui.spacing()

    show_editor = gh_imgui.checkbox("Show code editor", show_editor)

    show_whitespaces = gh_imgui.checkbox("Show white spaces", show_whitespaces)

    local colorizer_state = gh_imgui.checkbox("Enable colorizer", enable_colorizer)
    if (colorizer_state ~= enable_colorizer) then
      enable_colorizer = colorizer_state
      --gh_imgui.color_text_editor_set_language(lua_editor, "lua")
      gh_imgui.color_text_editor_set_property_bool(lua_editor, "colorizer", enable_colorizer)

      --gh_imgui.color_text_editor_set_language(glsl_editor, "glsl")
      gh_imgui.color_text_editor_set_property_bool(glsl_editor, "colorizer", enable_colorizer)
    end

    
    gh_imgui.spacing()
    gh_imgui.spacing()

      -- local dummy_a = 1.0
    gh_imgui.text("Backround color")
    bgcolor.r, bgcolor.g, bgcolor.b, bgcolor.a = gh_imgui.color_edit_rgba("##bgcolor", bgcolor.r, bgcolor.g, bgcolor.b, bgcolor.a)




    
    gh_imgui.spacing()
    gh_imgui.spacing()


    for i=0, max_points-1 do
      x = i
      y = 20.0 * math.sin(4.0*i*3.14159265 / 180.0 + elapsed_time*2.0) * math.sin(7.0*i*3.14159265 / 180.0 + elapsed_time*8.0)
      gh_imgui.plot2_set_value(plotid, 0, i, x, y)
      y = 20.0 * math.cos(4.0*i*3.14159265 / 180.0 + elapsed_time*2.0) * math.cos(2.0*i*3.14159265 / 180.0 + elapsed_time*4.0)
      gh_imgui.plot2_set_value(plotid, 1, i, x, y)
    end
    
  
    gh_imgui.plot2_set_frame_size(plotid, right_window_w, 50.0)
    gh_imgui.plot2_set_state(plotid, "show_grid_x", 0)
    gh_imgui.plot2_set_state(plotid, "show_grid_y", 0)
    gh_imgui.plot2_set_line_thickness(plotid, 2.0)
    gh_imgui.plot2_set_grid_size_and_subticks(plotid, 0, 200.0, 10)
    gh_imgui.plot2_set_scale(plotid, -20, 20, 0)
    gh_imgui.plot2_set_count_and_offset(plotid, max_points, 0)
    gh_imgui.plot2_set_overlay_text(plotid, "powersin()")
    gh_imgui.plot2_set_tooltip_format(plotid, "angle=%.2f, sin()=%.2f")
  
    gh_imgui.plot2_set_state(plotid, "show_tooltip", 0)
    gh_imgui.plot2_set_color(plotid, 0, 0.2, 0.8, 1.0, 1.0)
    gh_imgui.plot2_set_color(plotid, 1, 0.0, 1.0, 0.8, 1.0)
  
    gh_imgui.plot2_draw(plotid, "plotid1")
  







    for i=0, 360-1 do
      local x = 2.0 * math.cos(elapsed_time + i*0.25) * math.sin(i * 3.14159 / 180.0 * 2.2)
      gh_imgui.plotline_set_value1f(plotline_sin_index, i, x)
    end
    
    local type = 0 -- 0=line  -  1=histogram
    local overlay = "clampedsin()"
    local values_offset = 0
    local scale_min = -0.5
    local scale_max = 2.0
    local graph_size_x = right_window_w
    local graph_size_y = 50.0
  
    gh_imgui.plotline_draw(plotline_sin_index, type, overlay, values_offset, scale_min, scale_max, graph_size_x, graph_size_y)
  
    local j = 0
    for i=0, 10-1 do
      local x = 0.2 + (1.0 + math.sin(elapsed_time*2.6 + j*0.6)) * 0.5
      j = j + 1
      gh_imgui.plotline_set_value1f(plotline_sin_index2, i, x)
    end
    type = 1 -- 0=line  -  1=histogram
    overlay = "histosin()"
    values_offset = 0
    scale_min = 0.0
    scale_max = 1.2
    graph_size_x = right_window_w
    graph_size_y = 50.0
    gh_imgui.plotline_draw(plotline_sin_index2, type, overlay, values_offset, scale_min, scale_max, graph_size_x, graph_size_y)
  

  end 
  imgui_window_end()









  --[[
  ===========================================================================================
  Log / output window
  ===========================================================================================
  --]]

  local is_open = imgui_window_begin_no_titlebar("##log", winW, bottom_window_h, 0, shader_editor_h)
  if (is_open == 1) then

    gh_imgui.set_cur_font_display_offset(0, 4)
    gh_imgui.text("Time")
    gh_imgui.set_cur_font_display_offset(0, 0)
    gh_imgui.same_line(0, 10)
    gh_imgui.set_next_item_width(winW * 0.75)
    animation_time = gh_imgui.slider_1f("##animation_time", animation_time, 0.0, max_animation_time, 1.0)

    gh_imgui.same_line(0, 10)
    gh_imgui.set_next_item_width(50)
    local input_flags = 0
    local decimal_format = "%.1f"
    max_animation_time = gh_imgui.input_1f_v2("Max duration (sec)", max_animation_time, input_flags, decimal_format)

    --gh_imgui.separator()
    gh_imgui.text(string.format("FPS: %.0f | %s | OpenGL %s", fps, gl_renderer, gl_version))
    --gh_imgui.separator()
    --gh_imgui.text("Log")

    local size_x = 0
    local line_height = gh_imgui.get_text_line_height()
    local size_y = line_height * 6
    local border = 1
    local child_window_flags = 0
    gh_imgui.begin_child("##log_output", size_x, size_y, border, child_window_flags)
    gh_imgui.text(operations_log)
    gh_imgui.end_child()


    -- local size_x = 0
    -- local line_height = gh_imgui.get_text_line_height()
    -- local size_y = line_height * 5
    -- local input_text_flags = ImGuiInputTextFlags_ReadOnly
    -- gh_imgui.input_text_multiline("##log_output", operations_log, 16*1024, size_x, size_y, input_text_flags)


  end 
  imgui_window_end()




  imgui_frame_end()
  --
  -- ImGui end ---------------------------------------------------------------
  ----------------------------------------------------------------------------
  --]]























