
local elapsed_time = gh_utils.get_elapsed_time()
local dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  






if (reset_simulation == 1) then
  reset_simulation = 0
  
  gh_bullet3.actor_set_position(b3_box, 1, 4, 0)
  local vx = random(-2.0, 2.0)
  local vy = random(-2.0, 2.0)
  local vz = random(-2.0, 2.0)
  gh_bullet3.actor_set_angular_velocity(b3_box, vx, vy, vz)
  
  gh_bullet3.actor_set_position(b3_sphere, -1, 4, 0)
  vx = random(-2.0, 2.0)
  vy = random(-2.0, 2.0)
  vz = random(-2.0, 2.0)
  gh_bullet3.actor_set_angular_velocity(b3_sphere, vx, vy, vz)
end





-- Force position and orientation of kinematic actor.
--
gh_bullet3.actor_set_position(b3_box2, kinematic_pos.x, kinematic_pos.y, kinematic_pos.z)
gh_object.set_position(box2, kinematic_pos.x, kinematic_pos.y, kinematic_pos.z)

qx, qy, qz, qw = gh_utils.math_quat_from_euler_angles(0, 0, 10)
gh_bullet3.actor_set_orientation(b3_box2, qx, qy, qz, qw)
gh_object.set_orientation(box2, qx, qy, qz, qw)




gh_bullet3.actor_set_position(b3_box21, kinematic_pos.x-4.0, kinematic_pos.y+2.0, kinematic_pos.z)
gh_object.set_position(box21, kinematic_pos.x-4.0, kinematic_pos.y+2.0, kinematic_pos.z)

qx, qy, qz, qw = gh_utils.math_quat_from_euler_angles(0, 0, -10)
gh_bullet3.actor_set_orientation(b3_box21, qx, qy, qz, qw)
gh_object.set_orientation(box21, qx, qy, qz, qw)


-- Bullet physics simulation. 
max_sub_steps = 4
fixed_time_step = 1.0/60.0
gh_bullet3.scene_step_simulation(b3_scene, dt, max_sub_steps, fixed_time_step)



-- Read back Bullet actors and updates 3D objects transformation.
gh_bullet3.actor_apply_transform(b3_box, box)
--gh_bullet3.actor_apply_transform(b3_box2, box2)
gh_bullet3.actor_apply_transform(b3_sphere, sphere)







if (win_hovered == 0) then
  gx_camera.update(camera, dt)
end  
gh_camera.bind(camera)



gh_renderer.set_depth_test_state(1)


gh_renderer.clear_color_depth_buffers(0.3, 0.3, 0.3, 1, 1.0)



gh_gpu_program.bind(texture_prog)


gh_gpu_program.uniform4f(texture_prog, "uvtiling", 6, 6, 0, 0)
gh_texture.bind(ground_tex, 0)
gh_object.render(ground)

gh_gpu_program.uniform4f(texture_prog, "uvtiling", 1, 1, 0, 0)
gh_texture.bind(box_tex, 0)
gh_object.render(box)

gh_texture.bind(box2_tex, 0)
gh_object.render(box2)
gh_object.render(box21)

gh_gpu_program.uniform4f(texture_prog, "uvtiling", 2, 2, 0, 0)
gh_texture.bind(sphere_tex, 0)
gh_object.render(sphere)




gh_renderer.set_depth_test_state(0)

gh_renderer.set_blending_state(1)
gh_renderer.set_blending_factors(2, 5)
gh_gpu_program.uniform4f(texture_prog, "uvtiling", 1, 1, 0, 0)
gh_camera.bind(camera_ortho)
gh_texture.bind(bullet_tex, 0)
gh_object.set_position(quad, winW/2-95, -winH/2+45)
gh_object.render(quad)
gh_renderer.set_blending_state(0)







---[[
libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 0.5, 0, 1, ">> Bullet3 Physics (v" .. bullet3_ver .. ") <<")
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "FPS: " .. fps)
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_renderer)
y_offset = y_offset + 20

libfont_print(20, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_version)
y_offset = y_offset + 20


libfont_render()
--]]











  imgui_frame_begin()

  --gh_imgui.set_color(IMGUI_TITLE_BG_COLOR, 0.4, 0.4, 0.4, 0.90)
  gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.6)

  local is_open = imgui_window_begin_pos_size_once("Control panel", 250, 200, 10, 200)
  --local is_open = imgui_window_begin_v1("Control panel", 360, 560, 20, 20)
  if (is_open == 1) then
  
    

    win_hovered = gh_imgui.is_window_hovered()
            
  
    local window_w = gh_imgui.get_content_region_available_width()

    local widget_width = window_w * 1.0
    
    
    gh_imgui.text_rgba("Bullet3 Physics SDK version: " .. bullet3_ver, 1.0, 1.0, 0.0, 1.0)

    gh_imgui.text("Press [ESC] to quit the demo")
   
    
    gh_imgui.spacing()
    gh_imgui.spacing()
    
    if (gh_imgui.button("Reset simultation", 200, 20) == 1) then
      reset_simulation = 1
    end
    

    gh_imgui.spacing()
    gh_imgui.spacing()

    gh_imgui.text("Kinematic box position:")
    kinematic_pos.x = gh_imgui.slider_1f("X##kinematic_pos-x", kinematic_pos.x, -10.0, 10.0, 1.0)
    kinematic_pos.z = gh_imgui.slider_1f("Z##kinematic_pos-z", kinematic_pos.z, -10.0, 10.0, 1.0)


  end 

  imgui_window_end()

  imgui_frame_end()
  --
  -- ImGui end ---------------------------------------------------------------
  ----------------------------------------------------------------------------
  --]]
