
local elapsed_time = gh_utils.get_elapsed_time()
local dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  



if (is_windows == 1) then
  gh_window.keyboard_update_buffer(0)
end
  



if (win_hovered == 0) then
  gx_camera.update(camera, dt)
end  





if (reset_simulation == 1) then
  reset_simulation = 0
  bullets_reset(b3_scene)
  reset_blocks_position()
  reset_columns()  
end



if (num_bullets > 0) then
  local throw_bullet_dt = elapsed_time - throw_bullet_last_time
  local KC_SPACE = 57
  if ((throw_bullet_dt > 0.5) and (gh_input.keyboard_is_key_down(KC_SPACE) == 1)) then
    throw_bullet_last_time = elapsed_time
    bullet_throw(b3_scene, camera, bullet_speed)
    play_gun_sound = 1
  end
end

--[[
if (fire_bullet == 1) then
  bullet_throw(camera, bullet_speed)
  fire_bullet = 0
end  
--]]





local scene_contacts = 0  

-- http://bulletphysics.org/mediawiki-1.5.8/index.php/Stepping_the_World
-- --> timeStep < maxSubSteps * fixedTimeStep
--max_sub_steps = 4
--fixed_time_step = 1.0/60.0
max_sub_steps = 5
fixed_time_step = 1.0/120.0
if (run_simulation == 1) then
  
  gh_bullet3.scene_reset_all_contacts(b3_scene)

  gh_bullet3.scene_set_solver_num_iterations(b3_scene, b3_solver_num_iterations)
  
  gh_bullet3.scene_step_simulation(b3_scene, dt, max_sub_steps, fixed_time_step)
  
  gh_bullet3.scene_sync_3d_objects(b3_scene)
  
  scene_contacts = gh_bullet3.scene_check_contacts(b3_scene)
  
end  


if (scene_contacts > 0) then
  if (bullet_counter > 0) then
    local bullet = bullets[bullet_counter]
    local contacts, x, y, z = gh_bullet3.actor_get_contact_info(bullet.aid)
    
    local speed2 = gh_bullet3.actor_get_linear_speed2(bullet.aid)
    if (speed2 < 0.5) then
      bullet.is_sleeping = 1
    end
    
    --if ((bullet.is_sleeping == 0) and (contacts > 0) and (bullet.can_play_impact_sound == 1) and  (bullet.contact == 0)) then
    if ((bullet.is_sleeping == 0) and (bullet.can_play_impact_sound == 1) and (contacts > 0)) then
      bullet.contact = 1
      bullet.can_play_impact_sound = 0
      play_impact_sound = 1
    end
  end
end  



if (sound_enabled == 1) then

	if ((play_gun_sound == 1) and (av0 > 0)) then
    gh_av.pause(av0, 0)
    gh_av.reset_streams(av0)
	  play_gun_sound = 0
  end

	if (play_gun_sound == 1) then
	  gh_audio.update()
	  gh_audio.sound_play(gun_sound)
	  play_gun_sound = 0
	end  
  
  
  
	if ((play_impact_sound == 1) and (av1 > 0)) then
    gh_av.pause(av1, 0)
    gh_av.reset_streams(av1)
	  play_impact_sound = 0
  end

	if (play_impact_sound == 1) then
	  gh_audio.update()
	  gh_audio.sound_play(impact_sound)
	  play_impact_sound = 0
	end  

end




gh_renderer.set_depth_test_state(1)


gh_renderer.clear_color_depth_buffers(0.3, 0.3, 0.3, 1, 1.0)

gh_camera.bind(camera)


gh_gpu_program.bind(texture_prog)


gh_gpu_program.uniform4f(texture_prog, "uvtiling", 6, 6, 0, 0)
gh_texture.bind(ground_tex, 0)
gh_object.render(ground)


gh_gpu_program.uniform4f(texture_prog, "uvtiling", 1, 1, 0, 0)
gh_texture.bind(column_tex, 0)

gh_bullet3.actor_apply_transform(b3_cyl1, cylinder)
gh_object.render(cylinder)

gh_bullet3.actor_apply_transform(b3_cyl2, cylinder)
gh_object.render(cylinder)


gh_gpu_program.uniform4f(texture_prog, "uvtiling", 1, 1, 0, 0)
gh_texture.bind(box_tex, 0)


for i=1, wall.num_blocks do
  local block = wall.blocks[i]
  gh_object.render(block.meshid)
end


if (bullet_counter > 0) then
  gh_gpu_program.uniform4f(texture_prog, "uvtiling", 2, 2, 0, 0)
  gh_texture.bind(bullet_tex, 0)
  for i=1, bullet_counter do
    local bullet = bullets[i]
    gh_bullet3.actor_apply_transform(bullet.aid, sphere)
    gh_object.render(sphere)
  end
end



--gx_camera.draw_ref_grid(20, 20, 20, 20)
--gx_camera.draw_tripod(camera)






gh_renderer.set_blending_state(1)
gh_renderer.set_blending_factors(1, 1)
gh_camera.bind(camera_ortho)

gh_gpu_program.uniform4f(texture_prog, "uvtiling", 1, 1, 0, 0)
gh_texture.bind(crosshair_tex, 0)
gh_object.render(crosshair_quad)


gh_renderer.set_blending_factors(2, 5)
gh_texture.bind(bullet_physics_logo_tex, 0)
gh_object.set_position(logo_quad, winW/2-95, -winH/2+45)
gh_object.render(logo_quad)

gh_renderer.set_blending_state(0)







---[[
libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 0.5, 0, 1, ">> Bullet Physics (v" .. bullet3_ver .. ") <<")
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "FPS: " .. fps)
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_renderer)
y_offset = y_offset + 20

libfont_print(20, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_version)
y_offset = y_offset + 20


libfont_render()
--]]











  imgui_frame_begin()

  --gh_imgui.set_color(IMGUI_TITLE_BG_COLOR, 0.4, 0.4, 0.4, 0.90)

  gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.6)


  local pos_size_flag_always = 1 -- Always set the pos and/or size
  local pos_size_flag_once = 2 -- Set the pos and/or size once per runtime session (only the first call with succeed)
  local pos_size_flag_first_use_ever = 4  -- Set the pos and/or size if the window has no saved data (if doesn't exist in the .ini file)
  local pos_size_flag_appearing = 8  -- Set the pos and/or size if the window is appearing after being hidden/inactive (or the first time)

  local window_flags = 0 -- ImGuiWindowFlags_NoResize

  local is_open = gh_imgui.window_begin("Bullet Physics demo", 250, 350, 10, 200, window_flags, pos_size_flag_once, pos_size_flag_once)
  --local is_open = imgui_window_begin_v1("Control panel", 360, 560, 20, 20)
  if (is_open == 1) then
  
  
    local window_w = gh_imgui.get_content_region_available_width()

    local widget_width = window_w * 1.0
    
    
    gh_imgui.text("- Bullet Physics SDK version: " .. bullet3_ver)


    --gh_imgui.text([[ Bullet Physics SDK ]])
    
    --gh_imgui.text("num_collision_objects: " .. num_collision_objects)

    imgui_vertical_space()
    gh_imgui.text_rgba("- Press [SPACE] to shoot a bullet", 1.0, 1.0, 0.0, 1.0)
    gh_imgui.text_rgba("- Press [ESC] to quit the demo", 0.7, 0.7, 0.7, 1.0)
    
    --[[
    imgui_vertical_space()
    gh_imgui.text("Scene max contacts: " .. max_contacts)
    
    gh_imgui.text("Box contact info:")
    gh_imgui.text("- n = " .. box_contact_info.n)
    if (box_contact_info.n > 0) then
      gh_imgui.text(string.format("- pos = <%.1f; %.1f; %.1f>", box_contact_info.x, box_contact_info.y, box_contact_info.z))
    end
    gh_imgui.text("Sphere contact info:")
    gh_imgui.text("- n = " .. sphere_contact_info.n)
    if (sphere_contact_info.n > 0) then
      gh_imgui.text(string.format("- pos = <%.1f; %.1f; %.1f>", sphere_contact_info.x, sphere_contact_info.y, sphere_contact_info.z))
    end
      --]]
    
    
    
   
    
    imgui_vertical_space()
    imgui_vertical_space()
    if (run_simulation == 1) then
      if (gh_imgui.button("Pause simultation", 150, 20) == 1) then
        run_simulation = 0
      end
    else
      if (gh_imgui.button("Run simultation", 150, 20) == 1) then
        run_simulation = 1
      end
    end

    
    
    imgui_vertical_space()
    imgui_vertical_space()
    if (gh_imgui.button("Reset simultation", 150, 20) == 1) then
      reset_simulation = 1
    end
    
    
    if ((av0 > 0) or (gun_sound > 0)) then
    
      imgui_vertical_space()
      imgui_vertical_space()
      if (gh_imgui.button("Test gun sound", 150, 20) == 1) then
        play_gun_sound = 1
      end
    
      if (impact_sound > 0) then
        -- On Windows and Linux, the impact sound is loaded. On Raspberry Pi, only the gun sound is loaded.
        imgui_vertical_space()
        imgui_vertical_space()
        if (gh_imgui.button("Test impact sound", 150, 20) == 1) then
          play_impact_sound = 1
        end
      end
    end
    

    --[[
    imgui_vertical_space()
    imgui_vertical_space()
    if (gh_imgui.button("FIRE", 100, 20) == 1) then
      fire_bullet = 1
    end
    --]]
    

    imgui_vertical_space()
    imgui_vertical_space()


    gh_imgui.push_item_width(widget_width)
    
    
    gh_imgui.text("Bullet speed (m/sec)")
    local min_value = 10.0
    local max_value = 100.0
    local power = 1.0
    bullet_speed = gh_imgui.slider_1f("##bullet_speed", bullet_speed,   min_value, max_value,   power)
    
    
    imgui_vertical_space()
    gh_imgui.text("Bullet solver iterations")
    b3_solver_num_iterations = gh_imgui.slider_1i("##b3_solver_num_iterations", b3_solver_num_iterations,   4, 20)
    
    

    --[[
    gh_imgui.text("Simulation speed factor")
    local min_value = 1.0
    local max_value = 200.0
    local power = 1.0
    g_simulation_speed_factor = gh_imgui.slider_1f("##simspeed", g_simulation_speed_factor,   min_value, max_value,   power)

    imgui_vertical_space()
    imgui_vertical_space()
    --]]

    
    --[[
    
    imgui_vertical_space()
    imgui_vertical_space()

    local dummy_a = 1.0
    
    gh_imgui.text("Wire color")
    wire_color.r, wire_color.g, wire_color.b, dummy_a = gh_imgui.color_edit_rgba("##colorpicker-wire", wire_color.r, wire_color.g, wire_color.b, dummy_a)

    imgui_vertical_space()
    imgui_vertical_space()

    gh_imgui.text("Box fill color")
    box_color.r, box_color.g, box_color.b, dummy_a = gh_imgui.color_edit_rgba("##colorpicker-fill-box", box_color.r, box_color.g, box_color.b, dummy_a)
    
    gh_imgui.text("Ground fill color")
    ground_color.r, ground_color.g, ground_color.b, dummy_a = gh_imgui.color_edit_rgba("##colorpicker-fill-ground", ground_color.r, ground_color.g, ground_color.b, dummy_a)
    --]]
    
    
    
    for i=1, num_bullets do
      local bullet = bullets[i]
      local activationstate = gh_bullet3.actor_get_activation_state(bullet.aid)
      local s2 = gh_bullet3.actor_get_linear_speed2(bullet.aid)
      gh_imgui.text(string.format("bullet %d - linear speed2: %.3f", i, s2))
    end
    

    gh_imgui.pop_item_width()
    
    
    
    win_hovered = 0
    if ((gh_imgui.is_window_hovered() == 1) or (gh_imgui.is_any_item_hovered() == 1)) then
      win_hovered = 1
    end
    


  end 

  imgui_window_end()

  imgui_frame_end()
  --
  -- ImGui end ---------------------------------------------------------------
  ----------------------------------------------------------------------------
  --]]

  
--[[  
if (run_simulation == 1) then
  --gh_bullet3.scene_reset_all_contacts(b3_scene)
  
  gh_bullet3.scene_set_solver_num_iterations(b3_scene, b3_solver_num_iterations)
  
  gh_bullet3.scene_step_simulation(b3_scene, dt, max_sub_steps, fixed_time_step)
  
  num_collision_objects = gh_bullet3.scene_get_num_collision_objects(b3_scene)
  
  gh_bullet3.scene_sync_3d_objects(b3_scene)
  
  --contacts = gh_bullet3.scene_check_contacts(b3_scene)
end  
--]]
  
