
local elapsed_time = gh_utils.get_elapsed_time()
local dt = elapsed_time - last_time
last_time = elapsed_time





if ((win_hovered == false) and (item_hovered == false)) then
	camera_lookat_x = 0
	camera_lookat_y = 5
	camera_lookat_z = 0
	gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
	gx_camera.update(camera, dt)
end	

gh_camera.bind(camera._id)


gh_renderer.clear_color_depth_buffers(0.2, 0.2, 0.2, 1.0, 1.0)


--gh_renderer.wireframe()

gh_renderer.set_depth_test_state(1)


gh_gpu_program.bind(lighting_prog)
gh_gpu_program.uniform4f(lighting_prog, "light_position", light_position.x, light_position.y, light_position.z, 1.0);
gh_gpu_program.uniform4f(lighting_prog, "material_diffuse", 1.0, 0.2, .02, 1.0);


local sec_rotation = 360 / gearA._rot_speed
local rpm = 60 / sec_rotation


gh_gpu_program.uniform4f(lighting_prog, "material_diffuse", gearA._color.r, gearA._color.g, gearA._color.b, gearA._color.a);
gearA._rot_angle =  gearA._rot_angle +  gearA._rot_speed * dt
gh_object.set_euler_angles(gearA._mesh, 0, 0, gearA._rot_angle)
gh_object.set_position(gearA._mesh, 0, 0, 0)
gh_object.render(gearA._mesh)


gh_gpu_program.uniform4f(lighting_prog, "material_diffuse", gearB._color.r, gearB._color.g, gearB._color.b, gearB._color.a);
gearB._rot_speed = gearA._rot_speed / gear_ratio
gearB._rot_angle =  gearB._rot_angle +  gearB._rot_speed * dt
gh_object.set_euler_angles(gearB._mesh, 0, 0, -gearB._rot_angle - (gearB._initial_angle_offset*2.0))

local gear2_position_y = gearB._outer_radius + gearA._outer_radius

gh_object.set_position(gearB._mesh, 0.0, gear2_position_y, 0)
gh_object.render(gearB._mesh)

-- gh_renderer.solid()


if (is_rpi == false) then
	gh_gpu_program.bind(color_prog)
	gh_object.render(grid)
end






----------------------------------------------------------------------------
-- ImGui.
--
imgui_frame_begin()


local window_flags = 0
local is_open = imgui_window_begin_v1("Control panel", 360, -1, 20, 20)

if (is_open == 1) then



	local window_w = gh_imgui.get_content_region_available_width()

	local widget_width = window_w * 1.0


	gh_imgui.text("Angular speed (deg/second)")

	local min_value = 0.0
	local max_value = 500.0
	local power = 1.0 -- Use power!=1.0 for logarithmic sliders.
	gh_imgui.push_item_width(widget_width)
	gearA._rot_speed = gh_imgui.slider_1f("##rootspeed", gearA._rot_speed,   min_value, max_value,   power)
	gh_imgui.pop_item_width()

	local sec_rotation = 360 / gearA._rot_speed
	local rpm = 60 / sec_rotation
	local str = string.format("Rotation speed: %.1f RPM", rpm)
	gh_imgui.text(str)





	gh_imgui.spacing()
	gh_imgui.spacing()
	gh_imgui.spacing()

	local min_value = 0.0
	local max_value = 1.0
	local power = 1.0 -- Use power!=1.0 for logarithmic sliders.


	gh_imgui.text("Gear A diffuse color:")
	gearA._color.r, gearA._color.g, gearA._color.b, gearA._color.a = gh_imgui.color_edit_rgba("##gearAcolor", gearA._color.r, gearA._color.g, gearA._color.b, gearA._color.a)

	gh_imgui.spacing()
	gh_imgui.spacing()

	gh_imgui.text("Gear B diffuse color:")
	gearB._color.r, gearB._color.g, gearB._color.b, gearB._color.a = gh_imgui.color_edit_rgba("##gearBcolor", gearB._color.r, gearB._color.g, gearB._color.b, gearB._color.a)




	gh_imgui.spacing()
	gh_imgui.spacing()
	gh_imgui.spacing()

	gh_imgui.text("Light position:")
	min_value = -50.0
	max_value = 50.0
	local tmpz = 0
	light_position.x, light_position.y, light_position.z, tmpz = gh_imgui.slider_4f("##lightposition", light_position.x, light_position.y, light_position.z, 1.0,   min_value, max_value,   power)



	win_hovered = false
	if (gh_imgui.is_any_window_hovered() == 1) then
		win_hovered = true
	end

	item_hovered = false
	if (gh_imgui.is_any_item_hovered() == 1) then
		item_hovered = true
	end



end 

imgui_window_end()

imgui_frame_end()
----------------------------------------------------------------------------

