#----------------------------------------------------
# All GeeXLab modules
#
import gh_asus_aura
import gh_audio
import gh_av
import gh_bullet3
import gh_camera
import gh_font
import gh_gml
import gh_gpu_buffer
import gh_gpu_program
import gh_gpumon
import gh_imagemagick
import gh_imgui
import gh_input
import gh_leap
import gh_light
import gh_logiled
import gh_material
import gh_mesh
import gh_model
import gh_nvg
import gh_node
import gh_object
import gh_opencl
import gh_vr
import gh_ps
import gh_physx3
import gh_physx4
import gh_polyline
import gh_render_target
import gh_renderer  
import gh_rpi
import gh_sqlite3
import gh_texture
import gh_utils
import gh_vb
import gh_vertex_pool
import gh_window
#----------------------------------------------------


import sys


demo_dir = gh_utils.get_demo_dir() 		
sys.path.append(demo_dir)

lib_dir = gh_utils.get_lib_dir() 		
sys.path.append(lib_dir + "/python/")
sys.path.append(lib_dir + "/python/libfont/")

from imgui import *
from gxl_utils import *
from gxcamera_v1 import *
from libfont1 import *




gxl = gxl_utils()


winW, winH = gh_window.getsize(0)



win_hovered = 0



#-------------------------------------------------------------------
orbit_mode = 1
keyboard_speed = 10.0
camera_fov = 60.0
camera_lookat_x = 0
camera_lookat_y = 0
camera_lookat_z = 0


gx_camera = gxcamera()

camera = gx_camera.create_perspective(60, 1, 0, 0, winW, winH, 0.1, 1000)
gh_camera.set_position(camera, 0, 0, 8)
gx_camera.init_orientation(camera, 0, 0, 0, 30, 90)

if (orbit_mode == 1):
  gx_camera.set_mode_orbit()
else:
  gx_camera.set_mode_fly()


gx_camera.set_orbit_lookat(camera, camera_lookat_x, camera_lookat_y, camera_lookat_z)
gx_camera.set_keyboard_speed(keyboard_speed)
gh_camera.set_fov(camera, camera_fov)
#-------------------------------------------------------------------









#-------------------------------------------------------
#texture_prog = gh_node.getid("texture_prog")
#gh_gpu_program.uniform1i(texture_prog, "tex0", 0)
from init_shader import *
texture_prog = init_texture_shader()
gh_utils.trace("texture_prog => " + str(texture_prog))




#-------------------------------------------------------
PF_U8_RGB = 1
PF_U8_RGBA = 3
PF_F32_RGBA = 6
pixel_format = PF_U8_RGBA
gen_mipmaps = 1
compressed_texture = ""

filename = demo_dir + "textures/9452-diffuse.jpg"
box_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir + "textures/10912-diffuse.jpg"
sphere_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)

filename = demo_dir + "textures/4791-diffuse.jpg"
ground_tex = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)









quad = gh_mesh.create_quad(180, 80)




box_size = 1.0
box = gh_mesh.create_box(box_size, box_size, box_size, 1, 1, 1)
gh_object.set_position(box, 1, 3, 0)


sphere_radius = 0.5
sphere = gh_mesh.create_sphere(sphere_radius, 20, 20)
gh_object.set_position(sphere, -1, 3, 0)


ground = gh_mesh.create_plane(20, 20, 2, 2)





gh_renderer.set_vsync(0)

last_time = gh_utils.get_elapsed_time()


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0


reset_simulation = 0









physx4_ver = ""

gpu_physx = 0

px_scene = 0
px_actor_box = 0
px_actor_sphere = 0

physx_ok = gh_physx4.start()
if (physx_ok == 1):
  gh_utils.trace("PhysX 4 started up ok.")
  
  vmajor, vminor, vpatch = gh_physx4.get_version()
  physx4_ver = ("%d.%d.%d") % (vmajor, vminor, vpatch)

 
  bounce_threshold_velocity = 2.0
  enable_ccd = 0
  enable_collision_reporting = 0
  enable_stabilization = 1
  
  px_scene = gh_physx4.create_scene_broadphase_sap(bounce_threshold_velocity, enable_ccd, enable_collision_reporting, enable_stabilization)
  
  gh_physx4.set_scene_gravity(px_scene, 0, -10.0, 0)


  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.4
  px_material_plane = gh_physx4.create_material(static_friction, dynamic_friction, resilience)
  px_actor_plane = gh_physx4.create_actor_plane(px_scene, 0, 1, 0, 0, px_material_plane)

  material_density = 0.5

  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.1
  px_material_box = gh_physx4.create_material(static_friction, dynamic_friction, resilience)
  px_actor_box = gh_physx4.create_actor_box(px_scene, box_size, box_size, box_size, 1.5, 3, 0, material_density, px_material_box)
  gh_physx4.actor_set_sleep_threshold(px_actor_box, 0.01)
  gh_physx4.actor_set_linear_damping(px_actor_box, 0.02)
  gh_physx4.actor_set_linear_velocity(px_actor_box, 0, -1, 0)
  gh_physx4.actor_set_angular_velocity(px_actor_box, 0.5, 0.5, -0.4)
  
  
    
  
  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.6
  px_material_sphere = gh_physx4.create_material(static_friction, dynamic_friction, resilience)
  px_actor_sphere = gh_physx4.create_actor_sphere(px_scene, sphere_radius, -1.0, 3.0, 0.0, material_density, px_material_sphere)
  gh_physx4.actor_set_sleep_threshold(px_actor_sphere, 0.01)
  gh_physx4.actor_set_linear_damping(px_actor_sphere, 0.01)
  gh_physx4.actor_set_linear_velocity(px_actor_sphere, 0, 0, 0)
  gh_physx4.actor_set_angular_velocity(px_actor_sphere, 0, 0, 0)
  
  
  gh_utils.trace("PhysX 4 scene/materials/actors init ok.")


else:
  gh_utils.trace("PhysX 4 starting up failed.")





if (px_scene > 0):
  # Run a simulation
  gh_physx4.run_simulation(px_scene, 0.016, 0.016)

  # We can now update the mass of actors.
  gh_physx4.actor_update_mass(px_actor_box, 1.1)
  gh_physx4.actor_update_mass(px_actor_sphere, 1.1)

  # and why not update the material too?
  static_friction = 0.5
  dynamic_friction = 0.5
  resilience = 0.9
  gh_physx4.update_material(px_material_box, static_friction, dynamic_friction, resilience)





