#version 450

#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_shading_language_420pack : enable


struct CameraTransform
{
  mat4 ViewProjectionMatrix;
};

struct ObjectTransform
{
  mat4 ModelMatrix;
};

layout (std140, binding = 0) uniform uniforms_t
{ 
  CameraTransform C[2];
  ObjectTransform O[2];
} ub;


layout(push_constant) uniform push_block_t
{
  int camera_index;
  int object_index;
  int tex_index;
  int _padding_;
} cb;


layout (location = 0) in vec4 vposition;
layout (location = 1) in vec4 vtexcoord;
layout (location = 2) in vec4 vnormal;
layout (location = 3) in vec4 vcolor;

layout (location = 0) out vec4 v_color;
layout (location = 1) out vec4 v_texcoord;

out gl_PerVertex 
{
  vec4 gl_Position;
  
};

void main()
{
  vec4 P = ub.O[cb.object_index].ModelMatrix * vposition;
  //vec4 P = vposition;
  gl_Position = ub.C[cb.camera_index].ViewProjectionMatrix * P;
   
  // GL->VK conventions
  gl_Position.y = -gl_Position.y;
  gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
  
  v_color = vcolor;
  v_texcoord = vtexcoord;
}
