#version 450

layout (location = 0) in vec4 v_color;
layout (location = 1) in vec4 v_texcoord;


layout (binding = 1) uniform sampler2D tex[2];


layout(push_constant) uniform push_block_t
{
  int camera_index;
  int object_index;
  int tex_index;
  int _padding_;
} cb;


layout (location = 0) out vec4 FragColor;

void main()
{
  vec2 uv = v_texcoord.xy;
  uv.y = 1.0 - uv.y;
  vec4 c = texture(tex[cb.tex_index], uv);
  FragColor = c * v_color;
}
