


function UpdateFeetPosition(dt)
  px = px + (move_speed_x*dt)
  
  if (px > (winW/2 - quad_width/2)) then
    px = winW/2 - quad_width/2
    move_speed_x = -move_speed_x
  end
  
  if (px < -(winW/2 -  quad_width/2)) then
    px = -winW/2 +  quad_width/2
    move_speed_x = -move_speed_x
  end
 
end  


function DrawFeet(x)
  -- Blue quad
  gh_gpu_program.uniform4f(color_prog, "color", 0, 0, 1, 1)
  gh_object.set_position(quad, x, 40, 0.0, 1.0)
  gh_object.render(quad)

  -- Yellow quad
  gh_gpu_program.uniform4f(color_prog, "color", 1, 1, 0, 1)
  gh_object.set_position(quad, x, -40, 0.0, 1.0)
  gh_object.render(quad)
end


function DrawVQuads(r, g, b, a)
  gh_gpu_program.uniform4f(color_prog, "color", r, g, b, a)
  local n = winW / 20
  local px = -winW/2 + 10
  for i=0, n-1 do
    gh_object.set_position(vquad, px, 0.0, 0.0, 1.0)
    px = px + 20 + 20 
    gh_object.render(vquad)
  end
end







    
local elapsed_time = gh_utils.get_elapsed_time()
local dt = elapsed_time - last_time
last_time = elapsed_time



gh_renderer.set_depth_test_state(0)
gh_renderer.clear_color_depth_buffers(bgcolor.r, bgcolor.g, bgcolor.b, bgcolor.a, 1.0)
gh_camera.bind(camera_ortho)
gh_gpu_program.bind(color_prog)

if (display_vstripes == 1) then
  DrawVQuads(vstripescolor.r, vstripescolor.g, vstripescolor.b, vstripescolor.a)
end

UpdateFeetPosition(dt)
DrawFeet(px)










-- Control panel.
--
imgui_frame_begin()

  --gh_imgui.set_color(IMGUI_WINDOW_BG_COLOR, 0.1, 0.1, 0.1, 0.9)

  local is_open = imgui_window_begin_pos_size_always("Control panel", winW, 120, 0, winH-120)
  if (is_open == 1) then
  
    gh_imgui.group_begin()
    gh_imgui.text("Background color")
    gh_imgui.set_next_item_width(300)
    bgcolor.r, bgcolor.g, bgcolor.b, bgcolor.a = gh_imgui.color_edit_rgba("##bgcolor", bgcolor.r, bgcolor.g, bgcolor.b, bgcolor.a)
    gh_imgui.group_end()

    gh_imgui.same_line(0, 20)

    gh_imgui.group_begin()
    gh_imgui.text("Vertical stripes color")
    gh_imgui.set_next_item_width(300)
    vstripescolor.r, vstripescolor.g, vstripescolor.b, vstripescolor.a = gh_imgui.color_edit_rgba("##vstripescolor", vstripescolor.r, vstripescolor.g, vstripescolor.b, vstripescolor.a)
    gh_imgui.group_end()


    gh_imgui.spacing()
    

    gh_imgui.text("feet speed")
    local min_value = 10.0
    local max_value = 100.0
    local power = 1.0
    gh_imgui.set_next_item_width(300)
    move_speed_x = gh_imgui.slider_1f("##vX", move_speed_x,   min_value, max_value,   power)


    gh_imgui.same_line(0, 20)

    display_vstripes = gh_imgui.checkbox("display vertical stipes", display_vstripes)




    --[[
    win_hovered = 0
    if (gh_imgui.is_any_window_hovered() == 1) then
      win_hovered = 1
    end

    item_hovered = 0
    if (gh_imgui.is_any_item_hovered() == 1) then
      item_hovered = 1
    end
    --]]

  end 

  imgui_window_end()

  imgui_frame_end()
  