    
local elapsed_time = gh_utils.get_elapsed_time()
  

local platform_windows = 1 
local platform_osx = 2 
local platform_linux = 3 
local platform_rpi = 4 

if (gh_utils.get_platform() == platform_windows) then
  gh_window.keyboard_update_buffer(0)
end





local KC_SPACE = 57
local	KC_UP = 200
local	KC_LEFT = 203
local KC_RIGHT = 205
local	KC_DOWN = 208
local KC_F = 33
local KC_G = 34



if (gh_input.keyboard_is_key_down(KC_UP) == 1) then
  volume = volume + 0.01
  if (volume > 1.0) then
    volume = 1.0
  end
  if (av1 > 0) then
		gh_av.set_volume(av1, volume)
  end 
end

if (gh_input.keyboard_is_key_down(KC_DOWN) == 1) then
  volume = volume - 0.01
  if (volume < 0.0) then
    volume = 0.0
  end
  if (av1 > 0) then
		gh_av.set_volume(av1, volume)
  end 
end







if ((space_key_pressed == 0) and (gh_input.keyboard_is_key_down(KC_SPACE) == 1)) then
  space_key_pressed = 1
  if (pause_state == 0) then 
    pause_state = 1
  else
    pause_state = 0
  end
  if (av1 > 0) then
		gh_av.pause(av1, pause_state)
  end 
end

if (gh_input.keyboard_is_key_down(KC_SPACE) == 0) then
  space_key_pressed = 0
end





video_elapsed_time = 0
if (av1 > 0) then
  video_elapsed_time = gh_av.get_elapsed_time(av1)
else  
  video_elapsed_time = elapsed_time
end  





--[[
if ((g_seek_key_pressed == 0) and (gh_input.keyboard_is_key_down(KC_RIGHT) == 1)) then
  local seek_time = video_elapsed_time + 20.0
  gh_av.seek_frame_time(av1, seek_time)
  g_seek_key_pressed = 1
  g_seek_key_pressed_time = elapsed_time
end

if ((g_seek_key_pressed == 0) and (gh_input.keyboard_is_key_down(KC_LEFT) == 1)) then
  local seek_time = video_elapsed_time - 20.0
  gh_av.seek_frame_time(av1, seek_time)
  g_seek_key_pressed = 1
  g_seek_key_pressed_time = elapsed_time
end

if ((elapsed_time - g_seek_key_pressed_time) > 0.2) then
  g_seek_key_pressed = 0
end
--]]




gh_renderer.set_depth_test_state(0)
gh_renderer.set_scissor_state(1)
gh_camera.bind(camera_ortho)
gh_renderer.clear_color_depth_buffers(0.2, 0.2, 0.2, 1.0, 1.0)



if (update_video == 1) then
  gh_texture.bind(video_tex, 0)
  gh_av.video_update_texture(av1, video_tex)
  
  -- new function / GeeXLab 0.29.6+
  -- gh_av.video_update_texture_rgb24(av1, video_tex)
else
  gh_texture.bind(no_video_tex, 0)
end
 

gh_gpu_program.bind(tex_prog)
gh_object.render(mesh_quad)



gh_gpu_program.bind(vertex_color_prog)

gh_object.set_position(mesh_pb_bkg, 0, -quad_height/2 - 20, 0)
gh_object.render(mesh_pb_bkg)

local pb_ratio = 0
if (duration > 0) then
  pb_ratio = video_elapsed_time/duration
end
local pb_width = quad_width * pb_ratio
if (pb_width > quad_width) then 
  pb_width = quad_width -- This happens on Linux... 
end 
gh_mesh.update_quad_size(mesh_pb, pb_width, 16)
gh_object.set_position(mesh_pb, -quad_width/2 + pb_width/2, -quad_height/2 - 20, 0)
gh_object.render(mesh_pb)







libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 0.7, 0, 1, "Simple Video Player")
y_offset = y_offset + 20

libfont_print(20, y_offset, 0.7, 0.7, 0.7, 1, "[SPACE]: pause - [UP]/[DOWN]: volume")
y_offset = y_offset + 20


local hms_str, hour, min, sec = gh_utils.time_to_hour_min_sec(video_elapsed_time)

libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("video time: %s", hms_str))
y_offset = y_offset + 20



libfont_render()

