
local elapsed_time = gh_utils.get_elapsed_time()



gh_audio.update() -- Important!!!

local current_pos_ms = gh_audio.sound_get_position_ms(sound, channel)

local sp = {}
local num_sp_values = 10
gh_audio.sound_spectrum_read(sound, channel) -- spectrum = float_array[128]
for i=1, num_sp_values do
	sp[i] = gh_audio.sound_spectrum_get_value(sound, channel, i-1)
end




gh_renderer.clear_color_buffer(0.2, 0.2, 0.2, 1.0)




libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 1.0, 0, 1, "FMOD demo")
y_offset = y_offset + 30

local hms_str, hour, min, sec = gh_utils.time_to_hour_min_sec(elapsed_time)

libfont_print(20, y_offset, 0.7, 0.7, 0.7, 1, string.format("elapsed time: %s", hms_str))
y_offset = y_offset + 40


libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, "Sound info")
y_offset = y_offset + 20

hms_str, hour, min, sec = gh_utils.time_to_hour_min_sec(duration_ms/1000)
libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("-> duration: %s", hms_str))
y_offset = y_offset + 20

libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("-> channel: %d", channel))
y_offset = y_offset + 20

hms_str, hour, min, sec = gh_utils.time_to_hour_min_sec(current_pos_ms/1000)
libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("-> current position: %s", hms_str))
y_offset = y_offset + 20

libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, "-> spectrum:")
y_offset = y_offset + 20


for i=1, num_sp_values do
	libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("    . spectrum[%d]: %.1f", i, sp[i]))
	y_offset = y_offset + 20
end

libfont_render()


