

function MoveBoxWithDamping(box, dt)
  box.x = box.x + (box.move_x*dt)
  box.y = box.y + (box.move_y*dt)

  if (box.x > winW/2) then
    box.x = winW/2
    box.move_x = -box.move_x
  end

  if (box.x < -winW/2) then
    box.x = -winW/2
    box.move_x = -box.move_x
  end

  if (box.y > winH/2) then
    box.y = winH/2
    box.move_y = -box.move_y
  end

  if (box.y < -winH/2) then
    box.y = -winH/2
    box.move_y = -box.move_y
  end
  
  if (box.move_x > 0) then 
    box.move_x = box.move_x - box.velocity_damping*dt
    if (box.move_x < 0) then
      box.move_x = 0
    end
  end
  
  if (box.move_x < 0) then 
    box.move_x = box.move_x + box.velocity_damping*dt
    if (box.move_x > 0) then
      box.move_x = 0
    end
  end

  if (box.move_y > 0) then 
    box.move_y = box.move_y - box.velocity_damping*dt
    if (box.move_y < 0) then
      box.move_y = 0
    end
  end
  
  if (box.move_y < 0) then 
    box.move_y = box.move_y + box.velocity_damping*dt
    if (box.move_y > 0) then
      box.move_y = 0
    end
  end
  
  if (box.a > 0) then
    box.a = box.a - (box.color_damping)*dt
    if (box.a < 0) then box.a = 0 end
  end
 
end



function DrawQuad(box)
  gh_gpu_program.uniform4f(color_prog, "color", box.r, box.g, box.b, box.a)
  gh_object.set_position(quad, box.x, box.y, 0)
  gh_object.render(quad)
end








    
local elapsed_time = gh_utils.get_elapsed_time()
local dt = elapsed_time - last_time
last_time = elapsed_time




gh_renderer.clear_color_depth_buffers(0.2, 0.2, 0.2, 1.0, 1.0)
gh_camera.bind(camera_ortho)
gh_gpu_program.bind(color_prog)



for i=1, num_boxes do
  local box = all_boxes[i]
  MoveBoxWithDamping(box, dt)
  DrawQuad(box)
end












libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 1.0, 0, 1, "Bouncing boxes")
y_offset = y_offset + 30

local hms_str, hour, min, sec = gh_utils.time_to_hour_min_sec(elapsed_time)

libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("elapsed time: %s", hms_str))
y_offset = y_offset + 20

libfont_print(20, y_offset, 1.0, 1.0, 1.0, 1, string.format("number of boxes: %d", num_boxes))
y_offset = y_offset + 20

libfont_render()
