
local elapsed_time = gh_utils.get_elapsed_time()
local dt = gh_utils.get_time_step()

frames = frames+1
fps_time = fps_time + dt
if (fps_time >= 1.0) then
  fps_time = 0
  fps = frames
  frames = 0
end  




gh_renderer.set_depth_test_state(1)

gh_camera.bind(camera_ortho)
gh_renderer.clear_color_depth_buffers(0.2, 0.2, 0.2, 1.0, 1.0)


local num_vertices_processed = 0
local num_pixels_processed = 0

if (GL_ARB_shader_atomic_counters_ok == 1) then

  -- Reset the value of the atomic counter.
  --
  gh_gpu_buffer.bind_base(acbo_vert, binding_point_index_vert)
  gh_gpu_buffer.atomic_counter_set_value(acbo_vert, 0, 0)

  gh_gpu_buffer.bind_base(acbo_frag, binding_point_index_frag)
  gh_gpu_buffer.atomic_counter_set_value(acbo_frag, 0, 0)


  --[[
  gh_gpu_buffer.bind_base(acbo_vert, binding_point_index_vert)
  gh_gpu_buffer.map(acbo_vert)
  local buffer_offset_bytes = 0
  gh_gpu_buffer.set_value_1ui(acbo_vert, buffer_offset_bytes, 0)
  gh_gpu_buffer.unmap(acbo_vert)
  
  gh_gpu_buffer.bind_base(acbo_frag, binding_point_index_vert)
  gh_gpu_buffer.map(acbo_frag)
  local buffer_offset_bytes = 0
  gh_gpu_buffer.set_value_1ui(acbo_frag, buffer_offset_bytes, 0)
  gh_gpu_buffer.unmap(acbo_frag)
  --]]



  -- Render the quad.
  --
  gh_gpu_program.bind(ac_prog)
  gh_object.render(mesh_quad)


  -- Get atomic counter values.
  --
  gh_gpu_buffer.bind_base(acbo_vert, binding_point_index_vert)
  num_vertices_processed = gh_gpu_buffer.atomic_counter_get_value(acbo_vert, 0)

  gh_gpu_buffer.bind_base(acbo_frag, binding_point_index_frag)
  num_pixels_processed = gh_gpu_buffer.atomic_counter_get_value(acbo_frag, 0)

end







libfont_clear()

local y_offset = 40

libfont_print(20, y_offset, 1, 0.5, 0, 1, "OpenGL 4.2 GL_ARB_shader_atomic_counters Demo")
y_offset = y_offset + 20

if (GL_ARB_shader_atomic_counters_ok == 1) then

  gh_utils.font_render(font, 10, 60, 1.0, 1.0, 1.0, 1.0, string.format("Vertices - total: %d, processed: %d", num_vertices, num_vertices_processed))
  gh_utils.font_render(font, 10, 80, 1.0, 1.0, 1.0, 1.0, string.format("Pixels - processed: %d", num_pixels_processed))

  libfont_print(20, y_offset, 1, 1, 0, 1, string.format("Vertices - total: %d, processed: %d", num_vertices, num_vertices_processed))
  y_offset = y_offset + 20
  libfont_print(20, y_offset, 1, 1, 0, 1, string.format("Pixels - processed: %d", num_pixels_processed))
  y_offset = y_offset + 20

else
  libfont_print(20, y_offset, 1, 0.25, 0, 1, "GL_ARB_shader_atomic_counters NOT supported")
end


y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "FPS: " .. fps)
y_offset = y_offset + 20

y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 0, 1, "GL_RENDERER")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_renderer)
y_offset = y_offset + 20

libfont_print(20, y_offset, 1, 1, 0, 1, "GL_VERSION")
y_offset = y_offset + 20
libfont_print(20, y_offset, 1, 1, 1, 1, "> " .. gl_version)
y_offset = y_offset + 20


libfont_render()
