local demo_dir = gh_utils.get_demo_dir()
    
local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gxl_stdlib.lua")  





function LogOpenGLCap(cap_name)    
  local cap_value = gh_renderer.get_capability_4i(cap_name)
  gh_utils.trace(cap_name .. " = " .. cap_value)
end  
    



winW, winH = gh_window.getsize()




camera_ortho = gh_camera.create_ortho(-winW/2, winW/2, -winH/2, winH/2, 1.0, -1.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 1)



local aspect = 1.333
if (winH > 0) then
  aspect = winW / winH
end  
camera = gh_camera.create_persp(60, aspect, 0.1, 1000.0)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 10, 30)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.setupvec(camera, 0, 1, 0, 0)






GL_ARB_shader_atomic_counters_ok = gh_renderer.check_opengl_extension("GL_ARB_shader_atomic_counters")





--[[
local GL_INVALID_ENUM = 1280 -- 0x0500
local GL_INVALID_VALUE = 1281 -- 0x0501
local GL_INVALID_OPERATION = 1282 -- 0x0502
local GL_STACK_OVERFLOW = 1283 -- 0x0503
local GL_STACK_UNDERFLOW = 1284 -- 0x0504
local GL_OUT_OF_MEMORY = 1285 -- 0x0505

local glerr = gh_renderer.get_opengl_error()
gh_utils.trace("GL error = " .. glerr)
--]]


num_vertices = 0
mesh_quad = 0
acbo_vert = 0
binding_point_index_vert = 0
acbo_frag = 0
binding_point_index_frag = 1
ac_prog = 0
uniform_block_index = 0
uniform_block_size_in_bytes = 0


if (GL_ARB_shader_atomic_counters_ok == 1) then
  ac_prog = gh_node.getid("ac_prog")
end

if (ac_prog > 0) then

  mesh_quad = gh_mesh.create_quad(256, 256)
  num_vertices = gh_object.get_num_vertices(mesh_quad)
  

  gh_gpu_program.bind(ac_prog)
  gh_gpu_program.unbind(ac_prog)
  
  local buffer_size = 4 --  uint == 4 bytes
  local flags = ""
  acbo_vert = gh_gpu_buffer.create("ATOMIC_COUNTER", "GL_DYNAMIC_READ", buffer_size, flags)
  if (acbo_vert > 0) then
    gh_gpu_buffer.bind_base(acbo_vert, binding_point_index_vert)
  end
  
  buffer_size = 4
  flags = ""
  acbo_frag = gh_gpu_buffer.create("ATOMIC_COUNTER", "GL_DYNAMIC_READ", buffer_size, flags)
  if (acbo_frag > 0) then
    gh_gpu_buffer.bind_base(acbo_frag, binding_point_index_frag)
  end
end  


gh_utils.trace("Atomic Counters implementation limits:")
LogOpenGLCap("GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE")
LogOpenGLCap("GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS")
LogOpenGLCap("GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS")
LogOpenGLCap("GL_MAX_VERTEX_ATOMIC_COUNTERS")
LogOpenGLCap("GL_MAX_FRAGMENT_ATOMIC_COUNTERS")
LogOpenGLCap("GL_MAX_GEOMETRY_ATOMIC_COUNTERS")
LogOpenGLCap("GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS")
LogOpenGLCap("GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS")
LogOpenGLCap("GL_MAX_COMPUTE_ATOMIC_COUNTERS")


gh_renderer.set_scissor_state(0)

frame = 0

gh_renderer.set_vsync(0)

last_time = gh_utils.get_elapsed_time()

gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()


fps_time = 0
fps = 0
frames = 0

