    
winW, winH = gh_window.getsize(0)



-- Perspective camera.
--
local aspect = winW / winH
camera_params = { fov=60, znear=1.0, zfar=1000.0 }
camera = gh_camera.create_persp(camera_params.fov, aspect, camera_params.znear, camera_params.zfar)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 0, 12)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.set_upvec(camera, 0, 1, 0, 0)




local demo_dir = gh_utils.get_demo_dir() 		

gpu_prog = gh_node.getid("gpu_prog")
gh_gpu_program.uniform1i(gpu_prog, "tex0", 0)
gh_gpu_program.uniform4f(gpu_prog, "uv_tiling", 2.0, 2.0, 0.0, 0.0)




local use_std_vertex_attribs = 1 -- standard vertex attribs like gxl3d_Position.
local num_user_vertex_attribs = 0 -- no custom vertex attrib arrays.
local separate_vertex_arrays = 0 -- Separate or interleaved vertex attribs.
local vertex_alignment = 0
local alloc_vertex_particles = 0
gh_mesh.set_vertex_alloc_params(use_std_vertex_attribs, num_user_vertex_attribs, separate_vertex_arrays, vertex_alignment, alloc_vertex_particles)


--mesh = gh_mesh.create_torus(6.0, 2.0, 10) -- 200f / 121v
--mesh = gh_mesh.create_torus(6.0, 2.0, 20) -- 800f / 441v
--mesh = gh_mesh.create_torus(6.0, 2.0, 40) -- 3200f / 1681v
--mesh = gh_mesh.create_torus(6.0, 2.0, 50) -- 5000f / 2601v
--mesh = gh_mesh.create_torus(6.0, 2.0, 100) -- 20'000f / 10'201v
--mesh = gh_mesh.create_torus(6.0, 2.0, 200) -- 80'000f / 40'401v
--mesh = gh_mesh.create_torus(6.0, 2.0, 400) -- 320'000f / 160'801v
--mesh = gh_mesh.create_torus(6.0, 2.0, 500) -- 500'000f / 251'001v
--mesh = gh_mesh.create_torus(6.0, 2.0, 1000) -- 2'000'000f / 1'002'001v


mesh = gh_mesh.create_torus(0.6, 0.1, 50) -- 5'000f / 2601v
--mesh = gh_mesh.create_torus(0.6, 0.1, 100) -- 20'000f / 10'201v
--mesh = gh_mesh.create_torus(0.6, 0.1, 20) -- 800f / 441v

print(string.format("Faces: %d - vertices: %d", gh_object.get_num_faces(mesh), gh_object.get_num_vertices(mesh)))
gh_mesh.set_vertices_color(mesh, 1.0, 1.0, 0.0, 1.0)


local PF_U8_RGB = 1
local PF_U8_RGBA = 3
local PF_F32_RGBA = 6
local pixel_format = PF_U8_RGBA
local gen_mipmaps = 0
local compressed_texture = 0

local filename = demo_dir .. "data/t08.jpg"
tex0 = gh_texture.create_from_file_v6(filename, pixel_format, gen_mipmaps, compressed_texture)







gh_renderer.set_vsync(0)
gh_renderer.set_depth_test_state(1)




g_num_x = 30
g_num_y = 30



function draw_scene(w, h, time)

  gh_camera.set_position(camera, 0, 0, 20)
  gh_camera.set_lookat(camera, 0, 0, 0, 1)

  gh_camera.bind(camera)

  gh_renderer.clear_color_depth_buffers(0.2, 0.25, 0.30, 1.0, 1.0)


  gh_renderer.rasterizer_set_cull_state(1)
  gh_renderer.rasterizer_set_cull_face(1) -- 0 => NONE ; 1 => BACK ; 2 => FRONT
  gh_renderer.rasterizer_apply_states()


  gh_texture.bind(tex0, 0)
    
  gh_gpu_program.bind(gpu_prog)




  local num_x = g_num_x
  local num_y = g_num_y

  local size_x = 40.0
  local size_y = 20.0


  local step_x = size_x / num_x
  local step_y = size_y / num_y

  local pos_y = -size_y / 2.0



  ---[[
  for y=0, num_y do

    local pos_x = -size_x / 2.0

    for x=0, num_x do

      gh_object.set_euler_angles(mesh, time * 3.0 + x, time * 7.0 + y, time * 11.0)
      gh_object.set_position(mesh, pos_x, pos_y, 0.0)
      pos_x = pos_x + step_x

      gh_object.render(mesh)

    end

    pos_y = pos_y + step_y

  end
  --]]



  --[[
  gh_object.render_geometry_prepare(mesh)  

  for y=0, num_y do

    local pos_x = -size_x / 2.0

    for x=0, num_x do

      gh_object.set_euler_angles(mesh, time * 3.0 + x, time * 7.0 + y, time * 11.0)
      gh_object.set_position(mesh, pos_x, pos_y, 0.0)
      pos_x = pos_x + step_x

      gh_object.update_automatic_uniforms(mesh)
      --gh_object.render(mesh)
      gh_object.render_geometry_draw(mesh)

    end

    pos_y = pos_y + step_y

  end

  gh_object.render_geometry_finish(mesh)
  --]]

end