--[[
GeeXLab - GL-Z
vcgencmd management on Raspberry Pi


vcgencmd commands
commands="vcos, 
ap_output_control, ap_output_post_processing, 
vchi_test_init, vchi_test_exit, 
vctest_memmap, vctest_start, vctest_stop, vctest_set, vctest_get, 
pm_set_policy, pm_get_status, pm_show_stats, pm_start_logging, pm_stop_logging, 
version, 
commands, 
set_vll_dir, 
set_backlight, 
set_logging, 
get_lcd_info, 
arbiter, 
cache_flush, 
otp_dump, 
test_result, 
codec_enabled, 
get_camera, 
get_mem, 
measure_clock, 
measure_volts, 
enable_clock, 
scaling_kernel, 
scaling_sharpness, 
get_hvs_asserts, 
get_throttled, 
measure_temp, 
get_config, 
hdmi_ntsc_freqs, 
hdmi_adjust_clock, 
hdmi_status_show, 
hvs_update_fields, 
pwm_speedup, 
force_audio, 
hdmi_stream_channels, hdmi_channel_map, 
display_power, 
read_ring_osc, 
memtest, 
dispmanx_list, 
get_rsts, 
schmoo, 
render_bar, 
disk_notify, 
inuse_notify, 
sus_suspend, sus_status, sus_is_enabled, sus_stop_test_thread, 
egl_platform_switch, 
mem_validate, 
mem_oom, 
mem_reloc_stats, 
hdmi_cvt, hdmi_timings, 
readmr, 
bootloader_version, bootloader_config, 
file"



$ vcgencmd get_config int
arm_freq=1500
audio_pwm_mode=514
config_hdmi_boost=5
core_freq=550
core_freq_min=275
disable_commandline_tags=2
disable_l2cache=1
display_hdmi_rotate=-1
display_lcd_rotate=-1
enable_gic=1
force_eeprom_read=1
force_pwm_open=1
framebuffer_ignore_alpha=1
framebuffer_swap=1
gpu_freq=500
gpu_freq_min=500
hdmi_enable_4kp60=1
hdmi_samples_limit=0x1f4000
init_uart_clock=0x2dc6c00
lcd_framerate=60
mask_gpu_interrupt0=1024
mask_gpu_interrupt1=0x10000
max_framebuffer_height=2160
max_framebuffer_width=3840
max_framebuffers=2
over_voltage_avs=10000
pause_burst_frames=1
program_serial_random=1
hdmi_force_cec_address:0=65535
hdmi_force_cec_address:1=65535
hdmi_pixel_freq_limit:0=0x23c34600
hdmi_pixel_freq_limit:1=0x9a7ec80




--]]  


function rpi_vcgencmd_init(cpu)

  local cmd = "vcgencmd get_config int"
  local cmd_file = io.popen(cmd, 'r')

  local quit = 0
  while (quit == 0) do
    local line = cmd_file:read()
    if not line then break end

    if (line:find("arm_freq") ~= nil) then
      local x = string.match(line, '%d+')
        if (x ~= nil) then
         cpu.rpi_vcgencmd.arm_freq = tonumber(x)
       end
    end
    
    if (line:find("gpu_freq") ~= nil) then
      local x = string.match(line, '%d+')
        if (x ~= nil) then
         cpu.rpi_vcgencmd.gpu_freq = tonumber(x)
       end
    end
    
  end
   
  io.close(cmd_file)

end


function rpi_vcgencmd_update(cpu)

 local cmd = "vcgencmd measure_temp"
 -- temp=30.0'C
 local cmd_file = io.popen(cmd, 'r')
 local str_output = cmd_file:read('*all')
 io.close(cmd_file)
 local x = string.match(str_output, '[0-9]+%.[0-9]+')
 if (x ~= nil) then
   cpu.rpi_vcgencmd.temp = tonumber(x)
 end
 
 cmd = "vcgencmd measure_temp pmic"
 -- temp=32.0'C
 cmd_file = io.popen(cmd, 'r')
 str_output = cmd_file:read('*all')
 io.close(cmd_file)
 x = string.match(str_output, '[0-9]+%.[0-9]+')
 if (x ~= nil) then
   cpu.rpi_vcgencmd.temp_pmic = tonumber(x)
 end

 cmd = "vcgencmd measure_clock core"
 -- frequency(1)=549993152
 cmd_file = io.popen(cmd, 'r')
 str_output = cmd_file:read('*all')
 io.close(cmd_file)
 x = string.match(str_output, '=%d+')
 if (x ~= nil) then
   x = string.match(x, '%d+')
   cpu.rpi_vcgencmd.clock_core = tonumber(x)
 end
   
 
 cmd = "vcgencmd measure_clock arm"
 -- frequency(48)=600117184
 cmd_file = io.popen(cmd, 'r')
 str_output = cmd_file:read('*all')
 io.close(cmd_file)
 x = string.match(str_output, '=%d+')
 if (x ~= nil) then
   x = string.match(x, '%d+')
   cpu.rpi_vcgencmd.clock_arm = tonumber(x)
 end


 cmd = "vcgencmd measure_clock v3d"
 -- frequency(46)=499987808
 cmd_file = io.popen(cmd, 'r')
 str_output = cmd_file:read('*all')
 io.close(cmd_file)
 x = string.match(str_output, '=%d+')
 if (x ~= nil) then
   x = string.match(x, '%d+')
   cpu.rpi_vcgencmd.clock_v3d = tonumber(x)
 end

 cmd = "vcgencmd measure_volts"
 -- volt=0.8947V
 cmd_file = io.popen(cmd, 'r')
 str_output = cmd_file:read('*all')
 io.close(cmd_file)
 x = string.match(str_output, '[0-9]+%.[0-9]+')
 if (x ~= nil) then
   cpu.rpi_vcgencmd.volts = tonumber(x)
 end
 
 cmd = "vcgencmd get_throttled"
 -- throttled=0x0
 cmd_file = io.popen(cmd, 'r')
 str_output = cmd_file:read('*all')
 io.close(cmd_file)
 x = string.match(str_output, '0x%d')
 if (x ~= nil) then
   cpu.rpi_vcgencmd.throttled = tonumber(x)
 end
end

