//==================================================================================
// Copyright (c) 2016 , Advanced Micro Devices, Inc.  All rights reserved.
//
/// \author AMD Developer Tools Team
/// \file suNullContextCallsHistoryLogger.cpp
///
//==================================================================================

//------------------------------ suNullContextCallsHistoryLogger.cpp ------------------------------

// Infra:
#include <AMDTBaseTools/Include/gtAssert.h>
#include <AMDTOSWrappers/Include/osApplication.h>

// Local:
#include <AMDTServerUtilities/Include/suNullContextCallsHistoryLogger.h>
#include <AMDTServerUtilities/Include/suGlobalVariables.h>
#include <AMDTServerUtilities/Include/suStringConstants.h>


// ---------------------------------------------------------------------------
// Name:        suNullContextCallsHistoryLogger::suNullContextCallsHistoryLogger
// Description: Constructor
// Author:      Sigal Algranaty
// Date:        21/3/2010
// ---------------------------------------------------------------------------
suNullContextCallsHistoryLogger::suNullContextCallsHistoryLogger()
    : suCallsHistoryLogger(apContextID(AP_NULL_CONTEXT, 0), apMonitoredFunctionsAmount, suMaxLoggedOpenCLCalls(), SU_STR_nullContextCallsHistoryLoggerMessagesLabel, true)
{
}


// ---------------------------------------------------------------------------
// Name:        suNullContextCallsHistoryLogger::~suNullContextCallsHistoryLogger
// Description: Destructor
// Author:      Sigal Algranaty
// Date:        21/3/2010
// ---------------------------------------------------------------------------
suNullContextCallsHistoryLogger::~suNullContextCallsHistoryLogger()
{
}

// ---------------------------------------------------------------------------
// Name:        suNullContextCallsHistoryLogger::onFrameTerminatorCall
// Description: Called when a monitored function, defined as a frame terminator
//              is called. Clears the calls history log.
// Author:      Uri Shomroni
// Date:        18/2/2010
// ---------------------------------------------------------------------------
void suNullContextCallsHistoryLogger::onFrameTerminatorCall()
{
    // Clear the log:
    clearLog();
}

// ---------------------------------------------------------------------------
// Name:        suNullContextCallsHistoryLogger::calculateHTMLLogFilePath
// Description: Calculates and outputs the HTML log file path.
// Author:      Sigal Algranaty
// Date:        21/3/2010
// Implementation notes:
//   The log file path is:
//   <_logFilesDirectoryPath>\<Application name><OpenCLCallsLog>.txt
// ---------------------------------------------------------------------------
void suNullContextCallsHistoryLogger::calculateHTMLLogFilePath(osFilePath& textLogFilePath) const
{
    // Build the log file name:
    gtString logFileName;
    logFileName.appendFormattedString(SU_STR_callsLogFilePath);

    // Set the log file path:
    textLogFilePath = suCurrentSessionLogFilesDirectory();
    textLogFilePath.setFileName(logFileName);

    gtString fileExtension;
    apFileTypeToFileExtensionString(AP_HTML_FILE, fileExtension);
    textLogFilePath.setFileExtension(fileExtension);
}


// ---------------------------------------------------------------------------
// Name:        suNullContextCallsHistoryLogger::getHTMLLogFileHeader
// Description:
//   Outputs a string that will be used as the generated HTML log file's header
// Author:      Sigal Algranaty
// Date:        21/3/2010
// ---------------------------------------------------------------------------
void suNullContextCallsHistoryLogger::getHTMLLogFileHeader(gtString& htmlLogFileHeader) const
{
    htmlLogFileHeader.makeEmpty();

    // Get the debugged application name:
    gtString applicationName;
    osGetCurrentApplicationName(applicationName);

    // Print the HTML header:
    htmlLogFileHeader += L"<HTML>\n";
    htmlLogFileHeader += L"<head>\n";
    htmlLogFileHeader += L"   <title>No associated context calls log - ";
    htmlLogFileHeader += applicationName;
    htmlLogFileHeader += L" - generated by CodeXL</title>\n";
    htmlLogFileHeader += L"</head>\n\n";
    htmlLogFileHeader += L"<BODY style=\"font: 12px/16px Courier, Verdana, sans-serif; background-color: EFEFEF;\">\n";
    htmlLogFileHeader += L"<h3>\n";

    htmlLogFileHeader += L"////////////////////////////////////////////////////////////<br>\n";
    htmlLogFileHeader += L"// This File contains the log of all calls performed when there was no associated context<br>\n";

    htmlLogFileHeader += L"// Application: ";
    htmlLogFileHeader += applicationName;
    htmlLogFileHeader += L"<br>\n";

    htmlLogFileHeader += L"// Generated by CodeXL - OpenGL and OpenCL Debugger, Profiler and Memory Analyzer<br>\n";
    htmlLogFileHeader += L"// <A HREF=\"http://gpuopen.com/\" TARGET=\"_blank\">http://gpuopen.com/</A><br>\n";
    htmlLogFileHeader += L"////////////////////////////////////////////////////////////<br>\n";
    htmlLogFileHeader += L"</h3>\n";
    htmlLogFileHeader += L"<br>\n\n";
}

// ---------------------------------------------------------------------------
// Name:        suNullContextCallsHistoryLogger::getHTMLLogFileFooter
// Description:
//   Outputs a string that will be used as the generated HTML log file's footer
// Author:      Sigal Algranaty
// Date:        21/3/2010
// ---------------------------------------------------------------------------
void suNullContextCallsHistoryLogger::getHTMLLogFileFooter(gtString& htmlLogFileFooter) const
{
    htmlLogFileFooter = L"\n</BODY>\n";
    htmlLogFileFooter += L"</HTML>\n";
}
