//==================================================================================
// Copyright (c) 2016 , Advanced Micro Devices, Inc.  All rights reserved.
//
/// \author AMD Developer Tools Team
/// \file gdStringConstants.h
///
//==================================================================================

//------------------------------ gdStringConstants.h ------------------------------

#ifndef __GDSTRINGCONSTANTS
#define __GDSTRINGCONSTANTS

// Infra:
#include <AMDTBaseTools/Include/AMDTDefinitions.h>
// General Application items (ASCII):
#define GD_STR_CodeXLProductLineName "CodeXL"
#define GD_STR_CodeXLCaptionPrefix L"CodeXL "

// General Application items:
#define GD_STR_projectFileNameOnDeviceSuffix L"-device"
#define GD_STR_projectFileNameSimulatorSuffix L"-simulator"
#define GD_STR_projectFileNameSimulatorUnknownSDKSuffix L"-other"
#define GD_STR_digitalSignatureFileExtensions L"def"
#define GD_STR_executableApplicationFileExtension L"exe"

// General strings:
#define GD_STR_LeftParenthesis L"("
#define GD_STR_RightParenthesis L")"

// Keyboard shortcuts (Platform specific). Note that each has a menu version and a string version.
#if ((AMDT_BUILD_TARGET == AMDT_LINUX_OS) && (AMDT_LINUX_VARIANT == AMDT_MAC_OS_X_LINUX_VARIANT))
    // Please note that on Mac, we use Ctrl+ and Alt+ in the Menu strings since wxMac translates them
    // to the appropriate icon (cloverleaf for ctrl=command and microswitch for alt=option). This
    // is also true for shift, backspace=clear, etc.
    #define GD_STR_keyboardShortcutRunMenu L"Ctrl+Enter"
    #define GD_STR_keyboardShortcutRunString L"Command + Return"
    #define GD_STR_keyboardShortcutStepOverMenu L"Ctrl+Shift+O"
    #define GD_STR_keyboardShortcutStepOverString L"Command + Shift + O"
    #define GD_STR_keyboardShortcutStepInMenu L"Command+Shift+A"
    #define GD_STR_keyboardShortcutStepInString L"Command + Shift + A"
    #define GD_STR_keyboardShortcutStepOutMenu L"Command+Shift+B"
    #define GD_STR_keyboardShortcutStepOutString L"Command + Shift + B"
    #define GD_STR_keyboardShortcutAPIStepMenu L"Ctrl+Shift+Y"
    #define GD_STR_keyboardShortcutAPIStepString L"Command + Shift + Y"
    #define GD_STR_keyboardShortcutDrawStepMenu L"Ctrl+Shift+I"
    #define GD_STR_keyboardShortcutDrawStepString L"Command + Shift + I"
    #define GD_STR_keyboardShortcutFrameStepMenu L"Ctrl+Shift+T"
    #define GD_STR_keyboardShortcutFrameStepString L"Command + Shift + T"
    #define GD_STR_keyboardShortcutBreakMenu L"Alt+Ctrl+P"
    #define GD_STR_keyboardShortcutBreakString L"Option + Command + P"
    #define GD_STR_keyboardShortcutStopMenu L"Ctrl+Shift+Enter"
    #define GD_STR_keyboardShortcutStopString L"Command + Shift + Return"
    #define GD_STR_keyboardShortcutDebugMenu L"Ctrl+D"
    #define GD_STR_keyboardShortcutDebugString L"Command + D"
    #define GD_STR_keyboardShortcutNewString L"Command + N"
    #define GD_STR_keyboardShortcutOpenFileMenu L"Ctrl+Shift+O"
    #define GD_STR_keyboardShortcutOpenString L"Coammnd + O"
    #define GD_STR_keyboardShortcutStartupDialogMenu L"Alt+Ctrl+O"
    #define GD_STR_keyboardShortcutStartupDialogString L"Option + Coammnd + O"
    #define GD_STR_keyboardShortcutSaveMenu L"Ctrl+Alt+S"
    #define GD_STR_keyboardShortcutSaveString L"Command + S"
    #define GD_STR_keyboardShortcutCopyMenu L"Ctrl+C"
    #define GD_STR_keyboardShortcutCopyMenuA "Ctrl+C"
    #define GD_STR_keyboardShortcutCutMenu L"Ctrl+X"
    #define GD_STR_keyboardShortcutPasteMenu L"Ctrl+V"
    #define GD_STR_keyboardShortcutCopyString L"Command + C"
    #define GD_STR_keyboardShortcutFindMenu L"Ctrl+F"
    #define GD_STR_keyboardShortcutFindMenuA "Ctrl+F"
    #define GD_STR_keyboardShortcutFindString L"Command + F"
    #define GD_STR_keyboardShortcutFindNextMenu L"Ctrl+G"
    #define GD_STR_keyboardShortcutFindNextMenuA "Ctrl+G"
    #define GD_STR_keyboardShortcutFindNextString L"Command + G"
    #define GD_STR_keyboardShortcutSelectAllMenu L"Ctrl+A"
    #define GD_STR_keyboardShortcutSelectAllMenuA "Ctrl+A"
    #define GD_STR_keyboardShortcutSelectAllString L"Command + A"
    #define GD_STR_keyboardShortcutNextMarkerMenu L"Ctrl+Shift+N"
    #define GD_STR_keyboardShortcutNextMarkerString L"Command + Shift + N"
    #define GD_STR_keyboardShortcutPrevMarkerMenu L"Ctrl+Shift+P"
    #define GD_STR_keyboardShortcutPrevMarkerString L"Command + Shift + P"
    #define GD_STR_keyboardShortcutNextDiffMenu L"Ctrl+N"
    #define GD_STR_keyboardShortcutNextDiffString L"Command + N"
    #define GD_STR_keyboardShortcutPrevDiffMenu L"Ctrl+P"
    #define GD_STR_keyboardShortcutPrevDiffString L"Command + P"
    #define GD_STR_keyboardShortcutQuitMenu L"Ctrl+Q"
    #define GD_STR_keyboardShortcutQuitString L"Command + Q"
    #define GD_STR_keyboardShortcutCompileMenu L"Ctrl+K"
    #define GD_STR_keyboardShortcutCompileString L"Command + K"
    #define GD_STR_keyboardShortcutBuildMenu L"Ctrl+B"
    #define GD_STR_keyboardShortcutBuildString L"Command + B"
    #define GD_STR_keyboardShortcutVariablesMenu L"Ctrl+Shift+V"
    #define GD_STR_keyboardShortcutVariablesString L"Command + Shift + V"
    #define GD_STR_keyboardShortcutTexturesMenu L"Ctrl+T"
    #define GD_STR_keyboardShortcutTexturesString L"Command + T"
    #define GD_STR_keyboardShortcutStatisticsMenu L"Ctrl+Shift+S"
    #define GD_STR_keyboardShortcutStatisticsString L"Command + Shift + S"
    #define GD_STR_keyboardShortcutMemoryMenu L"Ctrl+Shift+M"
    #define GD_STR_keyboardShortcutMemoryString L"Command + Shift + M"
    #define GD_STR_keyboardShortcutErrorMenu L"Ctrl+E"
    #define GD_STR_keyboardShortcutErrorString L"Command + E"
    #define GD_STR_keyboardShortcutBreakpointsMenu L"Ctrl+\\"
    #define GD_STR_keyboardShortcutBreakpointsString L"Command + \\"
    #define GD_STR_keyboardShortcutDeleteMenu L"BACK"                           // wxMac translates this to the <x| backspace icon
    #define GD_STR_keyboardShortcutDeleteMenuA "BACK"                           // wxMac translates this to the <x| backspace icon
    #define GD_STR_keyboardShortcutDeleteString L"Backspace"
    #define GD_STR_keyboardShortcutRightMenu L"Ctrl+R"
    #define GD_STR_keyboardShortcutRightString L"Command + R"
    #define GD_STR_keyboardShortcutLeftMenu L"Ctrl+L"
    #define GD_STR_keyboardShortcutLeftString L"Command + L"
    #define GD_STR_keyboardShortcutZoomInMenu L"Ctrl++"
    #define GD_STR_keyboardShortcutZoomInString L"Command + +"
    #define GD_STR_keyboardShortcutZoomOutMenu L"Ctrl+-"
    #define GD_STR_keyboardShortcutZoomOutString L"Command + -"
    #define GD_STR_keyboardShortcutZoomOrigMenu L"Alt+0"
    #define GD_STR_keyboardShortcutZoomOrigString L"Option + 0"
    #define GD_STR_keyboardShortcutRedMenu L"Alt+R"
    #define GD_STR_keyboardShortcutRedString L"Option + R"
    #define GD_STR_keyboardShortcutGreenMenu L"Alt+G"
    #define GD_STR_keyboardShortcutGreenString L"Option + G"
    #define GD_STR_keyboardShortcutBlueMenu L"Alt+B"
    #define GD_STR_keyboardShortcutBlueString L"Option + B"
    #define GD_STR_keyboardShortcutAlphaMenu L"Alt+A"
    #define GD_STR_keyboardShortcutAlphaString L"Option + A"
    #define GD_STR_keyboardShortcutBackMenu L"Ctrl+["
    #define GD_STR_keyboardShortcutBackString L"Command + ["
    #define GD_STR_keyboardShortcutForwardMenu L"Ctrl+]"
    #define GD_STR_keyboardShortcutForwardString L"Command + ]"
#else
    #define GD_STR_keyboardShortcutRunMenu L"F5"
    #define GD_STR_keyboardShortcutRunMenuA "F5"
    #define GD_STR_keyboardShortcutRunString L"F5"
    #define GD_STR_keyboardShortcutStepOverMenu L"F10"
    #define GD_STR_keyboardShortcutStepOverString L"F10"
    #define GD_STR_keyboardShortcutStepInMenu L"F11"
    #define GD_STR_keyboardShortcutStepInString L"F11"
    #define GD_STR_keyboardShortcutStepOutMenu L"Shift+F11"
    #define GD_STR_keyboardShortcutStepOutString L"Shift + F11"
    #define GD_STR_keyboardShortcutAPIStepMenu L"Ctrl+F10"
    #define GD_STR_keyboardShortcutAPIStepString L"Ctrl + F10"
    #define GD_STR_keyboardShortcutDrawStepMenu L"Ctrl+Shift+F10"
    #define GD_STR_keyboardShortcutDrawStepString L"Ctrl + Shift + F10"
    #define GD_STR_keyboardShortcutFrameStepMenu L"Ctrl+F11"
    #define GD_STR_keyboardShortcutFrameStepString L"Ctrl + F11"
    #define GD_STR_keyboardShortcutBreakMenu L"F6"
    #define GD_STR_keyboardShortcutBreakString L"F6"
    #define GD_STR_keyboardShortcutStopMenu L"Shift+F5"
    #define GD_STR_keyboardShortcutStopString L"Shift + F5"
    #define GD_STR_keyboardShortcutDebugStringA "Ctrl + D"
    #define GD_STR_keyboardShortcutDebugString L"Ctrl + D"
    #define GD_STR_keyboardShortcutNextMarkerMenu L"Ctrl+Shift+N"
    #define GD_STR_keyboardShortcutNextMarkerString L"Ctrl + Shift + N"
    #define GD_STR_keyboardShortcutPrevMarkerMenu L"Ctrl+Shift+P"
    #define GD_STR_keyboardShortcutPrevMarkerString L"Ctrl + Shift + P"
    #define GD_STR_keyboardShortcutNextDiffMenu L"Ctrl+N"
    #define GD_STR_keyboardShortcutNextDiffString L"Ctrl + N"
    #define GD_STR_keyboardShortcutPrevDiffMenu L"Ctrl+P"
    #define GD_STR_keyboardShortcutPrevDiffString L"Ctrl + P"
    #define GD_STR_keyboardShortcutQuitMenu L"Ctrl+Q"
    #define GD_STR_keyboardShortcutQuitString L"Ctrl + Q"
    #define GD_STR_keyboardShortcutCompileMenu L"Ctrl+F7"
    #define GD_STR_keyboardShortcutCompileString L"Ctrl + F7"
    #define GD_STR_keyboardShortcutBuildMenu L"F7"
    #define GD_STR_keyboardShortcutBuildString L"F7"
    #define GD_STR_keyboardShortcutVariablesMenu L"Ctrl+Shift+V"
    #define GD_STR_keyboardShortcutVariablesString L"Ctrl + Shift + V"
    #define GD_STR_keyboardShortcutTexturesMenu L"Ctrl+T"
    #define GD_STR_keyboardShortcutTexturesString L"Ctrl + T"
    #define GD_STR_keyboardShortcutStatisticsMenu L"Ctrl+Shift+S"
    #define GD_STR_keyboardShortcutStatisticsString L"Ctrl + Shift + S"
    #define GD_STR_keyboardShortcutMemoryMenu L"Ctrl+Shift+M"
    #define GD_STR_keyboardShortcutMemoryString L"Ctrl + Shift + M"
    #define GD_STR_keyboardShortcutErrorMenu L"Ctrl+E"
    #define GD_STR_keyboardShortcutErrorString L"Ctrl + E"
    #define GD_STR_keyboardShortcutBreakpointsMenu L"Alt+Shift+B"
    #define GD_STR_keyboardShortcutBreakpointsString L"Ctrl + B"
    #define GD_STR_keyboardShortcutRightMenu L"Ctrl+R"
    #define GD_STR_keyboardShortcutRightString L"Ctrl+R"
    #define GD_STR_keyboardShortcutLeftMenu L"Ctrl+L"
    #define GD_STR_keyboardShortcutLeftString L"Ctrl+L"
    #define GD_STR_keyboardShortcutZoomInMenu L"+"
    #define GD_STR_keyboardShortcutZoomInString L"+"
    #define GD_STR_keyboardShortcutZoomOutMenu L"-"
    #define GD_STR_keyboardShortcutZoomOutString L"-"
    #define GD_STR_keyboardShortcutZoomOrigMenu L"Alt+0"
    #define GD_STR_keyboardShortcutZoomOrigString L"Alt + 0"
    #define GD_STR_keyboardShortcutRedMenu L"Alt+R"
    #define GD_STR_keyboardShortcutRedString L"Alt + R"
    #define GD_STR_keyboardShortcutGreenMenu L"Alt+G"
    #define GD_STR_keyboardShortcutGreenString L"Alt + G"
    #define GD_STR_keyboardShortcutBlueMenu L"Alt+B"
    #define GD_STR_keyboardShortcutBlueString L"Alt + B"
    #define GD_STR_keyboardShortcutAlphaMenu L"Alt+A"
    #define GD_STR_keyboardShortcutAlphaString L"Alt + A"
    #define GD_STR_keyboardShortcutBackMenu L"Alt+Left"
    #define GD_STR_keyboardShortcutBackString L"Alt + Left"
    #define GD_STR_keyboardShortcutForwardMenu L"Alt+Right"
    #define GD_STR_keyboardShortcutForwardString L"Alt + Right"
    #define GD_STR_keyboardShortcutExitMenu L"Alt+F4"
#endif

#define GD_STR_PropertiesViewViewsInformationComment L"The Views information is displayed only when the debugged process has been suspended"
#define GD_STR_PropertiesViewStartDebuggingComment L"To start debugging your application, press the Start Debugging button (" GD_STR_keyboardShortcutRunString GD_STR_RightParenthesis
#define GD_STR_PropertiesViewLoadProjectComment L"To open a CodeXL project go to File Open Project menu"
#define GD_STR_dragDropOnlyOneFileAllowed L"Only one file can be dropped into CodeXL!"
#define GD_STR_dragDropFormatNotSupportedWindows L"Unknown file format.\nSupported formats are:\n\n- Executable files (*.exe)\n- CodeXL Project files (*.gdb)"
#define GD_STR_dragDropFormatNotSupportedLinux L"Unknown file format.\nSupported formats are:\n\n- Executable files\n- CodeXL Project files (*.gdb)"
#define GD_STR_dragDropFormatNotSupportedMac L"Unknown file format.\nSupported formats are:\n\n- Application Bundles (*.app)\n- Executable files\n- CodeXL Project files (*.gdb)"
#define GD_STR_dragDropUnableToOpenFileWhileDebugProcessRunning L"Unable to open file while debug process is running"
#define GD_STR_CodeXL58DoesNotSupportES L"CodeXL version %ls does not support OpenGL ES projects."
#define GD_STR_CodeXL58DoesNotSupportiPhone L"CodeXL version %ls does not support iPhone projects."
#define GD_STR_PropertiesExecutionInformationSA L"To start debugging, select 'Start Debugging' from the Debug menu,<br> or click the 'Start Debugging' toolbar button."
#define GD_STR_PropertiesExecutionInformationVS L"To start debugging, select 'Start Debugging' from the CodeXL menu,<br> or click the 'Start Debugging' toolbar button."

// File Dialogs
#define GD_STR_stateVarFileSample "CodeXLOGLStateVariables.txt"
#define GD_STR_saveTotalStatistics L"Function Types"
#define GD_STR_saveStateChageStatistics L"State Change"
#define GD_STR_saveFunctionTypesStatisticsFileName "FunctionTypesStatisticsData"
#define GD_STR_saveFunctionCallsStatisticsFileName "FunctionCallsStatisticsData"
#define GD_STR_saveDeprecationStatisticsFileName "DeprecationStatisticsData"
#define GD_STR_saveVertexBatchStatisticsFileName "VertexBatchStatisticsData"
#define GD_STR_saveStateChageStatisticsFileName "StateChangeStatisticsData"
#define GD_STR_saveMemoryFileName "MemoryData"
#define GD_STR_stateVarFileDetails "Text Documents (*.txt)"
#define GD_STR_saveStateVariablesDialogHeader "Save State Variables as"

// Toolbar names:
#define GD_STR_DebugToolbar L"Debug Toolbar"
#define GD_STR_ExecutionModeToolbar L"Execution Mode Toolbar"
#define GD_STR_callsHistoryViewToolbar L"Function Calls History Toolbar"
#define GD_STR_ThreadsAndContextsToolbar L"Threads and Contexts Toolbar"
#define GD_STR_interactiveModeToolbar L"Interactive Mode Toolbar"
#define GD_STR_rasterModeToolbar L"Raster Mode Toolbar"
#define GD_STR_viewersToolbar L"Viewers Toolbar"
#define GD_STR_performanceToolbar L"Performance Toolbar"
#define GD_STR_openCLPerformanceToolbar L"OpenCL Performance Toolbar"

// Views captions:
#define GD_STR_breakpointsViewCaption L"Breakpoints"
#define GD_STR_breakpointsViewCommandName L"&Breakpoints"
#define GD_STR_callsHistoryViewCaptionDefault L"Function Calls History"
#define GD_STR_callsHistoryViewCommandName L"&Function Calls History"
#define GD_STR_callsHistoryViewCaptionNoContextAddition L" - No Context"
#define GD_STR_callsHistoryViewCaptionWithContext L"Function Calls History - %ls"
#define GD_STR_statisticsViewCaptionWithContext L"Statistics - %ls"
#define GD_STR_statisticsViewCaptionDefault L"Statistics"
#define GD_STR_statisticsViewCommandName L"&Statistics"
#define GD_STR_memoryViewCaptionWithContext L"Memory - %ls"
#define GD_STR_memoryViewCaptionDefault L"Memory"
#define GD_STR_memoryViewCommandName L"&Memory"
#define GD_STR_DebuggedProcessEventsViewCaption L"Debugged Process Events"
#define GD_STR_DebuggedProcessEventsViewCommandName L"&Debugged Process Events"
#define GD_STR_StateVariablesViewCaptionDefault L"OpenGL State Variables"
#define GD_STR_StateVariablesViewCommandName L"&OpenGL State Variables"
#define GD_STR_StateVariablesViewCaptionDefaultWithContext L"OpenGL State Variables - %ls"
#define GD_STR_CallsStackViewCaption L"Call Stack"
#define GD_STR_CallsStackViewCommandName L"&Call Stack"
#define GD_STR_FunctionCallsStatisticsView L"Function Calls Statistics"
#define GD_STR_localsViewCaption L"Locals"
#define GD_STR_localsViewCommandName L"&Locals"
#define GD_STR_watchViewCaption L"Watch"
#define GD_STR_watchViewCommandName L"&Watch"
#define GD_STR_ApplicationBackgroundFrame L"applicationBackgroundFrame"
#define GD_STR_OpenCLDebuggingToolbarName L"OpenCL Debugging"

// Project xml file
#define GD_STR_loadProjectFileVersionNode "FileVersion"
#define GD_STR_loadProjectCodeXLProjectExecutionTargetLocal "Local Computer"
#define GD_STR_loadProjectCodeXLProjectExecutionTargetiPhoneSimulator "iPhone / iPad Simulator"
#define GD_STR_loadProjectCodeXLProjectExecutionTargetiPhoneDevice "iPhone / iPad Device"
#define GD_STR_loadProjectCodeXLNode "CodeXL"
#define GD_STR_loadProjectLogFilesFolderNode "LogFilesFolder"
#define GD_STR_loadProjectRemoteTargetConnectionNode "RemoteTargetConnection"
#define GD_STR_loadProjectRemoteTargetConnectionHostNameNode "LocalComputerIPAddress"
#define GD_STR_loadProjectRemoteTargetConnectionAPIPortNode "APIPort"
#define GD_STR_loadProjectInterceptionMethodNode L"InterceptionMethod"
#define GD_STR_loadProjectInterceptionMethodNodeASCII "InterceptionMethod"
#define GD_STR_loadProjectDebugHSAKernelsNode L"DebugHSAKernels"
#define GD_STR_loadProjectDebugHSAKernelsNodeASCII "DebugHSAKernels"
#define GD_STR_loadProjectDebuggerBreakpoints "DebuggerBreakpoints"
#define GD_STR_loadProjectBreakpoints "Breakpoints"
#define GD_STR_loadProjectRemoteTargetConnectionEventsPortNode "EventsPort"
#define GD_STR_loadProjectFrameTerminatorsNode L"FrameTerminators"
#define GD_STR_loadProjectFrameTerminatorsNodeASCII "FrameTerminators"
#define GD_STR_loadProjectTerminatorsNode "Terminators"
#define GD_STR_loadProjectiPhoneSDKNode "iPhoneSDKPath"
#define GD_STR_loadProjectGlFlushNode "glFlush"
#define GD_STR_loadProjectSwapBuffersNode "SwapBuffers"
#define GD_STR_loadProjectGlFinishNode "glFinish"
#define GD_STR_loadProjectSwapLayerBuffersNode "SwapLayerBuffers"
#define GD_STR_loadProjectGlClearNode "glClear"
#define GD_STR_loadProjectMakeCurrentNode "MakeCurrent"
#define GD_STR_loadProjectGlFrameTerminatorGremedyNode "glFrameTerminatorGREMEDY"
#define GD_STR_loadProjectCl_gremedy_computation_frameNode "cl_gremedy_computation_frame"
#define GD_STR_loadProjectClFlushNode "clFlush"
#define GD_STR_loadProjectClFinishNode "clFinish"
#define GD_STR_loadProjectClWaitForEventsNode "clWaitForEvents"
#define GD_STR_loadProjectInitializeDirectDrawNode "InitializeDirectDrawLibrary"
#define GD_STR_loadProjectPerformanceCountersNode "PerformanceCounters"
#define GD_STR_loadProjectPerformanceCounterNode "Counter"
#define GD_STR_loadProjectPerformanceCounterNameNode "CounterName"
#define GD_STR_loadProjectPerformanceCounterColorNode "CounterColor"
#define GD_STR_loadProjectPerformanceCounterWidthNode "CounterWidth"
#define GD_STR_loadProjectPerformanceCounterScaleNode "CounterScale"
#define GD_STR_loadProjectPerformanceCounterDisplayedViewsNode "CounterViews"
#define GD_STR_loadProjectPerformanceCounterTypeNode "CounterType"
#define GD_STR_loadProjectGLDebugOutputNode "GLDebugOutput"
#define GD_STR_loadProjectGLDebugOutputLoggingEnabledNode L"GLDebugOutputLoggingEnabled"
#define GD_STR_loadProjectGLDebugOutputLoggingEnabledNodeASCII "GLDebugOutputLoggingEnabled"
#define GD_STR_loadProjectGLDebugOutputBreakOnReportsNode L"GLDebugOutputBreakOnReports"
#define GD_STR_loadProjectGLDebugOutputBreakOnReportsNodeASCII "GLDebugOutputBreakOnReports"
#define GD_STR_loadProjectGLDebugOutputMessagesMaskNode L"GLDebugOutputMessagesMask"
#define GD_STR_loadProjectGLDebugOutputMessagesMaskNodeASCII "GLDebugOutputMessagesMask"
#define GD_STR_loadProjectGLDebugOutputMessagesSeverityNode L"GLDebugOutputSeverity"
#define GD_STR_loadProjectGLDebugOutputMessagesSeverityNodeASCII "GLDebugOutputSeverity"
#define GD_STR_loadProjectPerformanceAdditionalCountersNode "AdditionalPerformanceCounters"
#define GD_STR_loadProjectPerformanceCounterOSIDNode "CounterOSId"
#define GD_STR_loadProjectPerformanceCountersDisplayedContextsNode "PerformanceCountersDisplayedContexts"
#define GD_STR_loadProjectPerformanceCountersDisplayedQueuesNode "PerformanceCountersDisplayedQueues"
#define GD_STR_loadProjectPerformanceCountersContextNode "Context"
#define GD_STR_loadProjectPerformanceCountersQueueNode "Queue"
#define GD_STR_loadProjectIgnoredMessagesIDSNode "IgnoredMessagesIDS"
#define GD_STR_loadProjectMessageIDNode "MessageID"
#define GD_STR_loadProjectDebugEnginesNode "DebugEngines"
#define GD_STR_loadProjectOpenCLDebugEngineNode "OpenCLDebugEngine"
#define GD_STR_loadProjectOpenGLDebugEngineNode "OpenGLDebugEngine"
#define GD_STR_loadProjectFunctionBreakpointNameNode L"FunctionName"
#define GD_STR_loadProjectBreakpointNode "Breakpoint"
#define GD_STR_loadProjectBreakpointType L"BreakpointType"
#define GD_STR_loadProjectBreakpointTypeFunction L"FunctionBreakpoint"
#define GD_STR_loadProjectBreakpointTypeKernel L"KernelFunctionBreakpoint"
#define GD_STR_loadProjectBreakpointTypeGeneric L"GenericBreakpoint"
#define GD_STR_loadProjectBreakpointTypeSourceCode L"SourceCode"
#define GD_STR_loadProjectBreakpointTypeHostSourceCode L"HostSourceCode"
#define GD_STR_loadProjectBreakpointTypeKernelSourceCode L"KernelSourceCode"
#define GD_STR_loadProjectFunctionBreakpointIsEnabledNode L"IsEnabled"
#define GD_STR_loadProjectIgnoreAllBreakpointsNode "IgnoreAllBreakpoints"
#define GD_STR_loadProjectOpenGLStateVarNode "OpenGLStateVariables"
#define GD_STR_loadProjectStateVarNode "StateVariables"
#define GD_STR_loadProjectStateVariableNameNode "VariableName"
#define GD_STR_loadProjectSourceCodeFilePathNode "SourceCodeFilePath"
#define GD_STR_loadProjectSourceCodeLineNumberNode L"LineNumber"


// Global settings page:
#define GD_STR_globalSettingsDebugPageTitle L"GPU &Debug"
#define GD_STR_globalSettingsCallStackGroupTitle "Call Stack"
#define GD_STR_globalSettingsAdditionalSourceDirectories "Additional source code directories:"
#define GD_STR_globalSettingsSelectAdditionalSourceFoldersTitle L"Select additional source code directories"
#define GD_STR_globalSettingsSourceCodeRootLocation "Source code root location:"
#define GD_STR_globalSettingsSelectSourceRootFolderTitle L"Select source code root location"
#define GD_STR_globalSettingsCollectObjectCreationStacks "Collect allocated objects' creation call stacks"
#define GD_STR_globalSettingsHTMLLogGroupTitle "HTML Log File"
#define GD_STR_globalSettingsSaveTexturesToLogFile "Enable texture and image logging in the Calls History HTML log (recommended)"
#define GD_STR_globalSettingsTextureFileFormat "Textures and images data file format"
#define GD_STR_globalSettingsTextureFileFormatJpg "JPG"
#define GD_STR_globalSettingsTextureFileFormatBmp "BMP"
#define GD_STR_globalSettingsTextureFileFormatPng "PNG"
#define GD_STR_globalSettingsTextureFileFormatTiff "TIFF"
#define GD_STR_globalSettingsTextureFileFormatTiffNote "* 3D textures and Images are always stored as tiff images"
#define GD_STR_globalSettingsTextureFileFormatAlphaNote "* tiff and png formats preserve alpha channel information"
#define GD_STR_globalSettingsCallsLoggingGroupTitle "Calls Logging"
#define GD_STR_globalSettingsAPILoggingTitle "Maximum amount of items logged:"
#define GD_STR_globalSettingsOpenGLLogging "OpenGL function calls (per context)"
#define GD_STR_globalSettingsOpenCLLogging "OpenCL function calls (per context)"
#define GD_STR_globalSettingsMaxTreeItems "Items shown in monitored objects tree (per type)"
#define GD_STR_globalSettingsOpenCLLoggingWillBeClearedWarning "* If this maximum is exceeded, the log will be cleared.\n   Define a frame terminator to avoid this automatic clearing."
#define GD_STR_globalSettingsOpenGLBeginEndBlockWarning "* the log will not be cleared during a glBegin-glEnd block."
#define GD_STR_globalSettingsFlushLogFile "Flush log file after every monitored function call (not recommended)"

// Global settings xml file
#define GD_STR_globalSettingsDebugXMLSectionPageTitle L"GPUDebug"
#define GD_STR_ToolsOptionsCollectAllocatedObjectsCreationCallsStacksNode L"CollectAllocatedObjectsCreationCallsStacks"
#define GD_STR_ToolsOptionsEnableTexturesLoggingNode L"EnableTexturesLogging"
#define GD_STR_ToolsOptionsTexturesFileFormatNode L"TexturesFileFormat"
#define GD_STR_ToolsOptionsMaxOpenGLCallsPerContextNode L"MaxOpenGLCallsPerContext"
#define GD_STR_ToolsOptionsMaxOpenCLCallsPerContextNode L"MaxOpenCLCallsPerContext"
#define GD_STR_ToolsOptionsMaxOpenCLCommandsPerQueueNode L"MaxOpenCLCommandsPerQueue"
#define GD_STR_ToolsOptionsMaxDebugTreeItemsPerTypeNode L"MaxDebugTreeItemsPerType"
#define GD_STR_ToolsOptionsFloatingPointPrecisionDisplayNode "FloatingPointPrecisionDisplay"
#define GD_STR_ToolsOptionsFlushLogFileAfterEveryFunctionNode L"FlushLogFileAfterEveryFunction"


// Main application window:
#define GD_STR_mainFrameText L" CodeXL "
#define GD_STR_mainFrameNoLicenseText L" - No License. Only CodeXL sample applications are functional"
#define GD_STR_welcome_statusbar L"Welcome to CodeXL!"
#define GD_STR_mainFrameAcademicLicense L" - FOR ACADEMIC USE ONLY!"
#define GD_STR_mainFrameIndieLicense L" - Indie developer edition"
#define GS_STR_updatingData L"Please wait, updating data..."
#define GS_STR_updatingDebuggedProcessData L"Please wait, updating debugged process data..."

// "File" menu:
#define GD_STR_exportFileMenu L"&Export"
#define GD_STR_saveStateVariables L"State Variables Snapshot..."


// "Recent projects" subMenu:
#define GD_STR_exportFileMenuStatusbarString L"Export debugging information to file"
#define GD_STR_saveStateVariablesStatusbarString L"Export the current context values of all OpenGL state variables to a file"
#define GD_STR_exitStatusbarString L"Exit the CodeXL application"

// "Edit" menu:
#define GD_STR_MarkerNextStatusbarString L"Next: Scroll the Calls History View to the next string marker function call"
#define GD_STR_MarkerPreviousStatusbarString L"Previous: Scroll the Calls History View to the previous string marker function call"

// "Debug" menu:
#define GD_STR_DebugMenuString L"&Debug"
#define GD_STR_StartDebugging L"&Start Debugging\t" GD_STR_keyboardShortcutRunMenu
#define GD_STR_StartDebuggingA "&Start Debugging\t" GD_STR_keyboardShortcutRunMenuA
#define GD_STR_StartDebuggingWithParam "&Start Debugging (%1)\t" GD_STR_keyboardShortcutRunMenuA
#define GD_STR_StartDebuggingTooltip "Start Debugging " GD_STR_keyboardShortcutRunMenuA
#define GD_STR_StartDebuggingTooltipWithParam "&Start Debugging (%1) " GD_STR_keyboardShortcutRunMenuA
#define GD_STR_SwitchToDebugMode L"Switch to &Debug Mode"
#define GD_STR_DebugMode L"&Debug Mode"
#define GD_STR_FrameStepDebugging L"&Frame Step\t" GD_STR_keyboardShortcutFrameStepMenu
#define GD_STR_DrawStepDebugging L"Dra&w Step\t" GD_STR_keyboardShortcutDrawStepMenu
#define GD_STR_APIStepDebugging L"&API Step\t" GD_STR_keyboardShortcutAPIStepMenu
#define GD_STR_StepOverDebugging L"Step &Over\t" GD_STR_keyboardShortcutStepOverMenu
#define GD_STR_StepInDebugging L"Step &In\t" GD_STR_keyboardShortcutStepInMenu
#define GD_STR_StepOutDebugging L"Step O&ut\t" GD_STR_keyboardShortcutStepOutMenu
#define GD_STR_BreakDebugging L"&Break\t" GD_STR_keyboardShortcutBreakMenu
#define GD_STR_StopDebugging L"Sto&p Debugging\t" GD_STR_keyboardShortcutStopMenu
#define GD_STR_StartDebuggingStatusbarString L"Go (" GD_STR_keyboardShortcutRunString L") - Start debugging the debugged application"
#define GD_STR_DebugModeStatusbarString L"Debug Mode - Move to Debug Mode"
#define GD_STR_FrameStepDebuggingStatusbarString L"Frame Step (" GD_STR_keyboardShortcutFrameStepString L") - Go to the next frame terminator"
#define GD_STR_DrawStepDebuggingStatusbarString L"Draw Step (" GD_STR_keyboardShortcutDrawStepString L") - Go to the next OpenGL draw function call"
#define GD_STR_APIStepDebuggingStatusbarString L"API Step (" GD_STR_keyboardShortcutAPIStepString L") - Go to the next API function call"
#define GD_STR_StepOverDebuggingStatusbarString L"Step Over (" GD_STR_keyboardShortcutStepOverString L") - Step over to the next source line"
#define GD_STR_StepInDebuggingStatusbarString L"Step In (" GD_STR_keyboardShortcutStepInString L") - Step into the next function"
#define GD_STR_StepOutDebuggingStatusbarString L"Step Out (" GD_STR_keyboardShortcutStepOutString L") - Step out of the current function"
#define GD_STR_BreakDebuggingStatusbarString L"Break (" GD_STR_keyboardShortcutBreakString L") - Suspend the application process at the next API function call"
#define GD_STR_StopDebuggingStatusbarString L"Stop Debugging (" GD_STR_keyboardShortcutStopString L") - Terminate the debugged application"

// "Breakpoints" menu:
#define GD_STR_BreakPointsMenuString L"Brea&kpoints"
#define GD_STR_BreakOnOpenGLError L"Break on OpenGL &Error\t" GD_STR_keyboardShortcutErrorMenu
#define GD_STR_BreakOnOpenCLError L"Break on Open&CL Error"
#define GD_STR_BreakOnDetectedError L"Break on &Detected Error"
#define GD_STR_BreakOnSoftwareFallbacks L"Break on Software &Fallbacks"
#define GD_STR_BreakOnRedundantStateChanges L"Break on Redundant &State Changes"
#define GD_STR_BreakOnDeprecatedFunctions L"Break on Deprecated &Functions"
#define GD_STR_BreakOnMemoryLeaks L"Break on Memory &Leaks"
#define GD_STR_BreakOnGLDebugOutput L"Break on OpenGL Debug &Output Extension Messages"
#define GD_STR_GLDebugOutputSettings L"OpenGL Debug Output Extension &Settings..."
#define GD_STR_Breakpoints L"&Add / Remove Breakpoints...\t" GD_STR_keyboardShortcutBreakpointsMenu
#define GD_STR_EnableAllBreakpoints L"Enable a&ll Breakpoints"
#define GD_STR_EnableDisableAllBreakpoints "Enable / Disable all &Breakpoints"
#define GD_STR_BreakOnOpenGLErrorStatusbarString L"CodeXL will break whenever an OpenGL error occurs in the debugged application"
#define GD_STR_BreakOnOpenCLErrorStatusbarString L"CodeXL will break whenever an OpenCL error occurs in the debugged application"
#define GD_STR_BreakOnDetectedErrorStatusbarString L"CodeXL will break whenever an error is detected by the CodeXL OpenGL Server"
#define GD_STR_BreakOnSoftwareFallbacksStatusbarString L"CodeXL will break whenever a software fallback is detected by the CodeXL OpenGL Server"
#define GD_STR_BreakOnRedundantStateChangesStatusbarString L"CodeXL will break whenever an OpenGL state change function is called and has no effect"
#define GD_STR_BreakOnDeprecatedFunctionsStatusbarString L"CodeXL will break whenever a deprecated OpenCL or OpenGL function is called"
#define GD_STR_BreakOnMemoryLeaksStatusbarString L"CodeXL will break whenever a memory leak occurs"
#define GD_STR_BreakOnGLDebugOutputStatusbarString L"CodeXL will break whenever a debug output message event occurs"
#define GD_STR_GLDebugOutputSettingsStatusbarString L"Change the OpenGL debug output Settings"
#define GD_STR_BreakpointsStatusbarString L"Choose OpenGL, WGL and OpenGL extension functions breakpoints"
#define GD_STR_EnableAllBreakpointsStatusbarString L"Enables or disables all currently selected breakpoints. This option is checked when at least one breakpoint is currently active."
#define GD_STR_BreakpointsBreakOn "Break on: %1"
#define GD_STR_BreakpointsBreakOnAllSelectedFunctions "Break on all selected functions"
#define GD_STR_DebugSettings L"Debug Se&ttings...\t"
#define GD_STR_DebugSettingsStatusbarString L"Specify the properties of the debugged application"

// "Images" menu:
#define GD_STR_ImagesMenuString L"&Images"

// "Tools" menu:
#define GD_STR_ToolsMenuString L"&Tools"

// Generic Context menu items that doesn't appear in the menu bar
#define GD_STR_contextSaveStateVariables "Export State Variables Snapshot..."
#define GD_STR_contextSaveFunctionCallsStatistics L"&Export Function Calls Statistics..."
#define GD_STR_contextSaveProfilingData L"&Export Profiling Data..."

// Statistics Export File Header
#define GD_STR_StatisticsExportFileHeaderSeperator L"/////////////////////////////////////////////////////////////////////////////////\n"
#define GD_STR_StatisticsExportFileHeaderTitlePrefix L"// This File contains "
#define GD_STR_StatisticsExportFileHeaderTitlePostfix L" Statistics Data information\n"
#define GD_STR_StatisticsExportFileHeaderProjectName L"// Project name: "
#define GD_STR_StatisticsExportFileHeaderGenerationDate L"// Generation date: "
#define GD_STR_StatisticsExportFileHeaderGenerationTime L"// Generation time: "
#define GD_STR_StatisticsExportFileHeaderGeneratedBy L"// Generated by CodeXL - an OpenCL and OpenGL Debugger\n"
#define GD_STR_StatisticsExportFileHeaderWebSite L"// http://gpuopen.com/\n"

// Raw data export as CSV
#define GD_STR_RawDataExportFileHeaderTitle L"// This File contains raw data information\n"
#define GD_STR_RawDataExportFileDataFormat L"// Data texel format: %ls\n"
#define GD_STR_RawDataExportFileDataType L"// Data texel type: %ls\n"
#define GD_STR_RawDataExportFileAmountOfDataPages L"// Amount of data pages: %d\n//\n"
#define GD_STR_RawDataExportFileDataDimensions L"// Raw data dimensions: %dw x %dh\n"

// OpenGL Debug output settings dialog:
#define GD_STR_GLDebugOutputTitle " CodeXL GL - OpenGL Debug Output Settings"
#define GD_STR_GLESDebugOutputTitle " CodeXL ES - OpenGL ES Debug Output Settings"
#define GD_STR_GLESiPhoneDebugOutputTitle " CodeXL iPhone - OpenGL ES Debug Output Settings"
#define GD_STR_GLDebugOutputSubTitle "OpenGL Debug Output Settings"
#define GD_STR_GLDebugOutputLoggingEnabled "Enable OpenGL Debug Output Logging"
#define GD_STR_GLDebugOutputBreakOnReports "Break on OpenGL Debug Output Reports"
#define GD_STR_GLDebugOutputEnableCategories "Reported Messages"
#define GD_STR_GLDebugOutputMessageCheckboxTooltip "Toggle message logging for\n"
#define GD_STR_GLDebugOutputMessageCheckboxSeparator " - "
#define GD_STR_GLDebugOutputMessageCheckboxAllSources "All sources"
#define GD_STR_GLDebugOutputMessageCheckboxAllTypes "All types"
#define GD_STR_GLDebugOutputGeneralSettings "General Settings"
#define GD_STR_GLDebugOutputMessagesSeverity "Reported Message Severities:"

// "Expired Maintenance" dialog:
#define GD_STR_ExpiredMaintenanceTitle L" Maintenance Package Expired"
#define GD_STR_ExpiredMaintenanceAlertSizerTitle L"Maintenance package expired"
#define GD_STR_ExpiredMaintenanceAlert L"\nYour maintenance package (including software updates) expired on:\n%ls. Therefore you do not have a license\nto use%ls version %ls that was released on:\n%ls.\n\n%ls will now work in evaluation mode to enable you to try\nout this new version."
#define GD_STR_ExpiredMaintenanceExtendYourLicenseSuggestion L"\n\nIf you wish to continue and receive software updates and\ntechnical support please purchase a maintenance package."
#define GD_STR_ExpiredMaintenanceLicenseInformationSizerTitle L"License maintenance expired"
#define GD_STR_ExpiredMaintenanceRenewLicenseWebLink L"http://gpuopen.com/"
#define GD_STR_ExpiredMaintenancePurchaseButtonCaption L"&Purchase"

// Save all textures and buffers dialog:
#define GD_STR_SaveAllTexturesAndBuffersDialogGLTitle " Save all Textures and Buffers"
#define GD_STR_SaveAllTexturesAndBuffersDialogCLTitle " Save all Buffers and Images"
#define GD_STR_SaveAllTexturesAndBuffersDialogCreateNewDirPrompt L"The directory '%ls' does not exist.\nWould you like to create a new directory?"
#define GD_STR_SaveAllTexturesAndBuffersDialogCreateNewDirTitle "Create new directory"
#define GD_STR_SaveAllTexturesAndBuffersDialogCreateNewDirFailed "Could not create directory %1."
#define GD_STR_SaveAllTexturesAndBuffersDialogCreateNewDirFailedTitle "Directory creation failed"
#define GD_STR_SaveAllTexturesBufferDialogChooseOutputDir "Select an output directory"
#define GD_STR_SaveAllTexturesBufferDialogExportSettingsTitle "Textures and Buffers Export Settings:"
#define GD_STR_SaveAllTexturesBufferDialogExportSettingsOutputFormat "Output Format"
#define GD_STR_SaveAllTexturesBufferDialogExportSettingsOutputDir "Output Directory"
#define GD_STR_SaveAllTexturesBufferDialogExportSettingsOverwrite "Overwrite existing files"

// "Expired Maintenance Reminder" dialog:
#define GD_STR_ExpiredMaintenanceReminderTitle1 L" Maintenance Package Expiration Reminder"
#define GD_STR_ExpiredMaintenanceReminderTitle2 L" License Expiration Reminder"
#define GD_STR_ExpiredMaintenanceReminderAlertSizerTitle1 L"Maintenance package expiration"
#define GD_STR_ExpiredMaintenanceReminderAlertSizerTitle2 L"License expiration"
#define GD_STR_ExpiredMaintenanceReminderAlertBeforeMaintenanceExpiration L"\nYour maintenance package (including software updates) will expire on: %ls."
#define GD_STR_ExpiredMaintenanceReminderAlertBeforeLicenseExpiration L"\nYour license will expire on: %ls."
#define GD_STR_ExpiredMaintenanceReminderAlertBeforeExpirationPast L"\nYour maintenance package (including software updates) expired on: %ls."
#define GD_STR_ExpiredMaintenanceReminderAlertBeforeExpiration1 L"\nWithout a valid maintenance package you will not be able to use newer versions of %ls."
#define GD_STR_ExpiredMaintenanceReminderAlertBeforeExpiration2 L"\nWithout a valid license you will not be able to use %ls."
#define GD_STR_ExpiredMaintenanceReminderExtendYourLicenseSuggestion1 L"\nIf you wish to continue and receive software updates and\ntechnical support please purchase a maintenance package."
#define GD_STR_ExpiredMaintenanceReminderExtendYourLicenseSuggestion2 L"\nIf you wish to continue and use CodeXL\nplease purchase a license."
#define GD_STR_ExpiredMaintenanceReminderLicenseInformationSizerTitle L"License maintenance expired"
#define GD_STR_ExpiredMaintenanceReminderRenewLicenseWebLink1 L"http://gpuopen.com/"
#define GD_STR_ExpiredMaintenanceReminderRenewLicenseWebLink2 L"http://gpuopen.com/"
#define GD_STR_ExpiredMaintenanceReminderPurchaseButtonCaption L"&Purchase"
#define GD_STR_ExpiredMaintenanceReminderRemindMeLater L"Remind me next time I run CodeXL"
#define GD_STR_ExpiredMaintenanceReminderRemindMeOneWeek L"Remind me in one week"
#define GD_STR_ExpiredMaintenanceReminderDontRemindMeLater L"Never remind me again"

// "Help about" dialog:
#define GD_STR_HelpAboutLicenseTitle L"License information"
#define GD_STR_HelpAboutLicenseeName L"Licensee name: "
#define GD_STR_HelpAboutLicenseeType L"License type: "
#define GD_STR_HelpAboutLicenseTypeAcademic L"Academic"
#define GD_STR_HelpAboutLicenseTypeIndie L"Indie"
#define GD_STR_HelpAboutLicenseTypeCommercial L"Commercial"
#define GD_STR_HelpAboutLicenseExpired L"Expired"
#define GD_STR_HelpAboutNoLicense L"No license installed"
#define GD_STR_HelpAboutLicenseExpirationDate L"License expiration date: "
#define GD_STR_HelpAboutSupportExpirationDate L"Support and upgrades expiration date: "
#define GD_STR_HelpAboutFreeLicense L"Complimentary License"
#define GD_STR_HelpAboutLicenseAcademicWarning1 L"** THIS LICENSE IS FOR ACADEMIC USE ONLY!"
#define GD_STR_HelpAboutLicenseAcademicWarning2 L"USING THIS LICENSE FOR NON-ACADEMIC OR COMMERCIAL USE IS FORBIDDEN."
#define GD_STR_HelpAboutLicenseIndieWarning1 L"** THIS LICENSE IS LIMITED FOR USE BY INDIE DEVELOPERS ONLY, ACCORDING TO"
#define GD_STR_HelpAboutLicenseIndieWarning2 L"THE TERMS DEFINED BY GRAPHIC REMEDY'S INDIE END USER LICENSE AGREEMENT"

// Finds dialogs:
#define GD_STR_ProcessEventsFindDialogTitle L"Find in the Process Events view"
#define GD_STR_CallsHistoryFindDialogTitle L"Find in the Function Calls History view"
#define GD_STR_FunctionCallsStatisticsFindDialogTitle L"Find in the Function Calls Statistics view"
#define GD_STR_CallsStackFindDialogTitle L"Find in the Call Stack view"
#define GD_STR_StateVariablesFindDialogTitle L"Find in the State Variables view"
#define GD_STR_CannotFindFindDialog L"Cannot find the string"

// "Debug Settings" dialog:
#define GD_STR_DebugSettingsDescription L"Please set the debugged application properties"
#define GD_STR_VisualStudioProjectSettingsDescription L"Please select the project settings"
#define GD_STR_DebugSettingsTitle L"Debug Settings"
#define GD_STR_VisualStudioProjectSettingsTitle L"Project Settings"
#define GD_STR_DebugSettingsConnectionSettingsTitle L"Connection Settings"
#define GD_STR_DebugSettingsProjectSettingsTitle L"Project Settings"
#define GD_STR_DebugSettingsFrameTerminatorsTitle L"OpenGL Render Frame Terminators"
#define GD_STR_DebugSettingsFrameTerminatorCheckBoxTitleToolTip L"Select the function/s that end each OpenGL render frame"
#define GD_STR_DebugSettingsComputeFrameTerminatorsTitle L"OpenCL Computation Frame Terminators"
#define GD_STR_DebugSettingsComputationFrameTerminatorCheckBoxTitleToolTip L"Select the function/s that end each OpenCL computation frame"
#define GD_STR_DebugSettingsAdvancedSettingsTitle L"Advanced Settings"
#define GD_STR_DebugSettingsCallsHistoryLogTitle L"Log Files"
#define GD_STR_DebugSettingsInitializeDirectDraw L"Initialize DirectDraw library on startup"
#define GD_STR_DebugSettingsInitializeDirectDrawToolTip L"Make the CodeXL OpenGL server initialize the DirectDraw library as it loads.\nThis option should only be enabled for applications using both OpenGL and DirectDraw,\nand only if the debugged application crashes on startup if this option off."
#define GD_STR_DebugSettingsProjectTypeTitle L"Project Type"
#if AMDT_BUILD_TARGET == AMDT_WINDOWS_OS
    #define GD_STR_DebugSettingsOpenGLESProject L"OpenGL &ES 1.1 Emulation"
#elif (AMDT_BUILD_TARGET == AMDT_LINUX_OS) && (AMDT_LINUX_VARIANT == AMDT_MAC_OS_X_LINUX_VARIANT)
    #define GD_STR_DebugSettingsOpenGLESProject L"OpenGL &ES (iPhone / iPad)"
#elif (AMDT_BUILD_TARGET == AMDT_LINUX_OS) && (AMDT_LINUX_VARIANT == AMDT_GENERIC_LINUX_VARIANT)
    #define GD_STR_DebugSettingsOpenGLESProject L"OpenGL &ES"
#else // AMDT_BUILD_TARGET
    #error Unknown build target!
#endif
#define GD_STR_DebugSettingsOpenGLAndOpenCLProject L"&OpenGL and OpenCL"
#define GD_STR_DebugSettingsProjectExecutionTargetTitle L"Project Execution Target"
#define GD_STR_DebugSettingsLocalComputerTarget L"Local Computer"
#define GD_STR_DebugSettingsiPhoneSimulatorTarget L"iPhone / iPad Simulator"
#define GD_STR_DebugSettingsiPhoneDeviceTarget L"iPhone / iPad Device"
#define GD_STR_DebugSettingsUseAutomaticConfiguration L"Use automatic configuration (recommended)"
#define GD_STR_DebugSettingsUseAutomaticConfigurationToolTip L"Automatically configure and run the on-device Xcode project. Uncheck this option only if experiencing problems with the automatic configuration."
#define GD_STR_DebugSettingsExportiPhoneDeviceServerLibraries L"iPhone / iPad Setup..."
#define GD_STR_DebugSettingsExportiPhoneDeviceServerLibrariesToolTip L"Export CodeXL iPhone/iPad on-device OpenGL ES server libraries to a selected directory and display the on-device setup instructions."
#define GD_STR_DebugSettingsExportiPhoneDeviceServerHelpToolTip L"Display the iPhone / iPad on-device setup instructions."
#define GD_STR_DebugSettingsLinuxLoaderUsePreload L"Use Pre-load mechanism"
#define GD_STR_DebugSettingsLogFile L"Log Files and Images Directory"
#define GD_STR_DebugSettingsProgramExe L"Executable for debug session:"
#define GD_STR_DebugSettingsProgramExeWarning "Please select an executable for debug session"
#define GD_STR_DebugSettingsProgramXcodeproj L"Xcode project for debug session:"
#define GD_STR_DebugSettingsProgramArgs L"Program arguments:"
#define GD_STR_DebugSettingsKernelSourceFilesFolder L"Kernel source files folder:"
#define GD_STR_DebugSettingsOSEnvVars L"Operating system environment variables:"
#define GD_STR_DebugSettingsOSEnvVarsButtonTooltip L"Edit OS environment variables"
#define GD_STR_DebugSettingsLinuxLoader L"Loader configuration:"
#define GD_STR_DebugSettingsProgramEnvVarsTooltip L"Session Environment Variables\n[variable name1]=[string1] ; [variable name2]=[string2] ; ..."
#define GD_STR_DebugSettingsWorkingDirectory L"Working directory:"
#define GD_STR_DebugSettingsLoadExeTitle L"Choose a program to debug"
#define GD_STR_DebugSettingsLoadWorkingDirTitle L"Choose the debugged application working directory"
#define GD_STR_DebugSettingsLoadLogDirTitle L"Choose the debugged application logs and data file directory"
#define GD_STR_DebugSettingsiPhoneSDK L"iPhone Simulator SDK Version / Path:"
#define GD_STR_DebugSettingsDefaultiPhoneSDKsComboOtherSDK L"Other"
#define GD_STR_DebugSettingsiPhoneSDKTitle L"Choose the iPhone Simulator SDK used to build your application"
#define GD_STR_DebugSettingsiPhoneSimulatorSDKsDefaultRootPath L"/Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs/"
#define GD_STR_DebugSettingsiPhoneSimulatorSDKsPrefix L"iPhoneSimulator"
#define GD_STR_DebugSettingsiPhoneSimulatorSDKsSuffix L".sdk"
#define GD_STR_DebugSettingsiPhoneSimulatorDefaultSDKVersionAsString L"3.2"
#define GD_STR_DebugSettingsiPhoneSDKDefaultValue GD_STR_DebugSettingsiPhoneSimulatorSDKsDefaultRootPath GD_STR_DebugSettingsiPhoneSimulatorSDKsPrefix GD_STR_DebugSettingsiPhoneSimulatorDefaultSDKVersionAsString GD_STR_DebugSettingsiPhoneSimulatorSDKsSuffix
#define GD_STR_DebugSettingsiPhoneSDKOpenGLESRelativePath L"/System/Library/Frameworks/OpenGLES.framework"
#define GD_STR_DebugSettingsiPhoneSDKBadValue L"The iPhone SDK path you've chosen doesn't seem to have a valid version of the OpenGL ES framework.\nPlease choose an SDK which contains the OpenGL ES framework\n(SDKs are usually found under /Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs)."
#define GD_STR_DebugSettingsiPhoneSDKMismatch L"The iPhone SDK path you've chosen doesn't seem to match the selected app's SDK version.\nIs this Ok?"
#define GD_STR_DebugSettingsRemoteTargetConnectionHostName L"This computer's IP address (to accept connections from the remote target):"
#define GD_STR_DebugSettingsRemoteDeviceConnectionHostName L"This computer's IP address (to accept connections from the remote device):"
#define GD_STR_DebugSettingsRemoteConnectionAPIPort L"API Port:"
#define GD_STR_DebugSettingsRemoteConnectionEventsPort L"Events Port:"

// Edit Environment Variables Dialog
#define GD_STR_EditVariablesDialogTitle L"Edit Environment Variables"
#define GD_STR_EditVariablesDialogDescription L"Please add operating system environment variables for the debugged session"
#define GD_STR_EditVariablesDialogVariableNameColumnTitle L"Environment Variable Name"
#define GD_STR_EditVariablesDialogAddEnvironmentVariable L"Add Environment Variable..."
#define GD_STR_EditVariablesDialogErrorMsgTitle L"Incorrect Variable Name"
#define GD_STR_EditVariablesDialogErrorMsg L"Variable name in row number %d is not valid"

// Double and single progress bar dialogs
#define GD_STR_DoubleProgressBarDialogCurrentItemProgress "Item Progress"
#define GD_STR_DoubleProgressBarDialogTotalProgress "Total Progress"
#define GD_STR_DoubleProgressBarDialogOutputLog "Output Log"
#define GD_STR_ProgressBarPleaseWaitMessage "Please Wait..."

// "Options" dialog:
#define GD_STR_OptionsTitle L"Options"
#define GD_STR_OptionsGeneralTab L"&General"
#define GD_STR_OptionsCallStackTab L"Call &Stack"
#define GD_STR_OptionsCallsLoggerTexturesTab L"&HTML Log File"
#define GD_STR_OptionsAdvancedTab L"&Advanced"
#define GD_STR_OptionsConnectionTab L"Co&nnection"
#define GD_STR_OptionsLoggingTab L"&Logging"

// Textures and Buffers image and spreadsheet logging formats descriptions
#define GD_STR_TexturesAndBuffersLoggingFormatJpeg "JPEG"
#define GD_STR_TexturesAndBuffersLoggingFormatBmp "BMP"
#define GD_STR_TexturesAndBuffersLoggingFormatPng "PNG (Preserves alpha values)"
#define GD_STR_TexturesAndBuffersLoggingFormatTiff "TIFF (3D Textures and Images are always stored in TIFF format)"
#define GD_STR_TexturesAndBuffersLoggingFormatCSV "CSV (Comma delimited file)"
#define GD_STR_TexturesAndBuffersLoggingThumbPostfix L"_thumb"

// "Additional directories" Dialog:
#define GD_STR_AdditionalDirectoriesTitle L"Source code directories"
#define GD_STR_AdditionalDirectoriesStaticText L"Please add additional source code directories"

// "Root path" Dialog
#define GD_STR_RootDialogPath L"Please set the source code root path"

#define GD_STR_OptionsAdvancedSamplePerformanceCounters L"Performance counters sample interval (mSec):"
#define GD_STR_OptionsAdvancedDebugLogLevel L"Debug log level:"

// Start Debugging Command:
#define GD_STR_LinuxBlockSignalsQueryCommand L"aticonfig --get-pcs-key=DDX,BlockSignalsOnLock 2>&1"
#define GD_STR_LinuxBlockSignalsMessageTitle "Warning - Driver configuration"
#define GD_STR_LinuxBlockSignalsMessage "The AMD Radeon Software driver is currently not configured to allow debugging of OpenCL and OpenGL applications.\n\nPlease open a terminal window and input the following command as root:\n\naticonfig --sb off\nthen reboot the machine to apply the change.\n\nContinuing without making this change may result in hangs and crashes.\nDo you wish to continue debugging?"

// Driver versions:
#define GD_STR_driverVendorName L"Advanced Micro Devices, Inc."
#define GD_STR_driverMinimalVersion L"11.1"
#define GD_STR_driverWorkingVersion L"11.4"
#define GD_STR_openclWorkingVersion L"2.5"
#define GD_STR_openclInternalVersion L"internal"
#define GD_STR_openclLookFor L"AMD-APP"
#define GD_STR_openclMinimumMajorVersion 831
#define GD_STR_openclMinimumMinorVersion 4
// Catalyst 11.11 has a runtime number of "OpenCL 1.1 AMD-APP (831.4)"
#define GD_STR_driverNoAMDWarning "You do not have a supported AMD GPU."
#define GD_STR_driverVeryOldDriverWarning "The version of AMD Radeon Software you have installed does not contain support for this version of CodeXL. It is recommended to install the latest versions of both AMD Radeon Software and CodeXL."

// "Connection" tab in options dialog
#define GD_STR_OptionsConnectionProxySettings L"Proxy settings"
#define GD_STR_OptionsConnectionUsingProxy L"I am using an HTTP proxy server:"
#define GD_STR_OptionsConnectionProxyPort L"Port number:"
#define GD_STR_OptionsConnectionInvalidProxyAddress L"Please insert a valid proxy IP or DNS address\n examples:\n  www.myproxy.example\n  123.456.78.90"
#define GD_STR_OptionsConnectionInvalidProxyPort L"Please insert a valid proxy port (number between 1 and 65535)"
#define GD_STR_OptionsConnectionInvalidProxyAddressAndPort GD_STR_OptionsConnectionInvalidProxyAddress L"\n\n" GD_STR_OptionsConnectionInvalidProxyPort
#define GD_STR_OptionsConnectionLogFilesDirDialogTitle L"Choose a directory for recording call logs"

// "Breakpoints" dialog:
#define GD_STR_BreakpointsTitle "Breakpoints"
#define GD_STR_BreakpointsDescription "Add a Function to the 'Active Breakpoints' list to set it as a breakpoint"
#define GD_STR_BreakpointsEnableDisableAllBreakpoints "E&nable all Breakpoints"
#define GD_STR_BreakpointsListText "API &Functions"
#define GD_STR_BreakPointsGenericText "&Error / Warning"
#define GD_STR_BreakpointsChoosenListText "Active Breakpoints"
#define GD_STR_BreakpointsBoxTitle "Breakpoints"
#define GD_STR_BreakpointsKernelListText "&Kernel Functions"
#define GD_STR_BreakpointsKernelAddMessage "Type kernel function name"
#define GD_STR_BreakPointsFunctionColumn "Breakpoint Name"
#define GD_STR_BreakPointsTypeColumn "Type"
#define GD_STR_BreakPointsCLFunctionType "cl API"
#define GD_STR_BreakPointsGLFunctionType "gl API"
#define GD_STR_BreakPointsGLESFunctionType "gl ES API"
#define GD_STR_BreakPointsCLKernelType "cl Kernel"
#define GD_STR_BreakPointsHSAKernelType "hsa Kernel"
#define GD_STR_BreakPointsGenericType "error/warning"
#define GD_STR_BreakPointsInvalidKernelName "Invalid kernel function name"
#define GD_STR_BreakPointsDuplicateKernelName "Kernel function name already in list"

// "State Variable" dialog:
#define GD_STR_StateVariableTitle L"State Variables"
#define GD_STR_StateVariableDescription "Add an OpenGL state variable to the variables 'watch' view to watch its value"
#define GD_STR_StateVariableListText "Available state variables"
#define GD_STR_StateVariableChoosenListText "State variables"
#define GD_STR_StateVariableBoxTitle "State variables"
#define GD_STR_StateVariablesMultipleItemsSelected "Multiple items are selected"
#define GD_STR_StateVariablesNoData "Data will be available on next debug break"
#define GD_STR_StateVariablesNonOpenGLContext "Data is only available for render contexts"

// "State Variable" compare viewer:
#define GD_STR_StateVariableCompareTitle L"State Variables Comparison Viewer"
#define GD_STR_StateVariableCompareListText L"Available state variables"
#define GD_STR_StateVariableCompareListJustDifferensText L"State variables with different values"
#define GD_STR_StateVariableCompareBoxTitle L"OpenGL state variables"
#define GD_STR_StateVariableCompareBoxTitleES L"OpenGL ES state variables"
#define GD_STR_StateVariableCompareSnapshotFile1Title L"Snapshot file 1"
#define GD_STR_StateVariableCompareSnapshotFile2Title L"Snapshot file 2"
#define GD_STR_StateVariableCompareOnlineComparison L"Compare render context %d state variable values to:"
#define GD_STR_StateVariableCompareOnlineComparisonNotGL L"Select a render context to compare its state variable values to:"
#define GD_STR_StateVariableCompareOnlineToSnapshotFile L"A snapshot file"
#define GD_STR_StateVariableCompareOnlineToDefaultValues L"%ls default state variable values"
#define GD_STR_StateVariableCompareOnlineToPreviousSuspension L"The previous debugged process suspension state variable values"
#define GD_STR_StateVariableCompareFind L"Find"
#define GD_STR_StateVariableCompareChangesOnly L"Show only differences"
#define GD_STR_StateVariableCompareNext L"Go to next difference (" GD_STR_keyboardShortcutNextDiffString GD_STR_RightParenthesis
#define GD_STR_StateVariableComparePrevious L"Go to previous difference (" GD_STR_keyboardShortcutPrevDiffString GD_STR_RightParenthesis
#define GD_STR_StateVariableCompareSaveSnapshot L"Export the current context values of all OpenGL state variables to a file"
#define GD_STR_StateVariablesCompareFindDialogTitle L"Find in the State Variables Comparison Viewer"
#define GD_STR_StateVariableCompareListTitleColumn0 L"Variable Name"
#define GD_STR_StateVariableCompareListTitleColumn1Snapshot L"Value - snapshot file 1"
#define GD_STR_StateVariableCompareListTitleColumn2Snapshot L"Value - snapshot file 2"
#define GD_STR_StateVariableCompareListTitleColumn2Current L"Value - context %d"
#define GD_STR_StateVariableCompareListTitleColumn2CurrentNotGL L"Value"
#define GD_STR_StateVariableCompareListTitleColumn1Previous L"Value - context %d - previous suspension"
#define GD_STR_StateVariableCompareListTitleColumn1PreviousNotGL L"Value - previous suspension"
#define GD_STR_StateVariableCompareListTitleColumn1DefaultOpenGL L"Value - context %d - OpenGL default values"
#define GD_STR_StateVariableCompareListTitleColumn1DefaultNotGL L"Value - OpenGL default values"
#define GD_STR_StateVariableCompareListTitleColumn1DefaultOpenGLES L"Value - context %d - OpenGL ES default values"
#define GD_STR_StateVariableCompareListTitleColumn1DefaultNotGLES L"Value - OpenGL ES default values"
#define GD_STR_StateVariableCompareAllValuesAreEqaul L"All Values are equal"
#define GD_STR_StateVariableCompareTitleChangeFocusIndentation L"           "
#define GD_STR_StateVariableCompareLoadSnapshot1Title L"Load OpenGL state variable snapshot 1"
#define GD_STR_StateVariableCompareLoadSnapshot2Title L"Load OpenGL state variable snapshot 2"

// "Performance Counters" dialog:
#define GD_STR_PerformanceCountersTitle L"Performance Counters"
#define GD_STR_PerformanceCounterTitle L"Performance Counter"
#define GD_STR_PerformanceCountersDescription L"Add a performance counters to the 'Active Counters' list to view it's usage"
#define GD_STR_PerformanceCountersAddBtn L"&Add >>"
#define GD_STR_PerformanceCountersRemoveBtn L"<< &Remove"
#define GD_STR_PerformanceCountersRemoveAllBtn L"Remove A&ll"
#define GD_STR_PerformanceCountersIgnoreAllBreakpoints L"&Enable Breakpoints"
#define GD_STR_PerformanceCountersBreakOnOpenGLError L"&Break on OpenGL errors"
#define GD_STR_PerformanceCountersBreakOnDetectedError L"Break on &Detected errors"
#define GD_STR_PerformanceCountersListText L"Available counters"
#define GD_STR_PerformanceCountersChoosenListText L"Active counters"
#define GD_STR_PerformanceCountersSelectCounter L"Select counter"
#define GD_STR_PerformanceCountersSettingsTitle L"Counter settings"
#define GD_STR_PerformanceCountersBoxTitle L"Performance counters"
#define GD_STR_PerformanceCountersATIOpenGLTitle L"ATI OpenGL Performance Counters"
#define GD_STR_PerformanceCountersATIStreamOpenCLTitle L"ATI Stream OpenCL Performance Counters"
#define GD_STR_PerformanceCountersVistaTitle L"Windows Vista Performance Counters"
#define GD_STR_PerformanceCountersLinuxTitle L"Linux OS Performance Counters"
#define GD_STR_PerformanceCountersMacTitle L"Mac OS X Performance Counters"
#define GD_STR_PerformanceCountersiPhoneGPUTitle L"iPhone / iPad GPU (SGX) Performance Counters"
#define GD_STR_PerformanceCountersiPhoneTitle L"iOS Performance Counters"
#define GD_STR_PerformanceCountersWindowsTitle L"Windows OS Performance Counters"
#define GD_STR_PerformanceCountersCodeXLTitle L"CodeXL Performance Counters"
#define GD_STR_PerformanceCountersCodeXLCLTitle L"CodeXL OpenCL Performance Counters"
#define GD_STR_PerformanceCountersMacOpenGLDriverTitle L"OpenGL Driver (%ls) Performance Counters"
#define GD_STR_PerformanceCountersVistaUnsupportedText L"Are available only when running CodeXL with Administrator permissions (Elevated mode), on English language Windows operating systems."
#define GD_STR_PerformanceCountersWinOSGeneralUnsupportedText L"Are only available on English language Windows operating systems."
#define GD_STR_PerformanceCountersMacOpenGLDriverNotSupportedText L"Performance counters are currently unavailable, please verify the %ls driver (GPU %d) is installed correctly and functioning."
#define GS_STR_PerformanceCountersMacOSCountersHiddenText L"Are only available on OpenGL, OpenCL or iPhone / iPad Simulator projects"
#define GS_STR_PerformanceCountersiPhoneOSCountersHiddenText L"Are only available on iPhone / iPad Device projects"
#define GD_STR_PerformanceCountersCodeXLText L"Counters exported by the CodeXL OpenGL Server."
#define GD_STR_PerformanceCountersCodeXLCLText L"Counters exported by the CodeXL OpenCL Server."
#define GD_STR_PerformanceCountersATIOpenGLText L"Counters exported by the ATI graphics driver and GPU."
#define GD_STR_PerformanceCountersATIStreamOpenCLText L"Counters exported by the ATI Stream OpenCL driver."
#define GD_STR_PerformanceCountersLinuxText L"System performance counters exported by the Linux operating system."
#define GD_STR_PerformanceCountersMacText L"System performance counters exported by the Mac OS X operating system."
#define GD_STR_PerformanceCountersWindowsText L"System performance counters exported by the Windows operating system."
#define GD_STR_PerformanceCountersiPhoneText L"System performance counters exported by the iOS operating system."
#define GD_STR_PerformanceCountersiPhoneGPUText L"Counters exported by the iPhone / iPad graphics driver and GPU (iPhone 3GS and iPad only)."
#define GD_STR_PerformanceCountersMacOpenGLDriverText L"Counters exported by the %ls graphics driver and GPU %d."
#define GD_STR_PerformanceCountersAddOS L"Add Other OS Counters..."
#define GD_STR_PerformanceCountersAddOSTitle L"Other Operating System Counters"
#define GD_STR_PerformanceCountersAddOSText L"Choose any available OS performance counters. After adding the counter/s to the list of the available performance counters, you can add the counter/s to the active counters list."
#define GD_STR_PerformanceCountersDeleteCounterConfirm L"The counter \""
#define GD_STR_PerformanceCountersDeleteCounterConfirm1 L"\" is selected as an Active counter for monitoring. Are you sure you want to delete it?"
#define GD_STR_PerformanceCountersDeleteContextConfirm L"By deleting \"context %d\" you will also delete \"context %d\" monitored Active counters.\nAre you sure you want to delete it?"
#define GD_STR_PerformanceCountersAddRenderContext L"Add Render Context..."
#define GD_STR_PerformanceCountersAddQueue L"Add Queue..."
#define GD_STR_PerformanceCountersAddRenderContextDialogTitle L"Add Render Context"
#define GD_STR_PerformanceCountersAddOpenCLQueueDialogTitle L"Add OpenCL Queue"
#define GD_STR_PerformanceCountersAddGLContextDialogDescription L"Select the ID of the context you want to add (2-100):"
#define GD_STR_PerformanceCountersAddCLContextDialogDescription L"Select the ID of the context you want to add (1-100):"
#define GD_STR_PerformanceCountersAddOpenCLQueueDialogDescription L"Select the ID of the OpenCL queue you want to add (1-100):"
#define GD_STR_PerformanceCountersAddRenderContextDescription L"Add other render contexts. After adding the context to the list of the available performance counters, you can add the context's counter/s to the Active counters list."
#define GD_STR_PerformanceCountersAddQueueDescription L"Add other command queues. After adding the command queue to the list of the available performance counters, you can add the queue's counter/s to the Active counters list."
#define GD_STR_PerformanceCountersAddAllreadyExists L"The counter \"%ls\" already exists."
#define GD_STR_PerformanceCountersSettingsScale L"Scale:"
#define GD_STR_PerformanceCountersSettingsDisplayIn L"Displayed in:"
#define GD_STR_PerformanceCountersSettingsColor L"Color:"
#define GD_STR_PerformanceCountersSettingsLineWeight L"Line width:"
#define GD_STR_PerformanceCountersOpenGLDriverTreeLabelOneGPU L" (%ls)"
#define GD_STR_PerformanceCountersOpenGLDriverTreeLabelMultiGPU L" (GPU %d - %ls)"
#define GD_STR_PerformanceCountersOpenGLDriverTreeLabelMultiGPUUnknownGPU L"Unknown GPU"
#define GD_STR_PerformanceCountersOpenGLDriverTreeLabelMultiGPUDescriptionSuffix L"\nExported by "
#define GD_STR_PerformanceCountersOpenGLDriverTreeCounterLabelGPUSuffix L" (GPU %d)"
#define GD_STR_PerformanceCountersCodeXLGLTreeLabel L"CodeXL GL"
#define GD_STR_PerformanceCountersCodeXLCLTreeLabel L"CodeXL CL"
#define GD_STR_PerformanceCountersATIOpenGLTreeLabel L"ATI OpenGL"
#define GD_STR_PerformanceCountersATIStreamOpenCLTreeLabel L"ATI Stream OpenCL"
#define GD_STR_PerformanceCountersWindowsTreeLabel L"Windows OS"
#define GD_STR_PerformanceCountersLinuxTreeLabel L"Linux"
#define GD_STR_PerformanceCountersMacTreeLabel L"Mac OS X"
#define GD_STR_PerformanceCountersOpenGLDriverTreeLabel L"OpenGL Driver"
#define GD_STR_PerformanceCountersiPhoneOSTreeLabel L"iOS"
#define GD_STR_PerformanceCountersiPhoneGPUTreeLabel L"iPhone / iPad GPU (SGX)"

// "Function Calls Statistics" View:
#define GD_STR_FunctionCallsStatisticsViewColumn1Title "Function Name"
#define GD_STR_FunctionCallsStatisticsViewColumn2Title "%"
#define GD_STR_FunctionCallsStatisticsViewColumn3Title "# of Calls"
#define GD_STR_FunctionCallsStatisticsViewColumn4Title "Function type"
#define GD_STR_FunctionCallsStatisticsViewGetFunction L"Get"
#define GD_STR_FunctionCallsStatisticsViewStateChangeFunction L"State Change"
#define GD_STR_FunctionCallsStatisticsViewDrawFunction L"Draw"
#define GD_STR_FunctionCallsStatisticsViewRasterFunction L"Raster"
#define GD_STR_FunctionCallsStatisticsViewProgramsShadersFunction L"Program and Shader"
#define GD_STR_FunctionCallsStatisticsViewProgramsAndKernelsFunction L"Program and Kernel"
#define GD_STR_FunctionCallsStatisticsViewTextureFunction L"Texture"
#define GD_STR_FunctionCallsStatisticsViewMatrixFunction L"Matrix"
#define GD_STR_FunctionCallsStatisticsViewQueryFunction L"Query"
#define GD_STR_FunctionCallsStatisticsViewDeprecatedFunction L"Deprecated"
#define GD_STR_FunctionCallsStatisticsViewBufferFunction L"Buffer"
#define GD_STR_FunctionCallsStatisticsViewBuffersImagesFunction L"Buffer and Image"
#define GD_STR_FunctionCallsStatisticsViewSyncFunction L"Synchronization"
#define GD_STR_FunctionCallsStatisticsViewFeedbackFunction L"Feedback"
#define GD_STR_FunctionCallsStatisticsViewVertexArrayFunction L"Vertex Array"
#define GD_STR_FunctionCallsStatisticsViewDebugFunction L"Debug"
#define GD_STR_FunctionCallsStatisticsViewQueueFunction L"Queue"
#define GD_STR_FunctionCallsStatisticsFindDialogTitle L"Find in the Function Calls Statistics view"

// Performance counters data:
#define GD_STR_PerformanceCounterDataOSNativeLongName L"OS Native"
#define GD_STR_PerformanceCounterDataOSNativeShortName L"OS"
#define GD_STR_PerformanceCounterDataOSNativeAdditionalLongName L"OS Native Additional"
#define GD_STR_PerformanceCounterDataOSNativeAdditionalShortName L"OS"
#define GD_STR_PerformanceCounterDataiPhoneOSLongName L"iOS"
#define GD_STR_PerformanceCounterDataiPhoneOSShortName L"iOS"
#define GD_STR_PerformanceCounterDataCodeXLLongName L"CodeXL"
#define GD_STR_PerformanceCounterDataCodeXLShortName L"GDB GL"
#define GD_STR_PerformanceCounterDataATIOpenGLLongName L"ATI OpenGL"
#define GD_STR_PerformanceCounterDataATIOpenGLShortName L"ATI GL"
#define GD_STR_PerformanceCounterDataATIStreamOpenCLLongName L"ATI Stream OpenCL"
#define GD_STR_PerformanceCounterDataATIStreamOpenCLShortName L"ATI CL"
#define GD_STR_PerformanceCounterDataCodeXLCLQueueLongName L"CodeXL CL Queue"
#define GD_STR_PerformanceCounterDataCodeXLCLQueueShortName L"GDB CL"
#define GD_STR_PerformanceCounterDataMacOpenGLDriverLongName L"OpenGL Driver"
#define GD_STR_PerformanceCounterDataMacOpenGLDriverShortName L"OGL"
#define GD_STR_PerformanceCounterDataiPhoneGPULongName L"iPhone / iPad GPU"
#define GD_STR_PerformanceCounterDataiPhoneGPUShortName L"SGX"

// "Performance Graph" View:
#define GD_STR_PerformanceGraphViewCounterAddCounter L"Add performance counter..."
#define GD_STR_PerformanceGraphViewCounterName L"Counter Name"
#define GD_STR_PerformanceGraphViewCounterScaledValue L"Scaled Value"

// Performance Dashboard view:
#define GD_STR_PerformanceDashboardViewAddCounterTooltip L"Add / Remove performance counters"

// "Add PDH Counter dialog
#define GD_STR_PDHCounterDlgTitle L"Add Performance Counter"

// "Calls History" View:
#define GD_STR_CallsHistoryTitle L"Function Calls History"
#define GD_STR_CallsHistoryTitleA "Function Calls History"
#define GD_STR_CallsHistoryProcessRunning L"Function Calls History - process is running"
#define GD_STR_CallsHistoryTitleUpdating L"Updating data..."
#define GD_STR_CallsHistoryLoadFunctionInfoError L"Failed to update line"
#define GD_STR_CallsHistoryContextPrefix L"Context"
#define GD_STR_CallsHistoryNULLContextPostfix L" OpenCL & OpenGL function calls"
#define GD_STR_CallsHistoryOpenGLContextPostfix L" OpenGL function calls"
#define GD_STR_CallsHistoryOpenCLContextPostfix L" OpenCL function calls"
#define GD_STR_CallsHistoryProfilingMode L"Calls data is not logged in Profiling Mode"
#define GD_STR_CallsHistoryStatusBarFunctionIndex L"Function index: "
#define GD_STR_CallsHistoryStatusBarStoppedBeforeExecuting L"Stopped before executing: "
#define GD_STR_CallsHistorySourceCodeIconImage L"GRSourceCodeIcon.png"

// "Process Events View"
#define GD_STR_ProcessEventsViewColumnTitle "Debugged process events"
#define GD_STR_ProcessEventsViewProcessCommandLine L"Process Command Line"
#define GD_STR_ProcessEventsViewProcessCreationError L"Process Creation Error"
#define GD_STR_ProcessEventsViewProcessWorkingFolder L"Process Working Folder"
#define GD_STR_ProcessEventsLoadingESImpl L"Loading OpenGL ES implementation"
#define GD_STR_ProcessEventsRenderContextWasCreated L"OpenGL Render Context %d Created"
#define GD_STR_ProcessEventsRenderContextWasDeleted L"OpenGL Render Context %d Deleted"
#define GD_STR_ProcessEventsComputeContextWasCreated L"OpenCL Compute Context %d Created"
#define GD_STR_ProcessEventsComputeContextWasDeleted L"OpenCL Compute Context %d Deleted"
#define GD_STR_ProcessEventsQueueWasCreated L"OpenCL Queue %d (Context %d) Created"
#define GD_STR_ProcessEventsQueueWasDeleted L"OpenCL Queue %d (Context %d) Deleted"
#define GD_STR_ProcessEventsProgramWasCreated L"OpenCL Program %d (Context %d) Created"
#define GD_STR_ProcessEventsProgramWasDeleted L"OpenCL Program %d (Context %d) Deleted"
#define GD_STR_ProcessEventsProgramBuildStarting L"Building OpenCL Program %s (Context %d)..."
#define GD_STR_ProcessEventsProgramBuildEnding L"Building OpenCL Program %s (Context %d) Ended"
#define GD_STR_ProcessEventsProgramBuildFailedWithDebugFlagsNoIndices L"Could not build OpenCL Program for debugging. Error code: "
#define GD_STR_ProcessEventsProgramBuildFailedWithDebugFlags L"Could not build OpenCL Program %d (Context %d) for debugging. Error code: "
#define GD_STR_ProcessEventsProgramBuildLog L"Build Log:"
#define GD_STR_ThreadEventsViewLineNumber L"Line Number"
#define GD_STR_ThreadEventsViewStartAddress L"Start Address"
#define GD_STR_ThreadEventsViewOsIdLWP L" (LWP: %lu)"                       // Use only in Linux
#define GD_STR_ThreadEventsViewTerminationTime L"Termination Time"
#define GD_STR_ThreadEventsViewTerminationCode L"Termination Code"
#define GD_STR_ThreadEventsViewAddress L"Address"
#define GD_STR_ThreadEventsViewReason L"Reason"
#define GD_STR_ThreadEventsViewDetails L"Details"
#define GD_STR_ProcessEventsViewDebuggedProcessOutputString L"Output String"
#define GD_STR_ProcessEventsViewGDBOutputString L"GDB Output String"
#define GD_STR_ProcessEventsViewAPIName L"API Name"
#define GD_STR_ProcessEventsViewCreatingThreadId L"Creating Thread ID"
#define GD_STR_ProcessEventsViewDeletingThreadId L"Deleting Thread ID"
#define GD_STR_ProcessEventsViewRenderContextWasCreated L"OpenGL Render Context Created"
#define GD_STR_ProcessEventsViewRenderContextWasDeleted L"OpenGL Render Context Deleted"
#define GD_STR_ProcessEventsViewComputeContextWasCreated L"OpenCL Compute Context Created"
#define GD_STR_ProcessEventsViewComputeContextWasDeleted L"OpenCL Compute Context Deleted"
#define GD_STR_ProcessEventsViewOpenCLQueueWasCreated L"OpenCL Queue Created"
#define GD_STR_ProcessEventsViewOpenCLQueueWasDeleted L"OpenCL Queue Deleted"
#define GD_STR_ProcessEventsViewOpenCLProgramWasCreated L"OpenCL Program Created"
#define GD_STR_ProcessEventsViewOpenCLProgramWasDeleted L"OpenCL Program Deleted"
#define GD_STR_ProcessEventsViewOpenCLProgramBuildStarted L"OpenCL Program Build Started..."
#define GD_STR_ProcessEventsViewOpenCLProgramBuildEnded L"OpenCL Program Build ended..."
#define GD_STR_ProcessEventsViewClear "Clear Events"

// "Process Events View" - Title for the properties view:
#define GD_STR_ProcessEventsViewPropertiesTitle L"Process Event"
#define GD_STR_ProcessEventsViewPropertiesTitleOutputDebugString L"Debug String"

// The terminology is:
// - Windows - dll
// - Linux / Mac - module
#if AMDT_BUILD_TARGET == AMDT_LINUX_OS
    #define GD_STR_ProcessEventsViewPropertiesTitleDllLoaded L"Module Loaded"
    #define GD_STR_ProcessEventsViewPropertiesTitleDllUnloaded L"Module Unloaded"
#else
    #define GD_STR_ProcessEventsViewPropertiesTitleDllLoaded L"DLL Loaded"
    #define GD_STR_ProcessEventsViewPropertiesTitleDllUnloaded L"DLL Unloaded"
#endif

#define GD_STR_ProcessEventsViewPropertiesTitleBreakpointHitTitle L"Breakpoint Hit"
#define GD_STR_ProcessEventsViewPropertiesTitleStepHit L"Step"
#define GD_STR_ProcessEventsViewPropertiesTitleDrawStepHit L"Draw Step"
#define GD_STR_ProcessEventsViewPropertiesTitleFrameStepHit L"Frame Step"
#define GD_STR_ProcessEventsViewPropertiesTitleBreakHit L"Break"
#define GD_STR_ProcessEventsViewPropertiesTitlePause L"Pause"
#define GD_STR_ProcessEventsViewPropertiesTitleBreakpoint L"Breakpoint"
#define GD_STR_ProcessEventsViewPropertiesTitleOpenGLErrorHit L"OpenGL Error"
#define GD_STR_ProcessEventsViewPropertiesTitleOpenCLErrorHit L"OpenCL Error"
#define GD_STR_ProcessEventsViewPropertiesTitleOpenGLDebugOutput L"OpenGL Debug Output"
#define GD_STR_ProcessEventsViewPropertiesInFunctionSuffix L" on function: %ls"
#define GD_STR_ProcessEventsViewPropertiesTitleRedundantStateChangeHit L"Redundant State Change"
#define GD_STR_ProcessEventsViewPropertiesTitleDeprecatedFunctionHit L"Deprecated Function"
#define GD_STR_ProcessEventsViewPropertiesTitleSoftwareFallbackHit L"Software Fallback"
#define GD_STR_ProcessEventsViewPropertiesTitleForeignBreakHit L"Foreign Break"
#define GD_STR_ProcessEventsViewPropertiesTitleWaitingForProcess L"Waiting for Process"
#define GD_STR_ProcessEventsViewPropertiesTitleThreadCreated L"Thread Created"
#define GD_STR_ProcessEventsViewPropertiesTitleEventProperties L"Event Properties"
#define GD_STR_ProcessEventsViewPropertiesTitleThreadTerminated L"Thread Terminated"
#define GD_STR_ProcessEventsViewPropertiesTitleMemoryLeak L"Memory Leak"
#define GD_STR_ProcessEventsViewPropertiesTitleCheckingForMemoryLeaks L"Checking for memory leaks"
#define GD_STR_ProcessEventsViewPropertiesDebugProcessEventName L"debug process event"
#define GD_STR_ProcessEventsViewPropertiesTitleDetectedError L"Detected Error"
#define GD_STR_ProcessEventsViewPropertiesTitleDebuggedProcessOutputString L"Debugged Process Output"
#define GD_STR_ProcessEventsViewPropertiesTitleGDBOutputString L"GDB Output String"
#define GD_STR_ProcessEventsViewPropertiesTitleGDBError L"GDB Error"
#define GD_STR_ProcessEventsViewPropertiesTitleException L"Exception"
#define GD_STR_ProcessEventsViewPropertiesTitleSignal L"Signal"
#define GD_STR_ProcessEventsViewPropertiesTitleAPIConnectionEstablished L"API Connection Established"
#define GD_STR_ProcessEventsViewPropertiesTitleAPIConnectionEnded L"API Connection Ended"

// "Process Events View" - Subtitle for the properties view:
#define GD_STR_ProcessEventsViewRedundantStateChangeHitDescription L"A redundant state change is a state change function call which did not modify any of the OpenGL State Variables' values."
#define GD_STR_ProcessEventsViewDeprecatedFunctionHitDescription L"The function was marked as deprecated in OpenGL. It is recommended to avoid using deprecated functions, as their compatibility with future OpenGL versions is not assured."
#define GD_STR_ProcessEventsViewDetectedErrorFunctionHitDescription L"The breakpoint was caused bt an error detected by the CodeXL OpenGL Server"
#define GD_STR_ProcessEventsViewSoftwareFallBackHitDescription L"A software fallback happens when OpenGL renders with the CPU instead of using the GPU. This usually causes a significant performance slowdown." AF_STR_HtmlNewLine AF_STR_HtmlNewLine L"Note that Software fallbacks may be caused by using certain OpenGL mechanisms, data formats, states etc. that are not supported by the GPU. Software Fallbacks are not necessarily caused by the specific function where the CodeXL OpenGL server detected them. It is recommended to avoid software fallbacks whenever possible."
#define GD_STR_ProcessEventsViewForeignBreakHitDescription L"A foreign breakpoint is a breakpoint generated by the debugged process and not by CodeXL."
#define GD_STR_ProcessEventsViewStepHitBeforeSubtitle L"* Stopped before function execution"
#define GD_STR_ProcessEventsViewStepHitAfterSubtitle L"* Stopped after function execution"
#define GD_STR_ProcessEventsViewErrorCode L"Error Code"
#define GD_STR_ProcessEventsViewErrorDescription L"Error Description"
#define GD_STR_ProcessEventsViewErrorNoteTitle L"Note"
#define GD_STR_ProcessEventsViewErrorNoteTurnOff L"To prevent CodeXL from breaking on detected errors, use the \"Break on Detected errors\" option in the Breakpoints menu."
#define GD_STR_ProcessEventsViewErrorNoteTurnOn L"To make CodeXL break on detected errors, use the \"Break on Detected errors\" option in the Breakpoints menu."
#define GD_STR_ProcessEventsViewPropertiesTitleSearchingForMemoryLeaksDescription L"To break on memory leaks, use the \"Break on Memory Leaks\" option in the CodeXL Breakpoints menu."

// "Process Events View" - Name in the ListCtrl:
#define GD_STR_ProcessEventsViewProcessCreated L"Process Created: "
#define GD_STR_ProcessEventsViewWaitingForProcess L"Waiting for Process: "
#define GD_STR_ProcessEventsViewThreadCreated L"Thread Created: "
#define GD_STR_ProcessEventsViewThreadTerminated L"Thread Terminated: "
#define GD_STR_ProcessEventsViewDllLoad L"DLL Loaded: "
#define GD_STR_ProcessEventsViewDllUnload L"DLL Unloaded: "
#define GD_STR_ProcessEventsViewModuleLoad L"Module Loaded: "
#define GD_STR_ProcessEventsViewModuleUnload L"Module Unloaded: "
#define GD_STR_ProcessEventsViewOutputDebugString L"Debug String: "
#define GD_STR_ProcessEventsViewGDBString L"GDB String: "
#define GD_STR_ProcessEventsViewGDBError L"GDB Error: "
#define GD_STR_ProcessEventsViewOutputString L"Output String: "
#define GD_STR_ProcessEventsViewBreakpointHit L"Breakpoint Hit: "
#define GD_STR_ProcessEventsViewStepHit L"Step: "
#define GD_STR_ProcessEventsViewDrawStepHit L"Draw Step: "
#define GD_STR_ProcessEventsViewFrameStepHit L"Frame Step: "
#define GD_STR_ProcessEventsViewStepInHit L"Step In: "
#define GD_STR_ProcessEventsViewStepOutHit L"Step Out: "
#define GD_STR_ProcessEventsViewStepOverHit L"Step Over: "
#define GD_STR_ProcessEventsViewBreakHit L"Break "
#define GD_STR_ProcessEventsViewOpenGLErrorHit L"OpenGL Error: "
#define GD_STR_ProcessEventsViewOpenCLErrorHit L"OpenCL Error: "
#define GD_STR_ProcessEventsViewTechnologyMonitorFailure L"Technology Monitor failure: "
#define GD_STR_ProcessEventsViewRedundantStateChangeHit L"Redundant State Change: "
#define GD_STR_ProcessEventsViewDeprecatedFunctionHit L"Deprecated Function Call: "
#define GD_STR_ProcessEventsViewSoftwareFallbackHit L"Software Fallback"
#define GD_STR_ProcessEventsViewHostBreakpointHit L"Host code breakpoint"
#define GD_STR_ProcessEventsViewForeignBreakHit L"Foreign Break"
#define GD_STR_ProcessEventsViewProcessCreationFailed L"Process Creation Failed"
#define GD_STR_ProcessEventsViewProcessStarted L"Process Run Started"
#define GD_STR_ProcessEventsViewSecondChanceException L"Second Chance Exception"
#define GD_STR_ProcessEventsViewException L"Exception: "
#define GD_STR_ProcessEventsViewSignal L"Signal: "
#define GD_STR_ProcessEventsViewDebuggedProcessErrorTitle L"Detected Error"


// OpenGL Errors names and descriptions:
#define GD_STR_ProcessEventsViewOGLErrorGL_NO_ERRORName L"GL_NO_ERROR"
#define GD_STR_ProcessEventsViewOGLErrorGL_INVALID_ENUMName L"GL_INVALID_ENUM"
#define GD_STR_ProcessEventsViewOGLErrorGL_INVALID_VALUEName L"GL_INVALID_VALUE"
#define GD_STR_ProcessEventsViewOGLErrorGL_INVALID_OPERATIONName L"GL_INVALID_OPERATION"
#define GD_STR_ProcessEventsViewOGLErrorGL_STACK_OVERFLOWName L"GL_STACK_OVERFLOW"
#define GD_STR_ProcessEventsViewOGLErrorGL_STACK_UNDERFLOWName L"GL_STACK_UNDERFLOW"
#define GD_STR_ProcessEventsViewOGLErrorGL_OUT_OF_MEMORYName L"GL_OUT_OF_MEMORY"
#define GD_STR_ProcessEventsViewOGLErrorGL_TABLE_TOO_LARGEName L"GL_TABLE_TOO_LARGE"
#define GD_STR_ProcessEventsViewOGLErrorGL_NO_ERRORDesc L"No OpenGL error."
#define GD_STR_ProcessEventsViewOGLErrorGL_INVALID_ENUMDesc L"An unacceptable value is specified for an enumerated argument.\nThe offending command is ignored, and has no other side effect than to set the error flag."
#define GD_STR_ProcessEventsViewOGLErrorGL_INVALID_VALUEDesc L"A numeric argument is out of range.\nThe offending function is ignored, having no side effect other than to set the error flag."
#define GD_STR_ProcessEventsViewOGLErrorGL_INVALID_OPERATIONDesc L"The specified operation is not allowed in the current state.\nThe offending function is ignored, having no side effect other than to set the error flag."
#define GD_STR_ProcessEventsViewOGLErrorGL_STACK_OVERFLOWDesc L"This command would cause a stack overflow.\nThe offending command is ignored, and has no other side effect than to set the error flag."
#define GD_STR_ProcessEventsViewOGLErrorGL_STACK_UNDERFLOWDesc L"This function would cause a stack underflow.\nThe offending function is ignored, having no side effect other than to set the error flag."
#define GD_STR_ProcessEventsViewOGLErrorGL_OUT_OF_MEMORYDesc L"There is not enough memory left to execute the function.\nThe state of OpenGL is undefined, except for the state of the error flags, after this error is recorded."
#define GD_STR_ProcessEventsViewOGLErrorGL_TABLE_TOO_LARGEDesc L"The specified table exceeds the implementation's maximum supported table size.\nThe offending command is ignored and has no other side effect than to set the error flag."
#define GD_STR_ProcessEventsViewOGLErrorGL_INVALID_FRAMEBUFFER_OPERATIONDesc L"An invalid frame buffer operation was performed."
#define GD_STR_ProcessEventsViewOGLErrorUnknown L"Unknown OpenGL error."

// OpenCL error codes and descriptions:
#define GD_STR_ProcessEventsViewOCLErrorCL_SUCCESSName L"CL_SUCCESS"
#define GD_STR_ProcessEventsViewOCLErrorCL_DEVICE_NOT_FOUNDName L"CL_DEVICE_NOT_FOUND"
#define GD_STR_ProcessEventsViewOCLErrorCL_DEVICE_NOT_AVAILABLEName L"CL_DEVICE_NOT_AVAILABLE"
#define GD_STR_ProcessEventsViewOCLErrorCL_COMPILER_NOT_AVAILABLEName L"CL_COMPILER_NOT_AVAILABLE"
#define GD_STR_ProcessEventsViewOCLErrorCL_MEM_OBJECT_ALLOCATION_FAILUREName L"CL_MEM_OBJECT_ALLOCATION_FAILURE"
#define GD_STR_ProcessEventsViewOCLErrorCL_OUT_OF_RESOURCESName L"CL_OUT_OF_RESOURCES"
#define GD_STR_ProcessEventsViewOCLErrorCL_OUT_OF_HOST_MEMORYName L"CL_OUT_OF_HOST_MEMORY"
#define GD_STR_ProcessEventsViewOCLErrorCL_PROFILING_INFO_NOT_AVAILABLEName L"CL_PROFILING_INFO_NOT_AVAILABLE"
#define GD_STR_ProcessEventsViewOCLErrorCL_MEM_COPY_OVERLAPName L"CL_MEM_COPY_OVERLAP"
#define GD_STR_ProcessEventsViewOCLErrorCL_IMAGE_FORMAT_MISMATCHName L"CL_IMAGE_FORMAT_MISMATCH"
#define GD_STR_ProcessEventsViewOCLErrorCL_IMAGE_FORMAT_NOT_SUPPORTEDName L"CL_IMAGE_FORMAT_NOT_SUPPORTED"
#define GD_STR_ProcessEventsViewOCLErrorCL_BUILD_PROGRAM_FAILUREName L"CL_BUILD_PROGRAM_FAILURE"
#define GD_STR_ProcessEventsViewOCLErrorCL_MAP_FAILUREName L"CL_MAP_FAILURE"
#define GD_STR_ProcessEventsViewOCLErrorCL_MISALIGNED_SUB_BUFFER_OFFSETName L"CL_MISALIGNED_SUB_BUFFER_OFFSET"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PROPERTYName L"CL_INVALID_PROPERTY"
#define GD_STR_ProcessEventsViewOCLErrorCL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LISTName L"CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_VALUEName L"CL_INVALID_VALUE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_DEVICE_TYPEName L"CL_INVALID_DEVICE_TYPE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PLATFORMName L"CL_INVALID_PLATFORM"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_DEVICEName L"CL_INVALID_DEVICE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_CONTEXTName L"CL_INVALID_CONTEXT"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_QUEUE_PROPERTIESName L"CL_INVALID_QUEUE_PROPERTIES"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_COMMAND_QUEUEName L"CL_INVALID_COMMAND_QUEUE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_HOST_PTRName L"CL_INVALID_HOST_PTR"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_MEM_OBJECTName L"CL_INVALID_MEM_OBJECT"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_IMAGE_FORMAT_DESCRIPTORName L"CL_INVALID_IMAGE_FORMAT_DESCRIPTOR"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_IMAGE_SIZEName L"CL_INVALID_IMAGE_SIZE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_SAMPLERName L"CL_INVALID_SAMPLER"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_BINARYName L"CL_INVALID_BINARY"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_BUILD_OPTIONSName L"CL_INVALID_BUILD_OPTIONS"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PROGRAMName L"CL_INVALID_PROGRAM"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PROGRAM_EXECUTABLEName L"CL_INVALID_PROGRAM_EXECUTABLE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNEL_NAMEName L"CL_INVALID_KERNEL_NAME"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNEL_DEFINITIONName L"CL_INVALID_KERNEL_DEFINITION"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNELName L"CL_INVALID_KERNEL"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_ARG_INDEXName L"CL_INVALID_ARG_INDEX"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_ARG_VALUEName L"CL_INVALID_ARG_VALUE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_ARG_SIZEName L"CL_INVALID_ARG_SIZE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNEL_ARGSName L"CL_INVALID_KERNEL_ARGS"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_WORK_DIMENSIONName L"CL_INVALID_WORK_DIMENSION"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_WORK_GROUP_SIZEName L"CL_INVALID_WORK_GROUP_SIZE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_WORK_ITEM_SIZEName L"CL_INVALID_WORK_ITEM_SIZE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_GLOBAL_OFFSETName L"CL_INVALID_GLOBAL_OFFSET"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_EVENT_WAIT_LISTName L"CL_INVALID_EVENT_WAIT_LIST"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_EVENTName L"CL_INVALID_EVENT"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_OPERATIONName L"CL_INVALID_OPERATION"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_GL_OBJECTName L"CL_INVALID_GL_OBJECT"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_BUFFER_SIZEName L"CL_INVALID_BUFFER_SIZE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_MIP_LEVELName L"CL_INVALID_MIP_LEVEL"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_GLOBAL_WORK_SIZEName L"CL_INVALID_GLOBAL_WORK_SIZE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PIPE_SIZEName L"CL_INVALID_PIPE_SIZE"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_DEVICE_QUEUEName L"CL_INVALID_DEVICE_QUEUE"
#define GD_STR_ProcessEventsViewOCLErrorUnknown L"Unknown OpenCL error"

#define GD_STR_ProcessEventsViewOCLErrorCL_SUCCESSDescription L"No OpenCL error."
#define GD_STR_ProcessEventsViewOCLErrorCL_DEVICE_NOT_FOUNDDescription L"No OpenCL devices that match the specified devices were found."
#define GD_STR_ProcessEventsViewOCLErrorCL_DEVICE_NOT_AVAILABLEDescription L"The specified device is currently unavailable."
#define GD_STR_ProcessEventsViewOCLErrorCL_COMPILER_NOT_AVAILABLEDescription L"A compiler is not available"
#define GD_STR_ProcessEventsViewOCLErrorCL_MEM_OBJECT_ALLOCATION_FAILUREDescription L"Failure to allocate memory for data store associated with image or buffer objects specified as arguments to kernel."
#define GD_STR_ProcessEventsViewOCLErrorCL_OUT_OF_RESOURCESDescription L"Failed to queue the execution instance of kernel on the command-queue because of insufficient resources needed to execute the kernel."
#define GD_STR_ProcessEventsViewOCLErrorCL_OUT_OF_HOST_MEMORYDescription L"Failed to allocate resources required by the OpenCL implementation on the host."
#define GD_STR_ProcessEventsViewOCLErrorCL_PROFILING_INFO_NOT_AVAILABLEDescription L"The profiling information is currently not available (because the command identified by event has not completed)."
#define GD_STR_ProcessEventsViewOCLErrorCL_MEM_COPY_OVERLAPDescription L"The source and destination images are the same image (or the source and destination buffers are the same buffer), and the source and destination regions overlap."
#define GD_STR_ProcessEventsViewOCLErrorCL_IMAGE_FORMAT_MISMATCHDescription L"The specified source and destination images are not of matching image formats."
#define GD_STR_ProcessEventsViewOCLErrorCL_IMAGE_FORMAT_NOT_SUPPORTEDDescription L"The specified image format is not supported."
#define GD_STR_ProcessEventsViewOCLErrorCL_BUILD_PROGRAM_FAILUREDescription L"Failed to build the program executable."
#define GD_STR_ProcessEventsViewOCLErrorCL_MAP_FAILUREDescription L"Failed to map the requested region into the host address space."
#define GD_STR_ProcessEventsViewOCLErrorCL_MISALIGNED_SUB_BUFFER_OFFSETDescription L"The specified object is a sub-buffer object and it was created not aligned to CL_DEVICE_MEM_BASE_ADDR_ALIGN value for device associated with queue."
#define GD_STR_ProcessEventsViewOCLErrorCL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LISTDescription L"The execution status of any of the events in event_list is a negative integer value"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PROPERTYDescription L"Invalid property specified"
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_VALUEDescription L"A parameter is not an expected value."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_DEVICE_TYPEDescription L"Device type specified is not valid."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PLATFORMDescription L"Specified platform is not a valid platform."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_DEVICEDescription L"Device or devices specified are not valid."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_CONTEXTDescription L"Specified context is not a valid OpenCL context, or the contexts associated with certain parameters are not the same."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_QUEUE_PROPERTIESDescription L"Specified properties are valid but are not supported by the device."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_COMMAND_QUEUEDescription L"Specified command-queue is not a valid command-queue."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_HOST_PTRDescription L"host_ptr is NULL and CL_MEM_USE_HOST_PTR or CL_MEM_COPY_HOST_PTR are set in flags or host_ptr is not NULL but CL_MEM_COPY_HOST_PTR or CL_MEM_USE_HOST_PTR are not set in flags."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_MEM_OBJECTDescription L"A parameter is not a valid memory, image, or buffer object."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_IMAGE_FORMAT_DESCRIPTORDescription L"Image format specified is not valid or is NULL, or the OpenGL renderbuffer internal format does not map to a supported OpenCL image format."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_IMAGE_SIZEDescription L"Specified image width, height or depth are 0 or they exceed values specified in CL_DEVICE_IMAGE2D_MAX_WIDTH / CL_DEVICE_IMAGE3D_MAX_WIDTH / CL_DEVICE_IMAGE2D_MAX_HEIGHT / CL_DEVICE_IMAGE3D_MAX_HEIGHT / CL_DEVICE_IMAGE3D_MAX_DEPTH respectively for all devices in context, or if the specified image row pitch does not follow rules described for clCreateImage2D or clCreateImage3D."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_SAMPLERDescription L"Specified sampler is not a valid sampler object."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_BINARYDescription L"The program binary is not a valid binary for the specified device."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_BUILD_OPTIONSDescription L"Specified build options are invalid."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PROGRAMDescription L"Specified program is not a valid program object."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PROGRAM_EXECUTABLEDescription L"No successfully built executable for program."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNEL_NAMEDescription L"The specified kernel name is not found in program."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNEL_DEFINITIONDescription L"The function definition for __kernel function given by kernel_name (such as the number of arguments, the argument types) is not the same for all devices for which the program executable has been built."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNELDescription L"Specified kernel is not a valid kernel object."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_ARG_INDEXDescription L"Invalid argument index is specified."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_ARG_VALUEDescription L"Argument value specified is NULL for an argument that is not declared with the __local qualifier or vice-versa."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_ARG_SIZEDescription L"Argument size specified (arg_size) does not match the size of the data type for an argument that is not a memory object<br>the argument is a memory object and arg_size != sizeof(cl_mem)<br>arg_size is zero and the argument is declared with the __local qualifier<br>or the argument is a sampler and arg_size != sizeof(cl_sampler)."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_KERNEL_ARGSDescription L"Kernel argument values have not been specified."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_WORK_DIMENSIONDescription L"work_dim is not a valid value."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_WORK_GROUP_SIZEDescription L"local_work_size is specified and the number of work-items specified by global_work_size is not evenly divisible by the work-group size given by local_work_size or does not match the work-group size specified for kernel using the __attribute__((reqd_work_group_size(X, Y, Z))) qualifier in program source."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_WORK_ITEM_SIZEDescription L"Number of work-items specified in any of local_work_size... [0]... local_work_size[work_dim - 1] is greater than the corresponding values specified by CL_DEVICE_MAX_WORK_ITEM_SIZES[0],... CL_DEVICE_MAX_WORK_ITEM_SIZES[work_dim -1]."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_GLOBAL_OFFSETDescription L"global_work_offset is not NULL."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_EVENT_WAIT_LISTDescription L"event_wait_list is NULL and num_events_in_wait_list > 0<br>event_wait_list is not NULL and num_events_in_wait_list is 0; or some of the specified event objects are not valid events."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_EVENTDescription L"Event objects specified are not valid."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_OPERATIONDescription L"Returned by clCreateImage2D, clCreateImage3D, and clCreateSampler if there are no devices in the context that support images.<br>Returned by clBuildProgram if the build of a program executable for any of the devices specified by a previous call to clBuildProgram for program has not completed, or if there are kernel objects attached to program.<br>Returned by clEnqueueNativeKernel if the specified device cannot execute the native kernel.<br>Returned by clCreateFromGLTexture2D if the miplevel is less than 0.<br>Returned by clCreateFromGLTexture3D if 3D images are not supported by the OpenCL embedded profile."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_GL_OBJECTDescription L"Returned by clCreateFromGLBuffer if bufobj is not a GL buffer object or is a GL buffer object but does not have an existing data store.<br>Returned by clCreateFromGLRenderbuffer if renderbuffer is not a GL renderbuffer object or if the width or height of renderbuffer is zero.<br>Returned by clCreateFromGLTexture2D and clCreateFromGLTexture3D if texture is not a GL texture object whose type matches texture_target, if the specified miplevel of texture is not defined, or if the width, height or depth of the specified miplevel is zero.<br>Returned by clGetGLObjectInfo and clGetGLTextureInfo if there is no GL object or texture associated with memobj.<br>Returned by clEnqueueAcquireGLObjects and clEnqueueReleaseGLObjects if memory objects in mem_objects have not been created from a GL object(s). The exact condition that generates this error depends on the calling function. "
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_BUFFER_SIZEDescription L"The value of the parameter size is 0 or is greater than CL_DEVICE_MAX_MEM_ALLOC_SIZE for all devices specified in the parameter context."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_MIP_LEVELDescription L"Specified mip level is invalid."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_GLOBAL_WORK_SIZEDescription L"global_work_size is NULL or any of the values specified in global_work_size[0], ... global_work_size[work_dim - 1] are 0 or exceed the range given by the sizeof(size_t) for the device on which the kernel execution will be enqueued."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_PIPE_SIZEDescription L"The specified pipe size is invalid."
#define GD_STR_ProcessEventsViewOCLErrorCL_INVALID_DEVICE_QUEUEDescription L"The specified argument is not a valid device queue (it is either a host queue or not a queue at all)."

// "OpenGL State Variables View"
#define GD_STR_StateVariablesViewVarName "OpenGL State Variable Name"
#define GD_STR_StateVariablesViewDoubleClickToAdd "Double-click to add a state variable..."
#define GD_STR_StateVariablesAddVariable "Add State Variable..."
#define GD_STR_StateVariablesAddBtn L"Add"
#define GD_STR_StateVariablesNoValue L"Not available"
#define GD_STR_StateVariablesNoValueA "Not available"
#define GD_STR_StateVariablesNoValueBeginEnd L"Not available while in glBegin-glEnd block"
#define GD_STR_StateVariablesNoValueInCLContext L"Not available in OpenCL context"
#define GD_STR_StateVariablesUnknownVar L"Unknown Variable"
#define GD_STR_StateVariablesPropertiesTitle L"OpenGL State Variable"
#define GD_STR_StateVariablesPropertiesStateVarItem L"state variable item"
#define GD_STR_StateVariablesPropertiesAddVariable L"Add state variable to the watch variables view"

// Calls Stack view
#define GD_STR_CallsStackPropertiesCallStack L"call stack item"
#define GD_STR_CallsStackPropertiesTitle L"Call Stack"
#define GD_STR_CallsStackPropertiesLineNumber L"Line Number"
#define GD_STR_CallsStackPropertiesFunctionStartAddress L"Function address"
#define GD_STR_CallsStackPropertiesModuleName L"Module Name"
#define GD_STR_CallsStackPropertiesInstructionCounterAddress L"Instruction Counter Address"
#define GD_STR_CallsStackCannotOpenSourceCodeError L"The related source code could not be opened by CodeXL.\nThis may be caused by a lack of or invalid debugging information."
#define GD_STR_CallsSelectThreadMessage "Select a Thread to view its Call Stack"
#define GD_STR_CallsStackWavefrontCallStackError "Cannot display wavefront call stack"
#define GD_STR_CallsStackWavefrontInactive "Select an active wavefront to view its call stack"

// Debug Toolbar
#define GD_STR_DebugToolbarTooltipStartDebugging L"Go - Start debugging / Resume debugged process run (" GD_STR_keyboardShortcutRunString GD_STR_RightParenthesis
#define GD_STR_DebugToolbarTooltipStep L"Single Step - Advance the debugged process to the next OpenGL function call (" GD_STR_keyboardShortcutStepString GD_STR_RightParenthesis
#define GD_STR_DebugToolbarTooltipDrawStep L"Draw Step - Advance the debugged process to the next OpenGL draw command (" GD_STR_keyboardShortcutDrawStepString GD_STR_RightParenthesis
#define GD_STR_DebugToolbarTooltipFrameStep L"Frame Step - Advance the debugged process to the next frame terminator (" GD_STR_keyboardShortcutFrameStepString GD_STR_RightParenthesis
#define GD_STR_DebugToolbarTooltipBreak L"Break - Break the debugged process execution at the next OpenGL call (" GD_STR_keyboardShortcutBreakString GD_STR_RightParenthesis
#define GD_STR_DebugToolbarTooltipStopDebugging L"Stop debugging - Stop debugging and terminate the debugged process execution (" GD_STR_keyboardShortcutStopString GD_STR_RightParenthesis

// Threads and Contexts Toolbar
#define GD_STR_ThreadsAndContextsToolbarTooltipChooseContextCombo L"Choose the context to be displayed. Related information will be shown in the CodeXL views"
#define GD_STR_ThreadsAndContextsToolbarTooltipChooseThreadCombo L"Choose the thread to be displayed. The related information will be shown in the CodeXL views"
#define GD_STR_ThreadsAndContextsComboboxContextInfoToolTip L"Render Context Information - Display pixel format, and other information about the currently selected render context"

// Render Contexts Combobox
#define GD_STR_RenderContextsComboboxGPUAffinity L"GPU %d,"

// Calls History Toolbar
#define GD_STR_CallsHistoryToolbarTooltipStartRecording "Record - Start / Stop Calls History HTML log file recording"
#define GD_STR_CallsHistoryToolbarTooltipOpenRecordedFile "Open the current context monitored function calls HTML log file"
#define GD_STR_CallsHistoryToolbarRecordingWarningTitle L"Recording Warning"
#define GD_STR_CallsHistoryToolbarRecordingWarningMessage L"Recording the OpenGL function calls to a file will affect the performance of CodeXL.<br><br>Please use this feature only when required."
#define GD_STR_CallsHistoryToolbarLogFilesDirectoryTitle L"Log files directory:"
#define GD_STR_CallsHistoryToolbarOpeningRecordedFileTitle L"Opening Recorded File"
#define GD_STR_CallsHistoryToolbarOpeningRecordedFileMessage L"Opening the recorded OpenGL Function Calls Log file may take some time depending on the file size."
#define GD_STR_CallsHistoryToolbarLogFilePath L"Log File Path"
#define GD_STR_CallsHistoryToolbarOpenLogFileInfo "A log file is created only after clicking the record button and running the debugger."
#define GD_STR_CallsHistoryToolbarTooltipNextMarker "Next: Scroll the Calls History View to the next string marker function call (glStringMarkerGREMEDY)"
#define GD_STR_CallsHistoryToolbarTooltipPreviousMarker "Previous: Scroll the Calls History View to the previous string marker function call (glStringMarkerGREMEDY)"
#define GD_STR_CallsHistoryCannotFindStringMarker "Cannot find a string marker."

// Interactive mode toolbar
#define GD_STR_InteractiveModeToolbarComboBreakInteractive L"Interactive break"
#define GD_STR_InteractiveModeToolbarComboNormal L"Normal mode"
#define GD_STR_InteractiveModeToolbarComboFront L"Front buffer"
#define GD_STR_InteractiveModeToolbarComboFrontInteractive L"Front interactive"
#define GD_STR_InteractiveModeToolbarTooltipInteractiveModeComboBox L"View your objects as they are being rendered by forcing OpenGL to draw into the front color buffer"
#define GD_STR_InteractiveModeToolbarTooltipSlowMotionCheckBox L"Enable the Slow Motion mode"
#define GD_STR_InteractiveModeToolbarTooltipSlowMotionSpinCtrl L"Set the slow motion delay time. The delay will occur after every OpenGL function call"

// Raster Mode Toolbar
#define GD_STR_RasterModeToolbarTooltipPoints L"Points - Force Points Polygon Raster mode (GL_POINT)"
#define GD_STR_RasterModeToolbarTooltipWireframe L"Wireframe - Force Wire Polygon Raster mode (GL_LINE)"
#define GD_STR_RasterModeToolbarTooltipFill L"Fill - Force fill Polygon Raster mode (GL_FILL)"

// Viewers Toolbar
#define GD_STR_ViewersToolbarTooltipSourceCode L"Show / Hide the Source Code Viewer"
#define GD_STR_ViewersToolbarTooltipStateVariablesCompare L"Show / Hide the State Variables Comparison Viewer (" GD_STR_keyboardShortcutVariablesString GD_STR_RightParenthesis
#define GD_STR_ViewersToolbarTooltipShadersSourceCode L"Show / Hide the Shaders and Kernels' Source Code Editor"
#define GD_STR_ViewersToolbarTooltipTextures L"Show / Hide the Textures, Buffers and Images Viewer (" GD_STR_keyboardShortcutTexturesString GD_STR_RightParenthesis
#define GD_STR_ViewersToolbarTooltipStatistics L"Show / Hide the Statistics Viewer (" GD_STR_keyboardShortcutStatisticsString GD_STR_RightParenthesis
#define GD_STR_ViewersToolbarTooltipMemoryAnalysis L"Show / Hide the Graphic and Compute Memory Analysis Viewer (" GD_STR_keyboardShortcutMemoryString GD_STR_RightParenthesis
#define GD_STR_ViewersToolbarTooltipCommandQueues L"Show / Hide the OpenCL Command Queues Viewer"

// Performance Toolbar
#define GD_STR_PerformanceToolbarTooltipSaveProfilingData L"Export the collected profiling data from the Performance Graph view to a file (.csv)"
#define GD_STR_PerformanceToolbarTooltipNullDriver L"Eliminate all draw commands - identify CPU / BUS performance bottlenecks (by ignoring all OpenGL draw commands)"
#define GD_STR_PerformanceToolbarTooltipNullTextures L"Eliminate all textures data fetch operations - identify textures memory performance bottlenecks (by forcing a 2x2 stub textures)"
#define GD_STR_PerformanceToolbarTooltipNullPortView L"Eliminate all raster operations - identify raster operations bottlenecks (by forcing a 1x1 pixels view port)"
#define GD_STR_PerformanceToolbarTooltipNullLights L"Eliminate all fixed pipeline light operations - identify pipeline light-related calculations bottlenecks (by turning off all OpenGL lights)"
#define GD_STR_PerformanceToolbarTooltipNullGeometryShaders L"Eliminate OpenGL geometry and fragment shaders operations - identify geometry shaders related bottlenecks (by disabling geometry shaders and forcing a simple stub fragment shader)"
#define GD_STR_PerformanceToolbarTooltipNullFragmentShaders L"Eliminate OpenGL fragment shaders operations - identify fragment shaders related bottlenecks (by forcing a simple stub fragment shader)"
#define GD_STR_PerformanceToolbarErrorStubOff L"Error: Failed to turn off the \"Force %ls\" mode"
#define GD_STR_PerformanceToolbarErrorStubOn L"Error: Failed to turn on the \"Force %ls\" mode"

// OpenCL Performance Toolbar
#define GD_STR_OpenCLPerformanceToolbarErrorExecutionOff L"Error: Failed to turn off the \"%ls\" mode"
#define GD_STR_OpenCLPerformanceToolbarErrorExecutionOn L"Error: Failed to turn on the \"%ls\" mode"
#define GD_STR_OpenCLPerformanceKernel L"Eliminate kernel execution operations - identify kernel-related bottlenecks (by forcing a trivial stub kernel)"
#define GD_STR_OpenCLPerformanceRead L"Eliminate read operations - identify read-related bottlenecks (by forcing all read operations to 1 byte / pixel)"
#define GD_STR_OpenCLPerformanceWrite L"Eliminate write operations - identify write-related bottlenecks (by forcing all write operations to 1 byte / pixel)"
#define GD_STR_OpenCLPerformanceCopy L"Eliminate copy operations - identify copy-related bottlenecks (by forcing all copy operations to 1 byte / pixel)"

// Execution Mode Toolbar
#define GD_STR_ExecutionModeToolbarTooltipDebug L"Debug Mode - Enables most of CodeXL's debugging features"
#define GD_STR_ExecutionModeToolbarTooltipAnalyze L"Analyze Mode - Enables in-depth analysis of the OpenGL usage: track redundant state changes, detailed deprecation information and usage statistics"
#define GD_STR_ExecutionModeToolbarTooltipProfiling L"Profile Mode - Disables some of CodeXL's debugging abilities to improve performance"

#define GD_STR_ExecutionModeToolbarPropertiesViewTitleDebug L"Debug Mode"
#define GD_STR_ExecutionModeToolbarPropertiesViewTitleAnalyze L"Analyze Mode - Performance Warning"
#define GD_STR_ExecutionModeToolbarPropertiesViewTitleProfile L"Profile Mode"

// Execution mode properties:
#define GD_STR_PropertiesDebugText L"Working in Debug Mode enables most of CodeXL's debugging features."
#define GD_STR_PropertiesDebugSummary L"Do not use this mode for performance analysis."
#define GD_STR_PropertiesAnalyzeWarning L"Using this mode will dramatically reduce performance."
#define GD_STR_PropertiesAnalyzeTextLine1 L"Working in Analyze Mode enables in-depth analysis of the OpenGL usage: "
#define GD_STR_PropertiesAnalyzeTextLine2 L"track redundant state changes, detailed deprecation information and usage statistics."
#define GD_STR_PropertiesAnalyzeSummary L"Use this feature only when required."
#define GD_STR_PropertiesProfilingText L"Working in Profile Mode enables performance analysis of the debugged application.<br>This mode disables some of CodeXL's debugging abilities to improve performance."
#define GD_STR_PropertiesProfilingSummary L"Use this mode for performance analysis."

// General Error messages
#define GD_STR_ErrorMessageLoadBreakpoints "Could not add the selected breakpoints."
#define GD_STR_ErrorMessageFailedTerminateDebugProcess "Failed to terminate the debugged process."
#define GD_STR_ErrorMessageFailedLaunchDebugProcess L"Failed to launch process."
#define GD_STR_ErrorMessageLoadBreakpointsFailed "Could not load the breakpoints."
#define GD_STR_ErrorMessageSaveStateVariablesFailed "Could not save the OpenGL state variables."
#define GD_STR_ErrorMessageSaveFunctionCallsStatisticsFailed L"Could not export the Function Calls Statistics to a file."
#define GD_STR_ErrorMessageSaveProfilingDataFailed "Could not save the profiling data."
#define GD_STR_ErrorMessageSaveFileFailed "An error occurred while saving the file to disk."
#define GD_STR_ErrorMessageNoLogDirectory L"The log files and images directory does not exist."
#define GD_STR_ErrorMessageNoFrameTerminators L"At least one OpenGL frame terminator must be selected."
#define GD_STR_ErrorMessageBadRemoteTargetConnectionParameters L"The Remote connection parameters are invalid.\nPlease choose an IP address and two different port numbers to be used by this computer."
#define GD_STR_ErrorMessageSpinCtrlNumericValue L"Must be a numeric value between %d and %d."
#if AMDT_BUILD_TARGET == AMDT_WINDOWS_OS
    #define GD_STR_ErrorMessageWarningInterceptionFailureOSSpecificDetails "\nThis may also happen when debugging CLR / .NET applications.\nIf the debugged application is a .NET application, try the following workaround steps:\n\t1. Navigate to CodeXL's install directory.\n\t2. If the application uses OpenGL/OpenCL through the 32-bit API, Open the \"spies\" subdirectory. If it uses the 64-bit API, open the \"spies64\" subdirectory.\n\t3. Copy the files \"OpenCL.dll\" and \"opengl32.dll\" to the application (*.exe) folder.\n\t4. Debugging should now work.\n\t5. When work with the debugger is done, remove the copied files from the directory, as they will interfere with the normal run of the application (outside CodeXL)."
#elif AMDT_BUILD_TARGET == AMDT_LINUX_OS
    #define GD_STR_ErrorMessageWarningInterceptionFailureOSSpecificDetails "\nThis may also happen if the environment variables LD_LIBRARY_PATH or LD_PRELOAD are defined for the application or modified during the application's run time.\nMake sure that the OpenCL and OpenGL drivers are not present in the beginning of the dynamic loader path, or are loaded only without a specific path (e.g. dlopen(\"libOpenCL.so\").\nAlternatively, if the application is built with the deprecated dynamic tag DT_RPATH, add the \"--enable-new-dtags\" linker flag to replace it with the newer DT_RUNPATH."
#else
    #error Unknown build target!
#endif
#define GD_STR_ErrorMessageWarningInterceptionFailure "An API module was loaded before the appropriate CodeXL server module.\nThis usually indicates that CodeXL's interception mechanism has failed and will usually result in failure to attach to the debugged process.\nThis usually happens when the OpenCL and OpenGL modules are loaded with a full path rather than just the file name." GD_STR_ErrorMessageWarningInterceptionFailureOSSpecificDetails
#define GD_STR_ErrorMessageFailedToLoadTheSpy "CodeXL failed to attach to the debugged process.\n\nPlease try the following as a workaround for this issue:\na. Go to CodeXL's installation directory.\nb. Enter into the \"spies\" subdirectory.\nc. Copy the OpenGL32.dll to the directory of the application (.exe file) that you are debugging.\n\n*** Don\'t forget to delete the copied OpenGL32.dll after you finish working with CodeXL!\n\nWe are working on a permanent solution for this problem. This will be available in one of our next versions."
#define GD_STR_ErrorMessageFailedToLoadTheESSpy "The debugged process loaded an OpenGL ES implementation that is not supported by CodeXL ES (%1).\n\nPlease delete or rename %2 and try launching the debugged process again."
#define GD_STR_ErrorMessageWarningOpenGLServerInOpenCLOnlyProject "The debugged process loaded an OpenGL implementation, but the project type is set to OpenCL only.\nPlease stop the debugged process, change the project type to OpenGL + OpenCL in the Debug Settings dialog,\n(" GD_STR_keyboardShortcutDebugStringA ") and launch it again."
#define GD_STR_ErrorMessageWarningOpenCLServerInOpenGLOnlyProject "The debugged process loaded an OpenCL implementation, but the project type is set to OpenGL only.\nPlease stop the debugged process, change the project type to OpenGL + OpenCL in the Debug Settings dialog,\n(" GD_STR_keyboardShortcutDebugStringA ") and launch it again."
#define GD_STR_ErrorMessageLoadPerformanceGraphCounters L"Could not add the selected counters."
#define GD_STR_ErrorMessageLoadTheWrongSpyOpenGL32 "The debugged application is trying to load the OpenGL implementation for an OpenGL ES project.\nPlease change the project type to an OpenGL project in the Debug Settings dialog."
#define GD_STR_ErrorMessageLoadTheWrongSpyOpenGL32Unicode L"The debugged application is trying to load the OpenGL implementation for an OpenGL ES project.\nPlease change the project type to an OpenGL project in the Debug Settings dialog."
#define GD_STR_ErrorMessageLoadTheWrongSpyOpenGLESCommon "The debugged application is trying to load the OpenGL ES implementation for an OpenGL project.\nPlease change the project type to an OpenGL ES project in the Debug Settings dialog."
#define GD_STR_ErrorMessageLoadTheWrongSpyOpenGLESCommonUnicode L"The debugged application is trying to load the OpenGL ES implementation for an OpenGL project.\nPlease change the project type to an OpenGL ES project in the Debug Settings dialog."
#define GD_STR_ClientHeartbeatFailureTitle L"Error: License server communication lost"
#define GD_STR_ClientHeartbeatContent1 L"Error: The communication with the license server was lost\nPlease check network status and License Server availability"
#define GD_STR_ClientHeartbeatContent2 L"Error: The communication with the license server was lost\nThe CodeXL application will now exit!"
#define GD_STR_ErrorMessageOpenGLESLinuxSupport L"CodeXL Linux does not yet support OpenGL ES.\nPlease email CodeXL support team if you currently need this functionality."
#define GD_STR_ErrorGDBIsNotInstalledMsgHeader "Error: Cannot find gdb"
#define GD_STR_ErrorGDBIsNotInstalled "Failed to launch gdb. Please verify that gdb is installed correctly on the local machine."
#define GD_STR_GDBMacInstallPackage L"(gdb is part of Apple's Xcode installation package)"
#define GD_STR_ErrorMacOSXArchitectureError "The debugged application is built under an architecture not compatible with CodeXL.\nCodeXL currently supports only Intel-based 32-bit applications."
#define GD_STR_ErrorAutomaticConfigurationFailed "The project automatic configuration failed. If this problem persists, please disable the \"Automatic Configuration\" checkbox in the Debug Settings dialog and configure manually."
#define GD_STR_ErrorCouldNotCreateProcess L"Could not create the debugged process."
#define GD_STR_ErrorCouldNotCreateProcessGenericReason L"Unexpected failure"

// General Warning messages:
#define GD_STR_KernelDebuggingInterruptedTitle "Kernel debugging was interrupted"
#define GD_STR_QuestionKernelDebuggingInterrupted "A breakpoint was hit before kernel execution has begun.\nDo you want to skip breakpoints and step into the kernel?"
#define GD_STR_resumingDebuggedApplication "Resuming debugged application"
#define GD_STR_WarningProgramBuildErrorWithDebugFlagsNoIndices L"Could not build OpenCL program for debugging.\nOpenCL kernel debugging will be disabled for this program.\nError Code: "
#define GD_STR_WarningProgramBuildErrorWithDebugFlags L"Could not build OpenCL program %d (Context %d) for debugging.\nOpenCL kernel debugging will be disabled for this program.\nError Code: "

// "Viewers"
#define GD_STR_TexturesViewerTitle L"Textures, Buffers and Images viewer"
#define GD_STR_TexturesViewerBusyInfo L"Loading images, please wait..."
#define GD_STR_ShadersSourceCodeViewerTitle L"Shaders and Kernels Source Code editor"
#define GD_STR_SourceCodeViewrTitle L"Source Code viewer - "

// HTML properties window:
#define GD_STR_PropertiesContextHeadline L"Context %d"
#define GD_STR_PropertiesContextDeleted L"Deleted"
#define GD_STR_PropertiesContextName L"Context Name"
#define GD_STR_PropertiesQueueName L"Queue Name"
#define GD_STR_PropertiesDebuggedApplicationFullPath L"Full Path"
#define GD_STR_PropertiesDebuggedApplicationCommandLineArgs L"Command Line Arguments"
#define GD_STR_PropertiesDebuggedApplicationEnvVars L"Environment Variables"
#define GD_STR_PropertiesRenderContextMessage L"Select a subcategory to view its details"
#define GD_STR_PropertiesRenderContextShareLists L"ShareLists"
#define GD_STR_PropertiesStaticBuffersListHeadline L"Context %d Static Buffers"
#define GD_STR_PropertiesRenderBuffersListHeadline L"Context %d Render Buffers"
#define GD_STR_PropertiesPipelinesListHeadline L"Context %d Program Pipelines"
#define GD_STR_PropertiesOpenGlSamplersListHeadline L"Context %d OpenGL Samplers"
#define GD_STR_PropertiesTexturesListHeadline L"Context %d Textures"
#define GD_STR_PropertiesImagesListHeadline L"Context %d Images"
#define GD_STR_PropertiesFBOsListHeadline L"Context %d Frame Buffers"
#define GD_STR_PropertiesVBOsListHeadline L"Context %d OpenGL Buffer Objects"
#define GD_STR_PropertiesCLBuffersListHeadline L"Context %d CL Buffers"
#define GD_STR_PropertiesCLPipesListHeadline L"Context %d CL Pipes"
#define GD_STR_PropertiesCLCommandQueuesListHeadline L"Context %d Command Queses"
#define GD_STR_PropertiesCLProgramsHeadline L"Context %d Computation Programs"
#define GD_STR_PropertiesCLSamplersHeadline L"Context %d Samplers"
#define GD_STR_PropertiesCLEventsHeadline L"Context %d Events"
#define GD_STR_PropertiesSyncsListHeadline L"Application Sync Objects"
#define GD_STR_PropertiesTexBuffersListHeadline L"Context %d Texture Buffers"
#define GD_STR_PropertiesDisplayListsListHeadline L"Context %d Display Lists"
#define GD_STR_PropertiesGLProgramsListHeadline L"Context %d Shading Programs"
#define GD_STR_PropertiesShadersListHeadline L"Context %d Shaders"
#define GD_STR_PropertiesPBuffersListHeadline L"Pixel Buffers"
#define GD_STR_PropertiesSelectItemMessage L"Select an item to display its details"
#define GD_STR_PropertiesMultipleItemsMessage L"Multiple items are selected" AF_STR_HtmlNewLine L"Select a single %ls to view its properties"
#define GD_STR_PropertiesMemorySizeProgramsExplanation L"Shading Programs have a very small memory overhead for maintaining uniform values and link logs. As a result, their memory consumption is usually very low, making it insignificant."
#define GD_STR_PropertiesMemorySizeFBOExplanation L"Framebuffer objects are virtual containers that allow attaching certain buffers and textures as logical OpenGL buffers. As a result, their memory consumption is very low, making it insignificant."
#define GD_STR_PropertiesMemorySizePBuffersExplanation L"Pixel buffers are hidden draw surfaces which are maintained by the OpenGL implementation. However, all their pixel information is displayed in CodeXL under the OpenGL render context which is made current to them. The remaining memory consumption is usually very low, making it insignificant."
#define GD_STR_PropertiesMemorySizeSyncObjectsExplanation L"OpenGL sync objects are logical objects that are used to synchronize OpenGL operations. They carry no data beyond their condition, and therefore their memory consumption is very low, making it insignificant."
#define GD_STR_PropertiesMemorySizeDisplayListsExplanation L"Display lists' sizes depend on the number and kinds of functions called in them as well as the OpenGL implementation. Display list memory size estimation is currently not supported by CodeXL."
#define GD_STR_PropertiesMemorySizeNAExplanation L"However, it is still possible to use the Memory Viewer for viewing memory leaks and object creation call stacks."
#define GD_STR_PropertiesProgramIsLinked L"Is Successfully Linked"
#define GD_STR_PropertiesProgramBuildStatus L"Build Status"
#define GD_STR_PropertiesProgramBinaryType L"Binary Type"
#define GD_STR_PropertiesShaderIsCompiled L"Is Successfully Compiled"
#define GD_STR_PropertiesShaderFilePath L"Shader File Path"
#define GD_STR_PropertiesProgramFilePath L"Program File Path"
#define GD_STR_PropertiesProgramBuildLog L"Program Build Log"
#define GD_STR_PropertiesProgramBuildOptions L"Program Build Options"
#define GD_STR_PropertiesShaderCompileLog L"Shader Compilation Log"
#define GD_STR_PropertiesProgramIsMarkedForDeletion L"Is Marked for Deletion"
#define GD_STR_PropertiesProgramWasUsedInLastFrame L"Used in Last Frame"
#define GD_STR_PropertiesProgramLinkLog L"Program Link Log"
#define GD_STR_PropertiesProgramRelatedProgramsHeader L"Related Programs"
#define GD_STR_PropertiesProgramKernelHeader L"Program Kernels"
#define GD_STR_PropertiesProgramKernelNamesHeader L"Program Kernel Names"
#define GD_STR_PropertiesProgramDevicesHeader L"Program Devices"
#define GD_STR_PropertiesBufferNameTitle L"Buffer Name"
#define GD_STR_PropertiesSubBufferRegionFormat L"Origin: %ls Size:%ls"
#define GD_STR_PropertiesSubBufferRegion L"Sub-buffer Region"
#define GD_STR_PropertiesSubBufferCreateType L"Sub-buffer Create Type"
#define GD_STR_PropertiesSubBufferName L"Sub-buffer Name"
#define GD_STR_PropertiesSubBufferUnsupportedCreateType L"Unsupported sub-buffer creation type"
#define GD_STR_PropertiesPipePacketSize L"Packet Size"
#define GD_STR_PropertiesPipeMaxPackets L"Max Packets"
#define GD_STR_PropertiesVBOCLPosfix L" (CL%d Buffer %d)"
#define GD_STR_PropertiesCLBufferGLPosfix L" (GL%d Buffer %d)"
#define GD_STR_PropertiesCLBufferFullName L"CL Context %d Buffer %d"
#define GD_STR_PropertiesGLVBOFullName L"GL Context %d Buffer %d"
#define GD_STR_PropertiesBufferTypeTitle L"Buffer Type"
#define GD_STR_PropertiesTextureTypeTitle L"Texture Type"
#define GD_STR_PropertiesImageTypeTitle L"Image Type"
#define GD_STR_PropertiesPipeNameTitle L"Pipe Name"
#define GD_STR_PropertiesShaderTypeTitle L"Shader Type"
#define GD_STR_PropertiesDisplayListTitle L"Display List"
#define GD_STR_PropertiesAmountTitle L"Amount"
#define GD_STR_PropertiesFlagsTitle L"Flags"
#define GD_STR_PropertiesDestructorPfnNotifyTitle L"Destructor pfn_notify"
#define GD_STR_PropertiesDestructorUserDataTitle L"Destructor user_data"
#define GD_STR_PropertiesStaticBuffers L"Static Buffers"
#define GD_STR_PropertiesSyncObjects L"Sync Objects"
#define GD_STR_PropertiesPBuffers L"PBuffers"
#define GD_STR_PropertiesVBOs L"OpenGL Buffer Objects"
#define GD_STR_PropertiesCLBuffers L"OpenCL Buffers"
#define GD_STR_PropertiesRenderBuffers L"Render Buffers"
#define GD_STR_PropertiesFBOs L"Frame Buffer Objects"
#define GD_STR_PropertiesDisplayLists L"Display Lists"
#define GD_STR_PropertiesBufferSize L"Buffer memory size"
#define GD_STR_PropertiesBufferAttachmentTitle L"Last Buffer Attachment"
#define GD_STR_PropertiesBufferCurrentAttachmentsTitle L"Current Buffer attachments"
#define GD_STR_PropertiesPixelSuffix L" px"
#define GD_STR_PropertiesDimensions L"Dimensions"
#define GD_STR_Properties1DDimensions L"%d"
#define GD_STR_Properties2DDimensions L"%dx%d"
#define GD_STR_Properties3DDimensions L"%dx%dx%d"
#define GD_STR_PropertiesTextureMiplevels L"# of Mipmaps"
#define GD_STR_PropertiesTextureCropRectangle L"(%.1f, %.1f, %.1f, %.1f)"
#define GD_STR_PropertiesGeneral L"General"
#define GD_STR_PropertiesWidth L"Width: "
#define GD_STR_PropertiesHeight L"Height: "
#define GD_STR_PropertiesDepth L"Depth: "
#define GD_STR_PropertiesCompressRate L"Compression Rate: "
#define GD_STR_PropertiesTextureCompressRateTitle L"Texture Compression"
#define GD_STR_PropertiesEstimatedMemorySize L"Uncompressed Estimated Memory Size: "
#define GD_STR_PropertiesCompressRateString L"1:%.1f "
#define GD_STR_PropertiesBorderWidth L"Border Width"
#define GD_STR_PropertiesPixelFormatTitle L"Pixel Format"
#define GD_STR_PropertiesPixelFormatFormat L"Format"
#define GD_STR_PropertiesInternalPixelFormat L"Internal Pixel Format"
#define GD_STR_PropertiesImageFormat L"Image Format"
#define GD_STR_PropertiesDataType L"Data Type"
#define GD_STR_PropertiesPixelFormat L"Pixel Format"
#define GD_STR_PropertiesPixelUsedInternalFormatFormat L"Used"
#define GD_STR_PropertiesPixelRequestedInternalFormat L"Requested"
#define GD_STR_PropertiesRenderBufferUnAttached L"Not Attached"
#define GD_STR_PropertiesRenderBufferAttachment L"%ls (FBO %u, %ls)"
#define GD_STR_PropertiesFBOName L"FBO name"
#define GD_STR_PropertiesRenderBufferHeadline L"Render Buffer %d"
#define GD_STR_PropertiesPiplineHeadline L"Program Pipeline %d"
#define GD_STR_PropertiesOpenGlSamplerHeadline L"OpenGL Sampler %d"
#define GD_STR_PropertiesFBOAttachedObjects L"FBO Attached Objects"
#define GD_STR_PropertiesSyncHandle L"Sync OpenGL handle"
#define GD_STR_PropertiesReason L"Reason"
#define GD_STR_PropertiesBreakOn L"Break on"
#define GD_STR_PropertiesBreakpointAPITitle L"API Function Breakpoint"
#define GD_STR_PropertiesBreakpointAPIFunctionName L"API Function Name"
#define GD_STR_PropertiesBreakpointSourceCodeTitle L"Source Code Breakpoint"
#define GD_STR_PropertiesBreakpointSourceCodeLineNumber L"Source Code Line Number"
#define GD_STR_PropertiesBreakpointSourceCodeFilePath L"Source Code File Path"
#define GD_STR_PropertiesBreakpointKernelFunctionTitle L"Kernel Function Breakpoint"
#define GD_STR_PropertiesBreakpointKernelFunctionName L"Kernel Function Name"
#define GD_STR_PropertiesBreakpointGenericTitle L"Error / Warning Breakpoint"
#define GD_STR_PropertiesBreakpointGenericName L"Error / Warning Breakpoint Reason"
#define GD_STR_PropertiesBreakpointIsEnabled L"Is Enabled"
#define GD_STR_PropertiesWatchTitle L"Watch Expresion"
#define GD_STR_PropertiesLocalsTitle L"Local Variable"
#define GD_STR_PropertiesWatchName L"Name"
#define GD_STR_PropertiesWatchValue L"Value"
#define GD_STR_PropertiesWatchType L"Type"
#define GD_STR_PropertiesWatchMultipleTitle L"Watch Expressions"
#define GD_STR_PropertiesWatchMultipleText L"Select a single watch expression to view its properties"
#define GD_STR_PropertiesBreakpointsMultipleTitle L"Breakpoints"
#define GD_STR_PropertiesBreakpointsMultipleText L"Select a single breakpoint to view its properties"
#define GD_STR_PropertiesOccurredIn L"Occurred in"
#define GD_STR_PropertiesGLFunctionTitle L"OpenGL Function Call"
#define GD_STR_PropertiesCLFunctionTitle L"OpenCL Function Call"
#define GD_STR_PropertiesNoContextFunctionTitle L"No Context Function Call"
#define GD_STR_PropertiesFunctionCallsNotLoggedInProfilingMode L"Monitored function calls are not logged when in profile mode"
#define GD_STR_PropertiesAttachedBufferName L"Attached OpenGL Buffer name"
#define GD_STR_PropertiesTextureNameFormat L"Texture %u"
#define GD_STR_PropertiesGLTextureFullNameFormat L"GL Context %d Texture %u"
#define GD_STR_PropertiesGLRenderBufferFullNameFormat L"GL Context %d Render Buffer %u"
#define GD_STR_PropertiesGLTextureFullNameFormatWithMiplevel L"GL Context %d Texture %u Level %d"
#define GD_STR_PropertiesTextureNameFormatShort L"Texture %u"
#define GD_STR_PropertiesImageNameFormat L"Image %u"
#define GD_STR_PropertiesImageNameFullFormat L"CL Context %d Image %u"
#define GD_STR_PropertiesImageNameFormatShort L"Image %u"
#define GD_STR_PropertiesImageGLDetailsFormatWithMipLevel L" (GL%d Tex%u-Level%u)"
#define GD_STR_PropertiesImageGLDetailsFormatWithMipLevelShort L" (GL%d Tex%u-Lvl%u)"
#define GD_STR_PropertiesImageGLTexureDetailsFormat L" (GL%d Tex%u)"
#define GD_STR_PropertiesImageGLRenderBufferDetailsFormat L" (GL%d Buf%u)"
#define GD_STR_PropertiesTextureCLDetailsFormat L" (CL%d Img%u)"
#define GD_STR_PropertiesDisplayListNameFormat L"Display List %u"
#define GD_STR_PropertiesProgramNameFormat L"Program %u"
#define GD_STR_PropertiesProgramPipelineNameFormat L"Program Pipeline %u"
#define GD_STR_PropertiesGlSamplerNameFormat L"GL Sampler %u"
#define GD_STR_PropertiesSamplerNameFormat L"Sampler %u"
#define GD_STR_PropertiesShaderNameFormat L"Shader %u"
#define GD_STR_PropertiesTextureLevelNameFormat L" (level %d) "
#define GD_STR_PropertiesTextureDoesNotExist L"* Texture %u does not exist, it may have already been deleted."
#define GD_STR_PropertiesTextureSuffix L" Texture"
#define GD_STR_PropertiesImageSuffix L" Image"
#define GD_STR_PropertiesLevelsPostfix L" Level(s)"
#define GD_STR_PropertiesTextureParametersMipLevelHeading L"Level %d Parameters"
#define GD_STR_PropertiesTextureParametersHeading L"Texture Parameters"
#define GD_STR_PropertiesProgramAttachedShadersHeader L"Attached Shaders"
#define GD_STR_PropertiesProgramHandleHeader L"Program Handle"
#define GD_STR_PropertiesSamplerHandleHeader L"Sampler Handle"
#define GD_STR_PropertiesSamplerAreCoordsNormalizedHeader L"Are Coordinates Normalized"
#define GD_STR_PropertiesSamplerFilterModeHeader L"Filter Mode"
#define GD_STR_PropertiesSamplerAddressingModeHeader L"Addressing Mode"
#define GD_STR_PropertiesEventHandleHeader L"Event Handle"
#define GD_STR_PropertiesImageHandleHeader L"Image Handle"
#define GD_STR_PropertiesBufferHandleHeader L"Buffer Handle"
#define GD_STR_PropertiesPipeHandleHeader L"Pipe Handle"
#define GD_STR_PropertiesKernelHandle L"Kernel Handle"
#define GD_STR_PropertiesKernelNameFormat L"Kernel %d"
#define GD_STR_PropertiesKernelFunctionName L"Kernel Function Name"
#define GD_STR_PropertiesProgramName L"Program Name"
#define GD_STR_PropertiesKernelNumArgsHeader L"# of Arguments"
#define GD_STR_PropertiesKernelArgsInfoHeader L"Arguments Information"
#define GD_STR_PropertiesReferenceCountHeader L"Reference Count"
#define GD_STR_PropertiesContextCreationPropertiesHeader L"Context Creation Properties"
#define GD_STR_PropertiesKernelWorkgroupInfoHeader L"Work-group information"
#define GD_STR_PropertiesKernelMaxWorkgroupSizeHeader L"Max Work-group Size on Device"
#define GD_STR_PropertiesKernelRequiredWorkgroupSizeHeader L"Work-group Size Required by Compiler"
#define GD_STR_PropertiesKernelRequiredWorkgroupSizeNoValue L"Any size"
#define GD_STR_PropertiesKernelRequiredLocalMemoryHeader L"Local Memory Size on Device"
#define GD_STR_PropertiesUniformsTypeTitle L"Uniform Type"
#define GD_STR_PropertiesShaderSourceCodeLengthTitle L"Source Code Length"
#define GD_STR_PropertiesShaderSourceCodeLengthValue L"%lu characters"
#define GD_STR_PropertiesShaderName L"Shader Name"
#define GD_STR_PropertiesShaderMarkedForDeletion L"Marked for Deletion"
#define GD_STR_PropertiesDisplayListListMode L"List Mode"
#define GD_STR_PropertiesFBONumberOfBoundObjects L"Number of Bound Objects"
#define GD_STR_PropertiesViewDetailsTemplate L"View %ls details"
#define GD_STR_PropertiesTextureThumbnailHeader L"Context %d Textures"
#define GD_STR_PropertiesImageThumbnailHeader L"Context %d Images"
#define GD_STR_PropertiesBuffersThumbnailHeader L"Available Buffers"
#define GD_STR_PropertiesOpenGLesExtraParameter L"GL_TEXTURE_CROP_RECT_OES"
#define GD_STR_PropertiesPBufferHeadline L"Pixel Buffer %d"
#define GD_STR_PropertiesPBufferHandlerHead L"PBuffer Handle"
#define GD_STR_PropertiesPBufferHRCHead L"Render Context"
#define GD_STR_PropertiesPBufferHDCHead L"Device Context"
#define GD_STR_PropertiesPBufferHRC L"Context %d"
#define GD_STR_PropertiesGeneratingPreview L"Generating preview image..."
#define GD_STR_PropertiesThumbnailFileNameSuffix L"-thumb"
#define GD_STR_PropertiesProgramName L"Program Name"
#define GD_STR_PropertiesProgramBuildLogStatus L"Build Status"
#define GD_STR_PropertiesProgramBuildLogStatusNone L"None"
#define GD_STR_PropertiesProgramBuildLogStatusError L"Error"
#define GD_STR_PropertiesProgramBuildLogStatusSuccess L"Success"
#define GD_STR_PropertiesProgramBuildLogStatusInProgress L"In Progress"
#define GD_STR_PropertiesProgramBuildLogSucceeded L"Build succeeded"
#define GD_STR_PropertiesAssociatedProgramNoProgram L"No Program"
#define GD_STR_PropertiesProgramGeometryParametersTitle L"Geometry Parameters"
#define GD_STR_PropertiesGeometryParametersNA L"Geometry parameters not supported by hardware."
#define GD_STR_PropertiesThreadId L"Thread ID"
#define GD_STR_PropertiesAssociatedParams L"Associated Parameters"
#define GD_STR_PropertiesTechnologyMonitorFailure L"Technology Monitor failure"
#define GD_STR_PropertiesTechnologyMonitorFailureReason L"Failure details"
#define GD_STR_PropertiesGLDebugOutputReport L"OpenGL Debug Output Message"
#define GD_STR_PropertiesReportedFrom L"Reported From"
#define GD_STR_PropertiesMessageDetail L"Message Detail"
#define GD_STR_PropertiesMessageSource L"Message Source"
#define GD_STR_PropertiesMessageType L"Message Type"
#define GD_STR_PropertiesMessageSeverity L"Message Severity"
#define GD_STR_PropertiesMessage L"Message"
#define GD_STR_PropertiesMessageID L"Message ID"
#define GD_STR_PropertiesCommmandQueueNameTitle L"Command Queue Name"
#define GD_STR_PropertiesCLCommandQueues L"Command Queues"
#define GD_STR_PropertiesCLCommandQueueName L"Command Queue %d"
#define GD_STR_PropertiesCLQueueName L"Queue %d"
#define GD_STR_PropertiesCLQueueNameShort L"Q%d"
#define GD_STR_PropertiesCLProgramName L"OpenCL Program %d"
#define GD_STR_PropertiesCLEventName L"Event %d"
#define GD_STR_PropertiesCLEventReleasedName L"Released Event"
#define GD_STR_PropertiesCLKernelName L"Kernel %d"
#define GD_STR_PropertiesCLProgramlName L"Program %d"
#define GD_STR_PropertiesCLProgramlNameShort L"P%d"
#define GD_STR_PropertiesCLImageName L"Image %d"
#define GD_STR_PropertiesCLContextName L"Context %d"
#define GD_STR_PropertiesCLSamplerName L"Sampler %d"
#define GD_STR_PropertiesCLBufferName L"Buffer %d"
#define GD_STR_PropertiesCLPipeName L"Pipe %d"
#define GD_STR_PropertiesGLBufferCLShared L"OpenCL Shared Buffer"
#define GD_STR_PropertiesCLBufferGLShared L"OpenGL Shared Buffer Object"
#define GD_STR_PropertiesGLTextureCLShared L"OpenCL Shared Image"
#define GD_STR_PropertiesCLImageGLShared L"OpenGL Shared Texture"
#define GD_STR_PropertiesCLContextHandle L"Context Handle"
#define GD_STR_PropertiesCLDeviceID L"Device ID"
#define GD_STR_PropertiesQueueOutOfOrderExecutionMode L"Out of Order Execution Mode"
#define GD_STR_PropertiesQueueProfilingMode L"Profiling Mode"
#define GD_STR_PropertiesQueueOnDevice L"Queue on-device"
#define GD_STR_PropertiesQueueOnDeviceOnDevice L"On-device"
#define GD_STR_PropertiesQueueOnDeviceHost L"Host"
#define GD_STR_PropertiesQueueOnDeviceDefault L"Default on-device queue"
#define GD_STR_PropertiesQueueSize L"Queue on-device size"
#define GD_STR_PropertiesQueueCommandNanoseconds L" ns"
#define GD_STR_PropertiesQueueCommandIdleTime L"Idle Time"
#define GD_STR_PropertiesQueueCommandDuration L"Duration"
#define GD_STR_PropertiesQueueCommandWaitedForSubmission L"Waited for Submission"
#define GD_STR_PropertiesQueueCommandWaitedForExecution L"Waited for Execution"
#define GD_STR_PropertiesQueueCommandSourcePrefix L"Source "
#define GD_STR_PropertiesQueueCommandDestinationPrefix L"Destination "
#define GD_STR_PropertiesQueueCommandReadPrefix L"Read "
#define GD_STR_PropertiesQueueCommandWrittenPrefix L"Written "
#define GD_STR_PropertiesQueueCommandFillPrefix L"Fill "
#define GD_STR_PropertiesQueueCommandCopiedPrefix L"Copied "
#define GD_STR_PropertiesQueueCommandMappedPrefix L"Mapped "
#define GD_STR_PropertiesQueueCommandUnmappedPrefix L"Unmapped "
#define GD_STR_PropertiesQueueCommandBufferPrefix L"Buffer "
#define GD_STR_PropertiesQueueCommandHostPrefix L"Host "
#define GD_STR_PropertiesQueueCommandMemoryObject L"Memory Object"
#define GD_STR_PropertiesQueueCommandBuffer L"Buffer"
#define GD_STR_PropertiesQueueCommandImage L"Image"
#define GD_STR_PropertiesQueueCommandOffset L"Offset"
#define GD_STR_PropertiesQueueCommandDataSize L"Data Size"
#define GD_STR_PropertiesQueueCommandOrigin L"Origin"
#define GD_STR_PropertiesQueueCommandRegion L"Region"
#define GD_STR_PropertiesQueueCommandColor L"Color"
#define GD_STR_PropertiesQueueCommandPointer L"Pointer"
#define GD_STR_PropertiesQueueCommandBlockingRead L"Blocking Read"
#define GD_STR_PropertiesQueueCommandBlockingWrite L"Blocking Write"
#define GD_STR_PropertiesQueueCommandBlockingMap L"Blocking Map"
#define GD_STR_PropertiesQueueCommandMapFlags L"Map Flags"
#define GD_STR_PropertiesQueueCommandRowPitch L"Row Pitch"
#define GD_STR_PropertiesQueueCommandSlicePitch L"Slice Pitch"
#define GD_STR_PropertiesQueueCommandUserFunctionAddress L"User Function Address"
#define GD_STR_PropertiesQueueCommandArgumentsPointer L"Arguments Pointer"
#define GD_STR_PropertiesQueueCommandArgumentsSize L"Arguments Size"
#define GD_STR_PropertiesQueueCommandMemObjectArguments L"Mem Object Arguments"
#define GD_STR_PropertiesQueueCommandKernel L"Kernel"
#define GD_STR_PropertiesQueueCommandWorkDimensions L"Work Dimensions"
#define GD_STR_PropertiesQueueCommandGlobalWorkOffsetA "Global Work Offset"
#define GD_STR_PropertiesQueueCommandGlobalWorkOffset L"Global Work Offset"
#define GD_STR_PropertiesQueueCommandGlobalWorkSize L"Global Work Size"
#define GD_STR_PropertiesQueueCommandLocalWorkSize L"Local Work Size"
#define GD_STR_PropertiesQueueCommandHostDataPointer L"Host Data Pointer"
#define GD_STR_PropertiesQueueCommandAcquiredObjects L"Acquired Objects"
#define GD_STR_PropertiesQueueCommandReleasedObjects L"Released Objects"
#define GD_STR_PropertiesQueueCommand4DOffsetValueFormat L"(%lu, %lu, %lu, %lu)"
#define GD_STR_PropertiesQueueCommand3DOffsetValueFormat L"(%lu, %lu, %lu)"
#define GD_STR_PropertiesQueueCommand2DOffsetValueFormat L"(%lu, %lu)"
#define GD_STR_PropertiesQueueCommand1DOffsetValueFormat L"(%lu)"
#define GD_STR_PropertiesQueueCommand3DSizeValueFormat L"%lux%lux%lu"
#define GD_STR_PropertiesQueueCommand2DSizeValueFormat L"%lux%lu"
#define GD_STR_PropertiesQueueCommand1DSizeValueFormat L"%lu"
#define GD_STR_PropertiesQueueCommandBytesValueSuffix L" bytes"
#define GD_STR_PropertiesQueueCommandBufferName L"Buffer %d"
#define GD_STR_PropertiesQueueCommandImageName L"Image %d"
#define GD_STR_PropertiesQueueCommandPipeName L"Pipe %d"
#define GD_STR_PropertiesQueueCommandKernelName L"Program %d - Kernel %d"
#define GD_STR_PropertiesQueueCommandEventWaitList L"Event Wait List"
#define GD_STR_PropertiesQueueCommandEventNameInWaitList L"Q%d - Event %d"
#define GD_STR_PropertiesQueueCommandEventReleasedNameInWaitList L"Q%d - Released Event"
#define GD_STR_PropertiesQueueCommandEvent L"Event"
#define GD_STR_PropertiesQueueCommandEventName L"Event %d"
#define GD_STR_PropertiesQueueCommandEventReleasedName L"Released Event"
#define GD_STR_PropertiesDeviceNumberOfQueues L"Number of Queues"
#define GD_STR_PropertiesDeviceTitle L"Device %d"
#define GD_STR_PropertiesDeviceType L"Device Type"
#define GD_STR_PropertiesDeviceName L"Device Name"
#define GD_STR_PropertiesDeviceVersion L"Device Version"
#define GD_STR_PropertiesDeviceVendor L"Device Vendor"

// OpenGL Program Pipelines:
#define GD_STR_PropertiesPipelineActiveProgram   L"Active Program"
#define GD_STR_PropertiesPipelineVertexShader    L"Vertex Shader"
#define GD_STR_PropertiesPipelineGeometryShader  L"Geometry Shader"
#define GD_STR_PropertiesPipelineFragmentShader  L"Fragment Shader"
#define GD_STR_PropertiesPipelineComputeShader   L"Compute Shader"
#define GD_STR_PropertiesPipelineTessCtrlShader  L"Tess Control Shader"
#define GD_STR_PropertiesPipelineTessEvalShader  L"Tess Evaluation Shader"
#define GD_STR_PropertiesPipelineBindingStatus   L"Pipeline Bound"

// OpenGL Samplers:
#define GD_STR_PropertiesSamplerBoundTextures           L"Bound to the following Texture Units"
#define GD_STR_PropertiesSamplerBorderColorRgbaRed      L"RGBA Red Border Color"
#define GD_STR_PropertiesSamplerBorderColorRgbaGreen    L"RGBA Green Border Color"
#define GD_STR_PropertiesSamplerBorderColorRgbaBlue     L"RGBA Blue Border Color"
#define GD_STR_PropertiesSamplerBorderColorRgbaAlpha    L"RGBA Alpha Border Color"
#define GD_STR_PropertiesSamplerTextureLodBias          L"Texture Level of Detail Bias"
#define GD_STR_PropertiesSamplerTextureMaxLod           L"Max Level of Detail"
#define GD_STR_PropertiesSamplerTextureMinLod           L"Min Level of Detail"
#define GD_STR_PropertiesSamplerTextureComparisonMode   L"Comparison Mode"
#define GD_STR_PropertiesSamplerTextureComparisonFunc   L"Comparison Function"
#define GD_STR_PropertiesSamplerTextureMagFilter        L"Magnification Filter"
#define GD_STR_PropertiesSamplerTextureMinFilter        L"Minification Filter"
#define GD_STR_PropertiesSamplerTextureWrapS            L"Texcoord S Wrap Mode"
#define GD_STR_PropertiesSamplerTextureWrapT            L"Texcoord T Wrap Mode"
#define GD_STR_PropertiesSamplerTextureWrapR            L"Texcoord R Wrap Mode"

// Properties View:
#define GD_STR_PropertiesView L"Properties View"
#define GD_STR_PropertiesViewLinkAvailableOnProcessSuspensionMessage "Object links are available only when debugged process is suspended"

// Multi watch view:
#define GD_STR_MultiWatchVariableTypeCaption "Variable Type:"
#define GD_STR_MultiWatchSliderCaption "Z Coordinate: %d"
#define GD_STR_MultiWatchSliderTooltip "Move the slider to view variable XY planes for different Z coordinates"
#define GD_STR_MultiWatchViewNotAvailable "The variable \"%s\" is currently unavailable"
#define GD_STR_MultiWatchVariableNameCaption "Variable Name:"
#define GD_STR_MultiWatchSelectVariable "Select or type kernel variable"
#define GD_STR_MultiWatchDoubleSliderLabel "Adjust variable value active range:"


// Proxy messages:
#define GD_STR_ImageProxyRenderBufferUnbound L"Buffer\nis unbound to\nan FBO"
#define GD_STR_ImageProxyObjectNAMessage L"%ls data\nis not available\nat this time"
#define GD_STR_ImageProxyRenderBufferOpenGLESUnsupportedFormat L"Selected render buffer\nformat cannot be\nread on OpenGL ES"
#define GD_STR_ImageProxyRenderBufferOpenGLESUnsupportedVBOData L"VBO data\ncannot be extracted\non OpenGL ES"
#define GD_STR_ImageProxyRenderBufferOpenGLESUnsupportedBufferType L"Buffer data\ncannot be extracted\non OpenGL ES"
#define GD_STR_ImageProxyGLBeginEndMessage L"%ls data\nis not available\nwhile in\nglBegin-glEnd\nblock"
#define GD_STR_ImageProxyTexture L"Texture"
#define GD_STR_ImageProxyStaticBuffer L"Static Buffer"
#define GD_STR_ImageProxyRenderBuffer L"Render Buffer"
#define GD_STR_ImageProxyPBuffer L"PBuffer"
#define GD_STR_ImageProxyImage L"Image"
#define GD_STR_ImageProxyImageTypeUnknown L"Image type\nis unknown"
#define GD_STR_ImageProxyTextureTypeUnknown L"Texture type\nis unknown"

// Images and buffers viewer:
#define GD_STR_ImagesAndBuffersViewerImageMouseHoverMessage "Place the mouse pointer over the image pixel \nto view the texel information"
#define GD_STR_ImagesAndBuffersViewerImageLeftClickMessage "Click on the image pixel to store the texel information"
#define GD_STR_ImagesAndBuffersViewerNullContextMessage "Textures, buffers and images are not available in no context mode"
#define GD_STR_ImagesAndBuffersViewerBufferClick "Click to\nview data"
#define GD_STR_ImagesAndBuffersViewerGeneralItemText "Click on an item to view details"

// Images and buffers control panel:
#define GD_STR_ImagesAndBuffersViewerControlPanel3DTextureSliderTooltip "Move the slider to view different layers of the 3D texture / image"
#define GD_STR_ImagesAndBuffersViewerControlPanelTextureArraySliderTooltip "Move the slider to view different layers of the texture array"
#define GD_STR_ImagesAndBuffersViewerControlPanelTextureMiplevelsSliderTooltip "Move the slider to view different texture mip levels"
#define GD_STR_ImagesAndBuffersViewerControlPanelTypeCaption "Type:"
#define GD_STR_ImagesAndBuffersViewerControlPanelFormatCaption "Format:"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferOffsetCaption "Offset:"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferStrideCaption "Stride:"
#define GD_STR_ImagesAndBuffersViewerControlPanelTexelFormatPrefix "OA_TEXEL_FORMAT_"
#define GD_STR_ImagesAndBuffersViewerControlPanelLocalWorkSizeCaption "Local Work Size:"
#define GD_STR_ImagesAndBuffersViewerControlPanelGlobalWorkSizeCaption "Global Work Size:"
#define GD_STR_ImagesAndBuffersViewerControlPanelGlobalWorkOffsetCaption "Global Work Offset:"
#define GD_STR_ImagesAndBuffersViewerControlPanelHoveredColorCaption "Hovered Color:"
#define GD_STR_ImagesAndBuffersViewerControlPanelSelectedColorCaption "Selected Color:"
#define GD_STR_ImagesAndBuffersViewerControlPanelHoveredPositionCaption "Hovered Position:"
#define GD_STR_ImagesAndBuffersViewerControlPanelSelectedPositionCaption "Selected Position:"
#define GD_STR_ImagesAndBuffersViewerControlPanelHoveredWorkitemCaption "Hovered W. Item:"
#define GD_STR_ImagesAndBuffersViewerControlPanelSelectedWorkitemCaption "Selected W. Item:"
#define GD_STR_ImagesAndBuffersViewerControlPanelHoveredValueCaption "Hovered Value:"
#define GD_STR_ImagesAndBuffersViewerControlPanelSelectedValueCaption "Selected Value:"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferDisplayOptionsCaption "Buffer Display Options"
#define GD_STR_ImagesAndBuffersViewerControlPanelKernelMultiWatchCaption "Multiple Kernel Work Item Watch"
#define GD_STR_ImagesAndBuffersViewerControlPanelImageInformationCaption "Image Information"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferGroupColor "Color"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferGroupVertex "Vertex"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferGroupIndex "Index"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferGroupNormal "Normal"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferGroupTexture "Texture"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferGroupInterleaved "Interleaved"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferOpenCLC "OpenCL C"
#define GD_STR_ImagesAndBuffersViewerControlPanelBufferGroupAll "All"
#define GD_STR_ImagesAndBuffersViewerControlPanelUnknownBufferFormatGroup L"Unknown buffer formats group"
#define GD_STR_ImagesAndBuffersViewerControlPanelStaleObjectWarning "<b>Note:</b><br>Buffer data display is not updated during kernel debugging"


// Images and buffers viewer strings:
#define GD_STR_ImagesAndBuffersViewerZoolLevelTooltip L"Set Zoom level"
#define GD_STR_ImagesAndBuffersViewerToolbarSelectTooltip L"Select Tool"
#define GD_STR_ImagesAndBuffersViewerToolbarPanTooltip L"Pan Tool"
#define GD_STR_ImagesAndBuffersViewerToolbarZoomInTool L"Zoom In (" GD_STR_keyboardShortcutZoomInString GD_STR_RightParenthesis
#define GD_STR_ImagesAndBuffersViewerToolbarZoomOutTool L"Zoom Out (" GD_STR_keyboardShortcutZoomOutString GD_STR_RightParenthesis
#define GD_STR_ImagesAndBuffersViewerToolbarOriginalSizeTool L"Original Size (100%)"
#define GD_STR_ImagesAndBuffersViewerToolbarBestFitTool L"Best Fit"
#define GD_STR_ImagesAndBuffersViewerToolbarRedChannelFilter L"Enable the Red Channel"
#define GD_STR_ImagesAndBuffersViewerToolbarGreenChannelFilter L"Enable the Green Channel"
#define GD_STR_ImagesAndBuffersViewerToolbarBlueChannelFilter L"Enable the Blue Channel"
#define GD_STR_ImagesAndBuffersViewerToolbarAlphaChannelFilter L"Enable the Alpha Channel"
#define GD_STR_ImagesAndBuffersViewerToolbarGrayscaleMode L"Enable Grayscale Mode"
#define GD_STR_ImagesAndBuffersViewerToolbarInvertMode L"Enable Color Invert Mode"
#define GD_STR_ImagesAndBuffersViewerToolbarRotateLeft L"Rotate Left (" GD_STR_keyboardShortcutLeftString GD_STR_RightParenthesis
#define GD_STR_ImagesAndBuffersViewerToolbarRotateRight L"Rotate Right (" GD_STR_keyboardShortcutRightString GD_STR_RightParenthesis
#define GD_STR_ImagesAndBuffersViewerChannelsAndRotateToolBarCaption L"Channels and Rotate ToolBar"
#define GD_STR_ImagesAndBuffersViewerToolsAndZoomToolBarCaption L"Tools and Zoom ToolBar"
#define GD_STR_ImagesAndBuffersViewerNavigationToolBarCaption L"Navigation ToolBar"
#define GD_STR_ImagesAndBuffersViewerArraySliderCaption "Texture Array Index: %d"
#define GD_STR_ImagesAndBuffersViewer3DSliderCaptionGL "3D Texture Layer: %d"
#define GD_STR_ImagesAndBuffersViewer3DSliderCaptionCL "3D Image Layer: %d"
#define GD_STR_ImagesAndBuffersViewerMiplevelsSliderCaption "Mipmaps"
#define GD_STR_ImagesAndBuffersViewerCurrentMiplevelSliderCaption "Mipmap Level: %d"
#define GD_STR_ImagesAndBuffersViewerPBufferName L"PBuffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferName L"GL Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameArray L"VBO %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameDrawIndir L"Draw Ind Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameDispatchIndir L"Dispatch Ind Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameElementArray L"EBO %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNamePixelPack L"Pack Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNamePixelUnpack L"Unpack Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameCopyRead L"Copy Read Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameCopyWrite L"Copy Write Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameTransformFeedback L"Feedback Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameUniform L"UBO %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameAtomic L"Atomic Counter Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameShaderStorage L"Shader Storage Buffer %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameQuery L"QBO %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameTexture L"TBO %d"
#define GD_STR_ImagesAndBuffersViewerGLBufferNameUnknown L"GL Buffer %d (Unknown type)"
#define GD_STR_ImagesAndBuffersViewerTexBufferName L"Tex Buffer %d"
#define GD_STR_ImagesAndBuffersViewerPBufferNameDeleted L"PBuffer %d (deleted)"
#define GD_STR_ImagesAndBuffersViewerPBufferNameRenderContext L" [Context %d]"
#define GD_STR_ImagesAndBuffersViewerLoadingGLTextureMessage L" Texture(s) data..."
#define GD_STR_ImagesAndBuffersViewerLoadingGLTexturesHeaderMessage L" Textures List..."
#define GD_STR_ImagesAndBuffersViewerLoadingCLImageMessage L" Image(s) data..."
#define GD_STR_ImagesAndBuffersViewerLoadingCLImagesHeaderMessage L" Images List..."
#define GD_STR_ImagesAndBuffersViewerLoadingMessage L"Loading"
#define GD_STR_ImagesAndBuffersViewerInitializingMessage L"Initializing"
#define GD_STR_ImagesAndBuffersViewerLoadingBufferMessage L" Buffer data..."
#define GD_STR_ImagesAndBuffersViewerInitializingBuffersMessage L" Buffers list..."
#define GD_STR_ImagesAndBuffersViewerPleaseWaitMessage L"Please wait..."
#define GD_STR_ImagesAndBuffersViewerExportFilePrefix L"%ls-Context%d"
#define GD_STR_ImagesAndBuffersViewerExportTextureSuffix L"-Texture%ulevel%d"
#define GD_STR_ImagesAndBuffersViewerExportImageSuffix L"-Image%u"
#define GD_STR_ImagesAndBuffersViewerExportStaticBufferSuffix L"-Static-%ls"
#define GD_STR_ImagesAndBuffersViewerExportPBufferSuffix L"-PBuffer%d-Static-%ls"
#define GD_STR_ImagesAndBuffersViewerExportRenderBufferSuffix L"-renderbuffer%d-Static-%ls"
#define GD_STR_ImagesAndBuffersViewerExportVBOSuffix L"-glbo%d"
#define GD_STR_ImagesAndBuffersViewerExportCLBufferSuffix L"-cl_buffer%d"
#define GD_STR_ImagesAndBuffersViewerExportCLSubBufferSuffix L"-cl_sub_buffer%d"
#define GD_STR_ImagesAndBuffersViewerExportDisabledGLBeginGLEndHeader L"Unable to export"
#define GD_STR_ImagesAndBuffersViewerExportDisabledGLBeginGLEndMessage L"Textures and Buffers cannot be saved while in glBegin-glEnd block."
#define GD_STR_ImagesAndBuffersViewerExportingGLTexturesAndBuffersMessage L"Exporting Textures and Buffers..."
#define GD_STR_ImagesAndBuffersViewerExportingCLBuffersAndImagesMessage L"Exporting Buffers and Images..."
#define GD_STR_ImagesAndBuffersViewerExportingDoneMessage "Done\n"
#define GD_STR_ImagesAndBuffersViewerExportingItemMessage L"Exporting %ls (%d of %d)..."
#define GD_STR_ImagesAndBuffersViewerExportFailure L"Export Failed: (%s)\n"
#define GD_STR_ImagesAndBuffersViewerExportSuccessLogEntry L"Export Success"
#define GD_STR_ImagesAndBuffersViewerExportFailureLogEntry L"Export Failed"
#define GD_STR_ImagesAndBuffersViewerExportFileExistLogEntry "File Exists"
#define GD_STR_ImagesAndBuffersViewerExportLogEntry L"%ls: (%ls) to \"%ls\"\n"
#define GD_STR_ImagesAndBuffersViewerExportItemNameTexture L"Texture %d"
#define GD_STR_ImagesAndBuffersViewerExportItemNameShortTexture L"Tex %d"
#define GD_STR_ImagesAndBuffersViewerExportItemNameImage L"Image %d"
#define GD_STR_ImagesAndBuffersViewerExportItemNameStaticBuffer L"Static %ls"
#define GD_STR_ImagesAndBuffersViewerExportItemNamePBuffer L"PBuffer %d, %ls"
#define GD_STR_ImagesAndBuffersViewerExportItemNameVBO L"GL Buffer Object %d"
#define GD_STR_ImagesAndBuffersViewerExportItemNameCLBuffer L"CL Buffer %d"
#define GD_STR_ImagesAndBuffersViewerExportItemNameCLSubBuffer L"CL Sub-Buffer %d"
#define GD_STR_ImagesAndBuffersViewerExportItemProgressDialogHeader "Saving"
#define GD_STR_ImagesAndBuffersViewerTextureHeadingLayerPostfix L"(layer %d)"
#define GD_STR_ImagesAndBuffersViewerTextureHeadingIndexPostfix L"(index %d)"
#define GD_STR_ImagesAndBuffersViewerTextureHeadingMipPostfix L"(mip %d)"

// Flush all images command strings:
#define GD_STR_FlushTexturesAndBuffersCommandPleaseWait L"Please Wait..."
#define GD_STR_FlushTexturesAndBuffersCommandWaitMessage L"Exporting textures and images for the calls log"
#define GD_STR_FlushTexturesAndBuffersCommandExportedGLObjectName L"Texture %d From Context %d"
#define GD_STR_FlushTexturesAndBuffersCommandExportedCLObjectName L"Image %d From Context %d"
#define GD_STR_FlushTexturesAndBuffersCommandExportingSuffix L"Exporting %ls"

// Monitored objects tree:
#define GD_STR_MonitoredObjectsTreeBackTooltip "Back"
#define GD_STR_MonitoredObjectsTreeBackToTooltip "Back to "
#define GD_STR_MonitoredObjectsTreeForwardTooltip "Forward"
#define GD_STR_MonitoredObjectsTreeForwardToTooltip "Forward to "
#define GD_STR_MonitoredObjectsTreeRootRunning "%s (Running)"
#define GD_STR_MonitoredObjectsTreeRootStopped "No project loaded"
#define GD_STR_MonitoredObjectsTreeRootStoppedWithMode "No project loaded - %s"
#define GD_STR_MonitoredObjectsTreeNotRunning "%s - Not running"
#define GD_STR_MonitoredObjectsTreeProfileMode "%s - Profile mode"
#define GD_STR_MonitoredObjectsTreeOpenItem "Open %1"
#define GD_STR_MonitoredObjectsTreeViewItemMemory "View %1 memory analysis"
#define GD_STR_MonitoredObjectsTreeViewContextStatistics "View %1 statistics"
#define GD_STR_MonitoredObjectsTreeItemsHiddenText L"(%d more...)"
#define GD_STR_MonitoredObjectsTreeItemsHiddenTitle L"Hidden tree items"
#define GD_STR_MonitoredObjectsTreeItemsHiddenDetails L"There are more items in this category than the defined maximum (%d).<br/>To change the maximal amount of items shown per type,\nGo to CodeXL options > GPU Debug > Advanced."

// Qt docakbale views captions:
#define GD_STR_ImagesAndBuffersViewerExplorerPaneCaption L"Textures & Buffers Explorer"
#define GD_STR_ImagesAndBuffersViewerImagesListPaneCaption L"Images list"
#define GD_STR_ImagesAndBuffersViewerOpenGLTexturePropertiesPaneCaption L"Properties view"
#define GD_STR_ImagesAndBuffersViewerThumbnailPaneCaption L"Thumbnail viewer"
#define GD_STR_ImagesAndBuffersViewerTextureManagerPaneCaption L"Textures, Buffers and Images viewer"
#define GD_STR_ImagesAndBuffersViewerTextureInformationPaneCaption L"Information panel"
#define GD_STR_ImagesAndBuffersViewerImageViewerCaption "Image view"
#define GD_STR_ImagesAndBuffersViewerDataViewerCaption "Data view"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewerCaption L"Thumbnail view"

#define GD_STR_ImagesAndBuffersViewerZoomLevelTooHigh L"Zoom level is too high! Please select another zoom level."
#define GD_STR_ImagesAndBuffersViewerZoomLevelTooHighCaption L"Warning"
#define GD_STR_ImagesAndBuffersViewerZoomLevelBadValueMessage L"Must be a numeric value between %d and %d."

// Images properties view:
#define GD_STR_ImagesAndBuffersViewerRenderBufferNameFormat L"Render Buffer %u"
#define GD_STR_ImagesAndBuffersViewerRenderBufferNameShortFormat L"R. Buffer %u"
#define GD_STR_ImagesAndBuffersViewerCubeMapPositiveX "+X"
#define GD_STR_ImagesAndBuffersViewerCubeMapNegativeX "-X"
#define GD_STR_ImagesAndBuffersViewerCubeMapPositiveY "+Y"
#define GD_STR_ImagesAndBuffersViewerCubeMapNegativeY "-Y"
#define GD_STR_ImagesAndBuffersViewerCubeMapPositiveZ "+Z"
#define GD_STR_ImagesAndBuffersViewerCubeMapNegativeZ "-Z"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewGLBottomCaption L" Texture"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewCLBottomCaption L" Image"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewRenderBufferBottomCaption L" Render Buffer"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewTexture1DDimensions L"%dw"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewTexture2DDimensions L"%dw x %dh"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewTexture3DDimensions L"%dw x %dh x %dd"
#define GD_STR_ImagesAndBuffersViewerThumbnailViewImageClickToolTip L"View "
#define GD_STR_ImagesAndBuffersViewerDoubleSliderLabel "Adjust \"%1 Channel\" active range:"
#define GD_STR_ImagesAndBuffersViewerImageHeading L"Image %d"
#define GD_STR_ImagesAndBuffersViewerTexBufferHeading L"Texture Buffer %d"
#define GD_STR_ImagesAndBuffersViewerTexBufferNameFormat L"Texture Buffer %u"
#define GD_STR_ImagesAndBuffersViewerTextureHeadingMipmap L" - mipmap %d"
#define GD_STR_ImagesAndBuffersViewerTextureMipmapError L"Mipmap Level %d is not available."
#define GD_STR_ImagesAndBuffersViewerVBONameFormat L"GL Buffer Object %u"
#define GD_STR_ImagesAndBuffersViewerCLBufferNameFormat L"Buffer %d"
#define GD_STR_ImagesAndBuffersViewerCLPipeNameFormat L"Pipe %d"

// Textures and Buffers Viewer - "File" menu
#define GD_STR_ImagesAndBuffersViewerMenuFile L"&File"
#define GD_STR_ImagesAndBuffersViewerMenuFileSaveImageAs L"&Save Image As...\t"
#define GD_STR_ImagesAndBuffersViewerMenuFileSaveRawDataAs L"Export &Raw Data..."
#define GD_STR_ImagesAndBuffersViewerMenuFileSaveAllAsImages L"Export All Images..."
#define GD_STR_ImagesAndBuffersViewerMenuFileSaveAllAsRawData L"Export All Raw Data..."
#define GD_STR_ImagesAndBuffersViewerMenuFileQuit L"&Quit\t" GD_STR_keyboardShortcutQuitMenu

// Textures and Buffers Viewer - "Edit" menu
#define GD_STR_ImagesAndBuffersViewerMenuEdit L"&Edit"
#define GD_STR_ImagesAndBuffersViewerMenuEditCopy L"&Copy\t" GD_STR_keyboardShortcutCopyMenu
#define GD_STR_ImagesAndBuffersViewerMenuEditSelectAll L"Select &All\t" GD_STR_keyboardShortcutSelectAllMenu

// Textures and Buffers Viewer - "View" menu
#define GD_STR_ImagesAndBuffersViewerMenuView L"&View"
#define GD_STR_ImagesAndBuffersViewerMenuViewImageView L"Image View"
#define GD_STR_ImagesAndBuffersViewerMenuViewDataView L"Data View"
#define GD_STR_ImagesAndBuffersViewerMenuViewImageViewShowExplorer L"Textures & Buffers Explorer"
#define GD_STR_ImagesAndBuffersViewerMenuViewImageViewShowRenderBuffersList L"Render Buffers List"
#define GD_STR_ImagesAndBuffersViewerMenuViewImageViewShowPropertiesView L"Properties View"
#define GD_STR_ImagesAndBuffersViewerMenuViewImageViewShowImageInfoPanel L"Image Information Panel"
#define GD_STR_ImagesAndBuffersViewerMenuViewZoomIn L"Zoom &In\t" GD_STR_keyboardShortcutZoomInMenu
#define GD_STR_ImagesAndBuffersViewerMenuViewZoomOut L"Zoom &Out\t" GD_STR_keyboardShortcutZoomOutMenu
#define GD_STR_ImagesAndBuffersViewerMenuViewBestFit L"Best &Fit"
#define GD_STR_ImagesAndBuffersViewerMenuViewOriginalSize L"Original Si&ze (100%)\t" GD_STR_keyboardShortcutZoomOrigMenu

// Textures and Buffers Viewer - "Image" menu
#define GD_STR_ImagesAndBuffersViewerMenuImage L"&Image"
#define GD_STR_ImagesAndBuffersViewerMenuImageRedChannel L"&Red Channel\t" GD_STR_keyboardShortcutRedMenu
#define GD_STR_ImagesAndBuffersViewerMenuImageGreenChannel L"&Green Channel\t" GD_STR_keyboardShortcutGreenMenu
#define GD_STR_ImagesAndBuffersViewerMenuImageBlueChannel L"&Blue Channel\t" GD_STR_keyboardShortcutBlueMenu
#define GD_STR_ImagesAndBuffersViewerMenuImageAlphaChannel L"&Alpha Channel\t" GD_STR_keyboardShortcutAlphaMenu
#define GD_STR_ImagesAndBuffersViewerMenuImageGrayscaleMode L"Gra&yscale Mode"
#define GD_STR_ImagesAndBuffersViewerMenuImageInvertMode L"&Invert Mode"
#define GD_STR_ImagesAndBuffersViewerMenuImageRotateLeft L"Rotate Lef&t\t" GD_STR_keyboardShortcutLeftMenu
#define GD_STR_ImagesAndBuffersViewerMenuImageRotateRight L"Rotate Ri&ght\t" GD_STR_keyboardShortcutRightMenu

// "Textures and Buffers Viewer" - properties window
#define GD_STR_TexturesViewerAllTextures L"All Textures"
#define GD_STR_TexturesViewerAllImages L"All Images"
#define GD_STR_TexturesViewerAllBuffers L"All Buffers"
#define GD_STR_TexturesViewerStaticBuffersHeader L"Static Buffers"
#define GD_STR_TexturesViewerVBOsHeader L"OpenGL Buffer Objects"
#define GD_STR_TexturesViewerTBOsHeader L"Texture Buffer Objects"
#define GD_STR_TexturesViewerPBuffersHeader L"PBuffers"
#define GD_STR_TexturesViewerFBOsHeader L"Frame Buffer Objects"
#define GD_STR_TexturesViewerNotAvailable L"Unavailable"
#define GD_STR_TexturesViewerTexturingIsNotEnabled L"Texture mapping is currently not enabled."
#define GD_STR_TexturesViewerDefault1DNameTextures L"Texture Unit %d - Default 1D Texture"
#define GD_STR_TexturesViewerDefault2DNameTextures L"Texture Unit %d - Default 2D Texture"
#define GD_STR_TexturesViewerDefault3DNameTextures L"Texture Unit %d - Default 3D Texture"
#define GD_STR_TexturesViewerDefault1DArrayNameTextures L"Texture Unit %d - Default 1D Array Texture"
#define GD_STR_TexturesViewerDefault2DArrayNameTextures L"Texture Unit %d - Default 2D Array Texture"
#define GD_STR_TexturesViewerDefaultCubeMapNameTextures L"Texture Unit %d - Default Cube Map Texture"
#define GD_STR_TexturesViewerDefaultCubeMapArrayNameTextures L"Texture Unit %d - Default Cube Map Array Texture"
#define GD_STR_TexturesViewerDefaultTextureRectangleName L"Texture Unit %d - Default Rectangle Texture"
#define GD_STR_TexturesViewerDefaultTexBufferName L"Texture Unit %d - Default Texture Buffer"
#define GD_STR_TexturesViewerDefaultUnknownNameTextures L"Texture Unit %d - Default Texture (Unknown target)"
#define GD_STR_TexturesViewerDefault1DNameShortTextures L"Tex Unit %d - Default 1D Tex"
#define GD_STR_TexturesViewerDefault2DNameShortTextures L"Tex Unit %d - Default 2D Tex"
#define GD_STR_TexturesViewerDefault3DNameShortTextures L"Tex Unit %d - Default 3D Tex"
#define GD_STR_TexturesViewerDefault1DArrayNameShortTextures L"Tex Unit %d - Default 1D Array Tex"
#define GD_STR_TexturesViewerDefault2DArrayNameShortTextures L"Tex Unit %d - Default 2D Array Tex"
#define GD_STR_TexturesViewerDefaultCubeMapNameShortTextures L"Tex Unit %d - Default Cube Map Tex"
#define GD_STR_TexturesViewerDefaultCubeMapArrayNameShortTextures L"Tex Unit %d - Default Cube Array Tex"
#define GD_STR_TexturesViewerDefaultTextureRectangleNameShort L"Tex Unit %d - Default Rect Tex"
#define GD_STR_TexturesViewerDefaultTexBufferNameShort L"Tex Unit %d - Default Tex Buffer"
#define GD_STR_TexturesViewerDefaultUnknownNameShortTextures L"Tex Unit %d - Default Tex (Unknown)"
#define GD_STR_TexturesViewerBound1DNameTextures L" (unit %d, bound 1D)"
#define GD_STR_TexturesViewerBound2DNameTextures L" (unit %d, bound 2D)"
#define GD_STR_TexturesViewerBound3DNameTextures L" (unit %d, bound 3D)"
#define GD_STR_TexturesViewerBound1DArrayNameTextures L" (unit %d, bound 1D Array)"
#define GD_STR_TexturesViewerBound2DArrayNameTextures L" (unit %d, bound 2D Array)"
#define GD_STR_TexturesViewerBoundCubeMapNameTextures L" (unit %d, bound cube map)"
#define GD_STR_TexturesViewerBoundTexRectangleNameTextures L" (unit %d, bound tex-rectangle)"
#define GD_STR_TexturesViewerBound1DNameTexturesEnabled L" (unit %d, bound 1D) - Enabled"
#define GD_STR_TexturesViewerBound2DNameTexturesEnabled L" (unit %d, bound 2D) - Enabled"
#define GD_STR_TexturesViewerBound3DNameTexturesEnabled L" (unit %d, bound 3D) - Enabled"
#define GD_STR_TexturesViewerBound1DArrayNameTexturesEnabled L" (unit %d, bound 1D Array) - Enabled"
#define GD_STR_TexturesViewerBound2DArrayNameTexturesEnabled L" (unit %d, bound 2D Array) - Enabled"
#define GD_STR_TexturesViewerBoundCubeMapNameTexturesEnabled L" (unit %d, bound cube map) - Enabled"
#define GD_STR_TexturesViewerBoundTexRectangleTexturesEnabled L" (unit %d, bound tex-rectangle) - Enabled"
#define GD_STR_TexturesViewerTextureBoundFBODetails L" (FBO %u, %ls)"
#define GD_STR_TexturesViewerTextureBoundPBufferDetails L" (PBuffer %d, %ls)"
#define GD_STR_TexturesViewerTexBufferVBODetails L" ( Buffer Object %d)"

// Render Buffer properties:
#define GD_STR_TexturesViewerNameRenderBuffer L"Render Buffer %u"
#define GD_STR_TexturesViewerAllRenderBuffers L"Render Buffers"

// OpenCL buffers:
#define GD_STR_TexturesViewerCLBuffers L"OpenCL Buffers"
#define GD_STR_TexturesViewerNameCLBuffer L"CL Buffer %d"
#define GD_STR_TexturesViewerNameCLSubBuffer L"CL Sub-buffer %d"
#define GD_STR_TexturesViewerNameCLBufferGLShared L" (GL%d - %d)"

// OpenCL pipes:
#define GD_STR_TexturesViewerCLPipes L"OpenCL Pipes"
#define GD_STR_TexturesViewerNameCLPipe L"CL Pipe %d"

// OpenCL samplers:
#define GD_STR_TexturesViewerNameCLSampler L"CL Sampler %d"


// Buffers summary strings:
#define GD_STR_TexturesViewerRenderBuffers L"Render Buffers"
#define GD_STR_TexturesViewerStaticBuffers L"Static Buffers"
#define GD_STR_TexturesViewerFBOs L"Frame Buffer Objects"
#define GD_STR_TexturesViewerVBOs L"OpenGL Buffer Objects"
#define GD_STR_TexturesViewerPBuffers L"PBuffers"

// FBO properties:
#define GD_STR_TexturesViewerNameFBO L"FBO %u"


// Texture and buffers viewer - objects tooltips:
#define GD_STR_ObjectTooltipBufferType L"Buffer type: %ls"
#define GD_STR_ObjectTooltipDataFormat L"Data format: %ls"
#define GD_STR_ObjectTooltipDataType L"Data type: %ls"
#define GD_STR_ObjectTooltipFBOName L"FBO: %u"
#define GD_STR_ObjectTooltipRequestedInternalFormat L"Requested internal format :%ls"
#define GD_STR_ObjectTooltipTexelFormat L"Texel format: %ls"
#define GD_STR_ObjectTooltipMiplevel L" - %d miplevel"
#define GD_STR_ObjectTooltipMiplevels L" - %d miplevels"
#define GD_STR_ObjectTooltipLastAttachment L"Last attachment: "
#define GD_STR_ObjectTooltipCurrentAttachments L"Current attachments: "
#define GD_STR_ObjectTooltipMemoryFlags L"Memory flags: %ls"
#define GD_STR_ObjectTooltipBufferHandle L"Buffer handle: %ls"
#define GD_STR_ObjectTooltipPixelFormat L"Pixel format: %ls"

// Source Code Viewer
#define GD_STR_SourceCodeViewerFileOpen L"&Open ..\t"
#define GD_STR_SourceCodeViewerFileSave L"&Save\t"
#define GD_STR_SourceCodeViewerFileSaveAs L"Save &as ..\tCtrl+Shift+S"
#define GD_STR_SourceCodeViewerFileClose L"&Close\tCtrl+W"
#define GD_STR_SourceCodeViewerFileProperties L"Proper&ties...\tCtrl+I"
#define GD_STR_SourceCodeViewerFileQuit L"&Quit\t" GD_STR_keyboardShortcutQuitMenu
#define GD_STR_SourceCodeViewerEditUndo L"&Undo\tCtrl+Z"
#define GD_STR_SourceCodeViewerEditRedo L"&Redo\tCtrl+Shift+Z"
#define GD_STR_SourceCodeViewerEditCut L"Cu&t\tCtrl+X"
#define GD_STR_SourceCodeViewerEditCopy L"&Copy\t" GD_STR_keyboardShortcutCopyMenu
#define GD_STR_SourceCodeViewerEditPaste L"&Paste\tCtrl+V"
#define GD_STR_SourceCodeViewerEditDelete L"&Delete\tDel"
#define GD_STR_SourceCodeViewerEditFind L"&Find\t" GD_STR_keyboardShortcutFindMenu
#define GD_STR_SourceCodeViewerEditFindNext L"Find &Next\t" GD_STR_keyboardShortcutFindNextMenu
#define GD_STR_SourceCodeViewerEditReplace L"&Replace\tCtrl+H"
#define GD_STR_SourceCodeViewerEditIndentSelectAll L"&Select All\t" GD_STR_keyboardShortcutSelectAllMenu
#define GD_STR_SourceCodeViewerEditMatchBrace L"&Match Brace\tCtrl+M"
#define GD_STR_SourceCodeViewerEditIndentReadOnlyMode L"&Readonly Mode"
#define GD_STR_SourceCodeViewerViewHighlightLanguage L"&Highlight Language..."
#define GD_STR_SourceCodeViewerViewToggleCurrentFold L"&Toggle Current Fold\tCtrl+T"
#define GD_STR_SourceCodeViewerViewWrapMode L"&Wrap Mode\tCtrl+U"
#define GD_STR_SourceCodeViewerViewShowLineEndings L"Show Line &Endings"
#define GD_STR_SourceCodeViewerViewShowIndentGuides L"Show &Indent Guides"
#define GD_STR_SourceCodeViewerViewShowLineNumbers L"Show Line &Numbers"
#define GD_STR_SourceCodeViewerViewShowLongLineMarker L"Show &Long Line Marker"
#define GD_STR_SourceCodeViewerViewShowWhitespace L"Show White&space"
#define GD_STR_SourceCodeViewerViewUseCodePage L"Use &Codepage of..."
#define GD_STR_SourceCodeViewerCharsetAnsi L"&ANSI (Windows)"
#define GD_STR_SourceCodeViewerCharsetMac L"&MAC (Macintosh)"
#if (AMDT_BUILD_TARGET == AMDT_LINUX_OS) && (AMDT_LINUX_VARIANT == AMDT_MAC_OS_X_LINUX_VARIANT)
    #define GD_STR_SourceCodeViewerEditReplaceAgain L"Replace &Again\tCtrl+Shift+H"
    #define GD_STR_SourceCodeViewerEditGoto L"&Goto\tCtrl+L"
    #define GD_STR_SourceCodeViewerEditIndentSelectLine L"Select &Line\tCtrl+Shift+L"
    #define GD_STR_SourceCodeViewerEditIndentIncrease L"&Indent Increase\tCtrl+]"
    #define GD_STR_SourceCodeViewerEditIndentReduce L"I&ndent Reduce\tCtrl+["
    // Mac doesn't have an L"Insert" key, and instead puts here a L"B", which is obviously a bad behaviour:
    #define GD_STR_SourceCodeViewerViewOverwriteMode L"&Overwrite Mode"
#else
    #define GD_STR_SourceCodeViewerEditReplaceAgain L"Replace &Again\tShift+F4"
    #define GD_STR_SourceCodeViewerEditGoto L"&Goto\tCtrl+G"
    #define GD_STR_SourceCodeViewerEditIndentSelectLine L"Select &Line\tCtrl+L"
    #define GD_STR_SourceCodeViewerEditIndentIncrease L"&Indent Increase\tTab"
    #define GD_STR_SourceCodeViewerEditIndentReduce L"I&ndent Reduce\tShift+Tab"
    #define GD_STR_SourceCodeViewerViewOverwriteMode L"&Overwrite Mode\tIns"
#endif

// Shaders Source Code Viewer:
#define GD_STR_ShadersSourceCodeViewerCompileShader L"Compile shader (" GD_STR_keyboardShortcutCompileString GD_STR_RightParenthesis
#define GD_STR_ShadersSourceCodeViewerBuildProgram L"Build program (" GD_STR_keyboardShortcutBuildString GD_STR_RightParenthesis
#define GD_STR_ShadersSourceCodeViewerValidateProgram L"Validate program after build"
#define GD_STR_ShadersSourceCodeViewerOpenBuildLog L"View the build output log"
#define GD_STR_ShadersSourceCodeViewerShadersAreNotEnabled L"Shaders are currently not enabled."
#define GD_STR_ShadersSourceCodeViewerDisplayStatusTitle L"Display Status"
#define GD_STR_ShadersSourceCodeViewerProgramsAreNotEnabled L"Programs are not currently enabled."
#define GD_STR_ShadersSourceCodeViewerProgramsNoContext L"Programs are unavailable in no context mode."
#define GD_STR_ShadersSourceCodeViewerNoPrograms L"There are no programs for this context."
#define GD_STR_ShadersSourceCodeViewerHtmlProcessIsRunning L"Shaders, kernels and programs are displayed only when the debugged process has been suspended."
#define GD_STR_ShadersSourceCodeViewerHtmlSelectShader L"Select a Shader or Program to be displayed."
#define GD_STR_ShadersSourceCodeViewerFileOpenTitle L"File Open"
#define GD_STR_ShadersSourceCodeViewerHtmlErrorWhileOpeningShader L"Cannot open file: "
#define GD_STR_ShadersSourceCodeViewerBuildingProgramProgressBarMessage L"Building program..."
#define GD_STR_ShadersSourceCodeViewerListCtrlOpenCLProgramName L"Program %d"
#define GD_STR_ShadersSourceCodeViewerListCtrlOpenCLProgramNotAttached L"Program not attached"
#define GD_STR_ShadersSourceCodeViewerListCtrlOpenCLProgramDeletedSuffix L" (marked for deletion)"
#define GD_STR_ShadersSourceCodeViewerListCtrlOpenCLKernelName L"Kernel %d"
#define GD_STR_ShadersSourceCodeViewerListCtrlActive L" (active)"
#define GD_STR_ShadersSourceCodeViewerListCtrlVertexShaderName L"Vertex Shader"
#define GD_STR_ShadersSourceCodeViewerListCtrlTessellationControlShaderName L"Tessellation Control Shader"
#define GD_STR_ShadersSourceCodeViewerListCtrlTessellationEvaluationShaderName L"Tessellation Evaluation Shader"
#define GD_STR_ShadersSourceCodeViewerListCtrlGeometryShaderName L"Geometry Shader"
#define GD_STR_ShadersSourceCodeViewerListCtrlFragmentShaderName L"Fragment Shader"
#define GD_STR_ShadersSourceCodeViewerListCtrlComputeShaderName L"Compute Shader"
#define GD_STR_ShadersSourceCodeViewerListCtrlUnknownShaderName L"Shader"
#define GD_STR_ShadersSourceCodeViewerListCtrlUnknownShaderNotAttached L"Shader not attached"
#define GD_STR_ShadersSourceCodeViewerListCtrlShaderNameIndentation L"  "
#define GD_STR_ShadersSourceCodeViewerListCtrlShaderNameNoProgram L" (No associated program)"
#define GD_STR_ShadersSourceCodeViewerHtmlTextureData L"Texture data"
#define GD_STR_ShadersSourceCodeViewerHtmlTextureDataUnitNumber L" - Texture unit "
#define GD_STR_ShadersSourceCodeViewerHtmlTextureDataUnitZero L" - Active Texture unit"
#define GD_STR_ShadersSourceCodeViewerHtmlActiveUniformsNotAvailable L"Active Uniforms are not available"
#define GD_STR_ShadersSourceCodeViewerVBOName L"OpenGL Uniform Buffer %d"
#define GD_STR_ShadersSourceCodeViewerHtmlActiveUniformsTitle L"Active Uniforms"
#define GD_STR_ShadersSourceCodeViewerHtmlActiveBuildInUniformsTitle L"Active Built-In Uniforms"
#define GD_STR_ShadersSourceCodeViewerHtmlActiveUniformBufferObjectsTitle L"Active Uniform Buffer Objects"
#define GD_STR_ShadersSourceCodeViewerShaderPropertiesPaneCaption L"Shader Properties"
#define GD_STR_ShadersSourceCodeViewerKernelPropertiesPaneCaption L"Kernel Properties"
#define GD_STR_ShadersSourceCodeViewerProgramPropertiesPaneCaption L"Program Properties"
#define GD_STR_ShadersSourceCodeViewerPropertiesPaneCaption L"Properties"
#define GD_STR_ShadersSourceCodeViewerListCtrlGLPaneCaption L"Programs and Shaders List"
#define GD_STR_ShadersSourceCodeViewerListCtrlCLPaneCaption L"Programs and Kernels List"
#define GD_STR_ShadersSourceCodeToolsPaneCaption L"Shaders and Kernels Source Code Editor Toolbar"
#define GD_STR_ShadersSourceCodeHTMLWindowPaneName L"Program Information"
#define GD_STR_ShadersSourceCodeSourceCodeWindowPaneName L"Object Source Code"
#define GD_STR_ShadersSourceCodeViewerBuildCompileShader L"&Compile shader\t" GD_STR_keyboardShortcutCompileMenu
#define GD_STR_ShadersSourceCodeViewerBuildBuildProgram L"&Build program\t" GD_STR_keyboardShortcutBuildMenu
#define GD_STR_ShadersSourceCodeViewerBuildValidate L"&Validate program after build"
#define GD_STR_ShadersSourceCodeViewerBuildViewLog L"View the build output &log"
#define GD_STR_ShadersSourceCodeViewerViewToolbar L"Tool&bar"
#define GD_STR_ShadersSourceCodeViewerViewProgramsAndShadersList L"&Programs and Kernels / Shaders List"
#define GD_STR_ShadersSourceCodeViewerViewPropertiesWindow L"P&roperties window"
#define GD_STR_ShadersSourceCodeViewerBuildStarted L" Build Started: "
#define GD_STR_ShadersSourceCodeViewerBuildStartedSpacer L"------"
#define GD_STR_ShadersSourceCodeViewerCompileStatusForamtSuccess L"Compile: %d Succeeded, %d Failed"
#define GD_STR_ShadersSourceCodeViewerCompileStatusForamtFailure L"Compile: %d Succeeded, <b><FONT COLOR=RED>%d Failed</FONT></b>"
#define GD_STR_ShadersSourceCodeViewerCLDeviceBuildStatusPrefix L"Build "
#define GD_STR_ShadersSourceCodeViewerSkippedBuild L"skipped"
#define GD_STR_ShadersSourceCodeViewerBuildStatusPrefix L"Build: "
#define GD_STR_ShadersSourceCodeViewerLinkStatusPrefix L"Link: "
#define GD_STR_ShadersSourceCodeViewerValidateStatusPrefix L"Validate: "
#define GD_STR_ShadersSourceCodeViewerStatusNotExecuted L"Not Executed"
#define GD_STR_ShadersSourceCodeViewerStatusSuccess L"Succeeded"
#define GD_STR_ShadersSourceCodeViewerStatusFailure L"<b><FONT COLOR=RED>Failed</FONT></b>"
#define GD_STR_ShadersSourceCodeViewerUpdatingOpenGLPrograms L"Updating OpenGL Programs..."
#define GD_STR_ShadersSourceCodeViewerUpdatingOpenGLShaders L"Updating OpenGL Shaders..."
#define GD_STR_ShadersSourceCodeViewerUpdatingOpenCLPrograms L"Updating OpenCL Programs..."
#define GD_STR_ShadersSourceCodeViewerUpdatingOpenCLKernels L"Updating OpenCL Kernels..."

// Shaders Source Code build log dialog
#define GD_STR_ShadersSourceCodeBuildLogDialogTitle L"Program build log"

// Debug log strings:
#define GD_STR_LogMsg_FailedToCreateAssertionsHandlers L"Failed to initialize assertion handlers"
#define GD_STR_LogMsg_FailedToInitAPI L"Failed to initialize the API package"
#define GD_STR_LogMsg_CheckForUpdatesTime L"Getting next update check time"
#define GD_STR_LogMsg_AutoCheckForUpdates L"Automatically checking for software updates"
#define GD_STR_LogMsg_LoadingSplashScreen L"Loading splash screen"
#define GD_STR_LogMsg_FinishedLoadingSplashScreen L"Finished loading splash screen"
#define GD_STR_LogMsg_mainFrameCreationBegin L"Main application frame creation started"
#define GD_STR_LogMsg_mainFrameCreationEnd L"Main application frame creation ended"
#define GD_STR_LogMsg_statusBarCreationBegin L"Status bar creation started"
#define GD_STR_LogMsg_statusBarCreationEnd L"Status bar creation ended"
#define GD_STR_LogMsg_toolBarsCreationBegin L"Toolbars creation started"
#define GD_STR_LogMsg_toolBarsCreationEnd L"Toolbars creation ended"
#define GD_STR_LogMsg_viewsCreationStart L"Views creation started"
#define GD_STR_LogMsg_viewsCreationEnd L"Views creation ended"
#define GD_STR_LogMsg_viewersCreationStart L"Viewers creation started"
#define GD_STR_LogMsg_viewersCreationEnd L"Viewers creation ended"
#define GD_STR_LogMsg_loadingGUILayoutsBegin L"Loading GUI layouts started"
#define GD_STR_LogMsg_loadingGUILayoutsEnd L"Loading GUI layouts ended"
#define GD_STR_LogMsg_failedToLoadOptionsFile L"Failed to load options file; Setting options to default values"
#define GD_STR_LogMsg_processCreated L"Project name: %ls - Process created"
#define GD_STR_LogMsg_ApplyiedLayout L"Main frame layout applied"
#define GD_STR_LogMsg_CmdLineArgs L"Reading command line arguments"
#define GD_STR_LogMsg_FinishedCmdLineArgs L"Finished handling command line arguments"

// Debug log L"soft" errors (reported only in debug log level)
#define GD_STR_LogMsg_couldNotDetermineTextureMemorySize L"Could not determine texture / image memory size"
#define GD_STR_LogMsg_couldNotUpdateTextureRawData L"Could not update texture / image raw data"
#define GD_STR_LogMsg_couldNotExportSpyData L"Could not export OpenGL server data"

// Statistics panel:
#define GD_STR_StatisticsViewerClearStatistics "&Clear Statistics"
#define GD_STR_StatisticsViewerShowDetailedBatchStatistics "Show detailed batch statistics"

// Statistics viewer:
#define GD_STR_StatisticsViewerFunctionCallsTitle L"Statistics and Redundant Function Calls Viewer"
#define GD_STR_StatisticsViewerPropertiesCaption L"Properties"
#define GD_STR_StatisticsViewerGraphViewCaption L"Graph View"
#define GD_STR_StatisticsViewerTotalStatisticsCaption "Function Types"
#define GD_STR_StatisticsViewerTotalStatisticsCaptionW L"Function Types"
#define GD_STR_StatisticsViewerTotalStatisticsShortName L"FunctionTypes"
#define GD_STR_StatisticsViewerTotalStatisticsMenu L"Function Types Statistics"
#define GD_STR_StatisticsViewerFunctionCallsStatisticsMenu L"Function Calls Statistics"
#define GD_STR_StatisticsViewerFunctionCallsStatisticsCaption "Function Calls"
#define GD_STR_StatisticsViewerDeprecatedFunctionCallsStatisticsCaption "Deprecated Function"
#define GD_STR_StatisticsViewerDeprecatedFunctionCallsStatisticsMenu L"Deprecated Function Statistics"
#define GD_STR_StatisticsViewerBatchStatisticsMenu L"Batch Statistics"
#define GD_STR_StatisticsViewerBatchStatisticsCaption "Vertex Batches"
#define GD_STR_StatisticsViewerBatchStatisticsShortName L"Vertex Batch"
#define GD_STR_StatisticsViewerCallsHistoryStatisticsShortName L"Calls History"
#define GD_STR_StatisticsViewerFunctionCallsStatisticsShortName L"FunctionCalls"
#define GD_STR_StatisticsViewerDeprectionStatisticsShortName L"Deprecation"
#define GD_STR_StatisticsViewerFunctionCallsHistoryCaption "Calls History"
#define GD_STR_StatisticsViewerBatchStatisticsMenu L"Batch Statistics"
#define GD_STR_StatisticsViewerStateChangeStatisticsMenu L"State Change Statistics"
#define GD_STR_StatisticsViewerStateChangeStatisticsCaption L"State Change"
#define GD_STR_StatisticsViewerStateChangeStatisticsShortName L"StateChange"
#define GD_STR_StatisticsViewerToolbarCaption L"Statistics Viewer Toolbar"
#define GD_STR_StatisticsViewerBreakOnRedundantStateChanges L"&Break on redundant state changes"
#define GD_STR_StatisticsViewerBreakOnDeprecated L"&Break on deprecated functions"
#define GD_STR_StatisticsViewerFileExportFunctionCallStatistics L"Export &Function Calls Statistics..."
#define GD_STR_StatisticsViewerFileExportStateChangeStatistics L"Export &State Change Statistics..."
#define GD_STR_StatisticsViewerFileExportDeprecationStatistics L"Export &Deprecation Statistics..."
#define GD_STR_StatisticsViewerFileExportBatchStatistics L"Export &Batch Statistics..."
#define GD_STR_StatisticsViewerFileExportTotalStatistics L"Export Function &Types Statistics..."
#define GD_STR_ErrorMessageSaveTotalStatisticsFailed L"Could not export the Function Types Statistics to a file."
#define GD_STR_ErrorMessageStateChangeTotalStatisticsFailed "Could not export the State Change Statistics to a file."
#define GD_STR_StatisticsViewerFileClearStatistics L"&Clear statistics"
#define GD_STR_StatisticsViewerFileQuit L"&Quit\t" GD_STR_keyboardShortcutQuitMenu
#define GD_STR_StatisticsViewerGraphView L"Graph View"
#define GD_STR_StatisticsViewerDetailedBatchStatisticsView L"Detailed Batch Statistics"
#define GD_STR_StatisticsViewerPropertiesView L"Properties View"
#define GD_STR_StatisticsViewerProfileModeProperties L"Statistics information is not available in Profile Mode"
#define GD_STR_StatisticsViewerCheckboxesWindowName L"Breakpoints"

// Memory analysis viewer:
#define GD_STR_MemoryAnalysisViewerTitle L"Graphic and Compute Memory Analysis Viewer"
#define GD_STR_MemoryAnalysisViewerListCaption "Graphic Objects Details"
#define GD_STR_MemoryAnalysisViewerTreeCaption L"Graphic Objects"
#define GD_STR_MemoryAnalysisViewerCreationStackCaption L"Object Creation Call Stack"
#define GD_STR_MemoryAnalysisViewerGraphView L"Graph View"
#define GD_STR_MemoryAnalysisViewerPropertiesView L"Properties View"
#define GD_STR_MemoryAnalysisViewerTreeVBOName L"OpenGL Buffer %u"
#define GD_STR_MemoryAnalysisViewerTreeSyncName L"Sync Object %d"
#define GD_STR_MemoryAnalysisViewerTreeRenderBufferName L"Render Buffer %u"
#define GD_STR_MemoryAnalysisViewerTreeProgramPipelineName L"Program Pipeline %u"
#define GD_STR_MemoryAnalysisViewerTreeOpenGlSamplerName L"OpenGL Sampler %u"
#define GD_STR_MemoryAnalysisViewerTreeDisplayListName L"Display List %u"
#define GD_STR_MemoryAnalysisViewerTreeFBOName L"FBO %u"
#define GD_STR_MemoryAnalysisViewerTreeTexturesNode L"Textures"
#define GD_STR_MemoryAnalysisViewerTreeImagesNode L"Images"
#define GD_STR_MemoryAnalysisViewerTreeBuffersNode L"Buffers"
#define GD_STR_MemoryAnalysisViewerTreePipesNode L"Pipes"
#define GD_STR_MemoryAnalysisViewerTreeSamplersNode L"Samplers"
#define GD_STR_MemoryAnalysisViewerTreeEventsNode L"Events"
#define GD_STR_MemoryAnalysisViewerTreeCLProgramsNode L"OpenCL Programs"
#define GD_STR_MemoryAnalysisViewerTreeCommandQueuesNode L"Command Queues"
#define GD_STR_MemoryAnalysisViewerTreeRenderBuffersNode L"Render Buffers"
#define GD_STR_MemoryAnalysisViewerTreeProgramPipelinesNode L"Program Pipelines"
#define GD_STR_MemoryAnalysisViewerTreeOpenGlSamplersNode L"OpenGL Samplers"
#define GD_STR_MemoryAnalysisViewerTreeStaticBuffersNode L"Static Buffers"
#define GD_STR_MemoryAnalysisViewerTreePBuffersNode L"Pixel Buffers"
#define GD_STR_MemoryAnalysisViewerTreeSyncObjectsNode L"Sync Obejcts"
#define GD_STR_MemoryAnalysisViewerTreeVBOsNode L"OpenGL Buffer Objects"
#define GD_STR_MemoryAnalysisViewerTreeGLProgramsNode L"Shading Programs"
#define GD_STR_MemoryAnalysisViewerTreeShadersNode L"Shaders"
#define GD_STR_MemoryAnalysisViewerTreeDisplaysListsNode L"Display Lists"
#define GD_STR_MemoryAnalysisViewerTreeFBOsNode L"Frame Buffer Objects"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContext                  L"Updating Context %d"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextStaticBuffers     GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Static Buffers"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextTextures          GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Textures"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextImages            GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Images"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextCLBuffers         GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenCL Buffers"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextCLPipes         GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenCL Pipes"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextCLSamplers        GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenCL Samplers"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextCLEvents          GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenCL Events"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextCommandQueues     GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenCL Command Queues"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextCLPrograms        GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenCL Programs"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextRenderBuffers     GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Render Buffers"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingProgramPipelines         GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Program Pipelines"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingOpenGlSamplers           GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenGL Samplers"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextVBOs              GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" OpenGL Buffer Objects"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextDisplayLists      GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Display Lists"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextShaders           GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Shaders"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextGLPrograms        GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" Shading Programs"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingContextFBOs              GD_STR_MemoryAnalysisViewerTreeUpdatingContext L" FBOs"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingPBuffer                  L"Updating PBuffer %d"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingSync                     L"Updating Sync object #%d"
#define GD_STR_MemoryAnalysisViewerTreeUpdatingEllipsis                 L"..."
#define GD_STR_MemoryAnalysisViewerListMemorySize "Memory Size"
#define GD_STR_MemoryAnalysisViewerListMemorySizeW L"Memory Size"
#define GD_STR_MemoryAnalysisViewerListAttachmentTarget "Attachment Target"
#define GD_STR_MemoryAnalysisViewerListAttachmentPoint "Attachment Point"
#define GD_STR_MemoryAnalysisViewerListMemoryFlags "Memory Flags"
#define GD_STR_MemoryAnalysisViewerListPipePacketSize "Packet Size"
#define GD_STR_MemoryAnalysisViewerListPipeMaxPackets "Max Packets"
#define GD_STR_MemoryAnalysisViewerListReferenceCount "Reference Count"
#define GD_STR_MemoryAnalysisViewerAmountOfEvents "# of Events"
#define GD_STR_MemoryAnalysisViewerListOutOfOrderExecutionMode "Out Of Order Execution Mode"
#define GD_STR_MemoryAnalysisViewerListProfilingMode "Profiling Mode"
#define GD_STR_MemoryAnalysisViewerListQueueOnDevice "Queue on device"
#define GD_STR_MemoryAnalysisViewerListQueueOnDeviceHost L"Host"
#define GD_STR_MemoryAnalysisViewerListQueueOnDeviceOnDevice L"On-Device"
#define GD_STR_MemoryAnalysisViewerListQueueOnDeviceDefault L" (Default)"
#define GD_STR_MemoryAnalysisViewerListFilterMode "Filter Mode"
#define GD_STR_MemoryAnalysisViewerListAddressingMode "Addressing Mode"
#define GD_STR_MemoryAnalysisViewerListSyncHandle "Handle"
#define GD_STR_MemoryAnalysisViewerListTextureType "Tex Type"
#define GD_STR_MemoryAnalysisViewerListImageType "Img Type"
#define GD_STR_MemoryAnalysisViewerListTextureMipmap "Mipmap"
#define GD_STR_MemoryAnalysisViewerListVerticesAmount "# of Vertices"
#define GD_STR_MemoryAnalysisViewerListTextureInternalFormat "Internal Format"
#define GD_STR_MemoryAnalysisViewerListTextureDataType "Data Type"
#define GD_STR_MemoryAnalysisViewerListTexturePixelFormat "Pixel Format"
#define GD_STR_MemoryAnalysisViewerInternalFormatRequested L" (Requested)"
#define GD_STR_MemoryAnalysisViewerNAGLBeginEndMessage L"N/A (glBegin-End block)"
#define GD_STR_MemoryAnalysisViewerListAttachment "Attachment"
#define GD_STR_MemoryAnalysisViewerListObjectType "Object Type"
#define GD_STR_MemoryAnalysisViewerListPixelFormatFormat "Format"
#define GD_STR_MemoryAnalysisViewerListDimensions "Dimensions"
#define GD_STR_MemoryAnalysisViewerListSourceCodeSize "Source Code Size"
#define GD_STR_MemoryAnalysisViewerListShaderType "Shader Type"
#define GD_STR_MemoryAnalysisViewerListNumberOfObjects "# of Objects"
#define GD_STR_MemoryAnalysisViewerListRenderContext "Render Context"
#define GD_STR_MemoryAnalysisViewerListTexturesNodeName "Textures"
#define GD_STR_MemoryAnalysisViewerListImagesNodeName "Images"
#define GD_STR_MemoryAnalysisViewerListRenderBuffersNodeName "Render Buffers"
#define GD_STR_MemoryAnalysisViewerListCLBuffersNodeName "CL Buffers"
#define GD_STR_MemoryAnalysisViewerListCLPipesNodeName "CL Pipes"
#define GD_STR_MemoryAnalysisViewerListCommandQueuesNodeName "Command Queues"
#define GD_STR_MemoryAnalysisViewerListCLProgramsNodeName "Computation Programs"
#define GD_STR_MemoryAnalysisViewerListCLSamplersNodeName "CL Samplers"
#define GD_STR_MemoryAnalysisViewerListCLEventsNodeName "CL Events"
#define GD_STR_MemoryAnalysisViewerListStaticBuffersNodeName "Static Buffers"
#define GD_STR_MemoryAnalysisViewerListVBONodeName "OpenGL Buffer Objects"
#define GD_STR_MemoryAnalysisViewerListGLProgramsNodeName "Shading Programs"
#define GD_STR_MemoryAnalysisViewerListOpenGLSamplersNodeName "GL Samplers"
#define GD_STR_MemoryAnalysisViewerListOpenGLProgramPipelinesNodeName "GL Program Pipelines"
#define GD_STR_MemoryAnalysisViewerListShadersNodeName "Shaders"
#define GD_STR_MemoryAnalysisViewerListDisplayListsNodeName "Display Lists"
#define GD_STR_MemoryAnalysisViewerListFBOsNodeName "FBOs"
#define GD_STR_MemoryAnalysisViewerListRenderContextName "Context Name"
#define GD_STR_MemoryAnalysisViewerListUnavailableSuspended "Memory analysis information is displayed only when the debugged process has been suspended."
#define GD_STR_MemoryAnalysisViewerListUnavailableDebugMode "Memory analysis information is displayed in debug mode."
#define GD_STR_MemoryAnalysisViewerObjectSizeTotalHTML L"Selected Objects Size: "
#define GD_STR_MemoryAnalysisViewerObjectSizeInsignificantA "Insignificant"
#define GD_STR_MemoryAnalysisViewerObjectSizeInsignificant L"Insignificant"
#define GD_STR_MemoryAnalysisViewerObjectSizeinsignificant L"insignificant"
#define GD_STR_MemoryAnalysisViewerObjectCreationCallStackCaption "Object Creation Call Stack"
#define GD_STR_MemoryAnalysisViewerObjectsSize "Selected Objects Size"
#define GD_STR_MemoryAnalysisViewerObjectSizeNoEstimateAvilable L"No Estimate Available"
#define GD_STR_MemoryAnalysisViewerMipMapLevels L" (%d levels)"
#define GD_STR_MemoryAnalysisViewerMipMapManual L"Manual"
#define GD_STR_MemoryAnalysisViewerMipMapAuto L"Auto"
#define GD_STR_MemoryAnalysisViewerSizeEstimated L" (Estimated)"
#define GD_STR_MemoryAnalysisViewerBreakOnMemoryLeaks L"&Break On Memory Leaks"
#define GD_STR_MemoryAnalysisViewerExportMemoryData "&Export Memory Data..."
#define GD_STR_MemoryAnalysisViewerPopulatingList L"Populating List..."
#define GD_STR_MemoryAnalysisViewerExportMemoryDataString L"GraphicMemoryData"
#define GD_STR_MemoryAnalysisFileDescription L" Memory Analysis Data information\n"
#define GD_STR_MemoryAnalysisViewerFileQuit L"&Quit\t" GD_STR_keyboardShortcutQuitMenu
#define GD_STR_MemoryAnalysisViewerStackItemMessage "Select a specific object from the CodeXL explorer tree to view its creation call stack"
#define GD_STR_MemoryAnalysisViewerUpdatingTexturesParameters L"Updating textures parameters"

#define GD_STR_MemoryLeakAppTerminationLeakTypeHeading L"Leak Type"
#define GD_STR_MemoryLeakAppTerminationLeakTypeRC L"Render context / pixel buffer / sync objects leak"
#define GD_STR_MemoryLeakAppTerminationLeakTypeCLC L"Compute context"
#define GD_STR_MemoryLeakAllocatedObjectsLeakTypeGraphic L"Allocated graphic objects leak"

#define GD_STR_MemoryLeakAppTerminationRenderContextsHTML L"Render Context(s)"
#define GD_STR_MemoryLeakAppTerminationPBuffersHTML L"Pixel Buffer(s)"
#define GD_STR_MemoryLeakAppTerminationSyncObjectsHTML L"Sync Object(s)"
#define GD_STR_MemoryLeakAppTerminationComputeContextsHTML L"Compute Context(s)"
#define GD_STR_MemoryLeakAppTerminationDetailsHeading L"Details"
#define GD_STR_MemoryLeakAppTerminationDetailsGL L"Some OpenGL Render Contexts, Pixel Buffers and / or Sync Objects were not deleted before the application was terminated, causing a graphic memory leak."
#define GD_STR_MemoryLeakAllocatedObjectsRenderContextHTML L"Render Context:"
#define GD_STR_MemoryLeakAppTerminationDetailsCL L"Some OpenCL Compute Contexts were not deleted before the application was terminated, causing a graphic memory leak."
#define GD_STR_MemoryLeakAllocatedObjectsComputeContextHTML L"Compute Context:"
#define GD_STR_MemoryLeakAllocatedObjectsObjectTypesHTML L"Object Types:"
#define GD_STR_MemoryLeakAllocatedObjectsDetailsHTML L"Render Context %u was deleted without clearing all its graphic objects, causing a graphic memory leak. Note that if using ShareLists, these objects may have been created in another render context."
#define GD_STR_MemoryLeakAllocatedObjectsTextures L"%d Texture(s)"
#define GD_STR_MemoryLeakAllocatedObjectsGLSamplers L"%d Sampler(s)"
#define GD_STR_MemoryLeakAllocatedObjectsRenderBuffers L"%d Render Buffer(s)"
#define GD_STR_MemoryLeakAllocatedObjectsFBOs L"%d FBO(s)"
#define GD_STR_MemoryLeakAllocatedObjectsVBOs L"%d GL Buffer Object(s)"
#define GD_STR_MemoryLeakAllocatedObjectsGLPrograms L"%d Shading Program(s)"
#define GD_STR_MemoryLeakAllocatedObjectsShaders L"%d Shader(s)"
#define GD_STR_MemoryLeakAllocatedObjectsPipelines L"%d Program Pipeline(s)"
#define GD_STR_MemoryLeakAllocatedObjectsDisplayLists L"%d Display List(s)"

// Statistics viewer properties information:
#define GD_STR_StatisticsViewerPropertiesProcessNotSuspended L"Statistics are only displayed when the debugged process has been suspended"
#define GD_STR_StatisticsViewerPropertiesGenericCallsHistory L"%ls function call"
#define GD_STR_StatisticsViewerPropertiesGenericGLCallsStatistics L"OpenGL function"
#define GD_STR_StatisticsViewerPropertiesGenericCLCallsStatistics L"OpenCL function"
#define GD_STR_StatisticsViewerPropertiesDeprecatedFunction L"Deprecated functions would be removed."
#define GD_STR_StatisticsViewerPropertiesDeprecatedTitle L"Deprecated"
#define GD_STR_StatisticsViewerPropertiesGetTitle L"Get"
#define GD_STR_StatisticsViewerPropertiesFunction L"function"

// Function Types statistics item viewer:
#define GD_STR_TotalStatisticsViewerDrawFunctions L"Draw Functions"
#define GD_STR_TotalStatisticsViewerRasterFunctions L"Raster Functions"
#define GD_STR_TotalStatisticsViewerGetFunctions L"Get Functions"
#define GD_STR_TotalStatisticsViewerStateChangeFunctions L"State Change Functions"
#define GD_STR_TotalStatisticsViewerEffectiveStateChangeFunctions L"Effective State Change Functions"
#define GD_STR_TotalStatisticsViewerRedundantStateChangeFunctions L"Redundant State Change Functions"
#define GD_STR_TotalStatisticsViewerProgramsAndShadersFunctions L"Program and Shader Functions"
#define GD_STR_TotalStatisticsViewerProgramsAndKernelsFunctions L"Program and Kernel Functions"
#define GD_STR_TotalStatisticsViewerTextureFunctions L"Texture Functions"
#define GD_STR_TotalStatisticsViewerMatrixFunctions L"Matrix Functions"
#define GD_STR_TotalStatisticsViewerNameFunctions L"Name Functions"
#define GD_STR_TotalStatisticsViewerQueryFunctions L"Query Functions"
#define GD_STR_TotalStatisticsViewerQueueFunctions L"Queue Functions"
#define GD_STR_TotalStatisticsViewerBufferImageFunctions L"Buffer and Image Functions"
#define GD_STR_TotalStatisticsViewerSyncFunctions L"Synchronization Functions"
#define GD_STR_TotalStatisticsViewerFeedbackFunctions L"Feedback Functions"
#define GD_STR_TotalStatisticsViewerVertexArrayFunctions L"Vertex Array Functions"
#define GD_STR_TotalStatisticsViewerDebugFunctions L"Debug Functions"
#define GD_STR_TotalStatisticsViewerCLNullContextFunctions L"OpenCL No Context Functions"
#define GD_STR_TotalStatisticsViewerGLNullContextFunctions L"OpenGL No Context Functions"
#define GD_STR_TotalStatisticsViewerGLContextBoundFunctions L"OpenGL Context-Bound Functions"
#define GD_STR_TotalStatisticsViewerCLContextBoundFunctions L"OpenCL Context-Bound Functions"
#define GD_STR_TotalStatisticsViewerBufferFunctions L"Buffer Functions"
#define GD_STR_TotalStatisticsViewerDeprecatedFunctions L"Deprecated Functions"
// Total statistics table columns headings
#define GD_STR_TotalStatisticsViewerColumn1Title "Function Type"
#define GD_STR_TotalStatisticsViewerColumn2Title "% of Calls"
#define GD_STR_TotalStatisticsViewerColumn3Title "# of Calls"
#define GD_STR_TotalStatisticsViewerColumn4Title "% of Calls (Avg. per Frame)"
#define GD_STR_TotalStatisticsViewerColumn5Title "# of Calls (Avg. per Frame)"
// // Total statistics table columns headings hints (tooltips)
#define GD_STR_TotalStatisticsViewerColumn1Tooltip "Function type"
#define GD_STR_TotalStatisticsViewerColumn2Tooltip "Percentage  of calls"
#define GD_STR_TotalStatisticsViewerColumn3Tooltip "Number of function calls. A function may have several types.\nCalls to such a function will be accounted for under each of the function types."
#define GD_STR_TotalStatisticsViewerColumn4Tooltip "Average number of calls per frame,\nas a percentage out of all calls in a frame.\nCalculated for %1 complete frames, not including the current frame."
#define GD_STR_TotalStatisticsViewerColumn5Tooltip "Average number of calls per frame.\nCalculated for %1 complete frames, not including the current frame."

#define GD_STR_TotalStatisticsViewerFramesNumber L"(%ls Frames)"
#define GD_STR_TotalStatisticsViewerNoFrameTerminators "No Frame Terminators Selected"
#define GD_STR_TotalStatisticsViewerExportStatistics L"&Export Function Types Statistics..."
#define GD_STR_TotalStatisticsFindDialogTitle L"Find in the Function Types Statistics view"

// State Change statistics item viewer:
#define GD_STR_StateChangeStatisticsViewerColumn1Title "Function Name"
#define GD_STR_StateChangeStatisticsViewerColumn2Title "# of Calls"
#define GD_STR_StateChangeStatisticsViewerColumn3Title "# of Effective Calls"
#define GD_STR_StateChangeStatisticsViewerColumn4Title "# of Redundant Calls"
#define GD_STR_StateChangeStatisticsViewerColumn5Title "% of Redundant Calls"
#define GD_STR_StateChangeStatisticsViewerNonAnalyzeMode L"More data is available in Analyze Mode"
#define GD_STR_StateChangeStatisticsViewerNonAnalyzeModeA "More data is available in Analyze Mode"
#define GD_STR_contextExportStateChangeStatistics L"&Export State Change Statistics..."
#define GD_STR_contextExportDeprecationStatistics L"&Export Deprecation Statistics..."
#define GD_STR_StateChangeStatisticsViewerFindDialogTitle L"Find in the State Change Statistics view"
#define GD_STR_DeprecationStatisticsViewerFindDialogTitle L"Find in the Deprecation Statistics view"

// Deprecation statistics item viewer:
#define GD_STR_DeprecationStatisticsViewerColumn1Title "Function Name"
#define GD_STR_DeprecationStatisticsViewerColumn2Title "Deprecation Reason"
#define GD_STR_DeprecationStatisticsViewerColumn3Title "# of Calls"
#define GD_STR_DeprecationStatisticsViewerColumn4Title "% of Calls"
#define GD_STR_DeprecationStatisticsViewerColumn5Title "Deprecated at Version"
#define GD_STR_DeprecationStatisticsViewerColumn6Title "Removed at Version"

// Batch statistics viewer:
#define GD_STR_BatchStatisticsViewerFileDescription L" Batch Statistics information\n"
#define GD_STR_BatchStatisticsViewerColumn1Title "Vertices per Batch"
#define GD_STR_BatchStatisticsViewerColumn2Title "# of Batches"
#define GD_STR_BatchStatisticsViewerColumn3Title "% of Batches"
#define GD_STR_BatchStatisticsViewerColumn4Title "# of Vertices"
#define GD_STR_BatchStatisticsViewerColumn5Title "% of Vertices"

#define GD_STR_BatchStatisticsViewerItemTooltip1 L"%ls - %ls Vertices/Batch: %.2f%%"
#define GD_STR_BatchStatisticsViewerItemTooltip2 L"%ls Vertices/Batch: %.2f%%"
#define GD_STR_BatchStatisticsViewerOnlyGLContexts "This view information is available only when an OpenGL context is selected"

// Based statistics view strings:
#define GD_STR_StatisticsViewerExportStatistics "&Export %1 Statistics..."
#define GD_STR_saveStatisticsFileName L"%lsStatisticsData"
#define GD_STR_StatisticsViewerFileDescription L" %ls Statistics information\n"
#define GD_STR_StatisticsFindDialogTitle L"Find in the %ls Statistics view"

// Select iPhone application dialog:
#define GD_STR_SelectIPhoneAppDialogTitle L"Select iPhone / iPad application"
#define GD_STR_SelectIPhoneAppDialogDescription L"Please select the application you would like to debug"
#define GD_STR_SelectIPhoneAppDialogListColumnName L"iPhone / iPad applications"
#define GD_STR_SelectIPhoneAppDialogManualButton L"Manual Selection"
#define GD_STR_SelectIPhoneAppDialogManualButtonToolTip L"Manually select an iPhone Simulator .app bundle from its build directory. This is usually \"build/Debug-iphonesimulator/YourAppName.app\" under the location of the .xcodeproj file."
#define GD_STR_SelectIPhoneAppDialogManualSelectionDialogTitle L"Manually select iPhone Simulator application"

// Start debugging command:
#define GD_STR_StartDebuggingExeFileDoesNotExist "The executable file does not exist.\nSee the \"Debug settings\" dialog: \"Executable for debug session\" field."
#define GD_STR_StartDebuggingXcodeprojFileDoesNotExist "The Xcode project file does not exist or is not a valid Xcode project.\nSee the \"Debug settings\" dialog: \"Xcode project for debug session\" field."
#define GD_STR_StartDebuggingWorkingFolderDoesNotExist "The working directory does not exist.\nSee the \"Debug settings\" dialog: \"Working directory\" field."
#define GD_STR_StartDebuggingLogDirDoesNotExist "The log files directory does not exist or is not writable.\nSee the \"Global Settings\" dialog, \"Logging\" tab."
#define GD_STR_StartDebuggingRemotePortsIllegal "One or more of the remote debugging ports are not defined.\nPlease set these ports to non-zero, distinct values\nor uncheck the \"Remote Target\" checkbox in the General settings"
#define GD_STR_StartDebuggingRemotePortsNotDistinct "Some of the remote debugging ports have the same number.\nPlease set these ports to non-zero, distinct values (Tools->Options->General),\nor uncheck the \"Remote Target\" checkbox in the General settings"
#define GD_STR_StartDebuggingFrameTerminatorsDoesNotExist "The \"Frame Terminators\" are not defined.\nSee the \"Debug Settings\" dialog."
#define GD_STR_iPhoneSimulatorIsNotInstalled "The iPhone Simulator application is not installed on the local computer.\nPlease install the iPhone SDK on the local computer to enable iPhone / iPad applications debugging."
#define GD_STR_InvalidiPhoneSimulatorSDK "The iPhone Simulator SDK path supplied doesn't exist.\n(%ls)\nPlease select a valid iPhone Simulator SDK in the Debug Settings dialog."
#define GD_STR_InvalidRemoteConnectionSettings "The remote connection IP address is invalid or the API and Events ports are identical.\nPlease select valid remote connection settings in the Debug Settings dialog."
#define GD_STR_RemoteConnectionSettingsDontWork "The remote connection IP address and ports cannot be used by this computer to listen to TCP connections.\nPlease select an IP address and two ports that can be used by this computer and are not blocked by a firewall or similar limitations."
#define GD_STR_WindowsSupportedBinaryTypes "CodeXL does not support running %ls binaries.\nPlease select a 32-bit or 64-bit Windows binary to continue."
#define GD_STR_missingSystemLibrariesPrefix "The following system libraries are missing: "
#define GD_STR_missingSystemLibrariesLinuxSuffix "Please ask your system administrator to install the missing libraries or create symbolic links from the above paths to the place where the libraries are installed."
#define GD_STR_missingSystemLibrariesDefaultSuffix "Please ask your system administrator to install the missing libraries."
#define GD_STR_missingSystemLibrariesLibOpenCL L"libOpenCL"
#define GD_STR_missingSystemLibrariesLibOpenGL L"libGL"
#define GD_STR_missingSystemLibrariesAdditionalInfo "\nOne of the following actions may remedy the situation:\n1: The libraries are missing and you need to ask your system administrator to install the missing libraries\n2: LIBGL_DRIVERS_PATH does not contain the path to a subdirectory where the library is installed\n3: If CodeXL is executed with sudo, use: sudo LIBGL_DRIVERS_PATH='subdirectory to install dir' CodeXL or fix sudoer file"
#define GD_STR_debugging64bitAppsOnLinuxError "The application selected for debug is a 64-bit application.\nThis version of CodeXL only supports debugging 32-bit applications."
#define GD_STR_debugging32bitAppsOnLinuxError "The application selected for debug is a 32-bit application.\nThis version of CodeXL only supports debugging 64-bit applications."

// OpenCL Command Queues viewer:
#define GD_STR_CommandQueuesViewerTitle L"OpenCL Command Queues Viewer"
#define GD_STR_CommandQueuesViewerListCaption "Command Queue Details"
#define GD_STR_CommandQueuesViewerCommandsListCommandTimeTitle "Duration (ms)"
#define GD_STR_CommandQueuesViewerCommandsListCommandNameTitle "Command Name"
#define GD_STR_CommandQueuesViewerCommandsListCommandParametersTitle "Parameters"
#define GD_STR_CommandQueuesViewerCommandsListAccumulatedTimeTitle "Accumulated Time (ms)"
#define GD_STR_CommandQueuesViewerCommandsListWaitedForSubmitTitle "Wait for Submit (ms)"
#define GD_STR_CommandQueuesViewerCommandsListWaitedForExecutionTitle "Wait for Execution (ms)"
#define GD_STR_CommandQueuesViewerExportCommandQueuesInformation "Export Command Queues information\n"
#define GD_STR_CommandQueuesViewerQueuesTreeCaption L"Command Queues"
#define GD_STR_CommandQueuesViewerCommandsListCaption L"Enqueued Commands"
#define GD_STR_CommandQueuesViewerGraphView L"Graph View"
#define GD_STR_CommandQueuesViewerRealtimeGraphView L"Realtime Graph View"
#define GD_STR_CommandQueuesViewerPropertiesView L"Properties View"
#define GD_STR_CommandQueuesViewerCommandDeviceName L"Device %d"
#define GD_STR_CommandQueuesViewerCommandQueueNameWithContext L"Context %d - Queue %d"
#define GD_STR_CommandQueuesViewerCommandQueueLabel L"Device %d C%d Q%d"
#define GD_STR_CommandQueuesViewerCommandsListCommandParameterKernelLong L"P%d Kernel %d"
#define GD_STR_CommandQueuesViewerCommandsListCommandParameterKernelShort L"P%d Kern %d"
#define GD_STR_CommandQueuesViewerCommandsListCommandParameterBufferLong L"Buffer %d"
#define GD_STR_CommandQueuesViewerCommandsListCommandParameterBufferShort L"Buf %d"
#define GD_STR_CommandQueuesViewerCommandsListCommandParameterImageLong L"Image %d"
#define GD_STR_CommandQueuesViewerCommandsListCommandParameterImageShort L"Img %d"
#define GD_STR_CommandQueuesViewerFileQuit L"&Quit\t" GD_STR_keyboardShortcutQuitMenu
#define GD_STR_CommandQueuesViewerViewCallsStackView L"&Call Stack View"
#define GD_STR_CommandQueuesViewerViewGraphView L"&Graph View"
#define GD_STR_CommandQueuesViewerMessageQueueEmpty L"No commands were enqueued since the last debug process suspension."
#define GD_STR_CommandQueuesViewerMessageSelectAQueue L"Select a command queue to view its enqueued commands."
#define GD_STR_CommandQueuesViewerMessageNoQueues L"There are no queues associated with the selected device."
#define GD_STR_CommandQueuesViewerMessageQueueDataFail L"Could not get command queue data."
#define GD_STR_CommandQueuesViewerMessageNonOpenCLProject L"Queues are only available in OpenCL projects."
#define GD_STR_CommandQueuesViewerMessageDataAvailableInBreak L"Queues information is only displayed when the debugged process has been suspended."
#define GD_STR_CommandQueuesViewerSaveCommandQueueFileName L"Context%d-Queue%dInformation"
#define GD_STR_CommandQueuesViewerFileDescription L"Context %d - Command Queue %d information\n"
#define GD_STR_CommandQueuesViewerExportCommandQueuesInformationStatusbarString L"Save the command queues information to a CSV file"

// Export device server libraries:
#define GD_STR_ExportDeviceServerLibrariesDialogExportSettingsTitle L"Please choose a directory for the on-device server libraries to be exported.\nAdding these libraries to your project is required in order to use CodeXL."
#define GD_STR_ExportDeviceServerLibrariesDialogSettingsTargetDir L"Target Directory"
#define GD_STR_ExportDeviceServerLibrariesDialogSettingsChooseTargetDirDialogTitle L"Choose Target Directory"
#define GD_STR_ExportDeviceServerLibrariesDialogSettingsOverwrite L"Overwrite existing files"
#define GD_STR_ExportDeviceServerLibrariesDialogSettingsCreateSubDirectory L"Export to a subdirectory named \"%ls\""
#define GD_STR_ExportDeviceServerLibrariesDialogCreateNewDirPrompt L"The directory '%ls' does not exist.\nWould you like to create a new directory?"
#define GD_STR_ExportDeviceServerLibrariesDialogCreateNewDirTitle L"Create new directory"
#define GD_STR_ExportDeviceServerLibrariesDialogCreateNewDirFailed L"Could not create directory %ls."
#define GD_STR_ExportDeviceServerLibrariesDialogCreateNewDirFailedTitle L"Directory creation failed"
// iPhone / iPad on-device:
#define GD_STR_ExportDeviceServerLibrariesDialogiPhoneTitle L"Export iPhone / iPad on-device server libraries"
#define GD_STR_ExportDeviceServerLibrariesDialogiPhoneDefaultSubDirectory L"GRemedyiPhoneDeviceServers"
#if AMDT_BUILD_CONFIGURATION == AMDT_RELEASE_BUILD
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary1 L"libGRBaseToolsESDevice.dylib"
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary2 L"libGROSWrappersESDevice.dylib"
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary3 L"libGRAPIClassesESDevice.dylib"
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary4 L"libGRSpiesUtilitiesESDevice.dylib"
#elif AMDT_BUILD_CONFIGURATION == AMDT_DEBUG_BUILD
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary1 L"libGRBaseToolsESDevice_d.dylib"
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary2 L"libGROSWrappersESDevice_d.dylib"
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary3 L"libGRAPIClassesESDevice_d.dylib"
    #define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary4 L"libGRSpiesUtilitiesESDevice_d.dylib"
#else
    #error Unknown build configuration!
#endif
#define GD_STR_ExportDeviceServerLibrariesCommandiPhoneLibrary5 L"spies/libGROpenGLESDeviceServer.dylib"
#define GD_STR_ExportDeviceServerLibrariesCommandiPhoneReadme L"../" OS_STR_CodeXLMacBundleResourcesDirName L"/CodeXL_iPhone_on-device_readme.html"
#define GD_STR_ExportDeviceServerLibrariesCommandiPhoneReadmeImage1 L"../" OS_STR_CodeXLMacBundleResourcesDirName L"/CodeXL_iPhone_on-device_readme-step_7.png"
#define GD_STR_ExportDeviceServerLibrariesCommandiPhoneReadmeImage2 L"../" OS_STR_CodeXLMacBundleResourcesDirName L"/CodeXL_iPhone_on-device_readme-step_8.png"
#define GD_STR_ExportDeviceServerLibrariesCommandiPhoneReadmeImage3 L"../" OS_STR_CodeXLMacBundleResourcesDirName L"/CodeXL_iPhone_on-device_readme-step_9.png"
#define GD_STR_ExportDeviceServerLibrariesCommandCouldNotCopy L"Could not copy device server library \"%ls\" to \"%ls\"."
#define GD_STR_ExportDeviceServerLibrariesCommandCopySuccessMsg L"Device server libraries exported successfully to \"%ls\"."
#define GD_STR_ExportDeviceServerLibrariesCommandCopyErrorMsg L"Problem copying device server libraries"

// Context debug flag:
#define GD_STR_DebugBitForcedOn L"One of the application contexts was created with the debug flag on in its context flags attribute.\nSince debug context mode reduces performance, it is recommended to restart the application in CodeXL's Profile mode."
#define GD_STR_DebugBitForcedOff L"One of the application contexts was created with debug flag off in its context flags attribute, in order to increase performance in Profile mode.\nIn order to enable debug context functionality, please restart the application in CodeXL's Debug or Analyze mode."

// Item identification:
#define GD_STR_ItemIDUnknown L"Unknown item"
#define GD_STR_AppRoot L"Application Root"
#define GD_STR_GLContext L"GL Context"
#define GD_STR_GLTextures L"Textures"
#define GD_STR_GLTexture L"Texture"
#define GD_STR_GLRenderBuffers L"Render Buffers"
#define GD_STR_GLRenderBuffer L"Render Buffer"
#define GD_STR_GLStaticBuffers L"Static Buffers"
#define GD_STR_GLStaticBuffer L"Static Buffer"
#define GD_STR_GLAllPBuffers L"All PBuffers"
#define GD_STR_GLPBuffers L"PBuffers"
#define GD_STR_GLPBuffer L"PBuffer"
#define GD_STR_GLPBufferStaticBuffer L"PBuffer Static Buffer"
#define GD_STR_GLSyncs L"Sync Objects"
#define GD_STR_GLSync L"Sync"
#define GD_STR_GLVBOs L"GL Buffers"
#define GD_STR_GLVBO L"GL Buffer"
#define GD_STR_Programs L"Programs"
#define GD_STR_Program L"Program"
#define GD_STR_GLShaders L"Shaders"
#define GD_STR_GLVertexShader L"Vertex Shader"
#define GD_STR_GLGeometryShader L"Geometry Shader"
#define GD_STR_GLFragmentShader L"Fragment Shader"
#define GD_STR_GLDisplayLists L"Display Lists"
#define GD_STR_GLDisplayList L"Display List"
#define GD_STR_GLFBOs L"FBOs"
#define GD_STR_GLFBO L"FBO"
#define GD_STR_GLFBOAttachment L"FBO Attachemnt"
#define GD_STR_CLContext L"CL Context"
#define GD_STR_CLImages L"CL Images"
#define GD_STR_CLImage L"CL Image"
#define GD_STR_CLBuffers L"CL Buffers"
#define GD_STR_CLBuffer L"CL Buffer"
#define GD_STR_CLSubBuffer L"CL Sub Buffer"
#define GD_STR_CLSamplers L"CL Samplers"
#define GD_STR_CLSampler L"CL Sampler"
#define GD_STR_CLEvents L"CL Events"
#define GD_STR_CLEvent L"CL Event"
#define GD_STR_CLCommandQueues L"CL Command Queues"
#define GD_STR_CLCommandQueue L"CL Command Queue"
#define GD_STR_CLDevice L"CL Device"
#define GD_STR_CLKernel L"Kernel"
#define GD_STR_CLKernelVariable L"Kernel variable"

// Application Toolbars:
#define GD_STR_ExecutionModeToolbarString L"ExecutionMode"
#define GD_STR_EditToolbarString L"Edit"

// gdBreakpointsView:
#define GD_STR_breakpintsViewNameColumnCaption "Name"
#define GD_STR_breakpintsViewDelete "Delete"
#define GD_STR_breakpointsViewDoubleClickToAdd "Double-click to add or remove breakpoints..."
#define GD_STR_breakpintsViewOpenDialog "Add / Remove Breakpoints..."
#define GD_STR_KernelFunctionNameBreakpointPrefix L"OpenCL Kernel: "
#define GD_STR_HSAKernelFunctionNameBreakpointPrefix L"HSA Kernel: "

// Locals / watch views:
#define GD_STR_localsViewNameColumnHeader "Name"
#define GD_STR_localsViewValueColumnHeader "Value"
#define GD_STR_localsViewTypeColumnHeader "Type"
#define GD_STR_watchViewNewWatchExpressionItem "Type watch expression name"
#define GD_STR_watchViewCannotEvaluateExpression L"Cannot evaluate expression"
#define GD_STR_variableTypeFloat L"float"
#define GD_STR_variableTypeDouble L"double"

// debug mode
#define GD_STR_executionMode L"Debug Mode"
#define GD_STR_executionModeAction L"Debugging"
#define GD_STR_executionModeVerb L"debug"
#define GD_STR_executionModeDescription L"Perform API-level debugging of OpenGL and OpenCL and <br>kernel debugging for OpenCL kernels running on AMD GPUs."
#define GD_STR_executionSesionType L"Debug"
#define GD_STR_executionStartButton L"Host+GPU Debug"

// Project settings extension:
#define GD_STR_projectSettingsExtensionName L"GPUDebug"
#define GD_STR_projectSettingsExtensionNameASCII "GPUDebug"
#define GD_STR_projectSettingsExtensionDisplayName L"Debug"
#define GD_STR_projectSettingsGLFrameTerminators "OpenGL Frame Terminators"
#define GD_STR_projectSettingsGLFrameTerminatorsTooltip "OpenGL Frame Terminators will be used to perform a frame step while debugging the application"
#define GD_STR_projectSettingsCLFrameTerminators "OpenCL Frame Terminators"
#define GD_STR_projectSettingsCLFrameTerminatorsTooltip "OpenCL Frame Terminators will be used to perform a frame step while debugging the application"
#define GD_STR_projectSettingsHSASettings "HSA Settings"
#define GD_STR_projectSettingsAddBreakpoints "Add / Remove Breakpoints..."
#define GD_STR_projectSettingsAddBreakpointsTooltip "Click to select API functions, Kernel functions and Generic breakpoint for the debugged application"

// Frame terminators:
#define GD_STR_DebugSettingsGlFlush "glF&lush"
#define GD_STR_DebugSettingsSwapBuffers "&SwapBuffers"
#define GD_STR_DebugSettingsSwapBuffersLinux "glX&SwapBuffers"
#define GD_STR_DebugSettingsGlFinish "gl&Finish"
#define GD_STR_DebugSettingsSwapLayerBuffers "SwapLayer&Buffers"
#define GD_STR_DebugSettingsGlClear "glClea&r"
#if (AMDT_BUILD_TARGET == AMDT_WINDOWS_OS)
    #define GD_STR_DebugSettingsMakeCurrent "wgl&MakeCurrent"
#else
    #define GD_STR_DebugSettingsMakeCurrent "glX&MakeCurrent / glXMakeContextCurrent"
#endif
#define GD_STR_DebugSettingsGlFrameTerminatorGREMEDY "glFrame&TerminatorGREMEDY"
#define GD_STR_DebugSettingsCl_gremedy_computation_frameCheckbox "cl_gremedy_com&putation_frame"
#define GD_STR_DebugSettingsClFlush "clFl&ush"
#define GD_STR_DebugSettingsClFinish "clF&inish"
#define GD_STR_DebugSettingsClWaitForEvents "cl&WaitForEvents"
#define GD_STR_DebugSettingsInvalidFrameTerminator L"At least one OpenGL frame terminator should be selected"
#define GD_STR_DebugSettingsDebugHSAKernels "Debug &HSA kernels (requires HSA driver)"

#endif  // __GDSTRINGCONSTANTS


