//==================================================================================
// Copyright (c) 2016 , Advanced Micro Devices, Inc.  All rights reserved.
//
/// \author AMD Developer Tools Team
/// \file gdHTMLStringConstants.h
///
//==================================================================================

//------------------------------ gdHTMLStringConstants.h ------------------------------

#ifndef __GDHTMLSTRINGCONSTANTS
#define __GDHTMLSTRINGCONSTANTS


// Link types characters:
#define GD_STR_HtmlPropertiesGLPrefix L"gl"
#define GD_STR_HtmlPropertiesCLPrefix L"cl"
#define GD_STR_HtmlPropertiesGLContextLink L"glcontext"
#define GD_STR_HtmlPropertiesCLContextLink L"clcontext"
#define GD_STR_HtmlPropertiesGLTextureLink L"gltexture"
#define GD_STR_HtmlPropertiesGLTexturesThumbnailLink L"gltexturesthumb"
#define GD_STR_HtmlPropertiesGLStaticBufferLink L"glstaticbuffer"
#define GD_STR_HtmlPropertiesGLStaticBuffersThumbnailLink L"glstaticbuffersthumb"
#define GD_STR_HtmlPropertiesGLPBufferLink L"glpbuffer"
#define GD_STR_HtmlPropertiesGLPBufferStaticBufferLink L"glpbufferstaticbuffer"
#define GD_STR_HtmlPropertiesGLProgramLink L"glprogram"
#define GD_STR_HtmlPropertiesGLVertexShaderLink L"glvertexshader"
#define GD_STR_HtmlPropertiesGLTessellationControlShaderLink L"gltessctrlshader"
#define GD_STR_HtmlPropertiesGLTessellationEvaluationShaderLink L"gltessevalshader"
#define GD_STR_HtmlPropertiesGLGeometryShaderLink L"glgeometryshader"
#define GD_STR_HtmlPropertiesGLFragmentShaderLink L"glfragmentshader"
#define GD_STR_HtmlPropertiesGLComputeShaderLink L"glcomputeshader"
#define GD_STR_HtmlPropertiesGLUnsupportedShaderLink L"glshader"
#define GD_STR_HtmlPropertiesGLRenderBufferLink L"glrenderbuffer"
#define GD_STR_HtmlPropertiesGLRenderBuffersThumbnailLink L"glrenderbuffersthumb"
#define GD_STR_HtmlPropertiesGLFBOLink L"glfbo"
#define GD_STR_HtmlPropertiesGLFBOsThumbnailLink L"glfbothumb"
#define GD_STR_HtmlPropertiesGLVBOLink L"glvbo"
#define GD_STR_HtmlPropertiesGLVBOsThumbnailLink L"glvbothumb"
#define GD_STR_HtmlPropertiesCLBufferLink L"clbuffer"
#define GD_STR_HtmlPropertiesCLSubBufferLink L"clsubbuffer"
#define GD_STR_HtmlPropertiesCLBuffersThumbnailLink L"clbuffersthumb"
#define GD_STR_HtmlPropertiesCLImageLink L"climage"
#define GD_STR_HtmlPropertiesCLImageThumbnailsLink L"climagesthumb"
#define GD_STR_HtmlPropertiesCLPipeLink L"clpipe"
#define GD_STR_HtmlPropertiesCLProgramLink L"clprogram"
#define GD_STR_HtmlPropertiesCLPlatformLink L"clplatform"
#define GD_STR_HtmlPropertiesCLKernelLink L"clkernel"
#define GD_STR_HtmlPropertiesCLDeviceLink L"cldevice"
#define GD_STR_HtmlPropertiesCLEventLink L"clevent"
#define GD_STR_HtmlPropertiesCLSamplerLink L"clsampler"
#define GD_STR_HtmlPropertiesLinkEnd L"</a>"

#define GD_STR_HtmlPropertiesGLContextFullLink L"<A href=glcontext-%d>GL %d</A>"
#define GD_STR_HtmlPropertiesCLContextFullLink L"<A href=clcontext-%d>CL %d</A>"

// Function types:
#define GD_STR_HtmlPropertiesGetFunctions L"Functions that retrieve data from %ls are considered <B>Get functions</B><BR /><BR />"
#define GD_STR_HtmlPropertiesDrawFunctions L"Functions that may have a visible effect on the draw buffer are considered <B>Draw functions</B>. Such functions may be functions that draw primitives, functions that draw raster data and functions that clear render buffers data."
#define GD_STR_HtmlPropertiesRasterFunctions L"Functions that copy or read pixels to or from frame buffers are considered <B>Raster functions</B>."
#define GD_STR_HtmlPropertiesProgramsAndShadersFunctions L"Functions that create, delete or manipulate the parameters of shaders and shading programs are considered <B>Program and Shaders functions</B>"
#define GD_STR_HtmlPropertiesProgramsAndKernelsFunctions L"Functions that create, delete or manipulate the parameters of kernels computation programs and kernels are considered <B>Program and Kernels functions</B>"
#define GD_STR_HtmlPropertiesTextureFunctions L"Functions that create textures, delete them or manipulate their parameters are considered <B>Texture functions</B>."
#define GD_STR_HtmlPropertiesMatrixFunctions L"Functions that manipulate the OpenGL matrices (model view matrix, projection matrix, color matrix, etc.) are considered <B>Matrix functions</B>."
#define GD_STR_HtmlPropertiesNameFunctions L"Functions related to OpenGL selection mode are considered <B>Name functions</B>. These functions establish a buffer for selection mode values or manipulate the name stack."
#define GD_STR_HtmlPropertiesQueryFunctions L"Functions related to OpenGL query objects are considered <B>Query functions</B>."
#define GD_STR_HtmlPropertiesBufferFunctions L"Functions related to OpenGL buffer objects are considered <B>Buffer functions</B>."
#define GD_STR_HtmlPropertiesBufferImageFunctions L"Functions related to OpenCL buffer and image objects are considered <B>Buffer and Image functions</B>."
#define GD_STR_HtmlPropertiesDeprecatedFunctions L"Functions deprecated from OpenGL. See Deprecated functions tab to view more details.</B>."
#define GD_STR_HtmlPropertiesStateChangeFunctions L"An OpenGL render context is a huge state machine. OpenGL offers many commands that manipulate state variable values. Such functions are considered <B>State Change functions</B>."
#define GD_STR_HtmlPropertiesQueueFunctions L"Functions related to OpenCL command queue objects are considered <B>Queue functions</B>."
#define GD_STR_HtmlPropertiesSyncFunctions L"Functions performing synchronization operations are considered <B>Synchronization functions</B>."
#define GD_STR_HtmlPropertiesFeedbackFunctions L"Functions related to OpenGL tranform feedback objects are considered <B>Feedback functions</B>."
#define GD_STR_HtmlPropertiesVertexArrayFunctions L"Functions related to OpenGL vertex array objects are considered <B>Vertex Array functions</B>."
#define GD_STR_HtmlPropertiesDebugFunctions L"Functions that are related to debug contexts and functionality are considered <B>Debug functions</B>."
#define GD_STR_HtmlPropertiesCLNullContextFunctions L"OpenCL Functions that can be executed with no associated context are considered <B>CL No Context functions</B>."
#define GD_STR_HtmlPropertiesGLNullContextFunctions L"OpenGL Functions that can be executed when there is no active render context are considered <B>GL No Context functions</B>."
#define GD_STR_HtmlPropertiesGLContextBoundFunctions L"OpenGL Functions that can only be executed when there is an active render context are considered <B>OpenGL Context-Bound functions</B>."
#define GD_STR_HtmlPropertiesCLContextBoundFunctions L"OpenCL Functions that can only be executed with an associated context are considered <B>OpenCL Context-Bound functions</B>."
#define GD_STR_HtmlPropertiesGetIsFunctions L"Using \"Get\" or \"Is\" functions slows down render performance. These commands force the graphic system to execute all queued OpenGL calls before it can answer the \"Get\" or \"Is\" query.<BR /><BR />"
#define GD_STR_HtmlPropertiesContextBoundFunctionsWarning L"Using Context-bound functions when there is no associated context is an eror.<BR />Use the Function Calls History view and select \"No Context\" to locate the context-bound function calls that were executed while there was no associated context.<BR />"
#define GD_STR_HtmlPropertiesGetIsFunctionsFunctionsAlternative L"Instead, consider caching relevant state variable values inside your application's code."
#define GD_STR_HtmlPropertiesInitializationGetFunctions L"Using \"Get\" or \"Is\" functions slows down render performance. These commands force the graphic system to execute all queued OpenGL calls before it can answer the \"Get\" or \"Is\" query.<BR /><BR />Some get functions such as this one are necessary, but only during the initialization of the OpenGL application.<BR /><BR />"
#define GD_STR_HtmlPropertiesInitializationGetFunctionsAlternative L"Avoid using these get functions outside the application initialization."
#define GD_STR_HtmlPropertiesglBeginglEnd L"Immediate mode rendering (glBegin-glEnd blocks) is considered an inefficient way to push primitive data into the graphic system. This mode requires making a large amount of function calls for describing the primitives' data.<BR /><BR />"
#define GD_STR_HtmlPropertiesglBeginglEndAlternative L"Instead, consider using VBOs (Vertex Buffer Objects) or Vertex Arrays, which enable pushing large data chunks at once."
#define GD_STR_HtmlPropertiesglGetError L"Using glGetError and similar functions slows down render performance and are unneeded for purposes other than testing.<BR /><BR />"
#define GD_STR_HtmlPropertiesglGetErrorAlternative L"Instead, use CodeXL's \"Break on OpenGL error\" feature (or the Shaders and Kernels' Source Code editor in case of Shader debugging)."
#define GD_STR_HtmlPropertiesglFinish L"Calling glFinish blocks your application's execution until all queued OpenGL calls are executed completely. This stops your application from running in parallel on the CPU while the GPU executes queued OpenGL calls, which slows down render performance.<BR /><BR />"
#define GD_STR_HtmlPropertiesglFinishAlternative L"Instead, consider using wglSwapBuffers, glXSwapBuffers, aglSwapBuffers, CGLFlushDrawable or eglSwapBuffers."
#define GD_STR_HtmlPropertiesglFlush L"Calling glFlush is usually redundant since wglSwapBuffers, glXSwapBuffers, aglSwapBuffers, CGLFlushDrawable and eglSwapBuffers execute all queued OpenGL calls before the buffer is presented to the user.<BR /><BR />"
#define GD_STR_HtmlPropertiesglFlushAlternative L"Consider using glFlush only when rendering directly into the front buffer or when rendering into a non-double-buffered buffer"
#define GD_STR_HtmlPropertiesglReadPixels L"glReadPixels reads a block of pixels from the frame buffer. This is considered a heavy operation (performance-wise)."
#define GD_STR_HtmlPropertiesglReadPixelsAlternative L"Instead, consider using a PBuffer or a render buffer."
#define GD_STR_HtmlPropertiesglGetPixelMap L"glGetPixelMap returns a specified pixel map. This is considered a heavy operation (performance-wise)."
#define GD_STR_HtmlPropertiesglGetPixelMapAlternative L"Instead, consider using a PBuffer or a render buffer."
#define GD_STR_HtmlPropertiesglGetShaderSource L"glGetShaderSource returns the source code string from a shader object. This is considered a heavy operation (performance-wise)."
#define GD_STR_HtmlPropertiesglGetShaderSourceAlternative L"Instead, consider caching the shader source code in your application or a file, or using CodeXL's Shaders and Kernels' Source Code editor."
#define GD_STR_HtmlPropertiesglGetTexImage L"glGetTexImage return a texture image. This is considered a heavy operation (performance-wise)."
#define GD_STR_HtmlPropertiesRedundantDefaultComment L"<B>State Change Statistics</B><BR /><BR />"
#define GD_STR_HtmlPropertiesRedundantNoWarning L"<B>This function has no redundant calls</B><BR /><BR />"
#define GD_STR_HtmlPropertiesRedundantYellowWarning L"<B><TABLE cellpadding=0 cellspacing=0><TR><TD>This function has a&nbsp;</TD><TD bgcolor=%ls>low</TD><TD>&nbsp;percentage of redundant calls</TD></TR></TABLE></B><BR /><BR />"
#define GD_STR_HtmlPropertiesRedundantOrangeWarning L"<B><TABLE cellpadding=0 cellspacing=0><TR><TD>This function has a&nbsp;</TD><TD bgcolor=%ls>high</TD><TD>&nbsp;percentage of redundant calls</TD></TR></TABLE></B><BR /><BR />"
#define GD_STR_HtmlPropertiesRedundantRedWarning L"<B><TABLE cellpadding=0 cellspacing=0><TR><TD>This function has a&nbsp;</TD><TD bgcolor=%ls>very high</TD><TD>&nbsp;percentage of redundant calls</TD></TR></TABLE></B><BR /><BR />"
#define GD_STR_HtmlPropertiesDeprecatedFunctionName L"<B>%ls</B><BR /><BR />"
#define GD_STR_HtmlPropertiesArgValueDeprecatedFunctionDepscription1 L"The function <b>%ls</b> was called with a deprecated argument value. This function behaviour is deprecated in OpenGL version %ls and is removed from OpenGL at version %ls."
#define GD_STR_HtmlPropertiesArgValueDeprecatedFunctionDepscription2 L"The function <b>%ls</b> was called with a deprecated argument value. This function behaviour is deprecated in OpenGL version and will be removed from OpenGL at a future version."
#define GD_STR_HtmlPropertiesArgValueDeprecatedFunctionDepscription3 L"You can execute your application and stop at deprecated functions in order to track the deprecated function arguments.<br>It is recommended to avoid using deprecated functions, as their compatibility with future OpenGL versions is not assured."
#define GD_STR_HtmlPropertiesNonGeneratedDeprecatedFunctionDepscription1 L"The function <b>%ls</b> is using an object that was not generated by an OpenGL function. This function behaviour is deprecated in OpenGL version %ls and is removed from OpenGL at version %ls."
#define GD_STR_HtmlPropertiesNonGeneratedDeprecatedFunctionDepscription2 L"The function <b>%ls</b> is using an object that was not generated by an OpenGL function. This function behaviour is deprecated in OpenGL version %ls and will be removed from OpenGL at a future version."
#define GD_STR_HtmlPropertiesNonGeneratedDeprecatedFunctionDepscription3 L"You can execute your application and stop at deprecated functions in order to track the deprecated function call.<br>It is recommended to avoid using deprecated functions, as their compatibility with future OpenGL versions is not assured."
#define GD_STR_HtmlPropertiesCallsHistoryRedundantSubtitle L"<U>Redundant State Change Function</U>"
#define GD_STR_HtmlPropertiesCallsHistoryGetSubtitle L"<U>Get Function</U>"
#define GD_STR_HtmlPropertiesCallsHistoryDeprecatedSubtitle L"<U>Deprecated Function</U>"
#define GD_STR_HtmlPropertiesCallsHistoryWarningTemplate L"<b><u>%ls</u></b><br><br>"
#define GD_STR_HtmlPropertiesBatchStatisticsTitle L"<B> %ls Vertex Batch</B><BR /><BR />"
#define GD_STR_HtmlPropertiesBatchRangeStatisticsTitle L"<B> %ls - %ls Vertex Batch</B><BR /><BR />"
#define GD_STR_HtmlPropertiesBatchStatisticsDescription L"<B>You draw %.4f%% of your vertices with %.2f%% of your batches</B><BR /><BR />"
#define GD_STR_HtmlPropertiesBatchStatisticsBestPractice L"It is good practice to draw as many vertices using as few batches as possible. Doing so will usually improve the application's rendering performance."
#define GD_STR_HtmlPropertiesRedundantStateChange L"An OpenGL render context is a huge state machine. OpenGL offers many commands that manipulate state variable values. Setting a state variable to the same value it had before the set operation is considered a <B>redundant state change</B>.<BR /><BR />Performing many redundant state changes reduces render performance - redundant state changes are not \"cheap\".<BR /><BR />"
#define GD_STR_HtmlPropertiesRedundantStateChangeAlternative L"Instead, consider caching appropriate state variable values in your application's code to avoid performing redundant state changes. A different approach is to perform <B>state sorting</B>: sort your data according to the states required to render it and set the state variable values required to render each data chunk only once."
#define GD_STR_HtmlPropertiesEffectiveStateChangeFunctions L"An OpenGL render context is a huge state machine. OpenGL offers many commands that manipulate state variable values. Setting a state variable to the same value it had before the set operation is considered a redundant state change. Setting it to a different value than the one it had before is considered an <B>effective state change</B>.<BR /><BR />Performing many state changes may reduce render performance. It is good practice to avoid redundant state changes whenever possible."
#define GD_STR_HtmlPropertiesTotalStatsGeneral L"%ls functions can be divided into many categories by what they operate on and how.<BR /><BR />Note that an %ls function can belong to multiple or none of the these categories."
#define GD_STR_HtmlPropertiesCallsHistoryRedundantTitle L"Redundant state change"

#define GD_STR_HtmlPropertiesBoldUnderLine L"<b><u>%ls</b></u><br><br>"

#endif  // __GDHTMLSTRINGCONSTANTS

