# Radeon™ GPU Profiler

The Radeon GPU Profiler (RGP) is a ground-breaking low-level optimization tool from AMD. It provides detailed timing information on Radeon Graphics using custom, built-in, hardware thread-tracing, allowing the developer deep inspection of GPU workloads.

This unique tool generates easy to understand visualizations of how your DirectX®12 and Vulkan® games interact with the GPU at the hardware level. Profiling a game is both a quick, and simple process using the Radeon Developer Panel and the public display driver.

In order to use the latest features of RGP, it is strongly recommended that users update to the latest driver.


## Getting Started

1. Install the latest AMD Video/display driver.
2. Unzip/Untar the download file. The directory contains the following:
   * Radeon Developer Service (RDS)
   * RadeonDeveloperServiceCLI (RDS headless)
   * Radeon Developer Panel (RDP)
   * Radeon GPU Profiler (RGP)
3. To capture a profile from a game, run the Radeon Developer Panel and follow the instructions in the Help. Help can be found in the following locations:
   * Help web pages exist in the "help" subdirectory
   * Help web pages can be accessed from the **Help** button in the Radeon Developer Panel
   * Help web pages can be accessed from the Welcome screen in the Radeon GPU Profiler, or from the **Help** menu
   * The documentation is hosted publicly at:
     * https://gpuopen.com/manuals/rdp_manual/rdp_manual-index/
     * https://gpuopen.com/manuals/rgp_manual/rgp_manual-index/

## Graphics APIs, RDNA™ hardware, and operating systems
### Supported APIs
 * DirectX12
 * Vulkan

### Supported RDNA hardware
* AMD Radeon RX 9000 series
* AMD Radeon RX 7000 series
* AMD Radeon RX 6000 series
* AMD Radeon RX 5000 series
* AMD Ryzen™ Processors with Radeon Graphics

### Supported Operating Systems
* Windows® 10
* Windows® 11
* Ubuntu 22.04 LTS (Vulkan only)
* Ubuntu 24.04 LTS (Vulkan only)


## Compute APIs, RDNA hardware, and operating systems
### Supported APIs
* OpenCL™
* HIP

### Supported RDNA hardware
* AMD Radeon RX 9000 series
* AMD Radeon RX 7000 series
* AMD Radeon RX 6000 series
* AMD Radeon RX 5000 series
* AMD Ryzen Processors with Radeon Graphics

### Supported Operating Systems
* Windows 10
* Windows 11

