/*
 * Decompiled with CFR 0.152.
 */
package art;

import art.DTrackNetTCP;
import art.DTrackNetUDP;
import art.DTrackParser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTrackSDK
extends DTrackParser
implements AutoCloseable {
    private static final int DTRACK2_PORT_COMMAND = 50105;
    private static final int DTRACK2_PORT_UDPSENDER = 50107;
    private static final int DTRACK2_PORT_FEEDBACK = 50110;
    private static final int DTRACK2_PROT_MAXLEN = 200;
    private static final int DEFAULT_TCP_TIMEOUT = 10000;
    private static final int DEFAULT_UDP_TIMEOUT = 1000;
    private static final int DEFAULT_UDP_BUFSIZE = 32768;
    private int messageErrorId;
    private int messageFrameNr;
    private String messageMsg;
    private String messageOrigin;
    private String messageStatus;
    private int tcpTimeout = 10000;
    private DTrackNetTCP tcp;
    private int udpBufSize = 32768;
    private int udpTimeout = 1000;
    private DTrackNetUDP udp;
    private String udpBuf;
    private InetAddress controllerIP;
    private InetAddress udpSenderIP;
    private int udpSenderPort;
    private Errors lastDataError;
    private Errors lastServerError;
    private int lastDTrackError;
    private String lastDTrackErrorString;
    private Logger log = Logger.getLogger(DTrackSDK.class.getName());

    public DTrackSDK(String string) {
        int n;
        String[] stringArray = string.split(":");
        if (stringArray.length == 0 || stringArray.length > 3) {
            return;
        }
        String string2 = null;
        boolean bl = false;
        if (stringArray.length == 1) {
            n = Integer.parseInt(stringArray[0]);
        } else {
            string2 = stringArray[0];
            n = Integer.parseInt(stringArray[1]);
            if (stringArray.length == 3) {
                if (!stringArray[2].equals("fw")) {
                    return;
                }
                bl = true;
            }
        }
        if (string2 == null) {
            this.init(null, n);
        } else {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                this.log.log(Level.SEVERE, "Can't get IP address", unknownHostException);
                return;
            }
            if (bl) {
                this.init(null, n);
                this.udpSenderIP = inetAddress;
                this.sendStatefulFirewallPacket();
            } else {
                this.init(inetAddress, n);
            }
        }
    }

    public DTrackSDK(int n) {
        this.init(null, n);
    }

    public DTrackSDK(InetAddress inetAddress, int n) {
        this.init(inetAddress, n);
    }

    public DTrackSDK(String string, int n) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.log.log(Level.SEVERE, "Can't get IP address", unknownHostException);
            return;
        }
        this.init(inetAddress, n);
    }

    private void init(InetAddress inetAddress, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (inetAddress != null) {
            if (inetAddress.isMulticastAddress()) {
                bl2 = true;
            } else {
                bl = true;
            }
        }
        Locale.setDefault(Locale.US);
        this.log.setLevel(Level.WARNING);
        this.lastDataError = Errors.ERR_NONE;
        this.lastServerError = Errors.ERR_NONE;
        this.setLastDTrackError();
        this.udp = bl2 ? new DTrackNetUDP(inetAddress, n) : new DTrackNetUDP(n);
        this.udpBuf = null;
        this.udpSenderPort = 50107;
        try {
            if (bl) {
                this.controllerIP = inetAddress;
                this.udpSenderIP = inetAddress;
                if (inetAddress.isReachable(this.tcpTimeout)) {
                    this.tcp = new DTrackNetTCP(this.controllerIP, 50105, this.tcpTimeout);
                    if (!this.tcp.isValid()) {
                        this.tcp = null;
                    }
                }
                this.sendStatefulFirewallPacket();
            }
        }
        catch (IOException iOException) {
            this.log.log(Level.SEVERE, "TCP port on " + this.controllerIP + " is not reachable", iOException);
        }
        this.startFrame();
        this.messageErrorId = 0;
        this.messageFrameNr = 0;
        this.messageMsg = "";
        this.messageOrigin = "";
        this.messageStatus = "";
    }

    public final boolean isValid() {
        if (!this.isDataInterfaceValid()) {
            return false;
        }
        return this.controllerIP == null || this.isCommandInterfaceFullAccess();
    }

    public final boolean isDataInterfaceValid() {
        if (this.udp == null) {
            return false;
        }
        return this.udp.isValid();
    }

    public final int getDataPort() {
        if (this.udp == null) {
            return 0;
        }
        return this.udp.getPort();
    }

    public final boolean isCommandInterfaceValid() {
        if (this.tcp == null) {
            return false;
        }
        return this.tcp.isValid();
    }

    public final boolean isCommandInterfaceFullAccess() {
        if (!this.isCommandInterfaceValid()) {
            return false;
        }
        String string = this.getParam("system", "access");
        return string != null && string.compareTo("full") == 0;
    }

    public boolean setDataTimeoutUS(int n) {
        this.udpTimeout = n <= 0 ? 1000 : n / 1000;
        return true;
    }

    public boolean setCommandTimeoutUS(int n) {
        this.tcpTimeout = n <= 0 ? 10000 : n / 1000;
        return true;
    }

    public boolean setDataBufferSize(int n) {
        if (n <= 0) {
            n = 32768;
        }
        this.udpBufSize = n;
        return true;
    }

    public boolean enableStatefulFirewallConnection(String string) {
        return this.enableStatefulFirewallConnection(string, 50107);
    }

    public boolean enableStatefulFirewallConnection(String string, int n) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.log.log(Level.SEVERE, "Can't get IP address", unknownHostException);
            return false;
        }
        this.udpSenderIP = inetAddress;
        this.udpSenderPort = n;
        this.sendStatefulFirewallPacket();
        return true;
    }

    public boolean receive() {
        this.lastDataError = Errors.ERR_NONE;
        if (!this.isDataInterfaceValid()) {
            this.lastDataError = Errors.ERR_NET;
            return false;
        }
        if (this.udp.isTerminated()) {
            this.udp.start(this.udpTimeout, this.udpBufSize);
        }
        this.startFrame();
        int n = this.udp.receive();
        this.udpBuf = this.udp.getPacketContent();
        if (n <= 0) {
            this.lastDataError = n == -1 ? Errors.ERR_TIMEOUT : Errors.ERR_NET;
            return false;
        }
        if (!this.parse(this.udpBuf)) {
            this.lastDataError = Errors.ERR_PARSE;
            return false;
        }
        this.endFrame();
        return true;
    }

    public boolean processPacket(String string) {
        this.lastDataError = Errors.ERR_NONE;
        this.startFrame();
        if (string != null && !string.isEmpty()) {
            this.lastDataError = Errors.ERR_PARSE;
            return false;
        }
        if (!this.parse(string)) {
            this.lastDataError = Errors.ERR_PARSE;
            return false;
        }
        this.endFrame();
        return true;
    }

    public final String getBuf() {
        return this.udpBuf;
    }

    public final Errors getLastDataError() {
        return this.lastDataError;
    }

    public final Errors getLastServerError() {
        return this.lastServerError;
    }

    public final int getLastDTrackError() {
        return this.lastDTrackError;
    }

    public final String getLastDTrackErrorDescription() {
        return this.lastDTrackErrorString;
    }

    public boolean startMeasurement() {
        int n;
        if (this.isCommandInterfaceValid() && (n = this.sendDTrack2Command("dtrack2 tracking start")) != 1) {
            return false;
        }
        this.sendStatefulFirewallPacket();
        this.udp.start(this.udpTimeout, this.udpBufSize);
        return true;
    }

    public boolean stopMeasurement() {
        int n;
        this.udp.terminate();
        return !this.isCommandInterfaceValid() || (n = this.sendDTrack2Command("dtrack2 tracking stop")) == 1;
    }

    public String getParam(String string, String string2) {
        return this.getParam(string + " " + string2);
    }

    public String getParam(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.sendDTrack2Command("dtrack2 get " + string, stringBuilder);
        if (n != 0) {
            return null;
        }
        if (!stringBuilder.toString().startsWith("dtrack2 set ")) {
            this.lastServerError = Errors.ERR_PARSE;
            return null;
        }
        String string2 = this.stringCmpParameter(stringBuilder.toString().substring(12), string);
        if (string2.isEmpty()) {
            this.lastServerError = Errors.ERR_PARSE;
            return null;
        }
        return string2;
    }

    public boolean setParam(String string, String string2, String string3) {
        return this.setParam(string + " " + string2 + " " + string3);
    }

    public boolean setParam(String string) {
        return this.sendDTrack2Command("dtrack2 set " + string) == 1;
    }

    public boolean getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.sendDTrack2Command("dtrack2 getmsg", stringBuilder);
        if (n != 0) {
            return false;
        }
        String string = stringBuilder.toString();
        if (!string.startsWith("dtrack2 msg ")) {
            return false;
        }
        this.messageStatus = "";
        this.messageMsg = "";
        this.messageOrigin = "";
        this.messageErrorId = 0;
        this.messageFrameNr = 0;
        int n2 = 11;
        int n3 = string.indexOf(32, n2 + 1);
        if (n3 < 0 || n3 <= n2) {
            return false;
        }
        this.messageOrigin = string.substring(n2 + 1, n3);
        n2 = n3;
        if ((n3 = string.indexOf(32, n2 + 1)) < 0 || n3 <= n2) {
            return false;
        }
        this.messageStatus = string.substring(n2 + 1, n3);
        n2 = n3;
        if ((n3 = string.indexOf(32, n2 + 1)) < 0 || n3 <= n2) {
            return false;
        }
        try {
            this.messageFrameNr = Integer.parseInt(string.substring(n2 + 1, n3));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        n2 = string.indexOf(120, n3 + 1);
        n3 = string.indexOf(32, n2 + 1);
        if (n2 < 0 || n3 < 0 || n3 <= n2) {
            return false;
        }
        try {
            this.messageErrorId = Integer.parseUnsignedInt(string.substring(n2 + 1, n3), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        n2 = string.indexOf(34, n3 + 1);
        n3 = string.indexOf(34, n2 + 1);
        if (n2 < 0 || n3 < 0 || n3 <= n2) {
            return false;
        }
        this.messageMsg = string.substring(n2 + 1, n3);
        return true;
    }

    public final int getMessageFrameNr() {
        return this.messageFrameNr;
    }

    public final int getMessageErrorId() {
        return this.messageErrorId;
    }

    public final String getMessageOrigin() {
        return this.messageOrigin;
    }

    public final String getMessageStatus() {
        return this.messageStatus;
    }

    public final String getMessageMsg() {
        return this.messageMsg;
    }

    private String stringCmpParameter(String string, String string2) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (n2 < string2.length()) {
            if (n >= string.length()) {
                return null;
            }
            char c = string2.charAt(n2);
            char c2 = string.charAt(n);
            if (!(bl || c != '0' && c2 != '0')) {
                while (n2 < string2.length() && string2.charAt(n2) == '0') {
                    ++n2;
                }
                while (n < string.length() && string.charAt(n) == '0') {
                    ++n;
                }
                bl = true;
                continue;
            }
            if (c == ' ' || c2 == ' ') {
                while (n2 < string2.length() && string2.charAt(n2) == ' ') {
                    ++n2;
                }
                while (n < string.length() && string.charAt(n) == ' ') {
                    ++n;
                }
                bl = false;
                continue;
            }
            if (c != c2) {
                return null;
            }
            bl = c >= '0' && c <= '9';
            ++n2;
            ++n;
        }
        while (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        return string.substring(n).replaceAll("\u0000", "");
    }

    public int sendDTrack2Command(String string) {
        return this.sendDTrack2Command(string, null);
    }

    public int sendDTrack2Command(String string, StringBuilder stringBuilder) {
        if (!this.isCommandInterfaceValid()) {
            this.lastServerError = Errors.ERR_NET;
            return -9;
        }
        this.lastServerError = Errors.ERR_NONE;
        this.setLastDTrackError();
        if (string.length() > 200) {
            this.lastServerError = Errors.ERR_NET;
            return -3;
        }
        if (!string.endsWith("\u0000")) {
            string = string.concat("\u0000");
        }
        if (this.tcp.send(string, this.tcpTimeout) != 0) {
            this.lastServerError = Errors.ERR_NET;
            return -9;
        }
        int n = this.tcp.receive(200, this.tcpTimeout);
        String string2 = this.tcp.getPacketContent();
        if (n < 0) {
            if (n == -1) {
                this.lastServerError = Errors.ERR_TIMEOUT;
            } else {
                this.lastServerError = Errors.ERR_NET;
                n = -9;
            }
            return n;
        }
        if (string2.startsWith("dtrack2 ok")) {
            return 1;
        }
        if (string2.startsWith("dtrack2 err")) {
            n = 2;
            int n2 = 0;
            String string3 = string2.substring(12);
            int n3 = string3.indexOf(32);
            try {
                n2 = Integer.parseInt(string3.substring(0, n3));
            }
            catch (NumberFormatException numberFormatException) {
                n = -10;
                n2 = -1100;
                this.lastServerError = Errors.ERR_PARSE;
            }
            n3 = string3.indexOf(34, n3 + 1);
            int n4 = string3.indexOf(34, n3 + 1);
            if (n3 >= 0 && n4 > n3) {
                this.setLastDTrackError(n2, string3.substring(n3 + 1, n4));
            } else {
                n = -10;
                this.setLastDTrackError(-1100, "SDK parser error");
                this.lastServerError = Errors.ERR_PARSE;
            }
            return n;
        }
        if (stringBuilder != null) {
            stringBuilder.append(string2.replaceAll("\u0000", ""));
        }
        return 0;
    }

    private void setLastDTrackError() {
        this.setLastDTrackError(0, "");
    }

    private void setLastDTrackError(int n, String string) {
        this.lastDTrackError = n;
        this.lastDTrackErrorString = string;
    }

    private boolean sendStatefulFirewallPacket() {
        if (!this.isDataInterfaceValid()) {
            return false;
        }
        if (this.udpSenderIP == null) {
            return false;
        }
        return this.udp.send(this.udpSenderIP, this.udpSenderPort, "fw4dtsdkj") == 0;
    }

    public boolean tactileFinger(int n, int n2, double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tfb 1 ");
        if (d > 1.0 || d < 0.0) {
            this.log.log(Level.SEVERE, "tactile strength not in range (0.0 - 1.0)");
            return false;
        }
        stringBuilder.append("[").append(n).append(" ").append(n2);
        stringBuilder.append(" 1.0 ").append(d).append("]");
        stringBuilder.append("\u0000");
        return this.sendFeedbackCommand(stringBuilder.toString());
    }

    public boolean tactileHand(int n, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tfb ").append(dArray.length).append(" ");
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > 1.0 || dArray[i] < 0.0) {
                this.log.log(Level.SEVERE, "tactile strength not in range (0.0 - 1.0)");
                return false;
            }
            stringBuilder.append("[").append(n).append(" ").append(i);
            stringBuilder.append(" 1.0 ").append(dArray[i]).append("]");
        }
        stringBuilder.append("\u0000");
        return this.sendFeedbackCommand(stringBuilder.toString());
    }

    public boolean tactileHandOff(int n, int n2) {
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
        }
        return this.tactileHand(n, dArray);
    }

    public boolean flystickBeep(int n, double d, double d2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ffb 1 ");
        stringBuilder.append("[").append(n).append(" ").append((int)d);
        stringBuilder.append(" ").append((int)d2).append(" 0 0][]");
        stringBuilder.append("\u0000");
        return this.sendFeedbackCommand(stringBuilder.toString());
    }

    public boolean flystickVibration(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ffb 1 ");
        stringBuilder.append("[").append(n).append(" 0 0 ").append(n2);
        stringBuilder.append(" 0][]");
        stringBuilder.append("\u0000");
        return this.sendFeedbackCommand(stringBuilder.toString());
    }

    private boolean sendFeedbackCommand(String string) {
        InetAddress inetAddress = this.controllerIP;
        if (inetAddress == null && (inetAddress = this.udp.getRemoteIp()) == null) {
            return false;
        }
        return this.udp.send(inetAddress, 50110, string) == 0;
    }

    public void setLogLevel(Level level) {
        this.log.setLevel(level);
    }

    @Override
    public void close() {
        if (this.udp != null) {
            this.udp.close();
        }
        if (this.tcp != null) {
            this.tcp.close();
        }
    }

    public static enum Errors {
        ERR_NET,
        ERR_NONE,
        ERR_PARSE,
        ERR_TIMEOUT;

    }
}

