/*
 * Decompiled with CFR 0.152.
 */
package art;

import art.DTrackBody;
import art.DTrackCameraStatus;
import art.DTrackFinger;
import art.DTrackFlystick;
import art.DTrackHand;
import art.DTrackHuman;
import art.DTrackInertial;
import art.DTrackJoint;
import art.DTrackMarker;
import art.DTrackMeaRef;
import art.DTrackMeaTool;
import art.DTrackParse;
import art.DTrackSDK;
import art.DTrackStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class DTrackParser {
    private static final String D3 = "ddd";
    private static final String D6 = "dddddd";
    private static final String D9 = "ddddddddd";
    private static final String D21 = "ddddddddddddddddddddd";
    private int actFramecounter = 0;
    private double actTimestamp = -1.0;
    private int actTimestampSec = 0;
    private int actTimestampUsec = 0;
    private int actLatencyUsec = 0;
    private List<DTrackBody> actBody = new ArrayList<DTrackBody>();
    private List<DTrackFlystick> actFlystick = new ArrayList<DTrackFlystick>();
    private List<DTrackHand> actHand = new ArrayList<DTrackHand>();
    private List<DTrackHuman> actHuman = new ArrayList<DTrackHuman>();
    private List<DTrackInertial> actInertial = new ArrayList<DTrackInertial>();
    private List<DTrackMarker> actMarker = new ArrayList<DTrackMarker>();
    private List<DTrackMeaRef> actMearef = new ArrayList<DTrackMeaRef>();
    private List<DTrackMeaTool> actMeatool = new ArrayList<DTrackMeaTool>();
    private boolean actIsStatusAvailable = false;
    private DTrackStatus actStatus;
    private int locNumBodycal;
    private int locNumFlystickOld;
    private int locNumMeatoolOld;
    private int locNumHandcal;
    private Logger log = Logger.getLogger(DTrackSDK.class.getName());

    private static void reducedToFullCov(double[][] dArray, double[] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = i * (i - 1) / 2;
            dArray[i][i] = dArray2[i * n - n2];
            for (int j = i + 1; j < n; ++j) {
                double d = dArray2[i * (n - 1) - n2 + j];
                dArray[j][i] = d;
                dArray[i][j] = d;
            }
        }
    }

    private static void oneToTwoDimRot(double[][] dArray, double[] dArray2) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = dArray2[i + j * 3];
            }
        }
    }

    private void log(String string, ParseError parseError) {
        Object[] objectArray = new String[]{string, parseError.toString()};
        this.log.log(Level.WARNING, "{0}: No {1} found", objectArray);
    }

    protected DTrackParser() {
    }

    protected void startFrame() {
        this.actFramecounter = 0;
        this.actTimestamp = -1.0;
        this.actTimestampSec = 0;
        this.actTimestampUsec = 0;
        this.actLatencyUsec = 0;
        this.locNumHandcal = -1;
        this.locNumBodycal = -1;
        this.locNumMeatoolOld = 0;
        this.locNumFlystickOld = 0;
        this.actIsStatusAvailable = false;
    }

    protected void endFrame() {
        int n;
        if (this.locNumBodycal >= 0 && (n = this.locNumBodycal - this.locNumFlystickOld - this.locNumMeatoolOld) != this.actBody.size()) {
            if (n < this.actBody.size()) {
                this.actBody.subList(n, this.actBody.size()).clear();
            } else {
                while (this.actBody.size() < n) {
                    this.actBody.add(new DTrackBody(this.actBody.size()));
                }
            }
        }
        if (this.locNumHandcal >= 0 && this.locNumHandcal != this.actHand.size()) {
            if (this.locNumHandcal < this.actHand.size()) {
                this.actHand.subList(this.locNumHandcal, this.actHand.size()).clear();
            } else {
                while (this.actHand.size() < this.locNumHandcal) {
                    this.actHand.add(new DTrackHand(this.actHand.size()));
                }
            }
        }
    }

    public final int getFrameCounter() {
        return this.actFramecounter;
    }

    public final double getTimeStamp() {
        return this.actTimestamp;
    }

    public final int getTimeStampSec() {
        return this.actTimestampSec;
    }

    public final int getTimeStampUsec() {
        return this.actTimestampUsec;
    }

    public final int getLatencyUsec() {
        return this.actLatencyUsec;
    }

    public final int getNumBody() {
        return this.actBody.size();
    }

    public final List<DTrackBody> getBody() {
        return this.actBody;
    }

    public final DTrackBody getBody(int n) {
        return this.actBody.get(n);
    }

    public final int getNumFlystick() {
        return this.actFlystick.size();
    }

    public final List<DTrackFlystick> getFlystick() {
        return this.actFlystick;
    }

    public final DTrackFlystick getFlystick(int n) {
        return this.actFlystick.get(n);
    }

    public final int getNumMeaTool() {
        return this.actMeatool.size();
    }

    public final List<DTrackMeaTool> getMeaTool() {
        return this.actMeatool;
    }

    public final DTrackMeaTool getMeaTool(int n) {
        return this.actMeatool.get(n);
    }

    public final int getNumMeaRef() {
        return this.actMearef.size();
    }

    public final List<DTrackMeaRef> getMeaRef() {
        return this.actMearef;
    }

    public final DTrackMeaRef getMeaRef(int n) {
        return this.actMearef.get(n);
    }

    public final int getNumHand() {
        return this.actHand.size();
    }

    public final List<DTrackHand> getHand() {
        return this.actHand;
    }

    public final DTrackHand getHand(int n) {
        return this.actHand.get(n);
    }

    public final int getNumHuman() {
        return this.actHuman.size();
    }

    public final List<DTrackHuman> getHuman() {
        return this.actHuman;
    }

    public final DTrackHuman getHuman(int n) {
        return this.actHuman.get(n);
    }

    public final int getNumInertial() {
        return this.actInertial.size();
    }

    public final List<DTrackInertial> getInertial() {
        return this.actInertial;
    }

    public final DTrackInertial getInertial(int n) {
        return this.actInertial.get(n);
    }

    public final int getNumMarker() {
        return this.actMarker.size();
    }

    public final List<DTrackMarker> getMarker() {
        return this.actMarker;
    }

    public final DTrackMarker getMarker(int n) {
        return this.actMarker.get(n);
    }

    public final boolean isStatusAvailable() {
        return this.actIsStatusAvailable;
    }

    public final DTrackStatus getStatus() {
        return this.actStatus;
    }

    protected boolean parse(String string) {
        if (string == null) {
            return false;
        }
        DTrackParse dTrackParse = new DTrackParse(string);
        do {
            if (this.parseLine(dTrackParse)) continue;
            this.log.log(Level.SEVERE, "Parsing failed");
            return false;
        } while (dTrackParse.nextLine());
        return true;
    }

    private boolean parseLine(DTrackParse dTrackParse) {
        if (!dTrackParse.nextStringword()) {
            return false;
        }
        String string = dTrackParse.getNextStringword();
        if (string.compareTo("fr") == 0) {
            return this.parseFr(dTrackParse);
        }
        if (string.compareTo("ts") == 0) {
            return this.parseTs(dTrackParse);
        }
        if (string.compareTo("ts2") == 0) {
            return this.parseTs2(dTrackParse);
        }
        if (string.compareTo("6d") == 0) {
            return this.parse6d(dTrackParse);
        }
        if (string.compareTo("6dcal") == 0) {
            return this.parse6dcal(dTrackParse);
        }
        if (string.compareTo("6dcov") == 0) {
            return this.parse6dcov(dTrackParse);
        }
        if (string.compareTo("6df") == 0) {
            return this.parse6df(dTrackParse);
        }
        if (string.compareTo("6df2") == 0) {
            return this.parse6df2(dTrackParse);
        }
        if (string.compareTo("6dmt") == 0) {
            return this.parse6dmt(dTrackParse);
        }
        if (string.compareTo("6dmt2") == 0) {
            return this.parse6dmt2(dTrackParse);
        }
        if (string.compareTo("6dmtr") == 0) {
            return this.parse6dmtr(dTrackParse);
        }
        if (string.compareTo("glcal") == 0) {
            return this.parseGlcal(dTrackParse);
        }
        if (string.compareTo("gl") == 0) {
            return this.parseGl(dTrackParse);
        }
        if (string.compareTo("6dj") == 0) {
            return this.parse6dj(dTrackParse);
        }
        if (string.compareTo("6di") == 0) {
            return this.parse6di(dTrackParse);
        }
        if (string.compareTo("3d") == 0) {
            return this.parse3d(dTrackParse);
        }
        if (string.compareTo("st") == 0) {
            return this.parseSt(dTrackParse);
        }
        return true;
    }

    private boolean parse3d(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("3d", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        if (n < this.actMarker.size()) {
            this.actMarker.subList(n, this.actMarker.size()).clear();
        }
        for (int i = 0; i < n; ++i) {
            DTrackParse.Block block = dTrackParse.parseBlock("id");
            if (block == null) {
                this.log("3d", ParseError.BLOCK);
                return false;
            }
            DTrackParse.Block block2 = dTrackParse.parseBlock(D3);
            if (block2 == null) {
                this.log("3d", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block2.getAllD();
            if (this.actMarker.size() > i) {
                this.actMarker.set(i, new DTrackMarker(block.getI(0), block.getD(0), dArray));
                continue;
            }
            this.actMarker.add(i, new DTrackMarker(block.getI(0), block.getD(0), dArray));
        }
        return true;
    }

    private boolean parse6di(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("6di", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        if (n != this.actInertial.size()) {
            if (n < this.actInertial.size()) {
                this.actInertial.subList(n, this.actInertial.size()).clear();
            } else {
                while (this.actInertial.size() < n) {
                    this.actInertial.add(new DTrackInertial(this.actInertial.size()));
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            DTrackParse.Block block = dTrackParse.parseBlock("iid");
            if (block == null) {
                this.log("6di", ParseError.BLOCK);
                return false;
            }
            int n2 = block.getI(0);
            if (n2 < 0 || n2 >= n) {
                this.log("6di", ParseError.INVALID);
                return false;
            }
            DTrackParse.Block block2 = dTrackParse.parseBlock(D3);
            if (block2 == null) {
                this.log("6di", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block2.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("6di", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block3.getAllD());
            this.actInertial.set(n2, new DTrackInertial(n2, block.getI(1), block.getD(0), dArray, dArray2));
        }
        return true;
    }

    private boolean parse6dj(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("6dj", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        if (n != this.actHuman.size()) {
            if (n < this.actHuman.size()) {
                this.actHuman.subList(n, this.actHuman.size()).clear();
            } else {
                while (this.actHuman.size() < n) {
                    this.actHuman.add(new DTrackHuman(this.actHuman.size()));
                }
            }
        }
        for (DTrackHuman dTrackHuman : this.actHuman) {
            dTrackHuman.setNotTracked();
        }
        if (!dTrackParse.nextInt()) {
            this.log("6dj", ParseError.INT);
            return false;
        }
        int n2 = dTrackParse.getNextInt();
        for (int i = 0; i < n2; ++i) {
            DTrackParse.Block block = dTrackParse.parseBlock("ii");
            if (block == null) {
                this.log("6dj", ParseError.BLOCK);
                return false;
            }
            int n3 = block.getI(0);
            int n4 = block.getI(1);
            if (n3 < 0 || n3 >= n) {
                this.log("6dj", ParseError.INVALID);
                return false;
            }
            DTrackJoint[] dTrackJointArray = new DTrackJoint[n4];
            for (int j = 0; j < n4; ++j) {
                DTrackParse.Block block2 = dTrackParse.parseBlock("id");
                if (block2 == null) {
                    this.log("6dj", ParseError.BLOCK);
                    return false;
                }
                DTrackParse.Block block3 = dTrackParse.parseBlock(D3);
                if (block3 == null) {
                    this.log("6dj", ParseError.BLOCK);
                    return false;
                }
                double[] dArray = block3.getAllD();
                DTrackParse.Block block4 = dTrackParse.parseBlock(D9);
                if (block4 == null) {
                    this.log("6dj", ParseError.BLOCK);
                    return false;
                }
                double[][] dArray2 = new double[3][3];
                DTrackParser.oneToTwoDimRot(dArray2, block4.getAllD());
                dTrackJointArray[j] = new DTrackJoint(block2.getI(0), block2.getD(0), dArray, dArray2);
            }
            this.actHuman.set(n3, new DTrackHuman(n3, dTrackJointArray));
        }
        return true;
    }

    private boolean parse6d(DTrackParse dTrackParse) {
        for (DTrackBody dTrackBody : this.actBody) {
            dTrackBody.setNotTracked();
        }
        if (!dTrackParse.nextInt()) {
            this.log("6d", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        for (int i = 0; i < n; ++i) {
            DTrackParse.Block block;
            DTrackParse.Block block2 = dTrackParse.parseBlock("id");
            if (block2 == null) {
                this.log("6d", ParseError.BLOCK);
                return false;
            }
            int n2 = block2.getI(0);
            if (n2 < 0) {
                this.log("6d", ParseError.INVALID);
                return false;
            }
            if (n2 >= this.actBody.size()) {
                while (this.actBody.size() <= n2) {
                    this.actBody.add(new DTrackBody(this.actBody.size()));
                }
            }
            if ((block = dTrackParse.parseBlock(D3)) == null) {
                this.log("6d", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("6d", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block3.getAllD());
            this.actBody.set(n2, new DTrackBody(n2, block2.getD(0), dArray, dArray2));
        }
        return true;
    }

    private boolean parse6dcal(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("6dcal", ParseError.INT);
            return false;
        }
        this.locNumBodycal = dTrackParse.getNextInt();
        return true;
    }

    private boolean parse6dcov(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("6dcov", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        for (int i = 0; i < n; ++i) {
            DTrackParse.Block block;
            DTrackParse.Block block2 = dTrackParse.parseBlock("iddd");
            if (block2 == null) {
                this.log("6dcov", ParseError.BLOCK);
                return false;
            }
            int n2 = block2.getI(0);
            double[] dArray = block2.getAllD();
            if (n2 < 0) {
                this.log("6dcov", ParseError.INVALID);
                return false;
            }
            if (n2 >= this.actBody.size()) {
                while (this.actBody.size() <= n2) {
                    this.actBody.add(new DTrackBody(this.actBody.size()));
                }
            }
            if ((block = dTrackParse.parseBlock(D21)) == null) {
                this.log("6dcov", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[6][6];
            DTrackParser.reducedToFullCov(dArray2, block.getAllD(), 6);
            this.actBody.get(n2).setCov(dArray2, dArray);
        }
        return true;
    }

    private boolean parse6df(DTrackParse dTrackParse) {
        int n;
        if (!dTrackParse.nextInt()) {
            this.log("6df", ParseError.INT);
            return false;
        }
        this.locNumFlystickOld = n = dTrackParse.getNextInt();
        if (n != this.actFlystick.size()) {
            if (n < this.actFlystick.size()) {
                this.actFlystick.subList(n, this.actFlystick.size()).clear();
            } else {
                while (this.actFlystick.size() < n) {
                    this.actFlystick.add(new DTrackFlystick(this.actFlystick.size()));
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            DTrackParse.Block block = dTrackParse.parseBlock("idi");
            if (block == null) {
                this.log("6df", ParseError.BLOCK);
                return false;
            }
            int n3 = block.getI(0);
            int n4 = block.getI(1);
            if (n3 < 0 || n3 >= n) {
                this.log("6df", ParseError.INVALID);
                return false;
            }
            int n5 = 8;
            int[] nArray = new int[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                nArray[n2] = n4 & 1;
                n4 >>= 1;
            }
            n2 = 2;
            double[] dArray = new double[n2];
            dArray[0] = nArray[5] != 0 ? -1.0 : (nArray[7] != 0 ? 1.0 : 0.0);
            dArray[1] = nArray[4] != 0 ? -1.0 : (nArray[6] != 0 ? 1.0 : 0.0);
            DTrackParse.Block block2 = dTrackParse.parseBlock(D3);
            if (block2 == null) {
                this.log("6df", ParseError.BLOCK);
                return false;
            }
            double[] dArray2 = block2.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("6df", ParseError.BLOCK);
                return false;
            }
            double[][] dArray3 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray3, block3.getAllD());
            this.actFlystick.set(n3, new DTrackFlystick(n3, block.getD(0), nArray, dArray, dArray2, dArray3));
        }
        return true;
    }

    private boolean parse6df2(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("6df2", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        if (n != this.actFlystick.size()) {
            if (n < this.actFlystick.size()) {
                this.actFlystick.subList(n, this.actFlystick.size()).clear();
            } else {
                while (this.actFlystick.size() < n) {
                    this.actFlystick.add(new DTrackFlystick(this.actFlystick.size()));
                }
            }
        }
        for (DTrackFlystick dTrackFlystick : this.actFlystick) {
            dTrackFlystick.setNotTracked();
        }
        if (!dTrackParse.nextInt()) {
            this.log("6df2", ParseError.INT);
            return false;
        }
        int n2 = dTrackParse.getNextInt();
        for (int i = 0; i < n2; ++i) {
            int n3;
            DTrackParse.Block block = dTrackParse.parseBlock("idii");
            if (block == null) {
                this.log("6df2", ParseError.BLOCK);
                return false;
            }
            int n4 = block.getI(0);
            int n5 = block.getI(1);
            int n6 = block.getI(2);
            if (n4 < 0 || n4 >= n) {
                this.log("6df2", ParseError.INVALID);
                return false;
            }
            DTrackParse.Block block2 = dTrackParse.parseBlock(D3);
            if (block2 == null) {
                this.log("6df2", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block2.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("6df2", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block3.getAllD());
            String string = "";
            for (n3 = 0; n3 < n5; n3 += 32) {
                string = string.concat("i");
            }
            for (n3 = 0; n3 < n6; ++n3) {
                string = string.concat("d");
            }
            DTrackParse.Block block4 = dTrackParse.parseBlock(string);
            if (block4 == null) {
                this.log("6df2", ParseError.BLOCK);
                return false;
            }
            double[] dArray3 = block4.getAllD();
            int n7 = 0;
            int n8 = 32;
            int n9 = 0;
            int[] nArray = new int[n5];
            for (int j = 0; j < n5; ++j) {
                if (n8 == 32) {
                    n9 = block4.getI(n7);
                    ++n7;
                    n8 = 0;
                }
                nArray[j] = n9 & 1;
                n9 >>= 1;
                ++n8;
            }
            this.actFlystick.set(n4, new DTrackFlystick(n4, block.getD(0), nArray, dArray3, dArray, dArray2));
        }
        return true;
    }

    private boolean parse6dmt(DTrackParse dTrackParse) {
        int n;
        if (!dTrackParse.nextInt()) {
            this.log("6dmt", ParseError.INT);
            return false;
        }
        this.locNumMeatoolOld = n = dTrackParse.getNextInt();
        if (n != this.actMeatool.size()) {
            if (n < this.actMeatool.size()) {
                this.actMeatool.subList(n, this.actMeatool.size()).clear();
            } else {
                while (this.actMeatool.size() < n) {
                    this.actMeatool.add(new DTrackMeaTool(this.actMeatool.size()));
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            DTrackParse.Block block = dTrackParse.parseBlock("idi");
            if (block == null) {
                this.log("6dmt", ParseError.BLOCK);
                return false;
            }
            int n2 = block.getI(0);
            if (n2 < 0 || n2 >= n) {
                this.log("6dmt", ParseError.INVALID);
                return false;
            }
            int n3 = 4;
            int n4 = block.getI(1);
            int[] nArray = new int[n3];
            for (int j = 0; j < n3; ++j) {
                nArray[j] = n4 & 1;
                n4 >>= 1;
            }
            DTrackParse.Block block2 = dTrackParse.parseBlock(D3);
            if (block2 == null) {
                this.log("6dmt", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block2.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("6dmt", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block3.getAllD());
            this.actMeatool.set(n2, new DTrackMeaTool(n2, block.getD(0), nArray, dArray, dArray2));
        }
        return true;
    }

    private boolean parse6dmt2(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("6dmt2", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        if (n != this.actMeatool.size()) {
            if (n < this.actMeatool.size()) {
                this.actMeatool.subList(n, this.actMeatool.size()).clear();
            } else {
                while (this.actMeatool.size() < n) {
                    this.actMeatool.add(new DTrackMeaTool(this.actMeatool.size()));
                }
            }
        }
        for (DTrackMeaTool dTrackMeaTool : this.actMeatool) {
            dTrackMeaTool.setNotTracked();
        }
        if (!dTrackParse.nextInt()) {
            this.log("6dmt2", ParseError.INT);
            return false;
        }
        int n2 = dTrackParse.getNextInt();
        for (int i = 0; i < n2; ++i) {
            DTrackParse.Block block = dTrackParse.parseBlock("idid");
            if (block == null) {
                this.log("6dmt2", ParseError.BLOCK);
                return false;
            }
            int n3 = block.getI(0);
            if (n3 < 0 || n3 >= n) {
                this.log("6dmt2", ParseError.INVALID);
                return false;
            }
            int n4 = block.getI(1);
            DTrackParse.Block block2 = dTrackParse.parseBlock(D3);
            if (block2 == null) {
                this.log("6dmt2", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block2.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("6dmt2", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block3.getAllD());
            String string = "";
            for (int j = 0; j < n4; j += 32) {
                string = string.concat("i");
            }
            DTrackParse.Block block4 = dTrackParse.parseBlock(string);
            if (block4 == null) {
                this.log("6dmt2", ParseError.BLOCK);
                return false;
            }
            int n5 = 0;
            int n6 = 32;
            int n7 = 0;
            int[] nArray = new int[n4];
            for (int j = 0; j < n4; ++j) {
                if (n6 == 32) {
                    n7 = block4.getI(n5);
                    ++n5;
                    n6 = 0;
                }
                nArray[j] = n7 & 1;
                n7 >>= 1;
                ++n6;
            }
            DTrackParse.Block block5 = dTrackParse.parseBlock(D6);
            if (block5 == null) {
                this.log("6dmt2", ParseError.BLOCK);
                return false;
            }
            double[][] dArray3 = new double[3][3];
            DTrackParser.reducedToFullCov(dArray3, block5.getAllD(), 3);
            this.actMeatool.set(n3, new DTrackMeaTool(n3, block.getD(0), block.getD(1), nArray, dArray, dArray2, dArray3));
        }
        return true;
    }

    private boolean parse6dmtr(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("6dmtr", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        if (n != this.actMearef.size()) {
            if (n < this.actMearef.size()) {
                this.actMearef.subList(n, this.actMearef.size()).clear();
            } else {
                while (this.actMearef.size() < n) {
                    this.actMearef.add(new DTrackMeaRef(this.actMearef.size()));
                }
            }
        }
        for (DTrackMeaRef dTrackMeaRef : this.actMearef) {
            dTrackMeaRef.setNotTracked();
        }
        if (!dTrackParse.nextInt()) {
            this.log("6dmtr", ParseError.INT);
            return false;
        }
        int n2 = dTrackParse.getNextInt();
        for (int i = 0; i < n2; ++i) {
            DTrackParse.Block block = dTrackParse.parseBlock("id");
            if (block == null) {
                this.log("6dmtr", ParseError.BLOCK);
                return false;
            }
            int n3 = block.getI(0);
            if (n3 < 0 || n3 >= n) {
                this.log("6dmtr", ParseError.INVALID);
                return false;
            }
            DTrackParse.Block block2 = dTrackParse.parseBlock(D3);
            if (block2 == null) {
                this.log("6dmtr", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block2.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("6dmtr", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block3.getAllD());
            this.actMearef.set(n3, new DTrackMeaRef(n3, block.getD(0), dArray, dArray2));
        }
        return true;
    }

    private boolean parseFr(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("fr", ParseError.INT);
            return false;
        }
        this.actFramecounter = dTrackParse.getNextInt();
        return true;
    }

    private boolean parseGl(DTrackParse dTrackParse) {
        for (DTrackHand dTrackHand : this.actHand) {
            dTrackHand.setNotTracked();
        }
        if (!dTrackParse.nextInt()) {
            this.log("gl", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        for (int i = 0; i < n; ++i) {
            DTrackParse.Block block;
            DTrackParse.Block block2 = dTrackParse.parseBlock("idii");
            if (block2 == null) {
                this.log("gl", ParseError.BLOCK);
                return false;
            }
            int n2 = block2.getI(0);
            int n3 = block2.getI(2);
            if (n2 < 0) {
                this.log("gl", ParseError.INVALID);
                return false;
            }
            if (n2 >= this.actHand.size()) {
                while (this.actHand.size() <= n2) {
                    this.actHand.add(new DTrackHand(this.actHand.size()));
                }
            }
            if ((block = dTrackParse.parseBlock(D3)) == null) {
                this.log("gl", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block.getAllD();
            DTrackParse.Block block3 = dTrackParse.parseBlock(D9);
            if (block3 == null) {
                this.log("gl", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block3.getAllD());
            DTrackFinger[] dTrackFingerArray = new DTrackFinger[n3];
            if (!this.parseFingerGl(dTrackParse, n2, n3, dTrackFingerArray)) {
                return false;
            }
            this.actHand.set(n2, new DTrackHand(n2, block2.getI(1), block2.getD(0), dArray, dArray2, dTrackFingerArray));
        }
        return true;
    }

    private boolean parseFingerGl(DTrackParse dTrackParse, int n, int n2, DTrackFinger[] dTrackFingerArray) {
        for (int i = 0; i < n2; ++i) {
            DTrackParse.Block block = dTrackParse.parseBlock(D3);
            if (block == null) {
                this.log("gl", ParseError.BLOCK);
                return false;
            }
            double[] dArray = block.getAllD();
            DTrackParse.Block block2 = dTrackParse.parseBlock(D9);
            if (block2 == null) {
                this.log("gl", ParseError.BLOCK);
                return false;
            }
            double[][] dArray2 = new double[3][3];
            DTrackParser.oneToTwoDimRot(dArray2, block2.getAllD());
            DTrackParse.Block block3 = dTrackParse.parseBlock(D6);
            if (block3 == null) {
                this.log("gl", ParseError.BLOCK);
                return false;
            }
            double[] dArray3 = new double[]{block3.getD(1), block3.getD(3), block3.getD(5)};
            double[] dArray4 = new double[]{block3.getD(2), block3.getD(4)};
            dTrackFingerArray[i] = new DTrackFinger(block3.getD(0), dArray, dArray2, dArray3, dArray4);
        }
        return true;
    }

    private boolean parseGlcal(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("glcal", ParseError.INT);
            return false;
        }
        this.locNumHandcal = dTrackParse.getNextInt();
        return true;
    }

    private boolean parseTs(DTrackParse dTrackParse) {
        if (!dTrackParse.nextDouble()) {
            this.log("ts", ParseError.DOUBLE);
            return false;
        }
        this.actTimestamp = dTrackParse.getNextDouble();
        return true;
    }

    private boolean parseTs2(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("ts2", ParseError.INT);
            return false;
        }
        this.actTimestampSec = dTrackParse.getNextInt();
        if (!dTrackParse.nextInt()) {
            this.log("ts2", ParseError.INT);
            this.actTimestampSec = 0;
            return false;
        }
        this.actTimestampUsec = dTrackParse.getNextInt();
        if (!dTrackParse.nextInt()) {
            this.log("ts2", ParseError.INT);
            this.actTimestampSec = 0;
            this.actTimestampUsec = 0;
            return false;
        }
        this.actLatencyUsec = dTrackParse.getNextInt();
        this.actTimestamp = (double)(this.actTimestampSec % 86400) + (double)this.actTimestampUsec / 1000000.0;
        return true;
    }

    private boolean parseSt(DTrackParse dTrackParse) {
        if (!dTrackParse.nextInt()) {
            this.log("st", ParseError.INT);
            return false;
        }
        int n = dTrackParse.getNextInt();
        if (n > 3) {
            n = 3;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        ArrayList<DTrackCameraStatus> arrayList = new ArrayList<DTrackCameraStatus>();
        for (int i = 0; i < n; ++i) {
            int n10;
            int n11;
            int n12;
            DTrackParse.Block block;
            if (i == 2) {
                block = dTrackParse.parseBlock("iii");
                if (block == null) {
                    this.log("st", ParseError.BLOCK);
                    return false;
                }
                n12 = block.getI(0);
                n11 = block.getI(1);
                n10 = block.getI(2);
            } else {
                block = dTrackParse.parseBlock("ii");
                if (block == null) {
                    this.log("st", ParseError.BLOCK);
                    return false;
                }
                n12 = block.getI(0);
                n11 = 0;
                n10 = block.getI(1);
            }
            if (n12 == 0) {
                if (n10 < 3) {
                    return false;
                }
                block = dTrackParse.parseBlock("iii");
                if (block == null) {
                    this.log("st", ParseError.BLOCK);
                    return false;
                }
                n2 = block.getI(0);
                n3 = block.getI(1);
                n4 = block.getI(2);
                continue;
            }
            if (n12 == 1) {
                if (n10 < 5) {
                    return false;
                }
                block = dTrackParse.parseBlock("iiiii");
                if (block == null) {
                    this.log("st", ParseError.BLOCK);
                    return false;
                }
                n5 = block.getI(0);
                n6 = block.getI(1);
                n7 = block.getI(2);
                n8 = block.getI(3);
                n9 = block.getI(4);
                continue;
            }
            if (n12 != 2) continue;
            if (n10 < 3) {
                return false;
            }
            for (int j = 0; j < n11; ++j) {
                DTrackParse.Block block2 = dTrackParse.parseBlock("iiii");
                if (block2 == null) {
                    this.log("st", ParseError.BLOCK);
                    return false;
                }
                int n13 = block2.getI(0);
                int n14 = block2.getI(1);
                int n15 = block2.getI(2);
                int n16 = block2.getI(3);
                arrayList.add(new DTrackCameraStatus(n13, n14, n15, n16));
            }
        }
        this.actStatus = new DTrackStatus(n2, n3, n4, n5, n6, n7, n8, n9, arrayList);
        this.actIsStatusAvailable = true;
        return true;
    }

    private static enum ParseError {
        BLOCK,
        DOUBLE,
        INT,
        INVALID;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

