/*
 * Decompiled with CFR 0.152.
 */
package art;

import art.DTrackSDK;
import java.util.logging.Level;
import java.util.logging.Logger;

class DTrackParse {
    private char[] c;
    private int cPtr;
    private String nextStringword;
    private int nextInt;
    private double nextDouble;
    private Logger log = Logger.getLogger(DTrackSDK.class.getName());

    protected DTrackParse(String string) {
        this.c = string.toCharArray();
        this.cPtr = 0;
    }

    protected boolean nextLine() {
        while (this.cPtr < this.c.length && this.c[this.cPtr] != '\r' && this.c[this.cPtr] != '\n') {
            ++this.cPtr;
        }
        while (this.cPtr < this.c.length && (this.c[this.cPtr] == '\r' || this.c[this.cPtr] == '\n' || this.c[this.cPtr] == ' ')) {
            ++this.cPtr;
        }
        return this.cPtr < this.c.length;
    }

    protected boolean nextStringword() {
        while (this.cPtr < this.c.length && this.c[this.cPtr] == ' ') {
            ++this.cPtr;
        }
        int n = this.cPtr;
        while (this.cPtr < this.c.length && this.c[this.cPtr] != ' ' && this.c[this.cPtr] != '\r' && this.c[this.cPtr] != '\n') {
            ++this.cPtr;
        }
        if (this.cPtr >= this.c.length) {
            return false;
        }
        this.nextStringword = new String(this.c, n, this.cPtr - n);
        return true;
    }

    protected boolean nextInt() {
        while (this.cPtr < this.c.length && this.c[this.cPtr] == ' ') {
            ++this.cPtr;
        }
        boolean bl = false;
        if (this.c[this.cPtr] == '-') {
            bl = true;
            ++this.cPtr;
        }
        int n = 0;
        while (this.cPtr < this.c.length && this.c[this.cPtr] >= '0' && this.c[this.cPtr] <= '9') {
            n = n * 10 + (this.c[this.cPtr] - 48);
            ++this.cPtr;
        }
        this.nextInt = bl ? -n : n;
        return true;
    }

    protected boolean nextDouble() {
        while (this.cPtr < this.c.length && this.c[this.cPtr] == ' ') {
            ++this.cPtr;
        }
        int n = this.cPtr;
        while (this.cPtr < this.c.length && this.c[this.cPtr] != ' ' && this.c[this.cPtr] != ']' && this.c[this.cPtr] != '\r' && this.c[this.cPtr] != '\n') {
            ++this.cPtr;
        }
        if (this.cPtr >= this.c.length) {
            return false;
        }
        String string = new String(this.c, n, this.cPtr - n);
        try {
            this.nextDouble = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    protected Block parseBlock(String string) {
        while (this.cPtr < this.c.length && this.c[this.cPtr] == ' ') {
            ++this.cPtr;
        }
        if (this.cPtr < this.c.length && this.c[this.cPtr] != '[') {
            while (this.cPtr < this.c.length && this.c[this.cPtr] != ']') {
                ++this.cPtr;
            }
            this.log.log(Level.WARNING, "Skipped block (no square bracket found) ({0})", this.cPtr);
            return null;
        }
        ++this.cPtr;
        Block block = new Block(string);
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = cArray[i];
            switch (c) {
                case 'i': {
                    if (!this.nextInt()) {
                        this.log.log(Level.WARNING, "Skipped block (int not found) ({0})", this.cPtr);
                        while (this.cPtr < this.c.length && this.c[this.cPtr] != ']') {
                            ++this.cPtr;
                        }
                        return null;
                    }
                    block.addI(this.nextInt);
                    continue block6;
                }
                case 'd': {
                    if (!this.nextDouble()) {
                        this.log.log(Level.WARNING, "Skipped block (double not found) ({0})", this.cPtr);
                        while (this.cPtr < this.c.length && this.c[this.cPtr] != ']') {
                            ++this.cPtr;
                        }
                        return null;
                    }
                    block.addD(this.nextDouble);
                    continue block6;
                }
                default: {
                    this.log.log(Level.WARNING, "Skipped block (format \"{0}\" undefined)", Character.valueOf(c));
                    while (this.cPtr < this.c.length && this.c[this.cPtr] != ']') {
                        ++this.cPtr;
                    }
                    return null;
                }
            }
        }
        while (this.cPtr < this.c.length && this.c[this.cPtr] != ']') {
            ++this.cPtr;
        }
        ++this.cPtr;
        this.log.fine("Block parsed successfully");
        return block;
    }

    protected String getNextStringword() {
        return this.nextStringword;
    }

    protected int getNextInt() {
        return this.nextInt;
    }

    protected double getNextDouble() {
        return this.nextDouble;
    }

    class Block {
        private double[] ddat;
        private int[] idat;
        private int dCount = 0;
        private int iCount = 0;

        private Block(String string) {
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = 0;
            for (char c : cArray) {
                if (c == 'i') {
                    ++n;
                    continue;
                }
                if (c != 'd') continue;
                ++n2;
            }
            this.ddat = new double[n2];
            this.idat = new int[n];
        }

        void addD(double d) {
            this.ddat[this.dCount++] = d;
        }

        void addI(int n) {
            this.idat[this.iCount++] = n;
        }

        double getD(int n) {
            return this.ddat[n];
        }

        int getI(int n) {
            return this.idat[n];
        }

        double[] getAllD() {
            return this.ddat;
        }

        int[] getAllI() {
            return this.idat;
        }
    }
}

