/*
 * Decompiled with CFR 0.152.
 */
package art;

import art.DTrackSDK;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class DTrackNetUDP {
    private String udpPacketContent = null;
    private DatagramSocket socket = null;
    private ReceiverRunnable receiver;
    private Logger log = Logger.getLogger(DTrackSDK.class.getName());

    protected DTrackNetUDP(InetAddress inetAddress, int n) {
        if (!inetAddress.isMulticastAddress()) {
            this.log.log(Level.SEVERE, "Not a multicast address");
            return;
        }
        if (n < 0 || n >= 65536) {
            this.log.log(Level.SEVERE, "Invalid port number");
            return;
        }
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = n != 0 ? new MulticastSocket(n) : new MulticastSocket();
            datagramSocket.setReuseAddress(true);
            ((MulticastSocket)datagramSocket).joinGroup(inetAddress);
        }
        catch (IOException iOException) {
            datagramSocket.close();
            this.log.log(Level.SEVERE, "Can't create multicast UDP socket", iOException);
            return;
        }
        this.socket = datagramSocket;
    }

    protected DTrackNetUDP(int n) {
        if (n < 0 || n >= 65536) {
            this.log.log(Level.SEVERE, "Invalid port number");
            return;
        }
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = n != 0 ? new DatagramSocket(n) : new DatagramSocket();
        }
        catch (SocketException socketException) {
            this.log.log(Level.SEVERE, "Can't create UDP socket", socketException);
            return;
        }
        this.socket = datagramSocket;
    }

    protected int close() {
        this.terminate();
        if (this.socket == null) {
            return -1;
        }
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
        this.socket = null;
        return 0;
    }

    protected boolean isValid() {
        return this.socket != null;
    }

    protected int getPort() {
        return this.socket.getLocalPort();
    }

    protected String getPacketContent() {
        return this.udpPacketContent;
    }

    protected int receive() {
        String string = this.receiver.getNext();
        if (string == null) {
            return -1;
        }
        this.udpPacketContent = string;
        return string.length();
    }

    protected InetAddress getRemoteIp() {
        if (this.receiver == null) {
            return null;
        }
        return this.receiver.getRemoteIp();
    }

    protected int send(InetAddress inetAddress, int n, String string) {
        byte[] byArray = string.getBytes();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            this.socket.send(datagramPacket);
            return 0;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.log.log(Level.WARNING, "UDP send timeout", socketTimeoutException);
            return -1;
        }
        catch (IOException iOException) {
            this.log.log(Level.SEVERE, "Can't send UDP data", iOException);
            return -2;
        }
    }

    protected int start(int n, int n2) {
        if (!this.isTerminated()) {
            return 0;
        }
        this.receiver = new ReceiverRunnable(this.socket, n2, n);
        Thread thread = new Thread(this.receiver);
        thread.setDaemon(true);
        thread.setName("DTrackSDK Receiver Thread");
        thread.start();
        return 0;
    }

    protected void terminate() {
        if (this.receiver != null) {
            this.receiver.terminate();
        }
    }

    protected boolean isTerminated() {
        if (this.receiver != null) {
            return this.receiver.isTerminated();
        }
        return true;
    }

    private class ReceiverRunnable
    implements Runnable {
        private DatagramSocket socket;
        private int maxLen;
        private int timeout;
        private byte[] remoteIp;
        private Lock lock = new ReentrantLock(true);
        private Condition cond;
        private boolean terminate = false;
        private String next = null;

        ReceiverRunnable(DatagramSocket datagramSocket, int n, int n2) {
            this.socket = datagramSocket;
            this.maxLen = n;
            this.timeout = n2;
            this.cond = this.lock.newCondition();
        }

        protected void terminate() {
            this.terminate = true;
        }

        protected boolean isTerminated() {
            return this.terminate;
        }

        protected String getNext() {
            try {
                this.lock.lockInterruptibly();
                if (this.next == null) {
                    if (!this.cond.await(this.timeout, TimeUnit.MILLISECONDS)) {
                        String string = null;
                        return string;
                    }
                    if (this.socket.isClosed()) {
                        String string = null;
                        return string;
                    }
                }
                String string = this.next;
                this.next = null;
                String string2 = string;
                return string2;
            }
            catch (InterruptedException interruptedException) {
                DTrackNetUDP.this.log.log(Level.WARNING, "Error while returning next UDP packet", interruptedException);
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        protected InetAddress getRemoteIp() {
            try {
                this.lock.lockInterruptibly();
                InetAddress inetAddress = InetAddress.getByAddress(this.remoteIp);
                return inetAddress;
            }
            catch (InterruptedException interruptedException) {
                DTrackNetUDP.this.log.log(Level.WARNING, "Error while returning remote IP address", interruptedException);
                Thread.currentThread().interrupt();
            }
            catch (UnknownHostException unknownHostException) {
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        @Override
        public void run() {
            if (this.socket.isClosed()) {
                this.terminate = true;
                return;
            }
            try {
                this.socket.setSoTimeout(this.timeout);
            }
            catch (SocketException socketException) {
                DTrackNetUDP.this.log.log(Level.WARNING, "Error while setting UDP socket timeout", socketException);
            }
            byte[] byArray = new byte[this.maxLen];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, this.maxLen);
            while (!this.socket.isClosed() && !this.terminate) {
                try {
                    this.socket.receive(datagramPacket);
                    this.lock.lock();
                    this.remoteIp = datagramPacket.getAddress().getAddress();
                    this.next = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
                    this.cond.signal();
                    this.lock.unlock();
                    Thread.sleep(0L, 1);
                }
                catch (SocketException socketException) {
                    if (this.socket.isClosed()) {
                        return;
                    }
                    DTrackNetUDP.this.log.log(Level.SEVERE, "Error in UDP socket", socketException);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    DTrackNetUDP.this.log.log(Level.SEVERE, "Error in UDP socket", iOException);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    DTrackNetUDP.this.log.log(Level.SEVERE, "Sleep while receiving UDP packet failed", interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

